# AUTOGENERATED! DO NOT EDIT! File to edit: ../01_pattern.ipynb.

# %% auto 0
__all__ = ['convert_patterns', 'convert_exceptions']

# %% ../01_pattern.ipynb 3
import string, re
import itertools as it
from collections.abc import Iterable, Mapping
import datrie  # type: ignore

# %% ../01_pattern.ipynb 5
def _cvt(
    pattern: str  # pattern as read from the TeX patterns file
) -> tuple[int, ...]:  # position i has the weight of the slot before character i
    res = [0 for _ in pattern]
    pos = 0
    for ch in pattern:
        if ch in string.digits:
            res[pos] = int(ch)
        else:
            pos += 1
    return tuple(res[:pos+1])

# %% ../01_pattern.ipynb 8
def convert_patterns(
    patterns: Iterable[str]  # TeX style patterns
) -> datrie.Trie:  # trie mapping matched substrings to weights
    num = re.compile('[0-9]')
    patterns = sorted(patterns, key=lambda x: num.sub('', x))
    alphabet = set(it.chain.from_iterable(patterns)) - set(string.digits) | {'\x1F'}
    trie = datrie.Trie(alphabet)
    for pat in patterns:
        pat = pat.replace('.', '\x1f')
        trie[num.sub('', pat)] = _cvt(pat)
    return trie

# %% ../01_pattern.ipynb 12
def convert_exceptions(
    exceptions: Iterable[str]
) -> Mapping[str, tuple[str,...]]:  # mapping from word to word parts
    return {w.replace('-', ''): tuple(w.split('-')) for w in exceptions}
