#
# Copyright (C) 2021 Northwestern University.
#
# Invenio is free software; you can redistribute it and/or modify it
# under the terms of the MIT License; see LICENSE file for more details.

"""Create vocabulary schemes."""

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = '4a9a4fd235f8'
down_revision = '6312f33645c1'
branch_labels = ()
depends_on = None


def upgrade():
    """Upgrade database."""
    op.create_table(
        'vocabularies_schemes',
        sa.Column('id', sa.String(), nullable=False),
        sa.Column('parent_id', sa.String(), nullable=False),
        sa.Column('name', sa.String(), nullable=True),
        sa.Column('uri', sa.String(), nullable=True),
        sa.PrimaryKeyConstraint(
            'id', 'parent_id', name=op.f('pk_vocabularies_schemes')
        )
    )


def downgrade():
    """Downgrade database."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('vocabularies_schemes')
    # ### end Alembic commands ###
