from typing import Any, Optional
from . import interfaces

AUTOCOMMIT_REGEXP: Any = ...
SERVER_SIDE_CURSOR_RE: Any = ...

class DefaultDialect(interfaces.Dialect):
    statement_compiler: Any = ...
    ddl_compiler: Any = ...
    type_compiler: Any = ...
    preparer: Any = ...
    supports_alter: bool = ...
    default_sequence_base: int = ...
    execute_sequence_format: Any = ...
    supports_views: bool = ...
    supports_sequences: bool = ...
    sequences_optional: bool = ...
    preexecute_autoincrement_sequences: bool = ...
    postfetch_lastrowid: bool = ...
    implicit_returning: bool = ...
    supports_right_nested_joins: bool = ...
    supports_native_enum: bool = ...
    supports_native_boolean: bool = ...
    supports_simple_order_by_label: bool = ...
    engine_config_types: Any = ...
    supports_native_decimal: bool = ...
    supports_unicode_statements: bool = ...
    supports_unicode_binds: bool = ...
    returns_unicode_strings: bool = ...
    description_encoding: Any = ...
    name: str = ...
    max_identifier_length: int = ...
    max_index_name_length: Any = ...
    supports_sane_rowcount: bool = ...
    supports_sane_multi_rowcount: bool = ...
    dbapi_type_map: Any = ...
    colspecs: Any = ...
    default_paramstyle: str = ...
    supports_default_values: bool = ...
    supports_empty_insert: bool = ...
    supports_multivalues_insert: bool = ...
    supports_server_side_cursors: bool = ...
    server_version_info: Any = ...
    construct_arguments: Any = ...
    requires_name_normalize: bool = ...
    reflection_options: Any = ...
    dbapi_exception_translation_map: Any = ...
    convert_unicode: Any = ...
    encoding: Any = ...
    positional: bool = ...
    dbapi: Any = ...
    paramstyle: Any = ...
    identifier_preparer: Any = ...
    case_sensitive: Any = ...
    label_length: Any = ...
    def __init__(self, convert_unicode: bool = ..., encoding: str = ..., paramstyle: Optional[Any] = ...,
                 dbapi: Optional[Any] = ..., implicit_returning: Optional[Any] = ...,
                 supports_right_nested_joins: Optional[Any] = ..., case_sensitive: bool = ...,
                 supports_native_boolean: Optional[Any] = ...,
                 label_length: Optional[Any] = ..., **kwargs) -> None: ...
    @property
    def dialect_description(self): ...
    @classmethod
    def get_pool_class(cls, url): ...
    default_schema_name: str = ...
    default_isolation_level: Any = ...
    def initialize(self, connection): ...
    def on_connect(self): ...
    def type_descriptor(self, typeobj): ...
    def reflecttable(self, connection, table, include_columns, exclude_columns, **opts): ...
    # Should be conn but using connection so mypy doesn't complain about superclass incompatibility
    def get_pk_constraint(self, connection, table_name, schema: Optional[Any] = ..., **kw): ...
    def validate_identifier(self, ident): ...
    def connect(self, *cargs, **cparams): ...
    def create_connect_args(self, url): ...
    def set_engine_execution_options(self, engine, opts): ...
    def set_connection_execution_options(self, connection, opts): ...
    def do_begin(self, dbapi_connection): ...
    def do_rollback(self, dbapi_connection): ...
    def do_commit(self, dbapi_connection): ...
    def do_close(self, dbapi_connection): ...
    def create_xid(self): ...
    def do_savepoint(self, connection, name): ...
    def do_rollback_to_savepoint(self, connection, name): ...
    def do_release_savepoint(self, connection, name): ...
    def do_executemany(self, cursor, statement, parameters, context: Optional[Any] = ...): ...
    def do_execute(self, cursor, statement, parameters, context: Optional[Any] = ...): ...
    def do_execute_no_params(self, *args, **kwargs): ...
    def is_disconnect(self, e, connection, cursor): ...
    def reset_isolation_level(self, dbapi_conn): ...

class StrCompileDialect(DefaultDialect):
    statement_compiler: Any = ...
    ddl_compiler: Any = ...
    type_compiler: Any = ...
    preparer: Any = ...
    supports_sequences: bool = ...
    sequences_optional: bool = ...
    preexecute_autoincrement_sequences: bool = ...
    implicit_returning: bool = ...
    supports_native_boolean: bool = ...
    supports_simple_order_by_label: bool = ...

class DefaultExecutionContext(interfaces.ExecutionContext):
    isinsert: bool = ...
    isupdate: bool = ...
    isdelete: bool = ...
    is_crud: bool = ...
    is_text: bool = ...
    isddl: bool = ...
    executemany: bool = ...
    compiled: Any = ...
    statement: Any = ...
    result_column_struct: Any = ...
    returned_defaults: Any = ...
    @property
    def engine(self): ...
    @property
    def postfetch_cols(self): ...
    @property
    def prefetch_cols(self): ...
    @property
    def returning_cols(self): ...
    @property
    def no_parameters(self): ...
    @property
    def should_autocommit(self): ...
    @property
    def connection(self): ...
    def should_autocommit_text(self, statement): ...
    def create_cursor(self): ...
    def create_server_side_cursor(self): ...
    def pre_exec(self): ...
    def post_exec(self): ...
    def get_result_processor(self, type_, colname, coltype): ...
    def get_lastrowid(self): ...
    def handle_dbapi_exception(self, e): ...
    def get_result_proxy(self): ...
    @property
    def rowcount(self): ...
    def supports_sane_rowcount(self): ...
    def supports_sane_multi_rowcount(self): ...
    def lastrow_has_defaults(self): ...
    def set_input_sizes(self, translate: Optional[Any] = ..., exclude_types: Optional[Any] = ...): ...
    def get_insert_default(self, column): ...
    def get_update_default(self, column): ...
