from typing import Any, Optional
from .interfaces import (
    MapperProperty as MapperProperty,
    PropComparator as PropComparator
)
from . import query

class DescriptorProperty(MapperProperty):
    doc: Any = ...
    key: Any = ...
    descriptor: Any = ...
    def instrument_class(self, mapper): ...

class CompositeProperty(DescriptorProperty):
    attrs: Any = ...
    composite_class: Any = ...
    active_history: Any = ...
    deferred: Any = ...
    group: Any = ...
    comparator_factory: Any = ...
    info: Any = ...
    def __init__(self, class_, *attrs, **kwargs) -> None: ...
    def instrument_class(self, mapper): ...
    def do_init(self): ...
    @property
    def props(self): ...
    @property
    def columns(self): ...
    def get_history(self, state, dict_, passive: Any = ...): ...
    class CompositeBundle(query.Bundle):
        property: Any = ...
        def __init__(self, property, expr) -> None: ...
        def create_row_processor(self, query, procs, labels): ...
    class Comparator(PropComparator):
        __hash__: Any = ...
        @property
        def clauses(self): ...
        def __clause_element__(self): ...
        def __eq__(self, other): ...
        def __ne__(self, other): ...

class ConcreteInheritedProperty(DescriptorProperty):
    descriptor: Any = ...
    def __init__(self) -> None: ...

class SynonymProperty(DescriptorProperty):
    name: str = ...
    map_column: Any = ...
    descriptor: Any = ...
    comparator_factory: Any = ...
    doc: Any = ...
    info: Any = ...
    def __init__(self, name, map_column: Optional[Any] = ..., descriptor: Optional[Any] = ...,
                 comparator_factory: Optional[Any] = ..., doc: Optional[Any] = ...,
                 info: Optional[Any] = ...) -> None: ...
    parent: Any = ...
    def set_parent(self, parent, init): ...

class ComparableProperty(DescriptorProperty):
    descriptor: Any = ...
    comparator_factory: Any = ...
    doc: Any = ...
    info: Any = ...
    def __init__(self, comparator_factory, descriptor: Optional[Any] = ...,
                 doc: Optional[Any] = ..., info: Optional[Any] = ...) -> None: ...
