def solidity_to_openai_type(solidity_type):
    base_type = solidity_type.rstrip("[]")
    is_array = solidity_type.endswith("[]")

    if base_type == "bool":
        return "array" if is_array else "boolean"

    if base_type.startswith(("int", "uint")):
        return "array" if is_array else "integer"

    if base_type == "address":
        return "array" if is_array else "string"

    if base_type.startswith("bytes") or base_type == "string":
        return "array" if is_array else "string"

    if "[" in base_type and "]" in base_type:
        return "array"

    if base_type.startswith("mapping") or base_type in ["struct", "enum"]:
        return "object"

    return "string"

def get_data_types(index):
    types = [
        "bool",
        "int8",
        "int16",
        "int24",
        "int32",
        "int40",
        "int48",
        "int56",
        "int64",
        "int72",
        "int80",
        "int88",
        "int96",
        "int104",
        "int112",
        "int120",
        "int128",
        "int136",
        "int144",
        "int152",
        "int160",
        "int168",
        "int176",
        "int184",
        "int192",
        "int200",
        "int208",
        "int216",
        "int224",
        "int232",
        "int240",
        "int248",
        "int256",
        "uint8",
        "uint16",
        "uint24",
        "uint32",
        "uint40",
        "uint48",
        "uint56",
        "uint64",
        "uint72",
        "uint80",
        "uint88",
        "uint96",
        "uint104",
        "uint112",
        "uint120",
        "uint128",
        "uint136",
        "uint144",
        "uint152",
        "uint160",
        "uint168",
        "uint176",
        "uint184",
        "uint192",
        "uint200",
        "uint208",
        "uint216",
        "uint224",
        "uint232",
        "uint240",
        "uint248",
        "uint256",
        "address",
        "bytes1",
        "bytes2",
        "bytes3",
        "bytes4",
        "bytes5",
        "bytes6",
        "bytes7",
        "bytes8",
        "bytes9",
        "bytes10",
        "bytes11",
        "bytes12",
        "bytes13",
        "bytes14",
        "bytes15",
        "bytes16",
        "bytes17",
        "bytes18",
        "bytes19",
        "bytes20",
        "bytes21",
        "bytes22",
        "bytes23",
        "bytes24",
        "bytes25",
        "bytes26",
        "bytes27",
        "bytes28",
        "bytes29",
        "bytes30",
        "bytes31",
        "bytes32",
        "bytes",
        "string",
        "int8[]",
        "int16[]",
        "int24[]",
        "int32[]",
        "int40[]",
        "int48[]",
        "int56[]",
        "int64[]",
        "int72[]",
        "int80[]",
        "int88[]",
        "int96[]",
        "int104[]",
        "int112[]",
        "int120[]",
        "int128[]",
        "int136[]",
        "int144[]",
        "int152[]",
        "int160[]",
        "int168[]",
        "int176[]",
        "int184[]",
        "int192[]",
        "int200[]",
        "int208[]",
        "int216[]",
        "int224[]",
        "int232[]",
        "int240[]",
        "int248[]",
        "int256[]",
        "uint8[]",
        "uint16[]",
        "uint24[]",
        "uint32[]",
        "uint40[]",
        "uint48[]",
        "uint56[]",
        "uint64[]",
        "uint72[]",
        "uint80[]",
        "uint88[]",
        "uint96[]",
        "uint104[]",
        "uint112[]",
        "uint120[]",
        "uint128[]",
        "uint136[]",
        "uint144[]",
        "uint152[]",
        "uint160[]",
        "uint168[]",
        "uint176[]",
        "uint184[]",
        "uint192[]",
        "uint200[]",
        "uint208[]",
        "uint216[]",
        "uint224[]",
        "uint232[]",
        "uint240[]",
        "uint248[]",
        "uint256[]",
        "address[]",
        "bytes1[]",
        "bytes2[]",
        "bytes3[]",
        "bytes4[]",
        "bytes5[]",
        "bytes6[]",
        "bytes7[]",
        "bytes8[]",
        "bytes9[]",
        "bytes10[]",
        "bytes11[]",
        "bytes12[]",
        "bytes13[]",
        "bytes14[]",
        "bytes15[]",
        "bytes16[]",
        "bytes17[]",
        "bytes18[]",
        "bytes19[]",
        "bytes20[]",
        "bytes21[]",
        "bytes22[]",
        "bytes23[]",
        "bytes24[]",
        "bytes25[]",
        "bytes26[]",
        "bytes27[]",
        "bytes28[]",
        "bytes29[]",
        "bytes30[]",
        "bytes31[]",
        "bytes32[]",
        "bytes[]",
        "string[]",
    ]
    return types[index]
