"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Image = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk8s_1 = require("cdk8s");
const constructs_1 = require("constructs");
const _shell_1 = require("./_shell");
const PARSE_DIGEST = /digest:\ (sha256:[0-9a-f]+)/;
/**
 * Represents a docker image built during synthesis from a context directory
 * (`dir`) with a `Dockerfile`.
 *
 * The image will be built using `docker build` and then pushed through `docker
 * push`. The URL of the pushed image can be accessed through `image.url`.
 *
 * If you push to a registry other then docker hub, you can specify the registry
 * URL through the `registry` option.
 */
class Image extends constructs_1.Construct {
    constructor(scope, id, props) {
        var _b, _c;
        super(scope, id);
        const registry = (_b = props.registry) !== null && _b !== void 0 ? _b : 'docker.io/library';
        const tag = `${registry}/${cdk8s_1.Names.toDnsLabel(this)}`;
        const allBuildArgs = [];
        (_c = props.buildArgs) === null || _c === void 0 ? void 0 : _c.forEach((arg) => {
            allBuildArgs.push('--build-arg');
            allBuildArgs.push(`${arg.name}=${arg.value}`);
        });
        if (props.file) {
            allBuildArgs.push('-f');
            allBuildArgs.push(props.file);
        }
        if (props.platform) {
            allBuildArgs.push(`--platform=${props.platform}`);
        }
        console.error(`building docker image ${tag} from ${props.file ? props.file : props.dir}`);
        _shell_1.shell('docker', 'build', '-t', tag, props.dir, ...allBuildArgs);
        console.error(`pushing docker image ${tag} to ${registry}`);
        const push = _shell_1.shell('docker', 'push', tag);
        const result = PARSE_DIGEST.exec(push);
        if (!result) {
            throw new Error(`unable to read image digest after push: ${push}`);
        }
        this.url = `${tag}@${result[1]}`;
    }
}
exports.Image = Image;
_a = JSII_RTTI_SYMBOL_1;
Image[_a] = { fqn: "cdk8s-image.Image", version: "0.2.149" };
//# sourceMappingURL=data:application/json;base64,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