"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PythonFunction = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const path = require("path");
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const bundling_1 = require("./bundling");
/**
 * A Python Lambda function
 */
class PythonFunction extends aws_lambda_1.Function {
    constructor(scope, id, props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_lambda_python_alpha_PythonFunctionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, PythonFunction);
            }
            throw error;
        }
        const { index = 'index.py', handler = 'handler', runtime } = props;
        if (props.index && !/\.py$/.test(props.index)) {
            throw new Error('Only Python (.py) index files are supported.');
        }
        // Entry
        const entry = path.resolve(props.entry);
        const resolvedIndex = path.resolve(entry, index);
        if (!fs.existsSync(resolvedIndex)) {
            throw new Error(`Cannot find index file at ${resolvedIndex}`);
        }
        const resolvedHandler = `${index.slice(0, -3)}.${handler}`.replace(/\//g, '.');
        if (props.runtime && props.runtime.family !== aws_lambda_1.RuntimeFamily.PYTHON) {
            throw new Error('Only `PYTHON` runtimes are supported.');
        }
        super(scope, id, {
            ...props,
            runtime,
            code: bundling_1.Bundling.bundle({
                entry,
                runtime,
                skip: !aws_cdk_lib_1.Stack.of(scope).bundlingRequired,
                ...props.bundling,
            }),
            handler: resolvedHandler,
        });
    }
}
exports.PythonFunction = PythonFunction;
_a = JSII_RTTI_SYMBOL_1;
PythonFunction[_a] = { fqn: "@aws-cdk/aws-lambda-python-alpha.PythonFunction", version: "2.32.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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