#MAEC Malware Subject Reference Class

#Copyright (c) 2014, The MITRE Corporation
#All rights reserved

#Compatible with MAEC v4.1
#Last updated 02/18/2014

import maec
import maec.bindings.maec_package as package_binding
       
class MalwareSubjectReference(maec.Entity):
    _namespace = maec.package._namespace

    def init(self, malware_subject_idref = None):
        super(MalwareSubjectReference, self).__init__()
        self.malware_subject_idref = malware_subject_idref

    def to_obj(self):
        malware_subject_reference_obj = package_binding.MalwareSubjectReferenceType()
        if self.malware_subject_idref is not None : malware_subject_reference_obj.set_malware_subject_idref(self.malware_subject_idref)
        return malware_subject_reference_obj

    def to_dict(self):
        malware_subject_reference_dict = {}
        if self.malware_subject_idref is not None : malware_subject_reference_dict['malware_subject_idref'] = self.malware_subject_idref
        return malware_subject_reference_dict

    @staticmethod
    def from_dict(malware_subject_reference_dict):
        if not malware_subject_reference_dict:
            return None
        malware_subject_reference_ = MalwareSubjectReference()
        malware_subject_reference_.malware_subject_idref = malware_subject_reference_dict.get('malware_subject_idref')
        return malware_subject_reference_

    @staticmethod
    def from_obj(malware_subject_reference_obj):
        if not malware_subject_reference_obj:
            return None
        malware_subject_reference_ = MalwareSubjectReference()
        malware_subject_reference_.malware_subject_idref = malware_subject_reference_obj.get_malware_subject_idref()
        return malware_subject_reference_
        