#!/usr/bin/env python3
#
# travo documentation build configuration file.
#
# This file is execfile()d with the current directory set to its
# containing dir.
#
# Note that not all possible configuration values are present in this
# autogenerated file.

from importlib.metadata import version

extensions = [
    "autoapi.extension",
    "numpydoc",
    "sphinx.ext.autodoc",
    "sphinx.ext.intersphinx",
    "sphinx.ext.mathjax",  # Maths visualization
    "sphinx.ext.graphviz",  # Dependency diagrams
    "sphinx_copybutton",
    "myst_nb",
    "sphinx_tabs.tabs",
    "sphinx_togglebutton",
]

# MathJax config
# See https://github.com/spatialaudio/nbsphinx/issues/572#issuecomment-853389268
mathjax_path = (
    "https://cdn.jsdelivr.net/npm/mathjax@2/MathJax.js?config=TeX-AMS-MML_HTMLorMML"
)
mathjax2_config = {
    "tex2jax": {
        "inlineMath": [["$", "$"], ["\\(", "\\)"]],
        "processEscapes": True,
        "ignoreClass": "document",
        "processClass": "math|output_area",
    }
}
myst_update_mathjax = False

# Other
autodoc_member_order = "bysource"
templates_path = ["_templates"]
source_suffix = {
    ".rst": "restructuredtext",
    ".myst.md": "myst-nb",
    ".md": "myst-nb",
}

# copybutton config
copybutton_prompt_text = ">>> "

project = "Travo"
copyright = "2023,2024 Travo development team"

project_ver = version(project)
version = ".".join(project_ver.split(".")[:2])
release = project_ver

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
exclude_patterns = ["talks", "_build", "**.ipynb_checkpoints"]

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = "sphinx"

# Intersphinx configuration
intersphinx_mapping = {
    "python": ("https://docs.python.org/3", None),
}

# -- Options for HTML output

html_theme = "sphinx_rtd_theme"
html_theme_options = {
    "header_links_before_dropdown": 3,
    "icon_links": [
        {
            # Label for this link
            "name": "GitLab",
            # URL where the link will redirect
            "url": "https://gitlab.com/travo-cr/travo",  # required
            # Icon class (if "type": "fontawesome"), or path to local
            # image (if "type": "local")
            "icon": "fa-brands fa-square-gitlab",
            # The type of image to be used
            "type": "fontawesome",
        },
        {
            "name": "PyPI",
            "url": "https://pypi.org/project/travo",
            "icon": "fa-custom fa-pypi",
            "type": "fontawesome",
        },
    ],
}

nb_custom_formats = {
    ".myst.md": ["jupytext.reads", {"fmt": "mystnb"}],
}

# sphinx-autoapi configuration
autoapi_type = "python"
autoapi_dirs = ["../../travo/"]
autoapi_options = [
    "members",
    "undoc-members",
    "show-inheritance",
    "show-module-summary",
    "special-members",
    "inherited-members",
]
autoapi_add_toctree_entry = False
autoapi_ignore = ["*/test_*.py", "*tests/__init__.py"]
