# coding: utf-8

"""
    Planetary Data System Registry API

    Federated PDS API which provides actionable end points standardized between the different nodes.   # noqa: E501

    The version of the OpenAPI document: 1.1
    Contact: pds-operator@jpl.nasa.gov
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from pds.api_client.api_client import ApiClient
from pds.api_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class BundlesProductsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def products_of_a_bundle(self, identifier, **kwargs):  # noqa: E501
        """get products belonging to a given bundle  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.products_of_a_bundle(identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str identifier: lidvid or lid (required)
        :param int start: offset in matching result list, for pagination
        :param int limit: maximum number of matching results returned, for pagination
        :param list[str] fields: returned fields, syntax field0,field1
        :param list[str] sort: sort results, syntax asc(field0),desc(field1)
        :param bool only_summary: only return the summary, useful to get the list of available properties
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Products
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.products_of_a_bundle_with_http_info(identifier, **kwargs)  # noqa: E501

    def products_of_a_bundle_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """get products belonging to a given bundle  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.products_of_a_bundle_with_http_info(identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str identifier: lidvid or lid (required)
        :param int start: offset in matching result list, for pagination
        :param int limit: maximum number of matching results returned, for pagination
        :param list[str] fields: returned fields, syntax field0,field1
        :param list[str] sort: sort results, syntax asc(field0),desc(field1)
        :param bool only_summary: only return the summary, useful to get the list of available properties
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Products, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'identifier',
            'start',
            'limit',
            'fields',
            'sort',
            'only_summary'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method products_of_a_bundle" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in local_var_params or  # noqa: E501
                                                        local_var_params['identifier'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `identifier` when calling `products_of_a_bundle`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'identifier' in local_var_params:
            path_params['identifier'] = local_var_params['identifier']  # noqa: E501

        query_params = []
        if 'start' in local_var_params and local_var_params['start'] is not None:  # noqa: E501
            query_params.append(('start', local_var_params['start']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'fields' in local_var_params and local_var_params['fields'] is not None:  # noqa: E501
            query_params.append(('fields', local_var_params['fields']))  # noqa: E501
            collection_formats['fields'] = 'multi'  # noqa: E501
        if 'sort' in local_var_params and local_var_params['sort'] is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
            collection_formats['sort'] = 'multi'  # noqa: E501
        if 'only_summary' in local_var_params and local_var_params['only_summary'] is not None:  # noqa: E501
            query_params.append(('only-summary', local_var_params['only_summary']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/bundles/{identifier}/products', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Products',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
