# coding: utf-8

"""
    Planetary Data System DOI Service API

    PDS API for managing DOI registration with OSTI service.  # noqa: E501

    The version of the OpenAPI document: 0.1
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from pds.api_client.api_client import ApiClient
from pds.api_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class DoisApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_check_dois(self, submitter, **kwargs):  # noqa: E501
        """get_check_dois  # noqa: E501

        Check submission status of all records pending release.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_check_dois(submitter, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str submitter: The email address of the user to register as author of the check action. This address is also included in the list of recipients. (required)
        :param bool email: If true, the check action sends results to the default recipients and pending DOI submitters.
        :param bool attachment: If true, the check action sends results as an email attachment. Has no effect if the email flag is not set to true.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DoiRecord
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_check_dois_with_http_info(submitter, **kwargs)  # noqa: E501

    def get_check_dois_with_http_info(self, submitter, **kwargs):  # noqa: E501
        """get_check_dois  # noqa: E501

        Check submission status of all records pending release.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_check_dois_with_http_info(submitter, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str submitter: The email address of the user to register as author of the check action. This address is also included in the list of recipients. (required)
        :param bool email: If true, the check action sends results to the default recipients and pending DOI submitters.
        :param bool attachment: If true, the check action sends results as an email attachment. Has no effect if the email flag is not set to true.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DoiRecord, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'submitter',
            'email',
            'attachment'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_check_dois" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'submitter' is set
        if self.api_client.client_side_validation and ('submitter' not in local_var_params or  # noqa: E501
                                                        local_var_params['submitter'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `submitter` when calling `get_check_dois`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'email' in local_var_params and local_var_params['email'] is not None:  # noqa: E501
            query_params.append(('email', local_var_params['email']))  # noqa: E501
        if 'attachment' in local_var_params and local_var_params['attachment'] is not None:  # noqa: E501
            query_params.append(('attachment', local_var_params['attachment']))  # noqa: E501
        if 'submitter' in local_var_params and local_var_params['submitter'] is not None:  # noqa: E501
            query_params.append(('submitter', local_var_params['submitter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/dois/check', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DoiRecord',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_doi_from_id(self, lidvid, **kwargs):  # noqa: E501
        """get_doi_from_id  # noqa: E501

        Get the status of a DOI from the transaction database.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_doi_from_id(lidvid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str lidvid: The LIDVID associated with the record to status or update. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DoiRecord
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_doi_from_id_with_http_info(lidvid, **kwargs)  # noqa: E501

    def get_doi_from_id_with_http_info(self, lidvid, **kwargs):  # noqa: E501
        """get_doi_from_id  # noqa: E501

        Get the status of a DOI from the transaction database.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_doi_from_id_with_http_info(lidvid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str lidvid: The LIDVID associated with the record to status or update. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DoiRecord, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'lidvid'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_doi_from_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'lidvid' is set
        if self.api_client.client_side_validation and ('lidvid' not in local_var_params or  # noqa: E501
                                                        local_var_params['lidvid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `lidvid` when calling `get_doi_from_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'lidvid' in local_var_params:
            path_params['lidvid'] = local_var_params['lidvid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/dois/{lidvid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DoiRecord',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_dois(self, **kwargs):  # noqa: E501
        """get_dois  # noqa: E501

        List the DOI requests within the transaction database  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dois(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param list[str] doi: List of DOIs to fetch from transaction database.
        :param list[str] submitter: List of submitter email addresses to filter DOIs by.
        :param list[str] node: List of PDS node names cited as contributor of the DOI to filter by. Each identifier must be one of the valid PDS steward IDs, see  https://pds.nasa.gov/datastandards/documents/dd/current/PDS4_PDS_DD_1D00.html#d5e72146
        :param list[str] status: List of DOI workflow status values to filter results by. Status must be one of the following - \"unknown\", \"reserved_not_submitted\",  \"reserved\", \"draft\", \"review\", \"pending\", or \"registered\".
        :param list[str] lid: List of LIDs to filter DOIs by. An LID may include the VID appended to the end.
        :param datetime start_date: A start date to filter resulting DOI records by. Only records with an update time after this date will be returned. Value must be of the form \\<YYYY\\>-\\<mm\\>-\\<dd\\>T\\<HH\\>:\\<MM\\>:\\<SS\\>.\\<ms\\>
        :param datetime end_date: An end date to filter resulting DOI records by. Only records with an update time prior to this date will be returned. Value must be of the form \\<YYYY\\>-\\<mm\\>-\\<dd\\>T\\<HH\\>:\\<SS\\>.\\<ms\\>
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[DoiSummary]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_dois_with_http_info(**kwargs)  # noqa: E501

    def get_dois_with_http_info(self, **kwargs):  # noqa: E501
        """get_dois  # noqa: E501

        List the DOI requests within the transaction database  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dois_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param list[str] doi: List of DOIs to fetch from transaction database.
        :param list[str] submitter: List of submitter email addresses to filter DOIs by.
        :param list[str] node: List of PDS node names cited as contributor of the DOI to filter by. Each identifier must be one of the valid PDS steward IDs, see  https://pds.nasa.gov/datastandards/documents/dd/current/PDS4_PDS_DD_1D00.html#d5e72146
        :param list[str] status: List of DOI workflow status values to filter results by. Status must be one of the following - \"unknown\", \"reserved_not_submitted\",  \"reserved\", \"draft\", \"review\", \"pending\", or \"registered\".
        :param list[str] lid: List of LIDs to filter DOIs by. An LID may include the VID appended to the end.
        :param datetime start_date: A start date to filter resulting DOI records by. Only records with an update time after this date will be returned. Value must be of the form \\<YYYY\\>-\\<mm\\>-\\<dd\\>T\\<HH\\>:\\<MM\\>:\\<SS\\>.\\<ms\\>
        :param datetime end_date: An end date to filter resulting DOI records by. Only records with an update time prior to this date will be returned. Value must be of the form \\<YYYY\\>-\\<mm\\>-\\<dd\\>T\\<HH\\>:\\<SS\\>.\\<ms\\>
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[DoiSummary], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'doi',
            'submitter',
            'node',
            'status',
            'lid',
            'start_date',
            'end_date'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_dois" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'doi' in local_var_params and local_var_params['doi'] is not None:  # noqa: E501
            query_params.append(('doi', local_var_params['doi']))  # noqa: E501
            collection_formats['doi'] = 'multi'  # noqa: E501
        if 'submitter' in local_var_params and local_var_params['submitter'] is not None:  # noqa: E501
            query_params.append(('submitter', local_var_params['submitter']))  # noqa: E501
            collection_formats['submitter'] = 'multi'  # noqa: E501
        if 'node' in local_var_params and local_var_params['node'] is not None:  # noqa: E501
            query_params.append(('node', local_var_params['node']))  # noqa: E501
            collection_formats['node'] = 'multi'  # noqa: E501
        if 'status' in local_var_params and local_var_params['status'] is not None:  # noqa: E501
            query_params.append(('status', local_var_params['status']))  # noqa: E501
            collection_formats['status'] = 'multi'  # noqa: E501
        if 'lid' in local_var_params and local_var_params['lid'] is not None:  # noqa: E501
            query_params.append(('lid', local_var_params['lid']))  # noqa: E501
            collection_formats['lid'] = 'multi'  # noqa: E501
        if 'start_date' in local_var_params and local_var_params['start_date'] is not None:  # noqa: E501
            query_params.append(('start_date', local_var_params['start_date']))  # noqa: E501
        if 'end_date' in local_var_params and local_var_params['end_date'] is not None:  # noqa: E501
            query_params.append(('end_date', local_var_params['end_date']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/dois', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[DoiSummary]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_dois(self, action, submitter, node, **kwargs):  # noqa: E501
        """post_dois  # noqa: E501

        Submit a DOI in reserve or draft status. The payload includes URLs for one or more  records to be submitted. Record URLs must resolve to PDS4 label files (xml).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_dois(action, submitter, node, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str action: The submission action to perform. Must be one of \"reserve\" or \"draft\". (required)
        :param str submitter: Email address of the submission requester. (required)
        :param str node: The PDS node name to cite as contributor of the DOI. Must be one of the valid PDS steward IDs, see  https://pds.nasa.gov/datastandards/documents/dd/current/PDS4_PDS_DD_1D00.html#d5e72146 (required)
        :param str url: URL to provide as the record to register a DOI for. URL must start with either \"http://\" or \"https://\" and resolve to a valid PDS4 label in XML format. This value is only utilized when request is set to \"draft\".
        :param bool force: If true, forces a reserve request to completion, ignoring any warnings encountered. Has no effect for draft requests.
        :param LabelsPayload labels_payload: Payload containing one or more labels in JSON or XML (PDS4) format. Required for reserve requests, but optional for draft.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DoiRecord
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.post_dois_with_http_info(action, submitter, node, **kwargs)  # noqa: E501

    def post_dois_with_http_info(self, action, submitter, node, **kwargs):  # noqa: E501
        """post_dois  # noqa: E501

        Submit a DOI in reserve or draft status. The payload includes URLs for one or more  records to be submitted. Record URLs must resolve to PDS4 label files (xml).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_dois_with_http_info(action, submitter, node, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str action: The submission action to perform. Must be one of \"reserve\" or \"draft\". (required)
        :param str submitter: Email address of the submission requester. (required)
        :param str node: The PDS node name to cite as contributor of the DOI. Must be one of the valid PDS steward IDs, see  https://pds.nasa.gov/datastandards/documents/dd/current/PDS4_PDS_DD_1D00.html#d5e72146 (required)
        :param str url: URL to provide as the record to register a DOI for. URL must start with either \"http://\" or \"https://\" and resolve to a valid PDS4 label in XML format. This value is only utilized when request is set to \"draft\".
        :param bool force: If true, forces a reserve request to completion, ignoring any warnings encountered. Has no effect for draft requests.
        :param LabelsPayload labels_payload: Payload containing one or more labels in JSON or XML (PDS4) format. Required for reserve requests, but optional for draft.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DoiRecord, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'action',
            'submitter',
            'node',
            'url',
            'force',
            'labels_payload'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_dois" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'action' is set
        if self.api_client.client_side_validation and ('action' not in local_var_params or  # noqa: E501
                                                        local_var_params['action'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `action` when calling `post_dois`")  # noqa: E501
        # verify the required parameter 'submitter' is set
        if self.api_client.client_side_validation and ('submitter' not in local_var_params or  # noqa: E501
                                                        local_var_params['submitter'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `submitter` when calling `post_dois`")  # noqa: E501
        # verify the required parameter 'node' is set
        if self.api_client.client_side_validation and ('node' not in local_var_params or  # noqa: E501
                                                        local_var_params['node'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `node` when calling `post_dois`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'action' in local_var_params and local_var_params['action'] is not None:  # noqa: E501
            query_params.append(('action', local_var_params['action']))  # noqa: E501
        if 'submitter' in local_var_params and local_var_params['submitter'] is not None:  # noqa: E501
            query_params.append(('submitter', local_var_params['submitter']))  # noqa: E501
        if 'node' in local_var_params and local_var_params['node'] is not None:  # noqa: E501
            query_params.append(('node', local_var_params['node']))  # noqa: E501
        if 'url' in local_var_params and local_var_params['url'] is not None:  # noqa: E501
            query_params.append(('url', local_var_params['url']))  # noqa: E501
        if 'force' in local_var_params and local_var_params['force'] is not None:  # noqa: E501
            query_params.append(('force', local_var_params['force']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'labels_payload' in local_var_params:
            body_params = local_var_params['labels_payload']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/dois', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DoiRecord',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_submit_doi(self, lidvid, **kwargs):  # noqa: E501
        """post_submit_doi  # noqa: E501

        Move a DOI record from draft/reserve status to \"review\".  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_submit_doi(lidvid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str lidvid: The LIDVID associated with the record to submit for review. (required)
        :param bool force: If true, forces a submit request to completion, ignoring any warnings encountered.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DoiRecord
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.post_submit_doi_with_http_info(lidvid, **kwargs)  # noqa: E501

    def post_submit_doi_with_http_info(self, lidvid, **kwargs):  # noqa: E501
        """post_submit_doi  # noqa: E501

        Move a DOI record from draft/reserve status to \"review\".  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_submit_doi_with_http_info(lidvid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str lidvid: The LIDVID associated with the record to submit for review. (required)
        :param bool force: If true, forces a submit request to completion, ignoring any warnings encountered.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DoiRecord, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'lidvid',
            'force'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_submit_doi" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'lidvid' is set
        if self.api_client.client_side_validation and ('lidvid' not in local_var_params or  # noqa: E501
                                                        local_var_params['lidvid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `lidvid` when calling `post_submit_doi`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'lidvid' in local_var_params:
            path_params['lidvid'] = local_var_params['lidvid']  # noqa: E501

        query_params = []
        if 'force' in local_var_params and local_var_params['force'] is not None:  # noqa: E501
            query_params.append(('force', local_var_params['force']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/dois/{lidvid}/submit', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DoiRecord',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def put_doi_from_id(self, lidvid, **kwargs):  # noqa: E501
        """put_doi_from_id  # noqa: E501

        Update the record associated with an existing DOI.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_doi_from_id(lidvid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str lidvid: The LIDVID associated with the record to status or update. (required)
        :param str submitter: Email address of the DOI update requester.
        :param str node: The PDS node name to cite as contributor of the DOI. Must be one of the valid PDS steward IDs, see  https://pds.nasa.gov/datastandards/documents/dd/current/PDS4_PDS_DD_1D00.html#d5e72146
        :param str url: URL to provide as the record to update the DOI with. URL must start with either \"http://\" or \"https://\" and resolve to a valid PDS4 label in XML format.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.put_doi_from_id_with_http_info(lidvid, **kwargs)  # noqa: E501

    def put_doi_from_id_with_http_info(self, lidvid, **kwargs):  # noqa: E501
        """put_doi_from_id  # noqa: E501

        Update the record associated with an existing DOI.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_doi_from_id_with_http_info(lidvid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str lidvid: The LIDVID associated with the record to status or update. (required)
        :param str submitter: Email address of the DOI update requester.
        :param str node: The PDS node name to cite as contributor of the DOI. Must be one of the valid PDS steward IDs, see  https://pds.nasa.gov/datastandards/documents/dd/current/PDS4_PDS_DD_1D00.html#d5e72146
        :param str url: URL to provide as the record to update the DOI with. URL must start with either \"http://\" or \"https://\" and resolve to a valid PDS4 label in XML format.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'lidvid',
            'submitter',
            'node',
            'url'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_doi_from_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'lidvid' is set
        if self.api_client.client_side_validation and ('lidvid' not in local_var_params or  # noqa: E501
                                                        local_var_params['lidvid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `lidvid` when calling `put_doi_from_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'lidvid' in local_var_params:
            path_params['lidvid'] = local_var_params['lidvid']  # noqa: E501

        query_params = []
        if 'submitter' in local_var_params and local_var_params['submitter'] is not None:  # noqa: E501
            query_params.append(('submitter', local_var_params['submitter']))  # noqa: E501
        if 'node' in local_var_params and local_var_params['node'] is not None:  # noqa: E501
            query_params.append(('node', local_var_params['node']))  # noqa: E501
        if 'url' in local_var_params and local_var_params['url'] is not None:  # noqa: E501
            query_params.append(('url', local_var_params['url']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/dois/{lidvid}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
