# coding: utf-8

"""
    Registry API

    Registry API enabling advanced search on PDS data and metadata. The API provides end-points to search for bundles, collections and any PDS products with advanced search queries. It also enables to browse the archive hierarchically downward (e.g. collection/s products) or upward (e.g. bundles containing a product). The detailed syntax for querying the end-point is given in the reference documentation.   # noqa: E501

    The version of the OpenAPI document: 1.1
    Contact: pds-operator@jpl.nasa.gov
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from pds.api_client.api_client import ApiClient
from pds.api_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class ReferencesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def class_member_of(self, _class, identifier, **kwargs):  # noqa: E501
        """returns one or more PDS Products that have the given PDS product class and lid/lidvid as a member.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.class_member_of(_class, identifier, async_req=True)
        >>> result = thread.get()

        :param _class: syntax: one of the allowable enum values  This is a shortcut for doing a query with ...  (required)
        :type _class: str
        :param identifier: syntax: lidvid or lid  behavior (lid): returns one or more items whose lid matches this lid exactly. If the endpoint ends with the identifier or /latest then a signle result is returned and it is the highest version. If the endpoint ends with /all then all versions of the lid are returned.  behavior (lidvid): returns one and only one item whose lidvid matches this lidvid exactly.  note: the current lid/lidvid resolution will match all the lids that start with lid. In other words, it acts like a glob of foobar*. It behavesn this way from first character to the last  note: simple sorting of the lidvid is being done to select the latest from the end of the list. However, the versions 1.0, 2.0, and 13.0 will sort to 1.0, 13.0, and 2.0 so the end of the list may not be the latest.  (required)
        :type identifier: str
        :param fields: syntax: fields=field1,field2,...  behavior: this parameter and the headder Accept: type determine what content is packaged for the result. While the types application/csv, application/kvp+json, and text/csv return only the fields requesteted, all of the other types have a minimal set of fields that must be returned. Duplicating a minimally required field in this parameter has not effect. The types vnd.nasa.pds.pds4+json and vnd.nasa.pds.pds4+xml have a complete set of fields that must be returned; meaning this parameter does not impact their content. When fields is not used, then the minimal set of fields, or all when minimal is an empty set, is returned.  notes: the blob fields are blocked unless specifically requrested and only for the */csv and application/kvp+csv types. 
        :type fields: list[str]
        :param limit: syntax: limit=10  behavior: maximum number of matching results returned, for pagination  note: limit=0 returns just the summary 
        :type limit: int
        :param sort: syntax: sort=asc(field0),desc(field1),...  behavior: is this implemented? 
        :type sort: list[str]
        :param start: syntax: start=12  behavior: offset in matching result list, for pagination 
        :type start: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: object
        """
        kwargs['_return_http_data_only'] = True
        return self.class_member_of_with_http_info(_class, identifier, **kwargs)  # noqa: E501

    def class_member_of_with_http_info(self, _class, identifier, **kwargs):  # noqa: E501
        """returns one or more PDS Products that have the given PDS product class and lid/lidvid as a member.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.class_member_of_with_http_info(_class, identifier, async_req=True)
        >>> result = thread.get()

        :param _class: syntax: one of the allowable enum values  This is a shortcut for doing a query with ...  (required)
        :type _class: str
        :param identifier: syntax: lidvid or lid  behavior (lid): returns one or more items whose lid matches this lid exactly. If the endpoint ends with the identifier or /latest then a signle result is returned and it is the highest version. If the endpoint ends with /all then all versions of the lid are returned.  behavior (lidvid): returns one and only one item whose lidvid matches this lidvid exactly.  note: the current lid/lidvid resolution will match all the lids that start with lid. In other words, it acts like a glob of foobar*. It behavesn this way from first character to the last  note: simple sorting of the lidvid is being done to select the latest from the end of the list. However, the versions 1.0, 2.0, and 13.0 will sort to 1.0, 13.0, and 2.0 so the end of the list may not be the latest.  (required)
        :type identifier: str
        :param fields: syntax: fields=field1,field2,...  behavior: this parameter and the headder Accept: type determine what content is packaged for the result. While the types application/csv, application/kvp+json, and text/csv return only the fields requesteted, all of the other types have a minimal set of fields that must be returned. Duplicating a minimally required field in this parameter has not effect. The types vnd.nasa.pds.pds4+json and vnd.nasa.pds.pds4+xml have a complete set of fields that must be returned; meaning this parameter does not impact their content. When fields is not used, then the minimal set of fields, or all when minimal is an empty set, is returned.  notes: the blob fields are blocked unless specifically requrested and only for the */csv and application/kvp+csv types. 
        :type fields: list[str]
        :param limit: syntax: limit=10  behavior: maximum number of matching results returned, for pagination  note: limit=0 returns just the summary 
        :type limit: int
        :param sort: syntax: sort=asc(field0),desc(field1),...  behavior: is this implemented? 
        :type sort: list[str]
        :param start: syntax: start=12  behavior: offset in matching result list, for pagination 
        :type start: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(object, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            '_class',
            'identifier',
            'fields',
            'limit',
            'sort',
            'start'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method class_member_of" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter '_class' is set
        if self.api_client.client_side_validation and local_var_params.get('_class') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `_class` when calling `class_member_of`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and local_var_params.get('identifier') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `identifier` when calling `class_member_of`")  # noqa: E501

        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `class_member_of`, must be a value greater than or equal to `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'start' in local_var_params and local_var_params['start'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `start` when calling `class_member_of`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if '_class' in local_var_params:
            path_params['class'] = local_var_params['_class']  # noqa: E501
        if 'identifier' in local_var_params:
            path_params['identifier'] = local_var_params['identifier']  # noqa: E501

        query_params = []
        if local_var_params.get('fields') is not None:  # noqa: E501
            query_params.append(('fields', local_var_params['fields']))  # noqa: E501
            collection_formats['fields'] = 'multi'  # noqa: E501
        if local_var_params.get('limit') is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if local_var_params.get('sort') is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
            collection_formats['sort'] = 'multi'  # noqa: E501
        if local_var_params.get('start') is not None:  # noqa: E501
            query_params.append(('start', local_var_params['start']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*', '*/*', 'application/csv', 'application/json', 'application/kvp+json', 'application/vnd.nasa.pds.pds4+json', 'application/vnd.nasa.pds.pds4+xml', 'application/xml', 'text/csv', 'text/html', 'text/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {
            200: "object",
            400: "ErrorMessage",
            404: "ErrorMessage",
            500: "ErrorMessage",
            501: "ErrorMessage",
        }

        return self.api_client.call_api(
            '/classes/{class}/{identifier}/member-of', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def class_member_of_of(self, _class, identifier, **kwargs):  # noqa: E501
        """returns one or more PDS Products that have the given PDS product class and lid/lidvid as a member of its members.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.class_member_of_of(_class, identifier, async_req=True)
        >>> result = thread.get()

        :param _class: syntax: one of the allowable enum values  This is a shortcut for doing a query with ...  (required)
        :type _class: str
        :param identifier: syntax: lidvid or lid  behavior (lid): returns one or more items whose lid matches this lid exactly. If the endpoint ends with the identifier or /latest then a signle result is returned and it is the highest version. If the endpoint ends with /all then all versions of the lid are returned.  behavior (lidvid): returns one and only one item whose lidvid matches this lidvid exactly.  note: the current lid/lidvid resolution will match all the lids that start with lid. In other words, it acts like a glob of foobar*. It behavesn this way from first character to the last  note: simple sorting of the lidvid is being done to select the latest from the end of the list. However, the versions 1.0, 2.0, and 13.0 will sort to 1.0, 13.0, and 2.0 so the end of the list may not be the latest.  (required)
        :type identifier: str
        :param fields: syntax: fields=field1,field2,...  behavior: this parameter and the headder Accept: type determine what content is packaged for the result. While the types application/csv, application/kvp+json, and text/csv return only the fields requesteted, all of the other types have a minimal set of fields that must be returned. Duplicating a minimally required field in this parameter has not effect. The types vnd.nasa.pds.pds4+json and vnd.nasa.pds.pds4+xml have a complete set of fields that must be returned; meaning this parameter does not impact their content. When fields is not used, then the minimal set of fields, or all when minimal is an empty set, is returned.  notes: the blob fields are blocked unless specifically requrested and only for the */csv and application/kvp+csv types. 
        :type fields: list[str]
        :param limit: syntax: limit=10  behavior: maximum number of matching results returned, for pagination  note: limit=0 returns just the summary 
        :type limit: int
        :param sort: syntax: sort=asc(field0),desc(field1),...  behavior: is this implemented? 
        :type sort: list[str]
        :param start: syntax: start=12  behavior: offset in matching result list, for pagination 
        :type start: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: object
        """
        kwargs['_return_http_data_only'] = True
        return self.class_member_of_of_with_http_info(_class, identifier, **kwargs)  # noqa: E501

    def class_member_of_of_with_http_info(self, _class, identifier, **kwargs):  # noqa: E501
        """returns one or more PDS Products that have the given PDS product class and lid/lidvid as a member of its members.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.class_member_of_of_with_http_info(_class, identifier, async_req=True)
        >>> result = thread.get()

        :param _class: syntax: one of the allowable enum values  This is a shortcut for doing a query with ...  (required)
        :type _class: str
        :param identifier: syntax: lidvid or lid  behavior (lid): returns one or more items whose lid matches this lid exactly. If the endpoint ends with the identifier or /latest then a signle result is returned and it is the highest version. If the endpoint ends with /all then all versions of the lid are returned.  behavior (lidvid): returns one and only one item whose lidvid matches this lidvid exactly.  note: the current lid/lidvid resolution will match all the lids that start with lid. In other words, it acts like a glob of foobar*. It behavesn this way from first character to the last  note: simple sorting of the lidvid is being done to select the latest from the end of the list. However, the versions 1.0, 2.0, and 13.0 will sort to 1.0, 13.0, and 2.0 so the end of the list may not be the latest.  (required)
        :type identifier: str
        :param fields: syntax: fields=field1,field2,...  behavior: this parameter and the headder Accept: type determine what content is packaged for the result. While the types application/csv, application/kvp+json, and text/csv return only the fields requesteted, all of the other types have a minimal set of fields that must be returned. Duplicating a minimally required field in this parameter has not effect. The types vnd.nasa.pds.pds4+json and vnd.nasa.pds.pds4+xml have a complete set of fields that must be returned; meaning this parameter does not impact their content. When fields is not used, then the minimal set of fields, or all when minimal is an empty set, is returned.  notes: the blob fields are blocked unless specifically requrested and only for the */csv and application/kvp+csv types. 
        :type fields: list[str]
        :param limit: syntax: limit=10  behavior: maximum number of matching results returned, for pagination  note: limit=0 returns just the summary 
        :type limit: int
        :param sort: syntax: sort=asc(field0),desc(field1),...  behavior: is this implemented? 
        :type sort: list[str]
        :param start: syntax: start=12  behavior: offset in matching result list, for pagination 
        :type start: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(object, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            '_class',
            'identifier',
            'fields',
            'limit',
            'sort',
            'start'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method class_member_of_of" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter '_class' is set
        if self.api_client.client_side_validation and local_var_params.get('_class') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `_class` when calling `class_member_of_of`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and local_var_params.get('identifier') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `identifier` when calling `class_member_of_of`")  # noqa: E501

        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `class_member_of_of`, must be a value greater than or equal to `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'start' in local_var_params and local_var_params['start'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `start` when calling `class_member_of_of`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if '_class' in local_var_params:
            path_params['class'] = local_var_params['_class']  # noqa: E501
        if 'identifier' in local_var_params:
            path_params['identifier'] = local_var_params['identifier']  # noqa: E501

        query_params = []
        if local_var_params.get('fields') is not None:  # noqa: E501
            query_params.append(('fields', local_var_params['fields']))  # noqa: E501
            collection_formats['fields'] = 'multi'  # noqa: E501
        if local_var_params.get('limit') is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if local_var_params.get('sort') is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
            collection_formats['sort'] = 'multi'  # noqa: E501
        if local_var_params.get('start') is not None:  # noqa: E501
            query_params.append(('start', local_var_params['start']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*', '*/*', 'application/csv', 'application/json', 'application/kvp+json', 'application/vnd.nasa.pds.pds4+json', 'application/vnd.nasa.pds.pds4+xml', 'application/xml', 'text/csv', 'text/html', 'text/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {
            200: "object",
            400: "ErrorMessage",
            404: "ErrorMessage",
            500: "ErrorMessage",
            501: "ErrorMessage",
        }

        return self.api_client.call_api(
            '/classes/{class}/{identifier}/member-of/member-of', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def class_member_of_of_vers(self, _class, identifier, versions, **kwargs):  # noqa: E501
        """returns one or more PDS Products that have the given PDS product class and lid/lidvid as a member of its members.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.class_member_of_of_vers(_class, identifier, versions, async_req=True)
        >>> result = thread.get()

        :param _class: syntax: one of the allowable enum values  This is a shortcut for doing a query with ...  (required)
        :type _class: str
        :param identifier: syntax: lidvid or lid  behavior (lid): returns one or more items whose lid matches this lid exactly. If the endpoint ends with the identifier or /latest then a signle result is returned and it is the highest version. If the endpoint ends with /all then all versions of the lid are returned.  behavior (lidvid): returns one and only one item whose lidvid matches this lidvid exactly.  note: the current lid/lidvid resolution will match all the lids that start with lid. In other words, it acts like a glob of foobar*. It behavesn this way from first character to the last  note: simple sorting of the lidvid is being done to select the latest from the end of the list. However, the versions 1.0, 2.0, and 13.0 will sort to 1.0, 13.0, and 2.0 so the end of the list may not be the latest.  (required)
        :type identifier: str
        :param versions: syntax: one of the allowable enum values  This is a shortcut for doing a query with ...  (required)
        :type versions: str
        :param fields: syntax: fields=field1,field2,...  behavior: this parameter and the headder Accept: type determine what content is packaged for the result. While the types application/csv, application/kvp+json, and text/csv return only the fields requesteted, all of the other types have a minimal set of fields that must be returned. Duplicating a minimally required field in this parameter has not effect. The types vnd.nasa.pds.pds4+json and vnd.nasa.pds.pds4+xml have a complete set of fields that must be returned; meaning this parameter does not impact their content. When fields is not used, then the minimal set of fields, or all when minimal is an empty set, is returned.  notes: the blob fields are blocked unless specifically requrested and only for the */csv and application/kvp+csv types. 
        :type fields: list[str]
        :param limit: syntax: limit=10  behavior: maximum number of matching results returned, for pagination  note: limit=0 returns just the summary 
        :type limit: int
        :param sort: syntax: sort=asc(field0),desc(field1),...  behavior: is this implemented? 
        :type sort: list[str]
        :param start: syntax: start=12  behavior: offset in matching result list, for pagination 
        :type start: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: object
        """
        kwargs['_return_http_data_only'] = True
        return self.class_member_of_of_vers_with_http_info(_class, identifier, versions, **kwargs)  # noqa: E501

    def class_member_of_of_vers_with_http_info(self, _class, identifier, versions, **kwargs):  # noqa: E501
        """returns one or more PDS Products that have the given PDS product class and lid/lidvid as a member of its members.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.class_member_of_of_vers_with_http_info(_class, identifier, versions, async_req=True)
        >>> result = thread.get()

        :param _class: syntax: one of the allowable enum values  This is a shortcut for doing a query with ...  (required)
        :type _class: str
        :param identifier: syntax: lidvid or lid  behavior (lid): returns one or more items whose lid matches this lid exactly. If the endpoint ends with the identifier or /latest then a signle result is returned and it is the highest version. If the endpoint ends with /all then all versions of the lid are returned.  behavior (lidvid): returns one and only one item whose lidvid matches this lidvid exactly.  note: the current lid/lidvid resolution will match all the lids that start with lid. In other words, it acts like a glob of foobar*. It behavesn this way from first character to the last  note: simple sorting of the lidvid is being done to select the latest from the end of the list. However, the versions 1.0, 2.0, and 13.0 will sort to 1.0, 13.0, and 2.0 so the end of the list may not be the latest.  (required)
        :type identifier: str
        :param versions: syntax: one of the allowable enum values  This is a shortcut for doing a query with ...  (required)
        :type versions: str
        :param fields: syntax: fields=field1,field2,...  behavior: this parameter and the headder Accept: type determine what content is packaged for the result. While the types application/csv, application/kvp+json, and text/csv return only the fields requesteted, all of the other types have a minimal set of fields that must be returned. Duplicating a minimally required field in this parameter has not effect. The types vnd.nasa.pds.pds4+json and vnd.nasa.pds.pds4+xml have a complete set of fields that must be returned; meaning this parameter does not impact their content. When fields is not used, then the minimal set of fields, or all when minimal is an empty set, is returned.  notes: the blob fields are blocked unless specifically requrested and only for the */csv and application/kvp+csv types. 
        :type fields: list[str]
        :param limit: syntax: limit=10  behavior: maximum number of matching results returned, for pagination  note: limit=0 returns just the summary 
        :type limit: int
        :param sort: syntax: sort=asc(field0),desc(field1),...  behavior: is this implemented? 
        :type sort: list[str]
        :param start: syntax: start=12  behavior: offset in matching result list, for pagination 
        :type start: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(object, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            '_class',
            'identifier',
            'versions',
            'fields',
            'limit',
            'sort',
            'start'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method class_member_of_of_vers" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter '_class' is set
        if self.api_client.client_side_validation and local_var_params.get('_class') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `_class` when calling `class_member_of_of_vers`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and local_var_params.get('identifier') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `identifier` when calling `class_member_of_of_vers`")  # noqa: E501
        # verify the required parameter 'versions' is set
        if self.api_client.client_side_validation and local_var_params.get('versions') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `versions` when calling `class_member_of_of_vers`")  # noqa: E501

        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `class_member_of_of_vers`, must be a value greater than or equal to `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'start' in local_var_params and local_var_params['start'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `start` when calling `class_member_of_of_vers`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if '_class' in local_var_params:
            path_params['class'] = local_var_params['_class']  # noqa: E501
        if 'identifier' in local_var_params:
            path_params['identifier'] = local_var_params['identifier']  # noqa: E501
        if 'versions' in local_var_params:
            path_params['versions'] = local_var_params['versions']  # noqa: E501

        query_params = []
        if local_var_params.get('fields') is not None:  # noqa: E501
            query_params.append(('fields', local_var_params['fields']))  # noqa: E501
            collection_formats['fields'] = 'multi'  # noqa: E501
        if local_var_params.get('limit') is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if local_var_params.get('sort') is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
            collection_formats['sort'] = 'multi'  # noqa: E501
        if local_var_params.get('start') is not None:  # noqa: E501
            query_params.append(('start', local_var_params['start']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*', '*/*', 'application/csv', 'application/json', 'application/kvp+json', 'application/vnd.nasa.pds.pds4+json', 'application/vnd.nasa.pds.pds4+xml', 'application/xml', 'text/csv', 'text/html', 'text/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {
            200: "object",
            400: "ErrorMessage",
            404: "ErrorMessage",
            500: "ErrorMessage",
            501: "ErrorMessage",
        }

        return self.api_client.call_api(
            '/classes/{class}/{identifier}/member-of/member-of/{versions}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def class_member_of_vers(self, _class, identifier, versions, **kwargs):  # noqa: E501
        """returns one or more PDS Products that have the given PDS product class and lid/lidvid as a member.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.class_member_of_vers(_class, identifier, versions, async_req=True)
        >>> result = thread.get()

        :param _class: syntax: one of the allowable enum values  This is a shortcut for doing a query with ...  (required)
        :type _class: str
        :param identifier: syntax: lidvid or lid  behavior (lid): returns one or more items whose lid matches this lid exactly. If the endpoint ends with the identifier or /latest then a signle result is returned and it is the highest version. If the endpoint ends with /all then all versions of the lid are returned.  behavior (lidvid): returns one and only one item whose lidvid matches this lidvid exactly.  note: the current lid/lidvid resolution will match all the lids that start with lid. In other words, it acts like a glob of foobar*. It behavesn this way from first character to the last  note: simple sorting of the lidvid is being done to select the latest from the end of the list. However, the versions 1.0, 2.0, and 13.0 will sort to 1.0, 13.0, and 2.0 so the end of the list may not be the latest.  (required)
        :type identifier: str
        :param versions: syntax: one of the allowable enum values  This is a shortcut for doing a query with ...  (required)
        :type versions: str
        :param fields: syntax: fields=field1,field2,...  behavior: this parameter and the headder Accept: type determine what content is packaged for the result. While the types application/csv, application/kvp+json, and text/csv return only the fields requesteted, all of the other types have a minimal set of fields that must be returned. Duplicating a minimally required field in this parameter has not effect. The types vnd.nasa.pds.pds4+json and vnd.nasa.pds.pds4+xml have a complete set of fields that must be returned; meaning this parameter does not impact their content. When fields is not used, then the minimal set of fields, or all when minimal is an empty set, is returned.  notes: the blob fields are blocked unless specifically requrested and only for the */csv and application/kvp+csv types. 
        :type fields: list[str]
        :param limit: syntax: limit=10  behavior: maximum number of matching results returned, for pagination  note: limit=0 returns just the summary 
        :type limit: int
        :param sort: syntax: sort=asc(field0),desc(field1),...  behavior: is this implemented? 
        :type sort: list[str]
        :param start: syntax: start=12  behavior: offset in matching result list, for pagination 
        :type start: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: object
        """
        kwargs['_return_http_data_only'] = True
        return self.class_member_of_vers_with_http_info(_class, identifier, versions, **kwargs)  # noqa: E501

    def class_member_of_vers_with_http_info(self, _class, identifier, versions, **kwargs):  # noqa: E501
        """returns one or more PDS Products that have the given PDS product class and lid/lidvid as a member.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.class_member_of_vers_with_http_info(_class, identifier, versions, async_req=True)
        >>> result = thread.get()

        :param _class: syntax: one of the allowable enum values  This is a shortcut for doing a query with ...  (required)
        :type _class: str
        :param identifier: syntax: lidvid or lid  behavior (lid): returns one or more items whose lid matches this lid exactly. If the endpoint ends with the identifier or /latest then a signle result is returned and it is the highest version. If the endpoint ends with /all then all versions of the lid are returned.  behavior (lidvid): returns one and only one item whose lidvid matches this lidvid exactly.  note: the current lid/lidvid resolution will match all the lids that start with lid. In other words, it acts like a glob of foobar*. It behavesn this way from first character to the last  note: simple sorting of the lidvid is being done to select the latest from the end of the list. However, the versions 1.0, 2.0, and 13.0 will sort to 1.0, 13.0, and 2.0 so the end of the list may not be the latest.  (required)
        :type identifier: str
        :param versions: syntax: one of the allowable enum values  This is a shortcut for doing a query with ...  (required)
        :type versions: str
        :param fields: syntax: fields=field1,field2,...  behavior: this parameter and the headder Accept: type determine what content is packaged for the result. While the types application/csv, application/kvp+json, and text/csv return only the fields requesteted, all of the other types have a minimal set of fields that must be returned. Duplicating a minimally required field in this parameter has not effect. The types vnd.nasa.pds.pds4+json and vnd.nasa.pds.pds4+xml have a complete set of fields that must be returned; meaning this parameter does not impact their content. When fields is not used, then the minimal set of fields, or all when minimal is an empty set, is returned.  notes: the blob fields are blocked unless specifically requrested and only for the */csv and application/kvp+csv types. 
        :type fields: list[str]
        :param limit: syntax: limit=10  behavior: maximum number of matching results returned, for pagination  note: limit=0 returns just the summary 
        :type limit: int
        :param sort: syntax: sort=asc(field0),desc(field1),...  behavior: is this implemented? 
        :type sort: list[str]
        :param start: syntax: start=12  behavior: offset in matching result list, for pagination 
        :type start: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(object, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            '_class',
            'identifier',
            'versions',
            'fields',
            'limit',
            'sort',
            'start'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method class_member_of_vers" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter '_class' is set
        if self.api_client.client_side_validation and local_var_params.get('_class') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `_class` when calling `class_member_of_vers`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and local_var_params.get('identifier') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `identifier` when calling `class_member_of_vers`")  # noqa: E501
        # verify the required parameter 'versions' is set
        if self.api_client.client_side_validation and local_var_params.get('versions') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `versions` when calling `class_member_of_vers`")  # noqa: E501

        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `class_member_of_vers`, must be a value greater than or equal to `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'start' in local_var_params and local_var_params['start'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `start` when calling `class_member_of_vers`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if '_class' in local_var_params:
            path_params['class'] = local_var_params['_class']  # noqa: E501
        if 'identifier' in local_var_params:
            path_params['identifier'] = local_var_params['identifier']  # noqa: E501
        if 'versions' in local_var_params:
            path_params['versions'] = local_var_params['versions']  # noqa: E501

        query_params = []
        if local_var_params.get('fields') is not None:  # noqa: E501
            query_params.append(('fields', local_var_params['fields']))  # noqa: E501
            collection_formats['fields'] = 'multi'  # noqa: E501
        if local_var_params.get('limit') is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if local_var_params.get('sort') is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
            collection_formats['sort'] = 'multi'  # noqa: E501
        if local_var_params.get('start') is not None:  # noqa: E501
            query_params.append(('start', local_var_params['start']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*', '*/*', 'application/csv', 'application/json', 'application/kvp+json', 'application/vnd.nasa.pds.pds4+json', 'application/vnd.nasa.pds.pds4+xml', 'application/xml', 'text/csv', 'text/html', 'text/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {
            200: "object",
            400: "ErrorMessage",
            404: "ErrorMessage",
            500: "ErrorMessage",
            501: "ErrorMessage",
        }

        return self.api_client.call_api(
            '/classes/{class}/{identifier}/member-of/{versions}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def class_members(self, _class, identifier, **kwargs):  # noqa: E501
        """returns one or more PDS Products that are members of the given PDS product class and lid/lidvid.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.class_members(_class, identifier, async_req=True)
        >>> result = thread.get()

        :param _class: syntax: one of the allowable enum values  This is a shortcut for doing a query with ...  (required)
        :type _class: str
        :param identifier: syntax: lidvid or lid  behavior (lid): returns one or more items whose lid matches this lid exactly. If the endpoint ends with the identifier or /latest then a signle result is returned and it is the highest version. If the endpoint ends with /all then all versions of the lid are returned.  behavior (lidvid): returns one and only one item whose lidvid matches this lidvid exactly.  note: the current lid/lidvid resolution will match all the lids that start with lid. In other words, it acts like a glob of foobar*. It behavesn this way from first character to the last  note: simple sorting of the lidvid is being done to select the latest from the end of the list. However, the versions 1.0, 2.0, and 13.0 will sort to 1.0, 13.0, and 2.0 so the end of the list may not be the latest.  (required)
        :type identifier: str
        :param fields: syntax: fields=field1,field2,...  behavior: this parameter and the headder Accept: type determine what content is packaged for the result. While the types application/csv, application/kvp+json, and text/csv return only the fields requesteted, all of the other types have a minimal set of fields that must be returned. Duplicating a minimally required field in this parameter has not effect. The types vnd.nasa.pds.pds4+json and vnd.nasa.pds.pds4+xml have a complete set of fields that must be returned; meaning this parameter does not impact their content. When fields is not used, then the minimal set of fields, or all when minimal is an empty set, is returned.  notes: the blob fields are blocked unless specifically requrested and only for the */csv and application/kvp+csv types. 
        :type fields: list[str]
        :param limit: syntax: limit=10  behavior: maximum number of matching results returned, for pagination  note: limit=0 returns just the summary 
        :type limit: int
        :param sort: syntax: sort=asc(field0),desc(field1),...  behavior: is this implemented? 
        :type sort: list[str]
        :param start: syntax: start=12  behavior: offset in matching result list, for pagination 
        :type start: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: object
        """
        kwargs['_return_http_data_only'] = True
        return self.class_members_with_http_info(_class, identifier, **kwargs)  # noqa: E501

    def class_members_with_http_info(self, _class, identifier, **kwargs):  # noqa: E501
        """returns one or more PDS Products that are members of the given PDS product class and lid/lidvid.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.class_members_with_http_info(_class, identifier, async_req=True)
        >>> result = thread.get()

        :param _class: syntax: one of the allowable enum values  This is a shortcut for doing a query with ...  (required)
        :type _class: str
        :param identifier: syntax: lidvid or lid  behavior (lid): returns one or more items whose lid matches this lid exactly. If the endpoint ends with the identifier or /latest then a signle result is returned and it is the highest version. If the endpoint ends with /all then all versions of the lid are returned.  behavior (lidvid): returns one and only one item whose lidvid matches this lidvid exactly.  note: the current lid/lidvid resolution will match all the lids that start with lid. In other words, it acts like a glob of foobar*. It behavesn this way from first character to the last  note: simple sorting of the lidvid is being done to select the latest from the end of the list. However, the versions 1.0, 2.0, and 13.0 will sort to 1.0, 13.0, and 2.0 so the end of the list may not be the latest.  (required)
        :type identifier: str
        :param fields: syntax: fields=field1,field2,...  behavior: this parameter and the headder Accept: type determine what content is packaged for the result. While the types application/csv, application/kvp+json, and text/csv return only the fields requesteted, all of the other types have a minimal set of fields that must be returned. Duplicating a minimally required field in this parameter has not effect. The types vnd.nasa.pds.pds4+json and vnd.nasa.pds.pds4+xml have a complete set of fields that must be returned; meaning this parameter does not impact their content. When fields is not used, then the minimal set of fields, or all when minimal is an empty set, is returned.  notes: the blob fields are blocked unless specifically requrested and only for the */csv and application/kvp+csv types. 
        :type fields: list[str]
        :param limit: syntax: limit=10  behavior: maximum number of matching results returned, for pagination  note: limit=0 returns just the summary 
        :type limit: int
        :param sort: syntax: sort=asc(field0),desc(field1),...  behavior: is this implemented? 
        :type sort: list[str]
        :param start: syntax: start=12  behavior: offset in matching result list, for pagination 
        :type start: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(object, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            '_class',
            'identifier',
            'fields',
            'limit',
            'sort',
            'start'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method class_members" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter '_class' is set
        if self.api_client.client_side_validation and local_var_params.get('_class') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `_class` when calling `class_members`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and local_var_params.get('identifier') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `identifier` when calling `class_members`")  # noqa: E501

        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `class_members`, must be a value greater than or equal to `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'start' in local_var_params and local_var_params['start'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `start` when calling `class_members`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if '_class' in local_var_params:
            path_params['class'] = local_var_params['_class']  # noqa: E501
        if 'identifier' in local_var_params:
            path_params['identifier'] = local_var_params['identifier']  # noqa: E501

        query_params = []
        if local_var_params.get('fields') is not None:  # noqa: E501
            query_params.append(('fields', local_var_params['fields']))  # noqa: E501
            collection_formats['fields'] = 'multi'  # noqa: E501
        if local_var_params.get('limit') is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if local_var_params.get('sort') is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
            collection_formats['sort'] = 'multi'  # noqa: E501
        if local_var_params.get('start') is not None:  # noqa: E501
            query_params.append(('start', local_var_params['start']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*', '*/*', 'application/csv', 'application/json', 'application/kvp+json', 'application/vnd.nasa.pds.pds4+json', 'application/vnd.nasa.pds.pds4+xml', 'application/xml', 'text/csv', 'text/html', 'text/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {
            200: "object",
            400: "ErrorMessage",
            404: "ErrorMessage",
            500: "ErrorMessage",
            501: "ErrorMessage",
        }

        return self.api_client.call_api(
            '/classes/{class}/{identifier}/members', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def class_members_members(self, _class, identifier, **kwargs):  # noqa: E501
        """returns one or more PDS Products that are the members of the members of the given PDS product class and lid/lidvid.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.class_members_members(_class, identifier, async_req=True)
        >>> result = thread.get()

        :param _class: syntax: one of the allowable enum values  This is a shortcut for doing a query with ...  (required)
        :type _class: str
        :param identifier: syntax: lidvid or lid  behavior (lid): returns one or more items whose lid matches this lid exactly. If the endpoint ends with the identifier or /latest then a signle result is returned and it is the highest version. If the endpoint ends with /all then all versions of the lid are returned.  behavior (lidvid): returns one and only one item whose lidvid matches this lidvid exactly.  note: the current lid/lidvid resolution will match all the lids that start with lid. In other words, it acts like a glob of foobar*. It behavesn this way from first character to the last  note: simple sorting of the lidvid is being done to select the latest from the end of the list. However, the versions 1.0, 2.0, and 13.0 will sort to 1.0, 13.0, and 2.0 so the end of the list may not be the latest.  (required)
        :type identifier: str
        :param fields: syntax: fields=field1,field2,...  behavior: this parameter and the headder Accept: type determine what content is packaged for the result. While the types application/csv, application/kvp+json, and text/csv return only the fields requesteted, all of the other types have a minimal set of fields that must be returned. Duplicating a minimally required field in this parameter has not effect. The types vnd.nasa.pds.pds4+json and vnd.nasa.pds.pds4+xml have a complete set of fields that must be returned; meaning this parameter does not impact their content. When fields is not used, then the minimal set of fields, or all when minimal is an empty set, is returned.  notes: the blob fields are blocked unless specifically requrested and only for the */csv and application/kvp+csv types. 
        :type fields: list[str]
        :param limit: syntax: limit=10  behavior: maximum number of matching results returned, for pagination  note: limit=0 returns just the summary 
        :type limit: int
        :param sort: syntax: sort=asc(field0),desc(field1),...  behavior: is this implemented? 
        :type sort: list[str]
        :param start: syntax: start=12  behavior: offset in matching result list, for pagination 
        :type start: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: object
        """
        kwargs['_return_http_data_only'] = True
        return self.class_members_members_with_http_info(_class, identifier, **kwargs)  # noqa: E501

    def class_members_members_with_http_info(self, _class, identifier, **kwargs):  # noqa: E501
        """returns one or more PDS Products that are the members of the members of the given PDS product class and lid/lidvid.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.class_members_members_with_http_info(_class, identifier, async_req=True)
        >>> result = thread.get()

        :param _class: syntax: one of the allowable enum values  This is a shortcut for doing a query with ...  (required)
        :type _class: str
        :param identifier: syntax: lidvid or lid  behavior (lid): returns one or more items whose lid matches this lid exactly. If the endpoint ends with the identifier or /latest then a signle result is returned and it is the highest version. If the endpoint ends with /all then all versions of the lid are returned.  behavior (lidvid): returns one and only one item whose lidvid matches this lidvid exactly.  note: the current lid/lidvid resolution will match all the lids that start with lid. In other words, it acts like a glob of foobar*. It behavesn this way from first character to the last  note: simple sorting of the lidvid is being done to select the latest from the end of the list. However, the versions 1.0, 2.0, and 13.0 will sort to 1.0, 13.0, and 2.0 so the end of the list may not be the latest.  (required)
        :type identifier: str
        :param fields: syntax: fields=field1,field2,...  behavior: this parameter and the headder Accept: type determine what content is packaged for the result. While the types application/csv, application/kvp+json, and text/csv return only the fields requesteted, all of the other types have a minimal set of fields that must be returned. Duplicating a minimally required field in this parameter has not effect. The types vnd.nasa.pds.pds4+json and vnd.nasa.pds.pds4+xml have a complete set of fields that must be returned; meaning this parameter does not impact their content. When fields is not used, then the minimal set of fields, or all when minimal is an empty set, is returned.  notes: the blob fields are blocked unless specifically requrested and only for the */csv and application/kvp+csv types. 
        :type fields: list[str]
        :param limit: syntax: limit=10  behavior: maximum number of matching results returned, for pagination  note: limit=0 returns just the summary 
        :type limit: int
        :param sort: syntax: sort=asc(field0),desc(field1),...  behavior: is this implemented? 
        :type sort: list[str]
        :param start: syntax: start=12  behavior: offset in matching result list, for pagination 
        :type start: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(object, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            '_class',
            'identifier',
            'fields',
            'limit',
            'sort',
            'start'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method class_members_members" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter '_class' is set
        if self.api_client.client_side_validation and local_var_params.get('_class') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `_class` when calling `class_members_members`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and local_var_params.get('identifier') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `identifier` when calling `class_members_members`")  # noqa: E501

        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `class_members_members`, must be a value greater than or equal to `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'start' in local_var_params and local_var_params['start'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `start` when calling `class_members_members`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if '_class' in local_var_params:
            path_params['class'] = local_var_params['_class']  # noqa: E501
        if 'identifier' in local_var_params:
            path_params['identifier'] = local_var_params['identifier']  # noqa: E501

        query_params = []
        if local_var_params.get('fields') is not None:  # noqa: E501
            query_params.append(('fields', local_var_params['fields']))  # noqa: E501
            collection_formats['fields'] = 'multi'  # noqa: E501
        if local_var_params.get('limit') is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if local_var_params.get('sort') is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
            collection_formats['sort'] = 'multi'  # noqa: E501
        if local_var_params.get('start') is not None:  # noqa: E501
            query_params.append(('start', local_var_params['start']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*', '*/*', 'application/csv', 'application/json', 'application/kvp+json', 'application/vnd.nasa.pds.pds4+json', 'application/vnd.nasa.pds.pds4+xml', 'application/xml', 'text/csv', 'text/html', 'text/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {
            200: "object",
            400: "ErrorMessage",
            404: "ErrorMessage",
            500: "ErrorMessage",
            501: "ErrorMessage",
        }

        return self.api_client.call_api(
            '/classes/{class}/{identifier}/members/members', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def class_members_members_vers(self, _class, identifier, versions, **kwargs):  # noqa: E501
        """returns one or more PDS Products that are the members of the members of the given PDS product class and lid/lidvid.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.class_members_members_vers(_class, identifier, versions, async_req=True)
        >>> result = thread.get()

        :param _class: syntax: one of the allowable enum values  This is a shortcut for doing a query with ...  (required)
        :type _class: str
        :param identifier: syntax: lidvid or lid  behavior (lid): returns one or more items whose lid matches this lid exactly. If the endpoint ends with the identifier or /latest then a signle result is returned and it is the highest version. If the endpoint ends with /all then all versions of the lid are returned.  behavior (lidvid): returns one and only one item whose lidvid matches this lidvid exactly.  note: the current lid/lidvid resolution will match all the lids that start with lid. In other words, it acts like a glob of foobar*. It behavesn this way from first character to the last  note: simple sorting of the lidvid is being done to select the latest from the end of the list. However, the versions 1.0, 2.0, and 13.0 will sort to 1.0, 13.0, and 2.0 so the end of the list may not be the latest.  (required)
        :type identifier: str
        :param versions: syntax: one of the allowable enum values  This is a shortcut for doing a query with ...  (required)
        :type versions: str
        :param fields: syntax: fields=field1,field2,...  behavior: this parameter and the headder Accept: type determine what content is packaged for the result. While the types application/csv, application/kvp+json, and text/csv return only the fields requesteted, all of the other types have a minimal set of fields that must be returned. Duplicating a minimally required field in this parameter has not effect. The types vnd.nasa.pds.pds4+json and vnd.nasa.pds.pds4+xml have a complete set of fields that must be returned; meaning this parameter does not impact their content. When fields is not used, then the minimal set of fields, or all when minimal is an empty set, is returned.  notes: the blob fields are blocked unless specifically requrested and only for the */csv and application/kvp+csv types. 
        :type fields: list[str]
        :param limit: syntax: limit=10  behavior: maximum number of matching results returned, for pagination  note: limit=0 returns just the summary 
        :type limit: int
        :param sort: syntax: sort=asc(field0),desc(field1),...  behavior: is this implemented? 
        :type sort: list[str]
        :param start: syntax: start=12  behavior: offset in matching result list, for pagination 
        :type start: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: object
        """
        kwargs['_return_http_data_only'] = True
        return self.class_members_members_vers_with_http_info(_class, identifier, versions, **kwargs)  # noqa: E501

    def class_members_members_vers_with_http_info(self, _class, identifier, versions, **kwargs):  # noqa: E501
        """returns one or more PDS Products that are the members of the members of the given PDS product class and lid/lidvid.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.class_members_members_vers_with_http_info(_class, identifier, versions, async_req=True)
        >>> result = thread.get()

        :param _class: syntax: one of the allowable enum values  This is a shortcut for doing a query with ...  (required)
        :type _class: str
        :param identifier: syntax: lidvid or lid  behavior (lid): returns one or more items whose lid matches this lid exactly. If the endpoint ends with the identifier or /latest then a signle result is returned and it is the highest version. If the endpoint ends with /all then all versions of the lid are returned.  behavior (lidvid): returns one and only one item whose lidvid matches this lidvid exactly.  note: the current lid/lidvid resolution will match all the lids that start with lid. In other words, it acts like a glob of foobar*. It behavesn this way from first character to the last  note: simple sorting of the lidvid is being done to select the latest from the end of the list. However, the versions 1.0, 2.0, and 13.0 will sort to 1.0, 13.0, and 2.0 so the end of the list may not be the latest.  (required)
        :type identifier: str
        :param versions: syntax: one of the allowable enum values  This is a shortcut for doing a query with ...  (required)
        :type versions: str
        :param fields: syntax: fields=field1,field2,...  behavior: this parameter and the headder Accept: type determine what content is packaged for the result. While the types application/csv, application/kvp+json, and text/csv return only the fields requesteted, all of the other types have a minimal set of fields that must be returned. Duplicating a minimally required field in this parameter has not effect. The types vnd.nasa.pds.pds4+json and vnd.nasa.pds.pds4+xml have a complete set of fields that must be returned; meaning this parameter does not impact their content. When fields is not used, then the minimal set of fields, or all when minimal is an empty set, is returned.  notes: the blob fields are blocked unless specifically requrested and only for the */csv and application/kvp+csv types. 
        :type fields: list[str]
        :param limit: syntax: limit=10  behavior: maximum number of matching results returned, for pagination  note: limit=0 returns just the summary 
        :type limit: int
        :param sort: syntax: sort=asc(field0),desc(field1),...  behavior: is this implemented? 
        :type sort: list[str]
        :param start: syntax: start=12  behavior: offset in matching result list, for pagination 
        :type start: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(object, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            '_class',
            'identifier',
            'versions',
            'fields',
            'limit',
            'sort',
            'start'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method class_members_members_vers" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter '_class' is set
        if self.api_client.client_side_validation and local_var_params.get('_class') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `_class` when calling `class_members_members_vers`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and local_var_params.get('identifier') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `identifier` when calling `class_members_members_vers`")  # noqa: E501
        # verify the required parameter 'versions' is set
        if self.api_client.client_side_validation and local_var_params.get('versions') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `versions` when calling `class_members_members_vers`")  # noqa: E501

        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `class_members_members_vers`, must be a value greater than or equal to `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'start' in local_var_params and local_var_params['start'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `start` when calling `class_members_members_vers`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if '_class' in local_var_params:
            path_params['class'] = local_var_params['_class']  # noqa: E501
        if 'identifier' in local_var_params:
            path_params['identifier'] = local_var_params['identifier']  # noqa: E501
        if 'versions' in local_var_params:
            path_params['versions'] = local_var_params['versions']  # noqa: E501

        query_params = []
        if local_var_params.get('fields') is not None:  # noqa: E501
            query_params.append(('fields', local_var_params['fields']))  # noqa: E501
            collection_formats['fields'] = 'multi'  # noqa: E501
        if local_var_params.get('limit') is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if local_var_params.get('sort') is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
            collection_formats['sort'] = 'multi'  # noqa: E501
        if local_var_params.get('start') is not None:  # noqa: E501
            query_params.append(('start', local_var_params['start']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*', '*/*', 'application/csv', 'application/json', 'application/kvp+json', 'application/vnd.nasa.pds.pds4+json', 'application/vnd.nasa.pds.pds4+xml', 'application/xml', 'text/csv', 'text/html', 'text/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {
            200: "object",
            400: "ErrorMessage",
            404: "ErrorMessage",
            500: "ErrorMessage",
            501: "ErrorMessage",
        }

        return self.api_client.call_api(
            '/classes/{class}/{identifier}/members/members/{versions}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def class_members_vers(self, _class, identifier, versions, **kwargs):  # noqa: E501
        """returns one or more PDS Products that are members of the given PDS product class and lid/lidvid.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.class_members_vers(_class, identifier, versions, async_req=True)
        >>> result = thread.get()

        :param _class: syntax: one of the allowable enum values  This is a shortcut for doing a query with ...  (required)
        :type _class: str
        :param identifier: syntax: lidvid or lid  behavior (lid): returns one or more items whose lid matches this lid exactly. If the endpoint ends with the identifier or /latest then a signle result is returned and it is the highest version. If the endpoint ends with /all then all versions of the lid are returned.  behavior (lidvid): returns one and only one item whose lidvid matches this lidvid exactly.  note: the current lid/lidvid resolution will match all the lids that start with lid. In other words, it acts like a glob of foobar*. It behavesn this way from first character to the last  note: simple sorting of the lidvid is being done to select the latest from the end of the list. However, the versions 1.0, 2.0, and 13.0 will sort to 1.0, 13.0, and 2.0 so the end of the list may not be the latest.  (required)
        :type identifier: str
        :param versions: syntax: one of the allowable enum values  This is a shortcut for doing a query with ...  (required)
        :type versions: str
        :param fields: syntax: fields=field1,field2,...  behavior: this parameter and the headder Accept: type determine what content is packaged for the result. While the types application/csv, application/kvp+json, and text/csv return only the fields requesteted, all of the other types have a minimal set of fields that must be returned. Duplicating a minimally required field in this parameter has not effect. The types vnd.nasa.pds.pds4+json and vnd.nasa.pds.pds4+xml have a complete set of fields that must be returned; meaning this parameter does not impact their content. When fields is not used, then the minimal set of fields, or all when minimal is an empty set, is returned.  notes: the blob fields are blocked unless specifically requrested and only for the */csv and application/kvp+csv types. 
        :type fields: list[str]
        :param limit: syntax: limit=10  behavior: maximum number of matching results returned, for pagination  note: limit=0 returns just the summary 
        :type limit: int
        :param sort: syntax: sort=asc(field0),desc(field1),...  behavior: is this implemented? 
        :type sort: list[str]
        :param start: syntax: start=12  behavior: offset in matching result list, for pagination 
        :type start: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: object
        """
        kwargs['_return_http_data_only'] = True
        return self.class_members_vers_with_http_info(_class, identifier, versions, **kwargs)  # noqa: E501

    def class_members_vers_with_http_info(self, _class, identifier, versions, **kwargs):  # noqa: E501
        """returns one or more PDS Products that are members of the given PDS product class and lid/lidvid.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.class_members_vers_with_http_info(_class, identifier, versions, async_req=True)
        >>> result = thread.get()

        :param _class: syntax: one of the allowable enum values  This is a shortcut for doing a query with ...  (required)
        :type _class: str
        :param identifier: syntax: lidvid or lid  behavior (lid): returns one or more items whose lid matches this lid exactly. If the endpoint ends with the identifier or /latest then a signle result is returned and it is the highest version. If the endpoint ends with /all then all versions of the lid are returned.  behavior (lidvid): returns one and only one item whose lidvid matches this lidvid exactly.  note: the current lid/lidvid resolution will match all the lids that start with lid. In other words, it acts like a glob of foobar*. It behavesn this way from first character to the last  note: simple sorting of the lidvid is being done to select the latest from the end of the list. However, the versions 1.0, 2.0, and 13.0 will sort to 1.0, 13.0, and 2.0 so the end of the list may not be the latest.  (required)
        :type identifier: str
        :param versions: syntax: one of the allowable enum values  This is a shortcut for doing a query with ...  (required)
        :type versions: str
        :param fields: syntax: fields=field1,field2,...  behavior: this parameter and the headder Accept: type determine what content is packaged for the result. While the types application/csv, application/kvp+json, and text/csv return only the fields requesteted, all of the other types have a minimal set of fields that must be returned. Duplicating a minimally required field in this parameter has not effect. The types vnd.nasa.pds.pds4+json and vnd.nasa.pds.pds4+xml have a complete set of fields that must be returned; meaning this parameter does not impact their content. When fields is not used, then the minimal set of fields, or all when minimal is an empty set, is returned.  notes: the blob fields are blocked unless specifically requrested and only for the */csv and application/kvp+csv types. 
        :type fields: list[str]
        :param limit: syntax: limit=10  behavior: maximum number of matching results returned, for pagination  note: limit=0 returns just the summary 
        :type limit: int
        :param sort: syntax: sort=asc(field0),desc(field1),...  behavior: is this implemented? 
        :type sort: list[str]
        :param start: syntax: start=12  behavior: offset in matching result list, for pagination 
        :type start: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(object, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            '_class',
            'identifier',
            'versions',
            'fields',
            'limit',
            'sort',
            'start'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method class_members_vers" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter '_class' is set
        if self.api_client.client_side_validation and local_var_params.get('_class') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `_class` when calling `class_members_vers`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and local_var_params.get('identifier') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `identifier` when calling `class_members_vers`")  # noqa: E501
        # verify the required parameter 'versions' is set
        if self.api_client.client_side_validation and local_var_params.get('versions') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `versions` when calling `class_members_vers`")  # noqa: E501

        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `class_members_vers`, must be a value greater than or equal to `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'start' in local_var_params and local_var_params['start'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `start` when calling `class_members_vers`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if '_class' in local_var_params:
            path_params['class'] = local_var_params['_class']  # noqa: E501
        if 'identifier' in local_var_params:
            path_params['identifier'] = local_var_params['identifier']  # noqa: E501
        if 'versions' in local_var_params:
            path_params['versions'] = local_var_params['versions']  # noqa: E501

        query_params = []
        if local_var_params.get('fields') is not None:  # noqa: E501
            query_params.append(('fields', local_var_params['fields']))  # noqa: E501
            collection_formats['fields'] = 'multi'  # noqa: E501
        if local_var_params.get('limit') is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if local_var_params.get('sort') is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
            collection_formats['sort'] = 'multi'  # noqa: E501
        if local_var_params.get('start') is not None:  # noqa: E501
            query_params.append(('start', local_var_params['start']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*', '*/*', 'application/csv', 'application/json', 'application/kvp+json', 'application/vnd.nasa.pds.pds4+json', 'application/vnd.nasa.pds.pds4+xml', 'application/xml', 'text/csv', 'text/html', 'text/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {
            200: "object",
            400: "ErrorMessage",
            404: "ErrorMessage",
            500: "ErrorMessage",
            501: "ErrorMessage",
        }

        return self.api_client.call_api(
            '/classes/{class}/{identifier}/members/{versions}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def product_member_of(self, identifier, **kwargs):  # noqa: E501
        """returns one or more PDS Products that have the given PDS lid/lidvid as a member.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.product_member_of(identifier, async_req=True)
        >>> result = thread.get()

        :param identifier: syntax: lidvid or lid  behavior (lid): returns one or more items whose lid matches this lid exactly. If the endpoint ends with the identifier or /latest then a signle result is returned and it is the highest version. If the endpoint ends with /all then all versions of the lid are returned.  behavior (lidvid): returns one and only one item whose lidvid matches this lidvid exactly.  note: the current lid/lidvid resolution will match all the lids that start with lid. In other words, it acts like a glob of foobar*. It behavesn this way from first character to the last  note: simple sorting of the lidvid is being done to select the latest from the end of the list. However, the versions 1.0, 2.0, and 13.0 will sort to 1.0, 13.0, and 2.0 so the end of the list may not be the latest.  (required)
        :type identifier: str
        :param fields: syntax: fields=field1,field2,...  behavior: this parameter and the headder Accept: type determine what content is packaged for the result. While the types application/csv, application/kvp+json, and text/csv return only the fields requesteted, all of the other types have a minimal set of fields that must be returned. Duplicating a minimally required field in this parameter has not effect. The types vnd.nasa.pds.pds4+json and vnd.nasa.pds.pds4+xml have a complete set of fields that must be returned; meaning this parameter does not impact their content. When fields is not used, then the minimal set of fields, or all when minimal is an empty set, is returned.  notes: the blob fields are blocked unless specifically requrested and only for the */csv and application/kvp+csv types. 
        :type fields: list[str]
        :param limit: syntax: limit=10  behavior: maximum number of matching results returned, for pagination  note: limit=0 returns just the summary 
        :type limit: int
        :param sort: syntax: sort=asc(field0),desc(field1),...  behavior: is this implemented? 
        :type sort: list[str]
        :param start: syntax: start=12  behavior: offset in matching result list, for pagination 
        :type start: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: object
        """
        kwargs['_return_http_data_only'] = True
        return self.product_member_of_with_http_info(identifier, **kwargs)  # noqa: E501

    def product_member_of_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """returns one or more PDS Products that have the given PDS lid/lidvid as a member.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.product_member_of_with_http_info(identifier, async_req=True)
        >>> result = thread.get()

        :param identifier: syntax: lidvid or lid  behavior (lid): returns one or more items whose lid matches this lid exactly. If the endpoint ends with the identifier or /latest then a signle result is returned and it is the highest version. If the endpoint ends with /all then all versions of the lid are returned.  behavior (lidvid): returns one and only one item whose lidvid matches this lidvid exactly.  note: the current lid/lidvid resolution will match all the lids that start with lid. In other words, it acts like a glob of foobar*. It behavesn this way from first character to the last  note: simple sorting of the lidvid is being done to select the latest from the end of the list. However, the versions 1.0, 2.0, and 13.0 will sort to 1.0, 13.0, and 2.0 so the end of the list may not be the latest.  (required)
        :type identifier: str
        :param fields: syntax: fields=field1,field2,...  behavior: this parameter and the headder Accept: type determine what content is packaged for the result. While the types application/csv, application/kvp+json, and text/csv return only the fields requesteted, all of the other types have a minimal set of fields that must be returned. Duplicating a minimally required field in this parameter has not effect. The types vnd.nasa.pds.pds4+json and vnd.nasa.pds.pds4+xml have a complete set of fields that must be returned; meaning this parameter does not impact their content. When fields is not used, then the minimal set of fields, or all when minimal is an empty set, is returned.  notes: the blob fields are blocked unless specifically requrested and only for the */csv and application/kvp+csv types. 
        :type fields: list[str]
        :param limit: syntax: limit=10  behavior: maximum number of matching results returned, for pagination  note: limit=0 returns just the summary 
        :type limit: int
        :param sort: syntax: sort=asc(field0),desc(field1),...  behavior: is this implemented? 
        :type sort: list[str]
        :param start: syntax: start=12  behavior: offset in matching result list, for pagination 
        :type start: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(object, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'identifier',
            'fields',
            'limit',
            'sort',
            'start'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method product_member_of" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and local_var_params.get('identifier') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `identifier` when calling `product_member_of`")  # noqa: E501

        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `product_member_of`, must be a value greater than or equal to `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'start' in local_var_params and local_var_params['start'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `start` when calling `product_member_of`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in local_var_params:
            path_params['identifier'] = local_var_params['identifier']  # noqa: E501

        query_params = []
        if local_var_params.get('fields') is not None:  # noqa: E501
            query_params.append(('fields', local_var_params['fields']))  # noqa: E501
            collection_formats['fields'] = 'multi'  # noqa: E501
        if local_var_params.get('limit') is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if local_var_params.get('sort') is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
            collection_formats['sort'] = 'multi'  # noqa: E501
        if local_var_params.get('start') is not None:  # noqa: E501
            query_params.append(('start', local_var_params['start']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*', '*/*', 'application/csv', 'application/json', 'application/kvp+json', 'application/vnd.nasa.pds.pds4+json', 'application/vnd.nasa.pds.pds4+xml', 'application/xml', 'text/csv', 'text/html', 'text/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {
            200: "object",
            400: "ErrorMessage",
            404: "ErrorMessage",
            500: "ErrorMessage",
            501: "ErrorMessage",
        }

        return self.api_client.call_api(
            '/products/{identifier}/member-of', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def product_member_of_of(self, identifier, **kwargs):  # noqa: E501
        """returns one or more PDS Products that have the given PDS lid/lidvid as a member of its members.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.product_member_of_of(identifier, async_req=True)
        >>> result = thread.get()

        :param identifier: syntax: lidvid or lid  behavior (lid): returns one or more items whose lid matches this lid exactly. If the endpoint ends with the identifier or /latest then a signle result is returned and it is the highest version. If the endpoint ends with /all then all versions of the lid are returned.  behavior (lidvid): returns one and only one item whose lidvid matches this lidvid exactly.  note: the current lid/lidvid resolution will match all the lids that start with lid. In other words, it acts like a glob of foobar*. It behavesn this way from first character to the last  note: simple sorting of the lidvid is being done to select the latest from the end of the list. However, the versions 1.0, 2.0, and 13.0 will sort to 1.0, 13.0, and 2.0 so the end of the list may not be the latest.  (required)
        :type identifier: str
        :param fields: syntax: fields=field1,field2,...  behavior: this parameter and the headder Accept: type determine what content is packaged for the result. While the types application/csv, application/kvp+json, and text/csv return only the fields requesteted, all of the other types have a minimal set of fields that must be returned. Duplicating a minimally required field in this parameter has not effect. The types vnd.nasa.pds.pds4+json and vnd.nasa.pds.pds4+xml have a complete set of fields that must be returned; meaning this parameter does not impact their content. When fields is not used, then the minimal set of fields, or all when minimal is an empty set, is returned.  notes: the blob fields are blocked unless specifically requrested and only for the */csv and application/kvp+csv types. 
        :type fields: list[str]
        :param limit: syntax: limit=10  behavior: maximum number of matching results returned, for pagination  note: limit=0 returns just the summary 
        :type limit: int
        :param sort: syntax: sort=asc(field0),desc(field1),...  behavior: is this implemented? 
        :type sort: list[str]
        :param start: syntax: start=12  behavior: offset in matching result list, for pagination 
        :type start: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: object
        """
        kwargs['_return_http_data_only'] = True
        return self.product_member_of_of_with_http_info(identifier, **kwargs)  # noqa: E501

    def product_member_of_of_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """returns one or more PDS Products that have the given PDS lid/lidvid as a member of its members.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.product_member_of_of_with_http_info(identifier, async_req=True)
        >>> result = thread.get()

        :param identifier: syntax: lidvid or lid  behavior (lid): returns one or more items whose lid matches this lid exactly. If the endpoint ends with the identifier or /latest then a signle result is returned and it is the highest version. If the endpoint ends with /all then all versions of the lid are returned.  behavior (lidvid): returns one and only one item whose lidvid matches this lidvid exactly.  note: the current lid/lidvid resolution will match all the lids that start with lid. In other words, it acts like a glob of foobar*. It behavesn this way from first character to the last  note: simple sorting of the lidvid is being done to select the latest from the end of the list. However, the versions 1.0, 2.0, and 13.0 will sort to 1.0, 13.0, and 2.0 so the end of the list may not be the latest.  (required)
        :type identifier: str
        :param fields: syntax: fields=field1,field2,...  behavior: this parameter and the headder Accept: type determine what content is packaged for the result. While the types application/csv, application/kvp+json, and text/csv return only the fields requesteted, all of the other types have a minimal set of fields that must be returned. Duplicating a minimally required field in this parameter has not effect. The types vnd.nasa.pds.pds4+json and vnd.nasa.pds.pds4+xml have a complete set of fields that must be returned; meaning this parameter does not impact their content. When fields is not used, then the minimal set of fields, or all when minimal is an empty set, is returned.  notes: the blob fields are blocked unless specifically requrested and only for the */csv and application/kvp+csv types. 
        :type fields: list[str]
        :param limit: syntax: limit=10  behavior: maximum number of matching results returned, for pagination  note: limit=0 returns just the summary 
        :type limit: int
        :param sort: syntax: sort=asc(field0),desc(field1),...  behavior: is this implemented? 
        :type sort: list[str]
        :param start: syntax: start=12  behavior: offset in matching result list, for pagination 
        :type start: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(object, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'identifier',
            'fields',
            'limit',
            'sort',
            'start'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method product_member_of_of" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and local_var_params.get('identifier') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `identifier` when calling `product_member_of_of`")  # noqa: E501

        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `product_member_of_of`, must be a value greater than or equal to `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'start' in local_var_params and local_var_params['start'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `start` when calling `product_member_of_of`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in local_var_params:
            path_params['identifier'] = local_var_params['identifier']  # noqa: E501

        query_params = []
        if local_var_params.get('fields') is not None:  # noqa: E501
            query_params.append(('fields', local_var_params['fields']))  # noqa: E501
            collection_formats['fields'] = 'multi'  # noqa: E501
        if local_var_params.get('limit') is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if local_var_params.get('sort') is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
            collection_formats['sort'] = 'multi'  # noqa: E501
        if local_var_params.get('start') is not None:  # noqa: E501
            query_params.append(('start', local_var_params['start']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*', '*/*', 'application/csv', 'application/json', 'application/kvp+json', 'application/vnd.nasa.pds.pds4+json', 'application/vnd.nasa.pds.pds4+xml', 'application/xml', 'text/csv', 'text/html', 'text/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {
            200: "object",
            400: "ErrorMessage",
            404: "ErrorMessage",
            500: "ErrorMessage",
            501: "ErrorMessage",
        }

        return self.api_client.call_api(
            '/products/{identifier}/member-of/member-of', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def product_member_of_of_vers(self, identifier, versions, **kwargs):  # noqa: E501
        """returns one or more PDS Products that have the given PDS lid/lidvid as a member of its members.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.product_member_of_of_vers(identifier, versions, async_req=True)
        >>> result = thread.get()

        :param identifier: syntax: lidvid or lid  behavior (lid): returns one or more items whose lid matches this lid exactly. If the endpoint ends with the identifier or /latest then a signle result is returned and it is the highest version. If the endpoint ends with /all then all versions of the lid are returned.  behavior (lidvid): returns one and only one item whose lidvid matches this lidvid exactly.  note: the current lid/lidvid resolution will match all the lids that start with lid. In other words, it acts like a glob of foobar*. It behavesn this way from first character to the last  note: simple sorting of the lidvid is being done to select the latest from the end of the list. However, the versions 1.0, 2.0, and 13.0 will sort to 1.0, 13.0, and 2.0 so the end of the list may not be the latest.  (required)
        :type identifier: str
        :param versions: syntax: one of the allowable enum values  This is a shortcut for doing a query with ...  (required)
        :type versions: str
        :param fields: syntax: fields=field1,field2,...  behavior: this parameter and the headder Accept: type determine what content is packaged for the result. While the types application/csv, application/kvp+json, and text/csv return only the fields requesteted, all of the other types have a minimal set of fields that must be returned. Duplicating a minimally required field in this parameter has not effect. The types vnd.nasa.pds.pds4+json and vnd.nasa.pds.pds4+xml have a complete set of fields that must be returned; meaning this parameter does not impact their content. When fields is not used, then the minimal set of fields, or all when minimal is an empty set, is returned.  notes: the blob fields are blocked unless specifically requrested and only for the */csv and application/kvp+csv types. 
        :type fields: list[str]
        :param limit: syntax: limit=10  behavior: maximum number of matching results returned, for pagination  note: limit=0 returns just the summary 
        :type limit: int
        :param sort: syntax: sort=asc(field0),desc(field1),...  behavior: is this implemented? 
        :type sort: list[str]
        :param start: syntax: start=12  behavior: offset in matching result list, for pagination 
        :type start: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: object
        """
        kwargs['_return_http_data_only'] = True
        return self.product_member_of_of_vers_with_http_info(identifier, versions, **kwargs)  # noqa: E501

    def product_member_of_of_vers_with_http_info(self, identifier, versions, **kwargs):  # noqa: E501
        """returns one or more PDS Products that have the given PDS lid/lidvid as a member of its members.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.product_member_of_of_vers_with_http_info(identifier, versions, async_req=True)
        >>> result = thread.get()

        :param identifier: syntax: lidvid or lid  behavior (lid): returns one or more items whose lid matches this lid exactly. If the endpoint ends with the identifier or /latest then a signle result is returned and it is the highest version. If the endpoint ends with /all then all versions of the lid are returned.  behavior (lidvid): returns one and only one item whose lidvid matches this lidvid exactly.  note: the current lid/lidvid resolution will match all the lids that start with lid. In other words, it acts like a glob of foobar*. It behavesn this way from first character to the last  note: simple sorting of the lidvid is being done to select the latest from the end of the list. However, the versions 1.0, 2.0, and 13.0 will sort to 1.0, 13.0, and 2.0 so the end of the list may not be the latest.  (required)
        :type identifier: str
        :param versions: syntax: one of the allowable enum values  This is a shortcut for doing a query with ...  (required)
        :type versions: str
        :param fields: syntax: fields=field1,field2,...  behavior: this parameter and the headder Accept: type determine what content is packaged for the result. While the types application/csv, application/kvp+json, and text/csv return only the fields requesteted, all of the other types have a minimal set of fields that must be returned. Duplicating a minimally required field in this parameter has not effect. The types vnd.nasa.pds.pds4+json and vnd.nasa.pds.pds4+xml have a complete set of fields that must be returned; meaning this parameter does not impact their content. When fields is not used, then the minimal set of fields, or all when minimal is an empty set, is returned.  notes: the blob fields are blocked unless specifically requrested and only for the */csv and application/kvp+csv types. 
        :type fields: list[str]
        :param limit: syntax: limit=10  behavior: maximum number of matching results returned, for pagination  note: limit=0 returns just the summary 
        :type limit: int
        :param sort: syntax: sort=asc(field0),desc(field1),...  behavior: is this implemented? 
        :type sort: list[str]
        :param start: syntax: start=12  behavior: offset in matching result list, for pagination 
        :type start: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(object, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'identifier',
            'versions',
            'fields',
            'limit',
            'sort',
            'start'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method product_member_of_of_vers" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and local_var_params.get('identifier') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `identifier` when calling `product_member_of_of_vers`")  # noqa: E501
        # verify the required parameter 'versions' is set
        if self.api_client.client_side_validation and local_var_params.get('versions') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `versions` when calling `product_member_of_of_vers`")  # noqa: E501

        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `product_member_of_of_vers`, must be a value greater than or equal to `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'start' in local_var_params and local_var_params['start'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `start` when calling `product_member_of_of_vers`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in local_var_params:
            path_params['identifier'] = local_var_params['identifier']  # noqa: E501
        if 'versions' in local_var_params:
            path_params['versions'] = local_var_params['versions']  # noqa: E501

        query_params = []
        if local_var_params.get('fields') is not None:  # noqa: E501
            query_params.append(('fields', local_var_params['fields']))  # noqa: E501
            collection_formats['fields'] = 'multi'  # noqa: E501
        if local_var_params.get('limit') is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if local_var_params.get('sort') is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
            collection_formats['sort'] = 'multi'  # noqa: E501
        if local_var_params.get('start') is not None:  # noqa: E501
            query_params.append(('start', local_var_params['start']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*', '*/*', 'application/csv', 'application/json', 'application/kvp+json', 'application/vnd.nasa.pds.pds4+json', 'application/vnd.nasa.pds.pds4+xml', 'application/xml', 'text/csv', 'text/html', 'text/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {
            200: "object",
            400: "ErrorMessage",
            404: "ErrorMessage",
            500: "ErrorMessage",
            501: "ErrorMessage",
        }

        return self.api_client.call_api(
            '/products/{identifier}/member-of/member-of/{versions}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def product_member_of_vers(self, identifier, versions, **kwargs):  # noqa: E501
        """returns one or more PDS Products that have the given PDS lid/lidvid as a member.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.product_member_of_vers(identifier, versions, async_req=True)
        >>> result = thread.get()

        :param identifier: syntax: lidvid or lid  behavior (lid): returns one or more items whose lid matches this lid exactly. If the endpoint ends with the identifier or /latest then a signle result is returned and it is the highest version. If the endpoint ends with /all then all versions of the lid are returned.  behavior (lidvid): returns one and only one item whose lidvid matches this lidvid exactly.  note: the current lid/lidvid resolution will match all the lids that start with lid. In other words, it acts like a glob of foobar*. It behavesn this way from first character to the last  note: simple sorting of the lidvid is being done to select the latest from the end of the list. However, the versions 1.0, 2.0, and 13.0 will sort to 1.0, 13.0, and 2.0 so the end of the list may not be the latest.  (required)
        :type identifier: str
        :param versions: syntax: one of the allowable enum values  This is a shortcut for doing a query with ...  (required)
        :type versions: str
        :param fields: syntax: fields=field1,field2,...  behavior: this parameter and the headder Accept: type determine what content is packaged for the result. While the types application/csv, application/kvp+json, and text/csv return only the fields requesteted, all of the other types have a minimal set of fields that must be returned. Duplicating a minimally required field in this parameter has not effect. The types vnd.nasa.pds.pds4+json and vnd.nasa.pds.pds4+xml have a complete set of fields that must be returned; meaning this parameter does not impact their content. When fields is not used, then the minimal set of fields, or all when minimal is an empty set, is returned.  notes: the blob fields are blocked unless specifically requrested and only for the */csv and application/kvp+csv types. 
        :type fields: list[str]
        :param limit: syntax: limit=10  behavior: maximum number of matching results returned, for pagination  note: limit=0 returns just the summary 
        :type limit: int
        :param sort: syntax: sort=asc(field0),desc(field1),...  behavior: is this implemented? 
        :type sort: list[str]
        :param start: syntax: start=12  behavior: offset in matching result list, for pagination 
        :type start: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: object
        """
        kwargs['_return_http_data_only'] = True
        return self.product_member_of_vers_with_http_info(identifier, versions, **kwargs)  # noqa: E501

    def product_member_of_vers_with_http_info(self, identifier, versions, **kwargs):  # noqa: E501
        """returns one or more PDS Products that have the given PDS lid/lidvid as a member.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.product_member_of_vers_with_http_info(identifier, versions, async_req=True)
        >>> result = thread.get()

        :param identifier: syntax: lidvid or lid  behavior (lid): returns one or more items whose lid matches this lid exactly. If the endpoint ends with the identifier or /latest then a signle result is returned and it is the highest version. If the endpoint ends with /all then all versions of the lid are returned.  behavior (lidvid): returns one and only one item whose lidvid matches this lidvid exactly.  note: the current lid/lidvid resolution will match all the lids that start with lid. In other words, it acts like a glob of foobar*. It behavesn this way from first character to the last  note: simple sorting of the lidvid is being done to select the latest from the end of the list. However, the versions 1.0, 2.0, and 13.0 will sort to 1.0, 13.0, and 2.0 so the end of the list may not be the latest.  (required)
        :type identifier: str
        :param versions: syntax: one of the allowable enum values  This is a shortcut for doing a query with ...  (required)
        :type versions: str
        :param fields: syntax: fields=field1,field2,...  behavior: this parameter and the headder Accept: type determine what content is packaged for the result. While the types application/csv, application/kvp+json, and text/csv return only the fields requesteted, all of the other types have a minimal set of fields that must be returned. Duplicating a minimally required field in this parameter has not effect. The types vnd.nasa.pds.pds4+json and vnd.nasa.pds.pds4+xml have a complete set of fields that must be returned; meaning this parameter does not impact their content. When fields is not used, then the minimal set of fields, or all when minimal is an empty set, is returned.  notes: the blob fields are blocked unless specifically requrested and only for the */csv and application/kvp+csv types. 
        :type fields: list[str]
        :param limit: syntax: limit=10  behavior: maximum number of matching results returned, for pagination  note: limit=0 returns just the summary 
        :type limit: int
        :param sort: syntax: sort=asc(field0),desc(field1),...  behavior: is this implemented? 
        :type sort: list[str]
        :param start: syntax: start=12  behavior: offset in matching result list, for pagination 
        :type start: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(object, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'identifier',
            'versions',
            'fields',
            'limit',
            'sort',
            'start'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method product_member_of_vers" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and local_var_params.get('identifier') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `identifier` when calling `product_member_of_vers`")  # noqa: E501
        # verify the required parameter 'versions' is set
        if self.api_client.client_side_validation and local_var_params.get('versions') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `versions` when calling `product_member_of_vers`")  # noqa: E501

        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `product_member_of_vers`, must be a value greater than or equal to `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'start' in local_var_params and local_var_params['start'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `start` when calling `product_member_of_vers`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in local_var_params:
            path_params['identifier'] = local_var_params['identifier']  # noqa: E501
        if 'versions' in local_var_params:
            path_params['versions'] = local_var_params['versions']  # noqa: E501

        query_params = []
        if local_var_params.get('fields') is not None:  # noqa: E501
            query_params.append(('fields', local_var_params['fields']))  # noqa: E501
            collection_formats['fields'] = 'multi'  # noqa: E501
        if local_var_params.get('limit') is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if local_var_params.get('sort') is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
            collection_formats['sort'] = 'multi'  # noqa: E501
        if local_var_params.get('start') is not None:  # noqa: E501
            query_params.append(('start', local_var_params['start']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*', '*/*', 'application/csv', 'application/json', 'application/kvp+json', 'application/vnd.nasa.pds.pds4+json', 'application/vnd.nasa.pds.pds4+xml', 'application/xml', 'text/csv', 'text/html', 'text/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {
            200: "object",
            400: "ErrorMessage",
            404: "ErrorMessage",
            500: "ErrorMessage",
            501: "ErrorMessage",
        }

        return self.api_client.call_api(
            '/products/{identifier}/member-of/{versions}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def product_members(self, identifier, **kwargs):  # noqa: E501
        """returns all of the members of the given lid/lidvid   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.product_members(identifier, async_req=True)
        >>> result = thread.get()

        :param identifier: syntax: lidvid or lid  behavior (lid): returns one or more items whose lid matches this lid exactly. If the endpoint ends with the identifier or /latest then a signle result is returned and it is the highest version. If the endpoint ends with /all then all versions of the lid are returned.  behavior (lidvid): returns one and only one item whose lidvid matches this lidvid exactly.  note: the current lid/lidvid resolution will match all the lids that start with lid. In other words, it acts like a glob of foobar*. It behavesn this way from first character to the last  note: simple sorting of the lidvid is being done to select the latest from the end of the list. However, the versions 1.0, 2.0, and 13.0 will sort to 1.0, 13.0, and 2.0 so the end of the list may not be the latest.  (required)
        :type identifier: str
        :param fields: syntax: fields=field1,field2,...  behavior: this parameter and the headder Accept: type determine what content is packaged for the result. While the types application/csv, application/kvp+json, and text/csv return only the fields requesteted, all of the other types have a minimal set of fields that must be returned. Duplicating a minimally required field in this parameter has not effect. The types vnd.nasa.pds.pds4+json and vnd.nasa.pds.pds4+xml have a complete set of fields that must be returned; meaning this parameter does not impact their content. When fields is not used, then the minimal set of fields, or all when minimal is an empty set, is returned.  notes: the blob fields are blocked unless specifically requrested and only for the */csv and application/kvp+csv types. 
        :type fields: list[str]
        :param limit: syntax: limit=10  behavior: maximum number of matching results returned, for pagination  note: limit=0 returns just the summary 
        :type limit: int
        :param sort: syntax: sort=asc(field0),desc(field1),...  behavior: is this implemented? 
        :type sort: list[str]
        :param start: syntax: start=12  behavior: offset in matching result list, for pagination 
        :type start: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: object
        """
        kwargs['_return_http_data_only'] = True
        return self.product_members_with_http_info(identifier, **kwargs)  # noqa: E501

    def product_members_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """returns all of the members of the given lid/lidvid   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.product_members_with_http_info(identifier, async_req=True)
        >>> result = thread.get()

        :param identifier: syntax: lidvid or lid  behavior (lid): returns one or more items whose lid matches this lid exactly. If the endpoint ends with the identifier or /latest then a signle result is returned and it is the highest version. If the endpoint ends with /all then all versions of the lid are returned.  behavior (lidvid): returns one and only one item whose lidvid matches this lidvid exactly.  note: the current lid/lidvid resolution will match all the lids that start with lid. In other words, it acts like a glob of foobar*. It behavesn this way from first character to the last  note: simple sorting of the lidvid is being done to select the latest from the end of the list. However, the versions 1.0, 2.0, and 13.0 will sort to 1.0, 13.0, and 2.0 so the end of the list may not be the latest.  (required)
        :type identifier: str
        :param fields: syntax: fields=field1,field2,...  behavior: this parameter and the headder Accept: type determine what content is packaged for the result. While the types application/csv, application/kvp+json, and text/csv return only the fields requesteted, all of the other types have a minimal set of fields that must be returned. Duplicating a minimally required field in this parameter has not effect. The types vnd.nasa.pds.pds4+json and vnd.nasa.pds.pds4+xml have a complete set of fields that must be returned; meaning this parameter does not impact their content. When fields is not used, then the minimal set of fields, or all when minimal is an empty set, is returned.  notes: the blob fields are blocked unless specifically requrested and only for the */csv and application/kvp+csv types. 
        :type fields: list[str]
        :param limit: syntax: limit=10  behavior: maximum number of matching results returned, for pagination  note: limit=0 returns just the summary 
        :type limit: int
        :param sort: syntax: sort=asc(field0),desc(field1),...  behavior: is this implemented? 
        :type sort: list[str]
        :param start: syntax: start=12  behavior: offset in matching result list, for pagination 
        :type start: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(object, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'identifier',
            'fields',
            'limit',
            'sort',
            'start'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method product_members" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and local_var_params.get('identifier') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `identifier` when calling `product_members`")  # noqa: E501

        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `product_members`, must be a value greater than or equal to `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'start' in local_var_params and local_var_params['start'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `start` when calling `product_members`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in local_var_params:
            path_params['identifier'] = local_var_params['identifier']  # noqa: E501

        query_params = []
        if local_var_params.get('fields') is not None:  # noqa: E501
            query_params.append(('fields', local_var_params['fields']))  # noqa: E501
            collection_formats['fields'] = 'multi'  # noqa: E501
        if local_var_params.get('limit') is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if local_var_params.get('sort') is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
            collection_formats['sort'] = 'multi'  # noqa: E501
        if local_var_params.get('start') is not None:  # noqa: E501
            query_params.append(('start', local_var_params['start']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*', '*/*', 'application/csv', 'application/json', 'application/kvp+json', 'application/vnd.nasa.pds.pds4+json', 'application/vnd.nasa.pds.pds4+xml', 'application/xml', 'text/csv', 'text/html', 'text/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {
            200: "object",
            400: "ErrorMessage",
            404: "ErrorMessage",
            500: "ErrorMessage",
            501: "ErrorMessage",
        }

        return self.api_client.call_api(
            '/products/{identifier}/members', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def product_members_members(self, identifier, **kwargs):  # noqa: E501
        """returns all of the members of the members of the given lid/lidvid   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.product_members_members(identifier, async_req=True)
        >>> result = thread.get()

        :param identifier: syntax: lidvid or lid  behavior (lid): returns one or more items whose lid matches this lid exactly. If the endpoint ends with the identifier or /latest then a signle result is returned and it is the highest version. If the endpoint ends with /all then all versions of the lid are returned.  behavior (lidvid): returns one and only one item whose lidvid matches this lidvid exactly.  note: the current lid/lidvid resolution will match all the lids that start with lid. In other words, it acts like a glob of foobar*. It behavesn this way from first character to the last  note: simple sorting of the lidvid is being done to select the latest from the end of the list. However, the versions 1.0, 2.0, and 13.0 will sort to 1.0, 13.0, and 2.0 so the end of the list may not be the latest.  (required)
        :type identifier: str
        :param fields: syntax: fields=field1,field2,...  behavior: this parameter and the headder Accept: type determine what content is packaged for the result. While the types application/csv, application/kvp+json, and text/csv return only the fields requesteted, all of the other types have a minimal set of fields that must be returned. Duplicating a minimally required field in this parameter has not effect. The types vnd.nasa.pds.pds4+json and vnd.nasa.pds.pds4+xml have a complete set of fields that must be returned; meaning this parameter does not impact their content. When fields is not used, then the minimal set of fields, or all when minimal is an empty set, is returned.  notes: the blob fields are blocked unless specifically requrested and only for the */csv and application/kvp+csv types. 
        :type fields: list[str]
        :param limit: syntax: limit=10  behavior: maximum number of matching results returned, for pagination  note: limit=0 returns just the summary 
        :type limit: int
        :param sort: syntax: sort=asc(field0),desc(field1),...  behavior: is this implemented? 
        :type sort: list[str]
        :param start: syntax: start=12  behavior: offset in matching result list, for pagination 
        :type start: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: object
        """
        kwargs['_return_http_data_only'] = True
        return self.product_members_members_with_http_info(identifier, **kwargs)  # noqa: E501

    def product_members_members_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """returns all of the members of the members of the given lid/lidvid   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.product_members_members_with_http_info(identifier, async_req=True)
        >>> result = thread.get()

        :param identifier: syntax: lidvid or lid  behavior (lid): returns one or more items whose lid matches this lid exactly. If the endpoint ends with the identifier or /latest then a signle result is returned and it is the highest version. If the endpoint ends with /all then all versions of the lid are returned.  behavior (lidvid): returns one and only one item whose lidvid matches this lidvid exactly.  note: the current lid/lidvid resolution will match all the lids that start with lid. In other words, it acts like a glob of foobar*. It behavesn this way from first character to the last  note: simple sorting of the lidvid is being done to select the latest from the end of the list. However, the versions 1.0, 2.0, and 13.0 will sort to 1.0, 13.0, and 2.0 so the end of the list may not be the latest.  (required)
        :type identifier: str
        :param fields: syntax: fields=field1,field2,...  behavior: this parameter and the headder Accept: type determine what content is packaged for the result. While the types application/csv, application/kvp+json, and text/csv return only the fields requesteted, all of the other types have a minimal set of fields that must be returned. Duplicating a minimally required field in this parameter has not effect. The types vnd.nasa.pds.pds4+json and vnd.nasa.pds.pds4+xml have a complete set of fields that must be returned; meaning this parameter does not impact their content. When fields is not used, then the minimal set of fields, or all when minimal is an empty set, is returned.  notes: the blob fields are blocked unless specifically requrested and only for the */csv and application/kvp+csv types. 
        :type fields: list[str]
        :param limit: syntax: limit=10  behavior: maximum number of matching results returned, for pagination  note: limit=0 returns just the summary 
        :type limit: int
        :param sort: syntax: sort=asc(field0),desc(field1),...  behavior: is this implemented? 
        :type sort: list[str]
        :param start: syntax: start=12  behavior: offset in matching result list, for pagination 
        :type start: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(object, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'identifier',
            'fields',
            'limit',
            'sort',
            'start'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method product_members_members" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and local_var_params.get('identifier') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `identifier` when calling `product_members_members`")  # noqa: E501

        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `product_members_members`, must be a value greater than or equal to `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'start' in local_var_params and local_var_params['start'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `start` when calling `product_members_members`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in local_var_params:
            path_params['identifier'] = local_var_params['identifier']  # noqa: E501

        query_params = []
        if local_var_params.get('fields') is not None:  # noqa: E501
            query_params.append(('fields', local_var_params['fields']))  # noqa: E501
            collection_formats['fields'] = 'multi'  # noqa: E501
        if local_var_params.get('limit') is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if local_var_params.get('sort') is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
            collection_formats['sort'] = 'multi'  # noqa: E501
        if local_var_params.get('start') is not None:  # noqa: E501
            query_params.append(('start', local_var_params['start']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*', '*/*', 'application/csv', 'application/json', 'application/kvp+json', 'application/vnd.nasa.pds.pds4+json', 'application/vnd.nasa.pds.pds4+xml', 'application/xml', 'text/csv', 'text/html', 'text/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {
            200: "object",
            400: "ErrorMessage",
            404: "ErrorMessage",
            500: "ErrorMessage",
            501: "ErrorMessage",
        }

        return self.api_client.call_api(
            '/products/{identifier}/members/members', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def product_members_members_vers(self, identifier, versions, **kwargs):  # noqa: E501
        """returns all of the members of the members of the given lid/lidvid   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.product_members_members_vers(identifier, versions, async_req=True)
        >>> result = thread.get()

        :param identifier: syntax: lidvid or lid  behavior (lid): returns one or more items whose lid matches this lid exactly. If the endpoint ends with the identifier or /latest then a signle result is returned and it is the highest version. If the endpoint ends with /all then all versions of the lid are returned.  behavior (lidvid): returns one and only one item whose lidvid matches this lidvid exactly.  note: the current lid/lidvid resolution will match all the lids that start with lid. In other words, it acts like a glob of foobar*. It behavesn this way from first character to the last  note: simple sorting of the lidvid is being done to select the latest from the end of the list. However, the versions 1.0, 2.0, and 13.0 will sort to 1.0, 13.0, and 2.0 so the end of the list may not be the latest.  (required)
        :type identifier: str
        :param versions: syntax: one of the allowable enum values  This is a shortcut for doing a query with ...  (required)
        :type versions: str
        :param fields: syntax: fields=field1,field2,...  behavior: this parameter and the headder Accept: type determine what content is packaged for the result. While the types application/csv, application/kvp+json, and text/csv return only the fields requesteted, all of the other types have a minimal set of fields that must be returned. Duplicating a minimally required field in this parameter has not effect. The types vnd.nasa.pds.pds4+json and vnd.nasa.pds.pds4+xml have a complete set of fields that must be returned; meaning this parameter does not impact their content. When fields is not used, then the minimal set of fields, or all when minimal is an empty set, is returned.  notes: the blob fields are blocked unless specifically requrested and only for the */csv and application/kvp+csv types. 
        :type fields: list[str]
        :param limit: syntax: limit=10  behavior: maximum number of matching results returned, for pagination  note: limit=0 returns just the summary 
        :type limit: int
        :param sort: syntax: sort=asc(field0),desc(field1),...  behavior: is this implemented? 
        :type sort: list[str]
        :param start: syntax: start=12  behavior: offset in matching result list, for pagination 
        :type start: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: object
        """
        kwargs['_return_http_data_only'] = True
        return self.product_members_members_vers_with_http_info(identifier, versions, **kwargs)  # noqa: E501

    def product_members_members_vers_with_http_info(self, identifier, versions, **kwargs):  # noqa: E501
        """returns all of the members of the members of the given lid/lidvid   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.product_members_members_vers_with_http_info(identifier, versions, async_req=True)
        >>> result = thread.get()

        :param identifier: syntax: lidvid or lid  behavior (lid): returns one or more items whose lid matches this lid exactly. If the endpoint ends with the identifier or /latest then a signle result is returned and it is the highest version. If the endpoint ends with /all then all versions of the lid are returned.  behavior (lidvid): returns one and only one item whose lidvid matches this lidvid exactly.  note: the current lid/lidvid resolution will match all the lids that start with lid. In other words, it acts like a glob of foobar*. It behavesn this way from first character to the last  note: simple sorting of the lidvid is being done to select the latest from the end of the list. However, the versions 1.0, 2.0, and 13.0 will sort to 1.0, 13.0, and 2.0 so the end of the list may not be the latest.  (required)
        :type identifier: str
        :param versions: syntax: one of the allowable enum values  This is a shortcut for doing a query with ...  (required)
        :type versions: str
        :param fields: syntax: fields=field1,field2,...  behavior: this parameter and the headder Accept: type determine what content is packaged for the result. While the types application/csv, application/kvp+json, and text/csv return only the fields requesteted, all of the other types have a minimal set of fields that must be returned. Duplicating a minimally required field in this parameter has not effect. The types vnd.nasa.pds.pds4+json and vnd.nasa.pds.pds4+xml have a complete set of fields that must be returned; meaning this parameter does not impact their content. When fields is not used, then the minimal set of fields, or all when minimal is an empty set, is returned.  notes: the blob fields are blocked unless specifically requrested and only for the */csv and application/kvp+csv types. 
        :type fields: list[str]
        :param limit: syntax: limit=10  behavior: maximum number of matching results returned, for pagination  note: limit=0 returns just the summary 
        :type limit: int
        :param sort: syntax: sort=asc(field0),desc(field1),...  behavior: is this implemented? 
        :type sort: list[str]
        :param start: syntax: start=12  behavior: offset in matching result list, for pagination 
        :type start: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(object, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'identifier',
            'versions',
            'fields',
            'limit',
            'sort',
            'start'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method product_members_members_vers" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and local_var_params.get('identifier') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `identifier` when calling `product_members_members_vers`")  # noqa: E501
        # verify the required parameter 'versions' is set
        if self.api_client.client_side_validation and local_var_params.get('versions') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `versions` when calling `product_members_members_vers`")  # noqa: E501

        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `product_members_members_vers`, must be a value greater than or equal to `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'start' in local_var_params and local_var_params['start'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `start` when calling `product_members_members_vers`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in local_var_params:
            path_params['identifier'] = local_var_params['identifier']  # noqa: E501
        if 'versions' in local_var_params:
            path_params['versions'] = local_var_params['versions']  # noqa: E501

        query_params = []
        if local_var_params.get('fields') is not None:  # noqa: E501
            query_params.append(('fields', local_var_params['fields']))  # noqa: E501
            collection_formats['fields'] = 'multi'  # noqa: E501
        if local_var_params.get('limit') is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if local_var_params.get('sort') is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
            collection_formats['sort'] = 'multi'  # noqa: E501
        if local_var_params.get('start') is not None:  # noqa: E501
            query_params.append(('start', local_var_params['start']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*', '*/*', 'application/csv', 'application/json', 'application/kvp+json', 'application/vnd.nasa.pds.pds4+json', 'application/vnd.nasa.pds.pds4+xml', 'application/xml', 'text/csv', 'text/html', 'text/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {
            200: "object",
            400: "ErrorMessage",
            404: "ErrorMessage",
            500: "ErrorMessage",
            501: "ErrorMessage",
        }

        return self.api_client.call_api(
            '/products/{identifier}/members/members/{versions}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def product_members_vers(self, identifier, versions, **kwargs):  # noqa: E501
        """returns all of the members of the given lid/lidvid   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.product_members_vers(identifier, versions, async_req=True)
        >>> result = thread.get()

        :param identifier: syntax: lidvid or lid  behavior (lid): returns one or more items whose lid matches this lid exactly. If the endpoint ends with the identifier or /latest then a signle result is returned and it is the highest version. If the endpoint ends with /all then all versions of the lid are returned.  behavior (lidvid): returns one and only one item whose lidvid matches this lidvid exactly.  note: the current lid/lidvid resolution will match all the lids that start with lid. In other words, it acts like a glob of foobar*. It behavesn this way from first character to the last  note: simple sorting of the lidvid is being done to select the latest from the end of the list. However, the versions 1.0, 2.0, and 13.0 will sort to 1.0, 13.0, and 2.0 so the end of the list may not be the latest.  (required)
        :type identifier: str
        :param versions: syntax: one of the allowable enum values  This is a shortcut for doing a query with ...  (required)
        :type versions: str
        :param fields: syntax: fields=field1,field2,...  behavior: this parameter and the headder Accept: type determine what content is packaged for the result. While the types application/csv, application/kvp+json, and text/csv return only the fields requesteted, all of the other types have a minimal set of fields that must be returned. Duplicating a minimally required field in this parameter has not effect. The types vnd.nasa.pds.pds4+json and vnd.nasa.pds.pds4+xml have a complete set of fields that must be returned; meaning this parameter does not impact their content. When fields is not used, then the minimal set of fields, or all when minimal is an empty set, is returned.  notes: the blob fields are blocked unless specifically requrested and only for the */csv and application/kvp+csv types. 
        :type fields: list[str]
        :param limit: syntax: limit=10  behavior: maximum number of matching results returned, for pagination  note: limit=0 returns just the summary 
        :type limit: int
        :param sort: syntax: sort=asc(field0),desc(field1),...  behavior: is this implemented? 
        :type sort: list[str]
        :param start: syntax: start=12  behavior: offset in matching result list, for pagination 
        :type start: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: object
        """
        kwargs['_return_http_data_only'] = True
        return self.product_members_vers_with_http_info(identifier, versions, **kwargs)  # noqa: E501

    def product_members_vers_with_http_info(self, identifier, versions, **kwargs):  # noqa: E501
        """returns all of the members of the given lid/lidvid   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.product_members_vers_with_http_info(identifier, versions, async_req=True)
        >>> result = thread.get()

        :param identifier: syntax: lidvid or lid  behavior (lid): returns one or more items whose lid matches this lid exactly. If the endpoint ends with the identifier or /latest then a signle result is returned and it is the highest version. If the endpoint ends with /all then all versions of the lid are returned.  behavior (lidvid): returns one and only one item whose lidvid matches this lidvid exactly.  note: the current lid/lidvid resolution will match all the lids that start with lid. In other words, it acts like a glob of foobar*. It behavesn this way from first character to the last  note: simple sorting of the lidvid is being done to select the latest from the end of the list. However, the versions 1.0, 2.0, and 13.0 will sort to 1.0, 13.0, and 2.0 so the end of the list may not be the latest.  (required)
        :type identifier: str
        :param versions: syntax: one of the allowable enum values  This is a shortcut for doing a query with ...  (required)
        :type versions: str
        :param fields: syntax: fields=field1,field2,...  behavior: this parameter and the headder Accept: type determine what content is packaged for the result. While the types application/csv, application/kvp+json, and text/csv return only the fields requesteted, all of the other types have a minimal set of fields that must be returned. Duplicating a minimally required field in this parameter has not effect. The types vnd.nasa.pds.pds4+json and vnd.nasa.pds.pds4+xml have a complete set of fields that must be returned; meaning this parameter does not impact their content. When fields is not used, then the minimal set of fields, or all when minimal is an empty set, is returned.  notes: the blob fields are blocked unless specifically requrested and only for the */csv and application/kvp+csv types. 
        :type fields: list[str]
        :param limit: syntax: limit=10  behavior: maximum number of matching results returned, for pagination  note: limit=0 returns just the summary 
        :type limit: int
        :param sort: syntax: sort=asc(field0),desc(field1),...  behavior: is this implemented? 
        :type sort: list[str]
        :param start: syntax: start=12  behavior: offset in matching result list, for pagination 
        :type start: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(object, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'identifier',
            'versions',
            'fields',
            'limit',
            'sort',
            'start'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method product_members_vers" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and local_var_params.get('identifier') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `identifier` when calling `product_members_vers`")  # noqa: E501
        # verify the required parameter 'versions' is set
        if self.api_client.client_side_validation and local_var_params.get('versions') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `versions` when calling `product_members_vers`")  # noqa: E501

        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `product_members_vers`, must be a value greater than or equal to `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'start' in local_var_params and local_var_params['start'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `start` when calling `product_members_vers`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in local_var_params:
            path_params['identifier'] = local_var_params['identifier']  # noqa: E501
        if 'versions' in local_var_params:
            path_params['versions'] = local_var_params['versions']  # noqa: E501

        query_params = []
        if local_var_params.get('fields') is not None:  # noqa: E501
            query_params.append(('fields', local_var_params['fields']))  # noqa: E501
            collection_formats['fields'] = 'multi'  # noqa: E501
        if local_var_params.get('limit') is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if local_var_params.get('sort') is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
            collection_formats['sort'] = 'multi'  # noqa: E501
        if local_var_params.get('start') is not None:  # noqa: E501
            query_params.append(('start', local_var_params['start']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*', '*/*', 'application/csv', 'application/json', 'application/kvp+json', 'application/vnd.nasa.pds.pds4+json', 'application/vnd.nasa.pds.pds4+xml', 'application/xml', 'text/csv', 'text/html', 'text/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {
            200: "object",
            400: "ErrorMessage",
            404: "ErrorMessage",
            500: "ErrorMessage",
            501: "ErrorMessage",
        }

        return self.api_client.call_api(
            '/products/{identifier}/members/{versions}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))
