# coding: utf-8

"""
    Planetary Data System API

    Federated PDS API which provides actionable end points standardized between the different nodes.   # noqa: E501

    The version of the OpenAPI document: 0.0
    Contact: pds-operator@jpl.nasa.gov
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from pds_api_client.configuration import Configuration


class Collection(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'title': 'str',
        'description': 'str',
        'instruments': 'list[str]',
        'targets': 'list[str]',
        'optional_properties': 'dict(str, list[str])'
    }

    attribute_map = {
        'id': 'id',
        'title': 'title',
        'description': 'description',
        'instruments': 'instruments',
        'targets': 'targets',
        'optional_properties': 'optional_properties'
    }

    def __init__(self, id=None, title=None, description=None, instruments=None, targets=None, optional_properties=None, local_vars_configuration=None):  # noqa: E501
        """Collection - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._title = None
        self._description = None
        self._instruments = None
        self._targets = None
        self._optional_properties = None
        self.discriminator = None

        self.id = id
        self.title = title
        if description is not None:
            self.description = description
        if instruments is not None:
            self.instruments = instruments
        if targets is not None:
            self.targets = targets
        if optional_properties is not None:
            self.optional_properties = optional_properties

    @property
    def id(self):
        """Gets the id of this Collection.  # noqa: E501

        identifier lidvid of the collection  # noqa: E501

        :return: The id of this Collection.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Collection.

        identifier lidvid of the collection  # noqa: E501

        :param id: The id of this Collection.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def title(self):
        """Gets the title of this Collection.  # noqa: E501


        :return: The title of this Collection.  # noqa: E501
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """Sets the title of this Collection.


        :param title: The title of this Collection.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and title is None:  # noqa: E501
            raise ValueError("Invalid value for `title`, must not be `None`")  # noqa: E501

        self._title = title

    @property
    def description(self):
        """Gets the description of this Collection.  # noqa: E501


        :return: The description of this Collection.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this Collection.


        :param description: The description of this Collection.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def instruments(self):
        """Gets the instruments of this Collection.  # noqa: E501

        identifier lidvid of the instrument or procedure generating the data  # noqa: E501

        :return: The instruments of this Collection.  # noqa: E501
        :rtype: list[str]
        """
        return self._instruments

    @instruments.setter
    def instruments(self, instruments):
        """Sets the instruments of this Collection.

        identifier lidvid of the instrument or procedure generating the data  # noqa: E501

        :param instruments: The instruments of this Collection.  # noqa: E501
        :type: list[str]
        """

        self._instruments = instruments

    @property
    def targets(self):
        """Gets the targets of this Collection.  # noqa: E501

        identifier lidvid of the target of the observation  # noqa: E501

        :return: The targets of this Collection.  # noqa: E501
        :rtype: list[str]
        """
        return self._targets

    @targets.setter
    def targets(self, targets):
        """Sets the targets of this Collection.

        identifier lidvid of the target of the observation  # noqa: E501

        :param targets: The targets of this Collection.  # noqa: E501
        :type: list[str]
        """

        self._targets = targets

    @property
    def optional_properties(self):
        """Gets the optional_properties of this Collection.  # noqa: E501


        :return: The optional_properties of this Collection.  # noqa: E501
        :rtype: dict(str, list[str])
        """
        return self._optional_properties

    @optional_properties.setter
    def optional_properties(self, optional_properties):
        """Sets the optional_properties of this Collection.


        :param optional_properties: The optional_properties of this Collection.  # noqa: E501
        :type: dict(str, list[str])
        """

        self._optional_properties = optional_properties

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Collection):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Collection):
            return True

        return self.to_dict() != other.to_dict()
