# coding: utf-8

"""
    Planetary Data System DOI Service API

    PDS API for managing DOI registration with OSTI service.  # noqa: E501

    The version of the OpenAPI document: 0.1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from pds.api_client.configuration import Configuration


class DoiRecordAllOf(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'record': 'str',
        'creation_date': 'datetime',
        'message': 'str'
    }

    attribute_map = {
        'record': 'record',
        'creation_date': 'creation_date',
        'message': 'message'
    }

    def __init__(self, record=None, creation_date=None, message=None, local_vars_configuration=None):  # noqa: E501
        """DoiRecordAllOf - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._record = None
        self._creation_date = None
        self._message = None
        self.discriminator = None

        if record is not None:
            self.record = record
        if creation_date is not None:
            self.creation_date = creation_date
        if message is not None:
            self.message = message

    @property
    def record(self):
        """Gets the record of this DoiRecordAllOf.  # noqa: E501

        full OSTI XML label  # noqa: E501

        :return: The record of this DoiRecordAllOf.  # noqa: E501
        :rtype: str
        """
        return self._record

    @record.setter
    def record(self, record):
        """Sets the record of this DoiRecordAllOf.

        full OSTI XML label  # noqa: E501

        :param record: The record of this DoiRecordAllOf.  # noqa: E501
        :type: str
        """

        self._record = record

    @property
    def creation_date(self):
        """Gets the creation_date of this DoiRecordAllOf.  # noqa: E501

        Creation date of the DOI record in iso8601 format  # noqa: E501

        :return: The creation_date of this DoiRecordAllOf.  # noqa: E501
        :rtype: datetime
        """
        return self._creation_date

    @creation_date.setter
    def creation_date(self, creation_date):
        """Sets the creation_date of this DoiRecordAllOf.

        Creation date of the DOI record in iso8601 format  # noqa: E501

        :param creation_date: The creation_date of this DoiRecordAllOf.  # noqa: E501
        :type: datetime
        """

        self._creation_date = creation_date

    @property
    def message(self):
        """Gets the message of this DoiRecordAllOf.  # noqa: E501


        :return: The message of this DoiRecordAllOf.  # noqa: E501
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message):
        """Sets the message of this DoiRecordAllOf.


        :param message: The message of this DoiRecordAllOf.  # noqa: E501
        :type: str
        """

        self._message = message

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DoiRecordAllOf):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, DoiRecordAllOf):
            return True

        return self.to_dict() != other.to_dict()
