# coding: utf-8

"""
    Registry API

    Registry API enabling advanced search on PDS data and metadata. The API provides end-points to search for bundles, collections and any PDS products with advanced search queries. It also enables to browse the archive hierarchically downward (e.g. collection/s products) or upward (e.g. bundles containing a product). The detailed syntax for querying the end-point is given in the reference documentation.   # noqa: E501

    The version of the OpenAPI document: 1.1
    Contact: pds-operator@jpl.nasa.gov
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from pds.api_client.configuration import Configuration


class Pds4Metadata(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'node_name': 'str',
        'ops_label_file_info': 'Pds4MetadataOpsLabelFileInfo',
        'ops_data_files': 'list[Pds4MetadataOpsDataFilesInner]',
        'ops_tracking_meta': 'Pds4MetadataOpsTrackingMeta'
    }

    attribute_map = {
        'node_name': 'node_name',
        'ops_label_file_info': 'ops:Label_File_Info',
        'ops_data_files': 'ops:Data_Files',
        'ops_tracking_meta': 'ops:Tracking_Meta'
    }

    def __init__(self, node_name=None, ops_label_file_info=None, ops_data_files=None, ops_tracking_meta=None, local_vars_configuration=None):  # noqa: E501
        """Pds4Metadata - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._node_name = None
        self._ops_label_file_info = None
        self._ops_data_files = None
        self._ops_tracking_meta = None
        self.discriminator = None

        if node_name is not None:
            self.node_name = node_name
        if ops_label_file_info is not None:
            self.ops_label_file_info = ops_label_file_info
        if ops_data_files is not None:
            self.ops_data_files = ops_data_files
        if ops_tracking_meta is not None:
            self.ops_tracking_meta = ops_tracking_meta

    @property
    def node_name(self):
        """Gets the node_name of this Pds4Metadata.  # noqa: E501


        :return: The node_name of this Pds4Metadata.  # noqa: E501
        :rtype: str
        """
        return self._node_name

    @node_name.setter
    def node_name(self, node_name):
        """Sets the node_name of this Pds4Metadata.


        :param node_name: The node_name of this Pds4Metadata.  # noqa: E501
        :type node_name: str
        """

        self._node_name = node_name

    @property
    def ops_label_file_info(self):
        """Gets the ops_label_file_info of this Pds4Metadata.  # noqa: E501


        :return: The ops_label_file_info of this Pds4Metadata.  # noqa: E501
        :rtype: Pds4MetadataOpsLabelFileInfo
        """
        return self._ops_label_file_info

    @ops_label_file_info.setter
    def ops_label_file_info(self, ops_label_file_info):
        """Sets the ops_label_file_info of this Pds4Metadata.


        :param ops_label_file_info: The ops_label_file_info of this Pds4Metadata.  # noqa: E501
        :type ops_label_file_info: Pds4MetadataOpsLabelFileInfo
        """

        self._ops_label_file_info = ops_label_file_info

    @property
    def ops_data_files(self):
        """Gets the ops_data_files of this Pds4Metadata.  # noqa: E501


        :return: The ops_data_files of this Pds4Metadata.  # noqa: E501
        :rtype: list[Pds4MetadataOpsDataFilesInner]
        """
        return self._ops_data_files

    @ops_data_files.setter
    def ops_data_files(self, ops_data_files):
        """Sets the ops_data_files of this Pds4Metadata.


        :param ops_data_files: The ops_data_files of this Pds4Metadata.  # noqa: E501
        :type ops_data_files: list[Pds4MetadataOpsDataFilesInner]
        """

        self._ops_data_files = ops_data_files

    @property
    def ops_tracking_meta(self):
        """Gets the ops_tracking_meta of this Pds4Metadata.  # noqa: E501


        :return: The ops_tracking_meta of this Pds4Metadata.  # noqa: E501
        :rtype: Pds4MetadataOpsTrackingMeta
        """
        return self._ops_tracking_meta

    @ops_tracking_meta.setter
    def ops_tracking_meta(self, ops_tracking_meta):
        """Sets the ops_tracking_meta of this Pds4Metadata.


        :param ops_tracking_meta: The ops_tracking_meta of this Pds4Metadata.  # noqa: E501
        :type ops_tracking_meta: Pds4MetadataOpsTrackingMeta
        """

        self._ops_tracking_meta = ops_tracking_meta

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Pds4Metadata):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Pds4Metadata):
            return True

        return self.to_dict() != other.to_dict()
