# coding: utf-8

"""
    Registry API

    Registry API enabling advanced search on PDS data and metadata. The API provides end-points to search for bundles, collections and any PDS products with advanced search queries. It also enables to browse the archive hierarchically downward (e.g. collection/s products) or upward (e.g. bundles containing a product). The detailed syntax for querying the end-point is given in the reference documentation.   # noqa: E501

    The version of the OpenAPI document: 1.1
    Contact: pds-operator@jpl.nasa.gov
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from pds.api_client.configuration import Configuration


class Pds4MetadataOpsLabelFileInfo(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'opsfile_name': 'str',
        'opsfile_ref': 'str',
        'opscreation_date': 'str',
        'opsfile_size': 'str',
        'opsmd5_checksum': 'str'
    }

    attribute_map = {
        'opsfile_name': 'ops:file_name',
        'opsfile_ref': 'ops:file_ref',
        'opscreation_date': 'ops:creation_date',
        'opsfile_size': 'ops:file_size',
        'opsmd5_checksum': 'ops:md5_checksum'
    }

    def __init__(self, opsfile_name=None, opsfile_ref=None, opscreation_date=None, opsfile_size=None, opsmd5_checksum=None, local_vars_configuration=None):  # noqa: E501
        """Pds4MetadataOpsLabelFileInfo - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._opsfile_name = None
        self._opsfile_ref = None
        self._opscreation_date = None
        self._opsfile_size = None
        self._opsmd5_checksum = None
        self.discriminator = None

        if opsfile_name is not None:
            self.opsfile_name = opsfile_name
        if opsfile_ref is not None:
            self.opsfile_ref = opsfile_ref
        if opscreation_date is not None:
            self.opscreation_date = opscreation_date
        if opsfile_size is not None:
            self.opsfile_size = opsfile_size
        if opsmd5_checksum is not None:
            self.opsmd5_checksum = opsmd5_checksum

    @property
    def opsfile_name(self):
        """Gets the opsfile_name of this Pds4MetadataOpsLabelFileInfo.  # noqa: E501


        :return: The opsfile_name of this Pds4MetadataOpsLabelFileInfo.  # noqa: E501
        :rtype: str
        """
        return self._opsfile_name

    @opsfile_name.setter
    def opsfile_name(self, opsfile_name):
        """Sets the opsfile_name of this Pds4MetadataOpsLabelFileInfo.


        :param opsfile_name: The opsfile_name of this Pds4MetadataOpsLabelFileInfo.  # noqa: E501
        :type opsfile_name: str
        """

        self._opsfile_name = opsfile_name

    @property
    def opsfile_ref(self):
        """Gets the opsfile_ref of this Pds4MetadataOpsLabelFileInfo.  # noqa: E501


        :return: The opsfile_ref of this Pds4MetadataOpsLabelFileInfo.  # noqa: E501
        :rtype: str
        """
        return self._opsfile_ref

    @opsfile_ref.setter
    def opsfile_ref(self, opsfile_ref):
        """Sets the opsfile_ref of this Pds4MetadataOpsLabelFileInfo.


        :param opsfile_ref: The opsfile_ref of this Pds4MetadataOpsLabelFileInfo.  # noqa: E501
        :type opsfile_ref: str
        """

        self._opsfile_ref = opsfile_ref

    @property
    def opscreation_date(self):
        """Gets the opscreation_date of this Pds4MetadataOpsLabelFileInfo.  # noqa: E501


        :return: The opscreation_date of this Pds4MetadataOpsLabelFileInfo.  # noqa: E501
        :rtype: str
        """
        return self._opscreation_date

    @opscreation_date.setter
    def opscreation_date(self, opscreation_date):
        """Sets the opscreation_date of this Pds4MetadataOpsLabelFileInfo.


        :param opscreation_date: The opscreation_date of this Pds4MetadataOpsLabelFileInfo.  # noqa: E501
        :type opscreation_date: str
        """

        self._opscreation_date = opscreation_date

    @property
    def opsfile_size(self):
        """Gets the opsfile_size of this Pds4MetadataOpsLabelFileInfo.  # noqa: E501


        :return: The opsfile_size of this Pds4MetadataOpsLabelFileInfo.  # noqa: E501
        :rtype: str
        """
        return self._opsfile_size

    @opsfile_size.setter
    def opsfile_size(self, opsfile_size):
        """Sets the opsfile_size of this Pds4MetadataOpsLabelFileInfo.


        :param opsfile_size: The opsfile_size of this Pds4MetadataOpsLabelFileInfo.  # noqa: E501
        :type opsfile_size: str
        """

        self._opsfile_size = opsfile_size

    @property
    def opsmd5_checksum(self):
        """Gets the opsmd5_checksum of this Pds4MetadataOpsLabelFileInfo.  # noqa: E501


        :return: The opsmd5_checksum of this Pds4MetadataOpsLabelFileInfo.  # noqa: E501
        :rtype: str
        """
        return self._opsmd5_checksum

    @opsmd5_checksum.setter
    def opsmd5_checksum(self, opsmd5_checksum):
        """Sets the opsmd5_checksum of this Pds4MetadataOpsLabelFileInfo.


        :param opsmd5_checksum: The opsmd5_checksum of this Pds4MetadataOpsLabelFileInfo.  # noqa: E501
        :type opsmd5_checksum: str
        """

        self._opsmd5_checksum = opsmd5_checksum

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Pds4MetadataOpsLabelFileInfo):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Pds4MetadataOpsLabelFileInfo):
            return True

        return self.to_dict() != other.to_dict()
