# coding: utf-8

"""
    Registry API

    Registry API enabling advanced search on PDS data and metadata. The API provides end-points to search for bundles, collections and any PDS products with advanced search queries. It also enables to browse the archive hierarchically downward (e.g. collection/s products) or upward (e.g. bundles containing a product). The detailed syntax for querying the end-point is given in the reference documentation.   # noqa: E501

    The version of the OpenAPI document: 1.1
    Contact: pds-operator@jpl.nasa.gov
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from pds.api_client.configuration import Configuration


class Pds4MetadataOpsTrackingMeta(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'opsarchive_status': 'str'
    }

    attribute_map = {
        'opsarchive_status': 'ops:archive_status'
    }

    def __init__(self, opsarchive_status=None, local_vars_configuration=None):  # noqa: E501
        """Pds4MetadataOpsTrackingMeta - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._opsarchive_status = None
        self.discriminator = None

        if opsarchive_status is not None:
            self.opsarchive_status = opsarchive_status

    @property
    def opsarchive_status(self):
        """Gets the opsarchive_status of this Pds4MetadataOpsTrackingMeta.  # noqa: E501


        :return: The opsarchive_status of this Pds4MetadataOpsTrackingMeta.  # noqa: E501
        :rtype: str
        """
        return self._opsarchive_status

    @opsarchive_status.setter
    def opsarchive_status(self, opsarchive_status):
        """Sets the opsarchive_status of this Pds4MetadataOpsTrackingMeta.


        :param opsarchive_status: The opsarchive_status of this Pds4MetadataOpsTrackingMeta.  # noqa: E501
        :type opsarchive_status: str
        """

        self._opsarchive_status = opsarchive_status

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Pds4MetadataOpsTrackingMeta):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Pds4MetadataOpsTrackingMeta):
            return True

        return self.to_dict() != other.to_dict()
