# coding: utf-8

"""
    Registry API

    Registry API enabling advanced search on PDS data and metadata. The API provides end-points to search for bundles, collections and any PDS products with advanced search queries. It also enables to browse the archive hierarchically downward (e.g. collection/s products) or upward (e.g. bundles containing a product). The detailed syntax for querying the end-point is given in the reference documentation.   # noqa: E501

    The version of the OpenAPI document: 1.1
    Contact: pds-operator@jpl.nasa.gov
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from pds.api_client.configuration import Configuration


class Pds4Product(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'metadata': 'Pds4Metadata',
        'pds4': 'object'
    }

    attribute_map = {
        'id': 'id',
        'metadata': 'metadata',
        'pds4': 'pds4'
    }

    def __init__(self, id=None, metadata=None, pds4=None, local_vars_configuration=None):  # noqa: E501
        """Pds4Product - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._metadata = None
        self._pds4 = None
        self.discriminator = None

        self.id = id
        if metadata is not None:
            self.metadata = metadata
        if pds4 is not None:
            self.pds4 = pds4

    @property
    def id(self):
        """Gets the id of this Pds4Product.  # noqa: E501

        LIDVID  # noqa: E501

        :return: The id of this Pds4Product.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Pds4Product.

        LIDVID  # noqa: E501

        :param id: The id of this Pds4Product.  # noqa: E501
        :type id: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def metadata(self):
        """Gets the metadata of this Pds4Product.  # noqa: E501


        :return: The metadata of this Pds4Product.  # noqa: E501
        :rtype: Pds4Metadata
        """
        return self._metadata

    @metadata.setter
    def metadata(self, metadata):
        """Sets the metadata of this Pds4Product.


        :param metadata: The metadata of this Pds4Product.  # noqa: E501
        :type metadata: Pds4Metadata
        """

        self._metadata = metadata

    @property
    def pds4(self):
        """Gets the pds4 of this Pds4Product.  # noqa: E501

        PDS4 JSON  # noqa: E501

        :return: The pds4 of this Pds4Product.  # noqa: E501
        :rtype: object
        """
        return self._pds4

    @pds4.setter
    def pds4(self, pds4):
        """Sets the pds4 of this Pds4Product.

        PDS4 JSON  # noqa: E501

        :param pds4: The pds4 of this Pds4Product.  # noqa: E501
        :type pds4: object
        """

        self._pds4 = pds4

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Pds4Product):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Pds4Product):
            return True

        return self.to_dict() != other.to_dict()
