from __future__ import annotations

from typing import *

class Chidori:
    def start_server(self, file_path: Optional[str]) -> None: ...
    def play(self, branch: int, frame: int) -> None: ...
    def pause(self, frame: int) -> None: ...
    def branch(self) -> None: ...
    def query(self, query: str, branch: int, frame: int) -> None: ...
    def list_branches(self) -> None: ...
    def display_graph_structure(self) -> None: ...
    def list_registered_graphs(self) -> None: ...
    def list_input_proposals(self) -> None: ...
    def list_change_events(self, callback: object) -> None: ...
    def poll_local_code_node_execution(self) -> None: ...
    def ack_local_code_node_execution(self, branch: int, counter: int) -> None: ...
    def respond_local_code_node_execution(self, branch: int, counter: int, node_name: str, response: Optional[object]) -> None: ...

class GraphBuilder:
    def custom_node(self, name: str, queries: List[Optional[str]], output_tables: List[str], output: str, node_type_name: str) -> None: ...
    def deno_code_node(self, name: str, queries: List[Optional[str]], output_tables: List[str], output: str, code: str, is_template: bool) -> None: ...
    def vector_memory_node(self, name: str, queries: List[Optional[str]], output_tables: List[str], output: str, template: str, action: str, embedding_model: str, db_vendor: str, collection_name: str) -> None: ...
    def prompt_node(self, name: str, queries: List[Optional[str]], output_tables: List[str], template: str, model: str) -> None: ...
    def commit(self, c: Chidori, branch: int) -> None: ...

class NodeHandle:
    def get_name(self) -> str: ...
    def run_when(self, node_handle: Optional[NodeHandle]) -> None: ...
    def query(self, branch: int, frame: int) -> None: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
