# coding: utf-8

"""
    VRt.Studio [ST]

    Veeroute Studio API.  # Description  Server part of the Veeroute Studio.  ## Reserved attributes  These attribute keys are reserved for specific business logic:  | Attribute key        | Parent entity | Purpose                                                                                                                                                                                      | |:---------------------|:--------------|:---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------| | `ICON_NAME`          | location      | The attribute value is written to the `web_location_geopoint.icon_name` field                                                                                                                | | `FORCED_GEOPROVIDER` | geo_settings  | The attribute value determines the geodata provider for rendering flights on the map, which will be used instead of the one specified in the `plan_settings.geo_settings.geo_provider` field |  ## Entity relationship diagram  ![erd](../uml/studio.svg) 

    The version of the OpenAPI document: 7.17.2697
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from vrt_lss_studio.models.attribute import Attribute
from typing import Optional, Set
from typing_extensions import Self

class GeoSettings(BaseModel):
    """
    Geodata usage settings. 
    """ # noqa: E501
    geo_provider: Optional[Annotated[str, Field(min_length=3, strict=True, max_length=256)]] = Field(default='VRT', description="Geodata provider:   * `VRT` - geo-data and traffic jams from Veeroute, work all over the world.  A specific provider may be specified for a specific region, availability depending on customer settings. ")
    toll_roads: Optional[StrictBool] = Field(default=True, description="Use toll roads.")
    ferry_crossing: Optional[StrictBool] = Field(default=True, description="Use ferry crossing.")
    traffic_jams: Optional[StrictBool] = Field(default=True, description="Accounting for traffic during the route planning.")
    flight_distance: Optional[StrictBool] = Field(default=False, description="Use for calculating straight line distances. If `false` is specified, distances are calculated by roads. When this parameter is enabled, geo-provider not used and traffic (`traffic_jams`) is automatically disabled. ")
    attributes: Optional[Annotated[List[Attribute], Field(min_length=0, max_length=250)]] = Field(default=None, description="Attributes. Used to add service information.")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["geo_provider", "toll_roads", "ferry_crossing", "traffic_jams", "flight_distance", "attributes"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GeoSettings from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in attributes (list)
        _items = []
        if self.attributes:
            for _item_attributes in self.attributes:
                if _item_attributes:
                    _items.append(_item_attributes.to_dict())
            _dict['attributes'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GeoSettings from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "geo_provider": obj.get("geo_provider") if obj.get("geo_provider") is not None else 'VRT',
            "toll_roads": obj.get("toll_roads") if obj.get("toll_roads") is not None else True,
            "ferry_crossing": obj.get("ferry_crossing") if obj.get("ferry_crossing") is not None else True,
            "traffic_jams": obj.get("traffic_jams") if obj.get("traffic_jams") is not None else True,
            "flight_distance": obj.get("flight_distance") if obj.get("flight_distance") is not None else False,
            "attributes": [Attribute.from_dict(_item) for _item in obj["attributes"]] if obj.get("attributes") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


