# coding: utf-8

"""
    Modern Logic Api

    Manage and version your customer decision logic outside of your codebase  # noqa: E501

    OpenAPI spec version: 1.0.0
    Contact: info@usemodernlogic.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from modern_logic_client.api_client import ApiClient


class AlertsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def alert_alert_id_get(self, alert_id, **kwargs):  # noqa: E501
        """Get Alert Details  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.alert_alert_id_get(alert_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int alert_id: Alert id (required)
        :return: Alert
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.alert_alert_id_get_with_http_info(alert_id, **kwargs)  # noqa: E501
        else:
            (data) = self.alert_alert_id_get_with_http_info(alert_id, **kwargs)  # noqa: E501
            return data

    def alert_alert_id_get_with_http_info(self, alert_id, **kwargs):  # noqa: E501
        """Get Alert Details  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.alert_alert_id_get_with_http_info(alert_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int alert_id: Alert id (required)
        :return: Alert
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['alert_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method alert_alert_id_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'alert_id' is set
        if ('alert_id' not in params or
                params['alert_id'] is None):
            raise ValueError("Missing the required parameter `alert_id` when calling `alert_alert_id_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'alert_id' in params:
            path_params['alertId'] = params['alert_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/alert/{alertId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Alert',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def alert_get(self, **kwargs):  # noqa: E501
        """List Alerts  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.alert_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int page_size: Number of elements to return (default is 10)
        :param int page_number: Lists are ordered by creation date ascending. To return the first page, set pageNumber to zero
        :param str assigned_to: The username of the user the alert is assigned to
        :param str assigned_to_team: The name of the team the alert is assigned to
        :param str workflow: The name of the workflow associated to the alert
        :param date before: Filter alerts to those that occurred before the given date.
        :param date after: Filter alerts to those that occurred after the given date.
        :return: InlineResponse2007
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.alert_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.alert_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def alert_get_with_http_info(self, **kwargs):  # noqa: E501
        """List Alerts  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.alert_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int page_size: Number of elements to return (default is 10)
        :param int page_number: Lists are ordered by creation date ascending. To return the first page, set pageNumber to zero
        :param str assigned_to: The username of the user the alert is assigned to
        :param str assigned_to_team: The name of the team the alert is assigned to
        :param str workflow: The name of the workflow associated to the alert
        :param date before: Filter alerts to those that occurred before the given date.
        :param date after: Filter alerts to those that occurred after the given date.
        :return: InlineResponse2007
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'assigned_to', 'assigned_to_team', 'workflow', 'before', 'after']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method alert_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501
        if 'page_number' in params:
            query_params.append(('pageNumber', params['page_number']))  # noqa: E501
        if 'assigned_to' in params:
            query_params.append(('assignedTo', params['assigned_to']))  # noqa: E501
        if 'assigned_to_team' in params:
            query_params.append(('assignedToTeam', params['assigned_to_team']))  # noqa: E501
        if 'workflow' in params:
            query_params.append(('workflow', params['workflow']))  # noqa: E501
        if 'before' in params:
            query_params.append(('before', params['before']))  # noqa: E501
        if 'after' in params:
            query_params.append(('after', params['after']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/alert', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse2007',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
