# coding: utf-8

"""
    Modern Logic Api

    Manage and version your customer decision logic outside of your codebase  # noqa: E501

    OpenAPI spec version: 1.0.0
    Contact: info@usemodernlogic.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from modern_logic_client.api_client import ApiClient


class DataSourcesApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def datasource_calls_datasource_call_id_get(self, datasource_call_id, **kwargs):  # noqa: E501
        """Get Data Source Call Details  # noqa: E501

        A datasource call is a single instance of when a datasource was queried by a workflow  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.datasource_calls_datasource_call_id_get(datasource_call_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int datasource_call_id: Data source call id (required)
        :return: DataSourceCall
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.datasource_calls_datasource_call_id_get_with_http_info(datasource_call_id, **kwargs)  # noqa: E501
        else:
            (data) = self.datasource_calls_datasource_call_id_get_with_http_info(datasource_call_id, **kwargs)  # noqa: E501
            return data

    def datasource_calls_datasource_call_id_get_with_http_info(self, datasource_call_id, **kwargs):  # noqa: E501
        """Get Data Source Call Details  # noqa: E501

        A datasource call is a single instance of when a datasource was queried by a workflow  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.datasource_calls_datasource_call_id_get_with_http_info(datasource_call_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int datasource_call_id: Data source call id (required)
        :return: DataSourceCall
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['datasource_call_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method datasource_calls_datasource_call_id_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'datasource_call_id' is set
        if ('datasource_call_id' not in params or
                params['datasource_call_id'] is None):
            raise ValueError("Missing the required parameter `datasource_call_id` when calling `datasource_calls_datasource_call_id_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'datasource_call_id' in params:
            path_params['datasourceCallId'] = params['datasource_call_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/datasource_calls/{datasourceCallId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DataSourceCall',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def datasource_datasource_id_calls_get(self, datasource_id, **kwargs):  # noqa: E501
        """List Data Source Calls  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.datasource_datasource_id_calls_get(datasource_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int datasource_id: Specified workflow to run, to evaluate the target user. (required)
        :param int page_size: Number of elements to return (default is 10)
        :param int page_number: Lists are ordered by creation date ascending. To return the first page, set pageNumber to zero
        :return: InlineResponse2006
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.datasource_datasource_id_calls_get_with_http_info(datasource_id, **kwargs)  # noqa: E501
        else:
            (data) = self.datasource_datasource_id_calls_get_with_http_info(datasource_id, **kwargs)  # noqa: E501
            return data

    def datasource_datasource_id_calls_get_with_http_info(self, datasource_id, **kwargs):  # noqa: E501
        """List Data Source Calls  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.datasource_datasource_id_calls_get_with_http_info(datasource_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int datasource_id: Specified workflow to run, to evaluate the target user. (required)
        :param int page_size: Number of elements to return (default is 10)
        :param int page_number: Lists are ordered by creation date ascending. To return the first page, set pageNumber to zero
        :return: InlineResponse2006
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['datasource_id', 'page_size', 'page_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method datasource_datasource_id_calls_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'datasource_id' is set
        if ('datasource_id' not in params or
                params['datasource_id'] is None):
            raise ValueError("Missing the required parameter `datasource_id` when calling `datasource_datasource_id_calls_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'datasource_id' in params:
            path_params['datasourceId'] = params['datasource_id']  # noqa: E501

        query_params = []
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501
        if 'page_number' in params:
            query_params.append(('pageNumber', params['page_number']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/datasource/{datasourceId}/calls', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse2006',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def datasource_datasource_id_get(self, datasource_id, **kwargs):  # noqa: E501
        """Get Data Source Details  # noqa: E501

        Evaluates a new user using the specificed workflow and user details. Typically called during onboarding.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.datasource_datasource_id_get(datasource_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int datasource_id: Data Source id (required)
        :return: DataSource
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.datasource_datasource_id_get_with_http_info(datasource_id, **kwargs)  # noqa: E501
        else:
            (data) = self.datasource_datasource_id_get_with_http_info(datasource_id, **kwargs)  # noqa: E501
            return data

    def datasource_datasource_id_get_with_http_info(self, datasource_id, **kwargs):  # noqa: E501
        """Get Data Source Details  # noqa: E501

        Evaluates a new user using the specificed workflow and user details. Typically called during onboarding.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.datasource_datasource_id_get_with_http_info(datasource_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int datasource_id: Data Source id (required)
        :return: DataSource
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['datasource_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method datasource_datasource_id_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'datasource_id' is set
        if ('datasource_id' not in params or
                params['datasource_id'] is None):
            raise ValueError("Missing the required parameter `datasource_id` when calling `datasource_datasource_id_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'datasource_id' in params:
            path_params['datasourceId'] = params['datasource_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/datasource/{datasourceId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DataSource',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def datasource_get(self, **kwargs):  # noqa: E501
        """List Data Sources  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.datasource_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int page_size: Number of elements to return (default is 10)
        :param int page_number: Lists are ordered by creation date ascending. To return the first page, set pageNumber to zero
        :return: InlineResponse2005
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.datasource_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.datasource_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def datasource_get_with_http_info(self, **kwargs):  # noqa: E501
        """List Data Sources  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.datasource_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int page_size: Number of elements to return (default is 10)
        :param int page_number: Lists are ordered by creation date ascending. To return the first page, set pageNumber to zero
        :return: InlineResponse2005
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method datasource_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501
        if 'page_number' in params:
            query_params.append(('pageNumber', params['page_number']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/datasource', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse2005',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
