# coding: utf-8

"""
    Modern Logic Api

    Manage and version your customer decision logic outside of your codebase  # noqa: E501

    OpenAPI spec version: 1.0.0
    Contact: info@usemodernlogic.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from modern_logic_client.api_client import ApiClient


class WorkflowsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def workflow_get(self, **kwargs):  # noqa: E501
        """List Available Workflows  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.workflow_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int page_size: Number of elements to return (default is 10)
        :param int page_number: Lists are ordered by creation date ascending. To return the first page, set pageNumber to zero
        :return: InlineResponse2001
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.workflow_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.workflow_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def workflow_get_with_http_info(self, **kwargs):  # noqa: E501
        """List Available Workflows  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.workflow_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int page_size: Number of elements to return (default is 10)
        :param int page_number: Lists are ordered by creation date ascending. To return the first page, set pageNumber to zero
        :return: InlineResponse2001
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method workflow_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501
        if 'page_number' in params:
            query_params.append(('pageNumber', params['page_number']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/workflow', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse2001',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def workflow_workflow_id_execute_post(self, body, workflow_id, **kwargs):  # noqa: E501
        """Execute Workflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.workflow_workflow_id_execute_post(body, workflow_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param dict(str, object) body: Execution Information (required)
        :param int workflow_id: Workflow id (required)
        :param int v: If you want to run a version other then the current production version, you can supply the version number to run.
        :return: WorkflowExecutionResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.workflow_workflow_id_execute_post_with_http_info(body, workflow_id, **kwargs)  # noqa: E501
        else:
            (data) = self.workflow_workflow_id_execute_post_with_http_info(body, workflow_id, **kwargs)  # noqa: E501
            return data

    def workflow_workflow_id_execute_post_with_http_info(self, body, workflow_id, **kwargs):  # noqa: E501
        """Execute Workflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.workflow_workflow_id_execute_post_with_http_info(body, workflow_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param dict(str, object) body: Execution Information (required)
        :param int workflow_id: Workflow id (required)
        :param int v: If you want to run a version other then the current production version, you can supply the version number to run.
        :return: WorkflowExecutionResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'workflow_id', 'v']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method workflow_workflow_id_execute_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `workflow_workflow_id_execute_post`")  # noqa: E501
        # verify the required parameter 'workflow_id' is set
        if ('workflow_id' not in params or
                params['workflow_id'] is None):
            raise ValueError("Missing the required parameter `workflow_id` when calling `workflow_workflow_id_execute_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workflow_id' in params:
            path_params['workflowID'] = params['workflow_id']  # noqa: E501

        query_params = []
        if 'v' in params:
            query_params.append(('v', params['v']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/workflow/{workflowID}/execute', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='WorkflowExecutionResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def workflow_workflow_id_executions_get(self, workflow_id, **kwargs):  # noqa: E501
        """List Workflow Executions  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.workflow_workflow_id_executions_get(workflow_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int workflow_id: Workflow Id (required)
        :param int v: If you want to return the executions of a particular workflow version instead of all workflows
        :param int page_size: Number of elements to return (default is 10)
        :param int page_number: Lists are ordered by creation date ascending. To return the first page, set pageNumber to zero
        :return: InlineResponse200
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.workflow_workflow_id_executions_get_with_http_info(workflow_id, **kwargs)  # noqa: E501
        else:
            (data) = self.workflow_workflow_id_executions_get_with_http_info(workflow_id, **kwargs)  # noqa: E501
            return data

    def workflow_workflow_id_executions_get_with_http_info(self, workflow_id, **kwargs):  # noqa: E501
        """List Workflow Executions  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.workflow_workflow_id_executions_get_with_http_info(workflow_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int workflow_id: Workflow Id (required)
        :param int v: If you want to return the executions of a particular workflow version instead of all workflows
        :param int page_size: Number of elements to return (default is 10)
        :param int page_number: Lists are ordered by creation date ascending. To return the first page, set pageNumber to zero
        :return: InlineResponse200
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workflow_id', 'v', 'page_size', 'page_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method workflow_workflow_id_executions_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workflow_id' is set
        if ('workflow_id' not in params or
                params['workflow_id'] is None):
            raise ValueError("Missing the required parameter `workflow_id` when calling `workflow_workflow_id_executions_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workflow_id' in params:
            path_params['workflowID'] = params['workflow_id']  # noqa: E501

        query_params = []
        if 'v' in params:
            query_params.append(('v', params['v']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501
        if 'page_number' in params:
            query_params.append(('pageNumber', params['page_number']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/workflow/{workflowID}/executions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse200',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def workflow_workflow_id_get(self, workflow_id, **kwargs):  # noqa: E501
        """Get Workflow Details  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.workflow_workflow_id_get(workflow_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int workflow_id: Workflow id (required)
        :return: Workflow
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.workflow_workflow_id_get_with_http_info(workflow_id, **kwargs)  # noqa: E501
        else:
            (data) = self.workflow_workflow_id_get_with_http_info(workflow_id, **kwargs)  # noqa: E501
            return data

    def workflow_workflow_id_get_with_http_info(self, workflow_id, **kwargs):  # noqa: E501
        """Get Workflow Details  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.workflow_workflow_id_get_with_http_info(workflow_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int workflow_id: Workflow id (required)
        :return: Workflow
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workflow_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method workflow_workflow_id_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workflow_id' is set
        if ('workflow_id' not in params or
                params['workflow_id'] is None):
            raise ValueError("Missing the required parameter `workflow_id` when calling `workflow_workflow_id_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workflow_id' in params:
            path_params['workflowID'] = params['workflow_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/workflow/{workflowID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Workflow',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def workflow_workflow_id_versions_get(self, workflow_id, **kwargs):  # noqa: E501
        """List Workflow Versions  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.workflow_workflow_id_versions_get(workflow_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int workflow_id: Workflow id (required)
        :param int page_size: Number of elements to return (default is 10)
        :param int page_number: Lists are ordered by creation date ascending. To return the first page, set pageNumber to zero
        :return: InlineResponse2002
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.workflow_workflow_id_versions_get_with_http_info(workflow_id, **kwargs)  # noqa: E501
        else:
            (data) = self.workflow_workflow_id_versions_get_with_http_info(workflow_id, **kwargs)  # noqa: E501
            return data

    def workflow_workflow_id_versions_get_with_http_info(self, workflow_id, **kwargs):  # noqa: E501
        """List Workflow Versions  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.workflow_workflow_id_versions_get_with_http_info(workflow_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int workflow_id: Workflow id (required)
        :param int page_size: Number of elements to return (default is 10)
        :param int page_number: Lists are ordered by creation date ascending. To return the first page, set pageNumber to zero
        :return: InlineResponse2002
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workflow_id', 'page_size', 'page_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method workflow_workflow_id_versions_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workflow_id' is set
        if ('workflow_id' not in params or
                params['workflow_id'] is None):
            raise ValueError("Missing the required parameter `workflow_id` when calling `workflow_workflow_id_versions_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workflow_id' in params:
            path_params['workflowID'] = params['workflow_id']  # noqa: E501

        query_params = []
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501
        if 'page_number' in params:
            query_params.append(('pageNumber', params['page_number']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/workflow/{workflowID}/versions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse2002',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def workflow_workflow_id_webhooks_get(self, workflow_id, **kwargs):  # noqa: E501
        """List Active Callbacks  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.workflow_workflow_id_webhooks_get(workflow_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int workflow_id: Workflow ID (required)
        :param int page_size: Number of elements to return (default is 10)
        :param int page_number: Lists are ordered by creation date ascending. To return the first page, set pageNumber to zero
        :return: InlineResponse2003
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.workflow_workflow_id_webhooks_get_with_http_info(workflow_id, **kwargs)  # noqa: E501
        else:
            (data) = self.workflow_workflow_id_webhooks_get_with_http_info(workflow_id, **kwargs)  # noqa: E501
            return data

    def workflow_workflow_id_webhooks_get_with_http_info(self, workflow_id, **kwargs):  # noqa: E501
        """List Active Callbacks  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.workflow_workflow_id_webhooks_get_with_http_info(workflow_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int workflow_id: Workflow ID (required)
        :param int page_size: Number of elements to return (default is 10)
        :param int page_number: Lists are ordered by creation date ascending. To return the first page, set pageNumber to zero
        :return: InlineResponse2003
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workflow_id', 'page_size', 'page_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method workflow_workflow_id_webhooks_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workflow_id' is set
        if ('workflow_id' not in params or
                params['workflow_id'] is None):
            raise ValueError("Missing the required parameter `workflow_id` when calling `workflow_workflow_id_webhooks_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workflow_id' in params:
            path_params['workflowID'] = params['workflow_id']  # noqa: E501

        query_params = []
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501
        if 'page_number' in params:
            query_params.append(('pageNumber', params['page_number']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/workflow/{workflowID}/webhooks', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse2003',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
