# coding: utf-8

"""
    Modern Logic Api

    Manage and version your customer decision logic outside of your codebase  # noqa: E501

    OpenAPI spec version: 1.0.0
    Contact: info@usemodernlogic.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class WorkflowExecutionResult(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'flags': 'list[str]',
        'warnings': 'list[RuleSetWarning]',
        'execution_id': 'int',
        'result': 'str',
        'score': 'str',
        'reason': 'list[str]',
        'date_evaluated': 'str',
        'workflow_id': 'int',
        'workflow_version': 'int',
        'defined_variables': 'dict(str, object)',
        'follow_up_required': 'bool'
    }

    attribute_map = {
        'flags': 'flags',
        'warnings': 'warnings',
        'execution_id': 'executionId',
        'result': 'result',
        'score': 'score',
        'reason': 'reason',
        'date_evaluated': 'dateEvaluated',
        'workflow_id': 'workflowId',
        'workflow_version': 'workflowVersion',
        'defined_variables': 'definedVariables',
        'follow_up_required': 'followUpRequired'
    }

    def __init__(self, flags=None, warnings=None, execution_id=None, result=None, score=None, reason=None, date_evaluated=None, workflow_id=None, workflow_version=None, defined_variables=None, follow_up_required=None):  # noqa: E501
        """WorkflowExecutionResult - a model defined in Swagger"""  # noqa: E501
        self._flags = None
        self._warnings = None
        self._execution_id = None
        self._result = None
        self._score = None
        self._reason = None
        self._date_evaluated = None
        self._workflow_id = None
        self._workflow_version = None
        self._defined_variables = None
        self._follow_up_required = None
        self.discriminator = None
        if flags is not None:
            self.flags = flags
        if warnings is not None:
            self.warnings = warnings
        if execution_id is not None:
            self.execution_id = execution_id
        if result is not None:
            self.result = result
        if score is not None:
            self.score = score
        if reason is not None:
            self.reason = reason
        if date_evaluated is not None:
            self.date_evaluated = date_evaluated
        if workflow_id is not None:
            self.workflow_id = workflow_id
        if workflow_version is not None:
            self.workflow_version = workflow_version
        if defined_variables is not None:
            self.defined_variables = defined_variables
        if follow_up_required is not None:
            self.follow_up_required = follow_up_required

    @property
    def flags(self):
        """Gets the flags of this WorkflowExecutionResult.  # noqa: E501


        :return: The flags of this WorkflowExecutionResult.  # noqa: E501
        :rtype: list[str]
        """
        return self._flags

    @flags.setter
    def flags(self, flags):
        """Sets the flags of this WorkflowExecutionResult.


        :param flags: The flags of this WorkflowExecutionResult.  # noqa: E501
        :type: list[str]
        """

        self._flags = flags

    @property
    def warnings(self):
        """Gets the warnings of this WorkflowExecutionResult.  # noqa: E501


        :return: The warnings of this WorkflowExecutionResult.  # noqa: E501
        :rtype: list[RuleSetWarning]
        """
        return self._warnings

    @warnings.setter
    def warnings(self, warnings):
        """Sets the warnings of this WorkflowExecutionResult.


        :param warnings: The warnings of this WorkflowExecutionResult.  # noqa: E501
        :type: list[RuleSetWarning]
        """

        self._warnings = warnings

    @property
    def execution_id(self):
        """Gets the execution_id of this WorkflowExecutionResult.  # noqa: E501


        :return: The execution_id of this WorkflowExecutionResult.  # noqa: E501
        :rtype: int
        """
        return self._execution_id

    @execution_id.setter
    def execution_id(self, execution_id):
        """Sets the execution_id of this WorkflowExecutionResult.


        :param execution_id: The execution_id of this WorkflowExecutionResult.  # noqa: E501
        :type: int
        """

        self._execution_id = execution_id

    @property
    def result(self):
        """Gets the result of this WorkflowExecutionResult.  # noqa: E501


        :return: The result of this WorkflowExecutionResult.  # noqa: E501
        :rtype: str
        """
        return self._result

    @result.setter
    def result(self, result):
        """Sets the result of this WorkflowExecutionResult.


        :param result: The result of this WorkflowExecutionResult.  # noqa: E501
        :type: str
        """
        allowed_values = ["APPROVED", "REJECTED", "FLAGGED_FOR_REVIEW", "PAUSED", "ERROR"]  # noqa: E501
        if result not in allowed_values:
            raise ValueError(
                "Invalid value for `result` ({0}), must be one of {1}"  # noqa: E501
                .format(result, allowed_values)
            )

        self._result = result

    @property
    def score(self):
        """Gets the score of this WorkflowExecutionResult.  # noqa: E501


        :return: The score of this WorkflowExecutionResult.  # noqa: E501
        :rtype: str
        """
        return self._score

    @score.setter
    def score(self, score):
        """Sets the score of this WorkflowExecutionResult.


        :param score: The score of this WorkflowExecutionResult.  # noqa: E501
        :type: str
        """

        self._score = score

    @property
    def reason(self):
        """Gets the reason of this WorkflowExecutionResult.  # noqa: E501


        :return: The reason of this WorkflowExecutionResult.  # noqa: E501
        :rtype: list[str]
        """
        return self._reason

    @reason.setter
    def reason(self, reason):
        """Sets the reason of this WorkflowExecutionResult.


        :param reason: The reason of this WorkflowExecutionResult.  # noqa: E501
        :type: list[str]
        """

        self._reason = reason

    @property
    def date_evaluated(self):
        """Gets the date_evaluated of this WorkflowExecutionResult.  # noqa: E501


        :return: The date_evaluated of this WorkflowExecutionResult.  # noqa: E501
        :rtype: str
        """
        return self._date_evaluated

    @date_evaluated.setter
    def date_evaluated(self, date_evaluated):
        """Sets the date_evaluated of this WorkflowExecutionResult.


        :param date_evaluated: The date_evaluated of this WorkflowExecutionResult.  # noqa: E501
        :type: str
        """

        self._date_evaluated = date_evaluated

    @property
    def workflow_id(self):
        """Gets the workflow_id of this WorkflowExecutionResult.  # noqa: E501


        :return: The workflow_id of this WorkflowExecutionResult.  # noqa: E501
        :rtype: int
        """
        return self._workflow_id

    @workflow_id.setter
    def workflow_id(self, workflow_id):
        """Sets the workflow_id of this WorkflowExecutionResult.


        :param workflow_id: The workflow_id of this WorkflowExecutionResult.  # noqa: E501
        :type: int
        """

        self._workflow_id = workflow_id

    @property
    def workflow_version(self):
        """Gets the workflow_version of this WorkflowExecutionResult.  # noqa: E501


        :return: The workflow_version of this WorkflowExecutionResult.  # noqa: E501
        :rtype: int
        """
        return self._workflow_version

    @workflow_version.setter
    def workflow_version(self, workflow_version):
        """Sets the workflow_version of this WorkflowExecutionResult.


        :param workflow_version: The workflow_version of this WorkflowExecutionResult.  # noqa: E501
        :type: int
        """

        self._workflow_version = workflow_version

    @property
    def defined_variables(self):
        """Gets the defined_variables of this WorkflowExecutionResult.  # noqa: E501

        this field contains the variables that were defined during your execution  # noqa: E501

        :return: The defined_variables of this WorkflowExecutionResult.  # noqa: E501
        :rtype: dict(str, object)
        """
        return self._defined_variables

    @defined_variables.setter
    def defined_variables(self, defined_variables):
        """Sets the defined_variables of this WorkflowExecutionResult.

        this field contains the variables that were defined during your execution  # noqa: E501

        :param defined_variables: The defined_variables of this WorkflowExecutionResult.  # noqa: E501
        :type: dict(str, object)
        """

        self._defined_variables = defined_variables

    @property
    def follow_up_required(self):
        """Gets the follow_up_required of this WorkflowExecutionResult.  # noqa: E501


        :return: The follow_up_required of this WorkflowExecutionResult.  # noqa: E501
        :rtype: bool
        """
        return self._follow_up_required

    @follow_up_required.setter
    def follow_up_required(self, follow_up_required):
        """Sets the follow_up_required of this WorkflowExecutionResult.


        :param follow_up_required: The follow_up_required of this WorkflowExecutionResult.  # noqa: E501
        :type: bool
        """

        self._follow_up_required = follow_up_required

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(WorkflowExecutionResult, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, WorkflowExecutionResult):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
