"""add utility meter

Revision ID: 2dbe1d6a4fa6
Revises: 81f94b4136ee
Create Date: 2023-11-02 17:25:37.856060

"""
from alembic import op
import sqlalchemy as sa

# revision identifiers, used by Alembic.
revision = "2dbe1d6a4fa6"
down_revision = "81f94b4136ee"
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "utility_meter",
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("name", sa.String(), nullable=False),
        sa.Column("last_meter_value", sa.Float(), nullable=False),
        sa.Column("device_id", sa.CHAR(32), nullable=False),
        sa.ForeignKeyConstraint(
            ["device_id"], ["devices.id"], name=op.f("fk_utility_meter_device_id_devices")
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_utility_meter")),
        sa.UniqueConstraint("id", name=op.f("uq_utility_meter_id")),
    )
    with op.batch_alter_table("DeviceMeasurement") as batch_op:
        batch_op.alter_column("device_id", existing_type=sa.CHAR(length=32), nullable=False)
    with op.batch_alter_table("devices") as batch_op:
        batch_op.alter_column("power_mode", existing_type=sa.VARCHAR(), nullable=False)
        batch_op.create_unique_constraint(op.f("uq_devices_id"), ["id"])
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(op.f("uq_devices_id"), "devices", type_="unique")
    with op.batch_alter_table("devices") as batch_op:
        batch_op.drop_constraint(op.f("uq_devices_id"), type_="unique")
        batch_op.alter_column("devices", "power_mode", existing_type=sa.VARCHAR(), nullable=True)
    with op.batch_alter_table("DeviceMeasurement") as batch_op:
        batch_op.alter_column(
            "DeviceMeasurement", "device_id", existing_type=sa.CHAR(length=32), nullable=True
        )
    op.drop_table("utility_meter")
    # ### end Alembic commands ###
