# coding: utf-8

"""
    Onfido API v3.6

    The Onfido API (v3.6)

    The version of the OpenAPI document: v3.6
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import date
from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from onfido.models.country_codes import CountryCodes
from onfido.models.document_types import DocumentTypes
from typing import Optional, Set
from typing_extensions import Self

class ExtractionExtractedData(BaseModel):
    """
    ExtractionExtractedData
    """ # noqa: E501
    document_number: Optional[StrictStr] = Field(default=None, description="The official document number.")
    first_name: Optional[StrictStr] = Field(default=None, description="First name.")
    last_name: Optional[StrictStr] = Field(default=None, description="Last name.")
    full_name: Optional[StrictStr] = Field(default=None, description="Full name.")
    spouse_name: Optional[StrictStr] = Field(default=None, description="Spouse name (French documents only).")
    widow_name: Optional[StrictStr] = Field(default=None, description="Widow name (French documents only).")
    alias_name: Optional[StrictStr] = Field(default=None, description="Alias name (French documents only).")
    gender: Optional[StrictStr] = Field(default=None, description="Gender (Valid values are Male and Female).")
    date_of_birth: Optional[date] = Field(default=None, description="Date of birth in YYYY-MM-DD format.")
    date_of_expiry: Optional[date] = Field(default=None, description="Date of expiry in YYYY-MM-DD format.")
    expiry_date: Optional[date] = Field(default=None, description="Date of expiry in YYYY-MM-DD format.")
    nationality: Optional[Annotated[str, Field(strict=True)]] = Field(default=None, description="Nationality in 3-letter ISO code.")
    mrz_line_1: Optional[StrictStr] = Field(default=None, description="Line 1 of the MRZ code.")
    mrz_line_2: Optional[StrictStr] = Field(default=None, description="Line 2 of the MRZ code.")
    mrz_line_3: Optional[StrictStr] = Field(default=None, description="Line 3 of the MRZ code.")
    address_1: Optional[StrictStr] = Field(default=None, description="Line 1 of the address.")
    address_2: Optional[StrictStr] = Field(default=None, description="Line 2 of the address.")
    address_3: Optional[StrictStr] = Field(default=None, description="Line 3 of the address.")
    address_4: Optional[StrictStr] = Field(default=None, description="Line 4 of the address.")
    address_5: Optional[StrictStr] = Field(default=None, description="Line 5 of the address.")
    issuing_authority: Optional[StrictStr] = Field(default=None, description="Issuing authority.")
    issuing_country: Optional[CountryCodes] = Field(default=None, description="Document country in 3-letter ISO code.")
    document_type: Optional[DocumentTypes] = Field(default=None, description="Type of document.")
    place_of_birth: Optional[StrictStr] = Field(default=None, description="Place of birth.")
    issuing_state: Optional[StrictStr] = Field(default=None, description="The state that issued the document.")
    issuing_date: Optional[date] = Field(default=None, description="Issuing date in YYYY-MM-DD format.")
    personal_number: Optional[StrictStr] = Field(default=None, description="The owner's unique identification number.")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["document_number", "first_name", "last_name", "full_name", "spouse_name", "widow_name", "alias_name", "gender", "date_of_birth", "date_of_expiry", "expiry_date", "nationality", "mrz_line_1", "mrz_line_2", "mrz_line_3", "address_1", "address_2", "address_3", "address_4", "address_5", "issuing_authority", "issuing_country", "document_type", "place_of_birth", "issuing_state", "issuing_date", "personal_number"]

    @field_validator('gender')
    def gender_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['Male', 'Female', 'unknown_default_open_api']):
            raise ValueError("must be one of enum values ('Male', 'Female', 'unknown_default_open_api')")
        return value

    @field_validator('nationality')
    def nationality_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[A-Z]{3}$", value):
            raise ValueError(r"must validate the regular expression /^[A-Z]{3}$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ExtractionExtractedData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ExtractionExtractedData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "document_number": obj.get("document_number"),
            "first_name": obj.get("first_name"),
            "last_name": obj.get("last_name"),
            "full_name": obj.get("full_name"),
            "spouse_name": obj.get("spouse_name"),
            "widow_name": obj.get("widow_name"),
            "alias_name": obj.get("alias_name"),
            "gender": obj.get("gender"),
            "date_of_birth": obj.get("date_of_birth"),
            "date_of_expiry": obj.get("date_of_expiry"),
            "expiry_date": obj.get("expiry_date"),
            "nationality": obj.get("nationality"),
            "mrz_line_1": obj.get("mrz_line_1"),
            "mrz_line_2": obj.get("mrz_line_2"),
            "mrz_line_3": obj.get("mrz_line_3"),
            "address_1": obj.get("address_1"),
            "address_2": obj.get("address_2"),
            "address_3": obj.get("address_3"),
            "address_4": obj.get("address_4"),
            "address_5": obj.get("address_5"),
            "issuing_authority": obj.get("issuing_authority"),
            "issuing_country": obj.get("issuing_country"),
            "document_type": obj.get("document_type"),
            "place_of_birth": obj.get("place_of_birth"),
            "issuing_state": obj.get("issuing_state"),
            "issuing_date": obj.get("issuing_date"),
            "personal_number": obj.get("personal_number")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


