# coding: utf-8

"""
    Onfido API v3.6

    The Onfido API (v3.6)

    The version of the OpenAPI document: v3.6
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict
from typing import Any, ClassVar, Dict, List, Optional
from onfido.models.report_configuration_facial_similarity import ReportConfigurationFacialSimilarity
from typing import Optional, Set
from typing_extensions import Self

class ReportConfiguration(BaseModel):
    """
    Defines configuration options for facial similarity checks used to distinguish between onboarding and reverification scenarios. 
    """ # noqa: E501
    facial_similarity_photo: Optional[ReportConfigurationFacialSimilarity] = None
    facial_similarity_photo_fully_auto: Optional[ReportConfigurationFacialSimilarity] = None
    facial_similarity_video: Optional[ReportConfigurationFacialSimilarity] = None
    facial_similarity_motion: Optional[ReportConfigurationFacialSimilarity] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["facial_similarity_photo", "facial_similarity_photo_fully_auto", "facial_similarity_video", "facial_similarity_motion"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ReportConfiguration from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of facial_similarity_photo
        if self.facial_similarity_photo:
            _dict['facial_similarity_photo'] = self.facial_similarity_photo.to_dict()
        # override the default output from pydantic by calling `to_dict()` of facial_similarity_photo_fully_auto
        if self.facial_similarity_photo_fully_auto:
            _dict['facial_similarity_photo_fully_auto'] = self.facial_similarity_photo_fully_auto.to_dict()
        # override the default output from pydantic by calling `to_dict()` of facial_similarity_video
        if self.facial_similarity_video:
            _dict['facial_similarity_video'] = self.facial_similarity_video.to_dict()
        # override the default output from pydantic by calling `to_dict()` of facial_similarity_motion
        if self.facial_similarity_motion:
            _dict['facial_similarity_motion'] = self.facial_similarity_motion.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ReportConfiguration from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "facial_similarity_photo": ReportConfigurationFacialSimilarity.from_dict(obj["facial_similarity_photo"]) if obj.get("facial_similarity_photo") is not None else None,
            "facial_similarity_photo_fully_auto": ReportConfigurationFacialSimilarity.from_dict(obj["facial_similarity_photo_fully_auto"]) if obj.get("facial_similarity_photo_fully_auto") is not None else None,
            "facial_similarity_video": ReportConfigurationFacialSimilarity.from_dict(obj["facial_similarity_video"]) if obj.get("facial_similarity_video") is not None else None,
            "facial_similarity_motion": ReportConfigurationFacialSimilarity.from_dict(obj["facial_similarity_motion"]) if obj.get("facial_similarity_motion") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


