# coding: utf-8

"""
    Onfido API v3.6

    The Onfido API (v3.6)

    The version of the OpenAPI document: v3.6
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import date
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class UsDrivingLicenceShared(BaseModel):
    """
    An object that contains all accepted fields for the Driver's License Data Verification report.
    """ # noqa: E501
    id_number: StrictStr = Field(description="Driving licence ID number")
    issue_state: Annotated[str, Field(strict=True)] = Field(description="Two letter code of issuing state (state-issued driving licenses only)")
    address_line_1: Optional[StrictStr] = Field(default=None, description="Line 1 of the address")
    address_line_2: Optional[StrictStr] = Field(default=None, description="Line 2 of the address")
    city: Optional[StrictStr] = Field(default=None, description="The city of the owner's address")
    date_of_birth: Optional[date] = Field(default=None, description="Date of birth in yyyy-mm-dd format")
    document_category: Optional[StrictStr] = Field(default=None, description="Document category.")
    expiration_date: Optional[date] = Field(default=None, description="Expiration date of the driving licence in yyyy-mm-dd format")
    eye_color_code: Optional[StrictStr] = Field(default=None, description="Eye color code.")
    first_name: Optional[StrictStr] = Field(default=None, description="The owner's first name")
    gender: Optional[StrictStr] = None
    issue_date: Optional[date] = Field(default=None, description="Issue date in yyyy-mm-dd format")
    last_name: Optional[StrictStr] = Field(default=None, description="The owner's surname")
    middle_name: Optional[StrictStr] = Field(default=None, description="The owner's middle name")
    name_suffix: Optional[StrictStr] = Field(default=None, description="The owner's name suffix")
    postal_code: Optional[StrictStr] = Field(default=None, description="The postcode or ZIP of the owner's address")
    state: Optional[Annotated[str, Field(strict=True)]] = Field(default=None, description="2-characters state code")
    weight_measure: Optional[StrictInt] = Field(default=None, description="Weight in pounds")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id_number", "issue_state", "address_line_1", "address_line_2", "city", "date_of_birth", "document_category", "expiration_date", "eye_color_code", "first_name", "gender", "issue_date", "last_name", "middle_name", "name_suffix", "postal_code", "state", "weight_measure"]

    @field_validator('issue_state')
    def issue_state_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^[A-Z]{2}$", value):
            raise ValueError(r"must validate the regular expression /^[A-Z]{2}$/")
        return value

    @field_validator('document_category')
    def document_category_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['driver license', 'driver permit', 'id card', 'unknown_default_open_api']):
            raise ValueError("must be one of enum values ('driver license', 'driver permit', 'id card', 'unknown_default_open_api')")
        return value

    @field_validator('eye_color_code')
    def eye_color_code_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['BLK', 'BLU', 'BRO', 'DIC', 'GRY', 'GRN', 'HAZ', 'MAR', 'PNK', 'unknown_default_open_api']):
            raise ValueError("must be one of enum values ('BLK', 'BLU', 'BRO', 'DIC', 'GRY', 'GRN', 'HAZ', 'MAR', 'PNK', 'unknown_default_open_api')")
        return value

    @field_validator('gender')
    def gender_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['Male', 'Female', 'unknown_default_open_api']):
            raise ValueError("must be one of enum values ('Male', 'Female', 'unknown_default_open_api')")
        return value

    @field_validator('state')
    def state_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[A-Z]{2}$", value):
            raise ValueError(r"must validate the regular expression /^[A-Z]{2}$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UsDrivingLicenceShared from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "gender",
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UsDrivingLicenceShared from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id_number": obj.get("id_number"),
            "issue_state": obj.get("issue_state"),
            "address_line_1": obj.get("address_line_1"),
            "address_line_2": obj.get("address_line_2"),
            "city": obj.get("city"),
            "date_of_birth": obj.get("date_of_birth"),
            "document_category": obj.get("document_category"),
            "expiration_date": obj.get("expiration_date"),
            "eye_color_code": obj.get("eye_color_code"),
            "first_name": obj.get("first_name"),
            "gender": obj.get("gender"),
            "issue_date": obj.get("issue_date"),
            "last_name": obj.get("last_name"),
            "middle_name": obj.get("middle_name"),
            "name_suffix": obj.get("name_suffix"),
            "postal_code": obj.get("postal_code"),
            "state": obj.get("state"),
            "weight_measure": obj.get("weight_measure")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


