# generated by datamodel-codegen:
#   filename:  openapi.json
#   timestamp: 2025-03-21T21:21:27+00:00

from __future__ import annotations

from datetime import datetime
from enum import Enum
from typing import Any, Dict, List, Literal, Optional, Union

from pydantic import BaseModel, ConfigDict, Field, RootModel, constr

from .. import (
    EnvScopedObjectReference,
    GlobalObjectReference,
    ObjectReference,
    TypedEnvScopedObjectReference,
)
from ..ListMeta import ListMeta
from ..ObjectMeta import ObjectMeta


class ApiVersion(Enum):
    networking_v1 = 'networking/v1'


class Kind(Enum):
    network = 'Network'


class Metadata(ObjectMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None, examples=['https://api.confluent.cloud/networking/v1/networks/n-12345']
    )
    resource_name: Optional[Any] = Field(
        None,
        examples=[
            'crn://confluent.cloud/organization=9bb441c4-edef-46ac-8a41-c49e44a3fd9a/environment=env-abc123/network=n-12345'
        ],
    )


class Kind1Model(Enum):
    peering = 'Peering'


class Metadata1Model(ObjectMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None, examples=['https://api.confluent.cloud/networking/v1/peerings/p-12345']
    )
    resource_name: Optional[Any] = Field(
        None,
        examples=[
            'crn://confluent.cloud/organization=9bb441c4-edef-46ac-8a41-c49e44a3fd9a/environment=env-abc123/network=n-456xyz/peering=p-12345'
        ],
    )


class PeeringStatus(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    phase: str = Field(
        ...,
        description='The lifecycle phase of the peering:\n\n  PROVISIONING: peering provisioning is in progress;\n\n  PENDING_ACCEPT: peering connection request is pending acceptance by the customer;\n\n  READY:  peering is ready;\n\n  FAILED: peering is in a failed state;\n\n  DEPROVISIONING: peering deprovisioning is in progress;\n\n  DISCONNECTED: peering has been disconnected in the cloud provider by the customer;\n',
        examples=['READY'],
    )
    error_code: Optional[str] = Field(
        None,
        description='Error code if peering is in a failed state. May be used for programmatic error checking.',
    )
    error_message: Optional[str] = Field(
        None, description='Displayable error message if peering is in a failed state'
    )


class Kind1Model1(Enum):
    transit_gateway_attachment = 'TransitGatewayAttachment'


class Metadata1Model1(ObjectMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/networking/v1/transit-gateway-attachments/tga-12345'
        ],
    )
    resource_name: Optional[Any] = Field(
        None,
        examples=[
            'crn://confluent.cloud/organization=9bb441c4-edef-46ac-8a41-c49e44a3fd9a/environment=env-abc123/network=n-456xyz/transit-gateway-attachment=tga-12345'
        ],
    )


class Kind1Model2(Enum):
    private_link_access = 'PrivateLinkAccess'


class Metadata1Model2(ObjectMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/networking/v1/private-link-accesses/pla-12345'
        ],
    )
    resource_name: Optional[Any] = Field(
        None,
        examples=[
            'crn://confluent.cloud/organization=9bb441c4-edef-46ac-8a41-c49e44a3fd9a/environment=env-abc123/network=n-456xyz/private-link-access=pla-12345'
        ],
    )


class PrivateLinkAccessStatus(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    phase: str = Field(
        ...,
        description='The lifecycle phase of the PrivateLink access configuration:\n\n  PROVISIONING: PrivateLink access provisioning is in progress;\n\n  READY:  PrivateLink access is ready;\n\n  FAILED: PrivateLink access is in a failed state;\n\n  DEPROVISIONING: PrivateLink access deprovisioning is in progress;\n',
        examples=['READY'],
    )
    error_code: Optional[str] = Field(
        None,
        description='Error code if PrivateLink access is in a failed state. May be used for programmatic error checking.',
    )
    error_message: Optional[str] = Field(
        None,
        description='Displayable error message if PrivateLink access is in a failed state',
    )


class Kind1Model3(Enum):
    network_link_service = 'NetworkLinkService'


class Metadata1Model3(ObjectMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/networking/v1/network-link-services/nls-12345'
        ],
    )
    resource_name: Optional[Any] = Field(
        None,
        examples=[
            'crn://confluent.cloud/organization=9bb441c4-edef-46ac-8a41-c49e44a3fd9a/environment=env-abc123/network=n-456xyz/network-link-service=nls-12345'
        ],
    )


class NetworkLinkServiceStatus(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    phase: str = Field(
        ...,
        description='The lifecycle phase of the network link service:\n\nREADY:  network link service is ready;\n',
        examples=['READY'],
    )
    error_code: Optional[str] = Field(
        None,
        description='Error code if network link service is in a failed state.\nMay be used for programmatic error checking.\n',
    )
    error_message: Optional[str] = Field(
        None,
        description='Displayable error message if network link service is in a failed state',
    )


class Kind1Model4(Enum):
    network_link_endpoint = 'NetworkLinkEndpoint'


class Metadata1Model4(ObjectMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/networking/v1/network-link-endpoints/nle-12345'
        ],
    )
    resource_name: Optional[Any] = Field(
        None,
        examples=[
            'crn://confluent.cloud/organization=9bb441c4-edef-46ac-8a41-c49e44a3fd9a/environment=env-abc123/network=n-456xyz/network-link-endpoint=nle-12345'
        ],
    )


class NetworkLinkEndpointStatus(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    phase: str = Field(
        ...,
        description='The lifecycle phase of the network link endpoint:\n\n  PROVISIONING: network link endpoint provisioning is in progress;\n\n  PENDING_ACCEPT: network link endpoint request is pending acceptance by the the owner of the target;\n\n  READY:  network link endpoint is ready;\n\n  FAILED: network link endpoint is in a failed state;\n\n  DEPROVISIONING: network link endpoint deprovisioning is in progress;\n\n  EXPIRED: network link endpoint request is expired, can only be deleted;\n\n  DISCONNECTED: network link endpoint is in a disconnected state, target owner has removed the permissions;\n\n  DISCONNECTING: network link endpoint disconnection is in progress;\n\n  INACTIVE: network link endpoint is created, but not active since there are no clusters in the network;\n',
        examples=['READY'],
    )
    error_code: Optional[str] = Field(
        None,
        description='Error code if network link is in a failed state. May be used for programmatic error checking.',
    )
    error_message: Optional[str] = Field(
        None,
        description='Displayable error message if network link is in a failed state',
    )
    expires_at: Optional[datetime] = Field(
        None,
        description='The date and time when the request expires if it is not accepted by the target network admin.',
        examples=['2024-01-01T00:00:00Z'],
    )


class Kind1Model5(Enum):
    network_link_service_association = 'NetworkLinkServiceAssociation'


class Metadata1Model5(ObjectMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/networking/v1/network-link-service-associations/nlsa-12345'
        ],
    )
    resource_name: Optional[Any] = Field(
        None,
        examples=[
            'crn://confluent.cloud/organization=9bb441c4-edef-46ac-8a41-c49e44a3fd9a/environment=env-abc123/network=n-456xyz/network-link-service=nls-12345/network-link-endpoint=nle-12345'
        ],
    )


class NetworkLinkServiceAssociationStatus(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    phase: str = Field(
        ...,
        description='The lifecycle phase of the network link endpoint:\n\n  PROVISIONING: network link endpoint provisioning is in progress;\n\n  PENDING_ACCEPT: network link endpoint request is pending acceptance by the the owner of the target;\n\n  READY:  network link endpoint is ready;\n\n  FAILED: network link endpoint is in a failed state;\n\n  DEPROVISIONING: network link endpoint deprovisioning is in progress;\n\n  EXPIRED: network link endpoint request is expired, can only be deleted;\n\n  DISCONNECTED: network link endpoint is in a disconnected state, target owner has removed the permissions;\n\n  DISCONNECTING: network link endpoint disconnection is in progress;\n\n  INACTIVE: network link endpoint is created, but not active since there are no clusters in the network;\n',
        examples=['READY'],
    )
    error_code: Optional[str] = Field(
        None,
        description='Error code if network link is in a failed state. May be used for programmatic error checking.',
    )
    error_message: Optional[str] = Field(
        None,
        description='Displayable error message if network link is in a failed state',
    )
    expires_at: Optional[datetime] = Field(
        None,
        description='The date and time when the request expires if it is not accepted by the target network admin.',
        examples=['2024-01-01T00:00:00Z'],
    )


class Cidr(RootModel[constr(pattern=r'^\d+\.\d+\.\d+\.\d+/\d+$')]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: constr(pattern=r'^\d+\.\d+\.\d+\.\d+/\d+$') = Field(
        ..., description='IPv4 CIDR block', examples=['10.200.0.0/16']
    )


class ConnectionType(RootModel[str]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: str = Field(
        ..., description='Network connection type.', examples=['PRIVATELINK']
    )


class DnsConfig(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    resolution: str = Field(..., description='Network DNS resolution type.')


class Kind1Model6(Enum):
    aws_network = 'AwsNetwork'


class AwsNetwork(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    kind: Literal['AwsNetwork'] = Field(..., description='Network kind type.')
    vpc: str = Field(
        ...,
        description='The Confluent Cloud VPC ID.',
        examples=['vpc-00000000000000000'],
    )
    account: str = Field(
        ...,
        description='The AWS account ID associated with the Confluent Cloud VPC.',
        examples=['000000000000'],
    )
    private_link_endpoint_service: Optional[str] = Field(
        None,
        description='The endpoint service of the Confluent Cloud VPC. (used for PrivateLink) if available.',
        examples=['com.amazonaws.vpce.eu-west-3.vpce-00000000000000000'],
    )


class Kind1Model7(Enum):
    gcp_network = 'GcpNetwork'


class GcpNetwork(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    kind: Literal['GcpNetwork'] = Field(..., description='Network kind type.')
    project: str = Field(
        ...,
        description='The GCP Project ID associated with the Confluent Cloud VPC.',
        examples=['cc-prod-3'],
    )
    vpc_network: str = Field(
        ...,
        description='The network name of the Confluent Cloud VPC.',
        examples=['prod-network'],
    )
    private_service_connect_service_attachments: Optional[Dict[str, str]] = Field(
        None,
        description='The mapping of zones to Private Service Connect Service\nAttachments if available. Keys are zones and values are\n[GCP Private Service Connect Service\nAttachment](https://cloud.google.com/vpc/docs/configure-private-service-connect-producer#api_7)\n',
        examples=[
            {
                'us-central1-a': 'projects/cc-prod/regions/us-central1/serviceAttachments/s-7jjm9-service-attachment-us-central1-a',
                'us-central1-b': 'projects/cc-prod/regions/us-central1/serviceAttachments/s-7jjm9-service-attachment-us-central1-b',
                'us-central1-c': 'projects/cc-prod/regions/us-central1/serviceAttachments/s-7jjm9-service-attachment-us-central1-c',
            }
        ],
    )


class Kind1Model8(Enum):
    azure_network = 'AzureNetwork'


class AzureNetwork(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    kind: Literal['AzureNetwork'] = Field(..., description='Network kind type.')
    vnet: str = Field(
        ...,
        description='The resource ID of the Confluent Cloud VNet.',
        examples=[
            '/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/prod-group/providers/Microsoft.Network/virtualNetworks/prod-network'
        ],
    )
    subscription: str = Field(
        ...,
        description='The Azure Subscription ID associated with the Confluent Cloud VPC.',
        examples=['00000000-0000-0000-0000-000000000000'],
    )
    private_link_service_aliases: Optional[Dict[str, str]] = Field(
        None,
        description='The mapping of zones to Private Link Service Aliases if available. Keys are zones\nand values are [Azure Private Link Service\nAliases](https://docs.microsoft.com/en-us/azure/private-link/private-link-service-overview#share-your-service).\n',
        examples=[
            {
                '1': '0-00000-privatelink-1.00000000-0000-0000-0000-000000000000.westeurope.azure.privatelinkservice',
                '2': '0-00000-privatelink-2.00000000-0000-0000-0000-000000000000.westeurope.azure.privatelinkservice',
                '3': '0-00000-privatelink-3.00000000-0000-0000-0000-000000000000.westeurope.azure.privatelinkservice',
            }
        ],
    )
    private_link_service_resource_ids: Optional[Dict[str, str]] = Field(
        None,
        description='The mapping of zones to Private Link Service Resource IDs if available. Keys are zones\nand values are [Azure Private Link Service Resource\nIDs](https://docs.microsoft.com/en-us/azure/private-link/private-link-service-overview#share-your-service).\n',
        examples=[
            {
                '1': '/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/0-00000/providers/Microsoft.Network/privateLinkServices/0-00000-privatelink-1',
                '2': '/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/0-00000/providers/Microsoft.Network/privateLinkServices/0-00000-privatelink-2',
                '3': '/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/0-00000/providers/Microsoft.Network/privateLinkServices/0-00000-privatelink-3',
            }
        ],
    )


class Kind1Model9(Enum):
    aws_peering = 'AwsPeering'


class AwsPeering(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    kind: Literal['AwsPeering'] = Field(..., description='Peering kind type.')
    account: constr(pattern=r'^\d{12}$') = Field(
        ...,
        description='The AWS account ID associated with the VPC you are peering with Confluent Cloud network.',
        examples=['000000000000'],
    )
    vpc: constr(min_length=1) = Field(
        ...,
        description='The VPC ID you are peering with Confluent Cloud network.',
        examples=['vpc-00000000000000000'],
    )
    routes: List[Cidr] = Field(
        ...,
        description='The [CIDR blocks](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing) of the VPC you are peering\nwith Confluent Cloud network. This is used by Confluent Cloud network to route traffic back to your network.\nThe CIDR block must be a private range and cannot overlap with the Confluent Cloud CIDR block.\n',
        examples=[['10.108.16.0/21']],
    )
    customer_region: str = Field(
        ...,
        description='The region of the VPC you are peering with Confluent Cloud network.',
        examples=['us-east-1'],
    )


class Kind1Model10(Enum):
    gcp_peering = 'GcpPeering'


class GcpPeering(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    kind: Literal['GcpPeering'] = Field(
        ..., description='Peering kind type.', examples=['GcpPeering']
    )
    project: constr(min_length=1) = Field(
        ...,
        description='The Google Cloud project ID associated with the VPC that you are peering with Confluent Cloud network.\n',
        examples=['my-gcp-project'],
    )
    vpc_network: constr(min_length=1) = Field(
        ...,
        description='The name of the VPC that you are peering with Confluent Cloud network.',
        examples=['my-gcp-network'],
    )
    import_custom_routes: Optional[bool] = Field(
        False,
        description='Enable customer route import. For more information, see\n[Importing custom routes](https://cloud.google.com/vpc/docs/vpc-peering#importing-exporting-routes).\n',
        examples=[True],
    )


class Kind1Model11(Enum):
    azure_peering = 'AzurePeering'


class AzurePeering(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    kind: Literal['AzurePeering'] = Field(..., description='Peering kind type.')
    tenant: constr(min_length=1) = Field(
        ...,
        description='The Azure Tenant ID in which your Azure Subscription exists.\nRepresents an organization in Azure Active Directory. You can find your Azure Tenant ID in the Azure Portal\nunder\n[Azure Active Directory](https://portal.azure.com/#blade/Microsoft_AAD_IAM/ActiveDirectoryMenuBlade/Overview).\nMust be a valid **32 character UUID string**.\n',
    )
    vnet: constr(min_length=1) = Field(
        ...,
        description='The resource ID of the VNet that you are peering with Confluent Cloud. You can find the name of your Azure VNet in the [Azure Portal on the Overview tab of your Azure Virtual Network](https://portal.azure.com/#blade/HubsExtension/BrowseResource/resourceType/Microsoft.Network%2FvirtualNetworks).',
        examples=[
            '/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/my-rg/providers/Microsoft.Network/virtualNetworks/my-vnet'
        ],
    )
    customer_region: str = Field(
        ...,
        description='The region of the VNet you are peering with Confluent Cloud network.',
        examples=['eastus2'],
    )


class Kind1Model12(Enum):
    aws_transit_gateway_attachment = 'AwsTransitGatewayAttachment'


class AwsTransitGatewayAttachment(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    kind: Literal['AwsTransitGatewayAttachment'] = Field(
        ..., description='AWS Transit Gateway Attachment kind type.'
    )
    ram_share_arn: str = Field(
        ...,
        description='The full AWS Resource Name (ARN) for the AWS Resource Access Manager (RAM) Share of the Transit Gateways that you want Confluent Cloud to be attached to.',
        examples=[
            'arn:aws:ram:us-west-3:000000000000:resource-share/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxx'
        ],
    )
    transit_gateway_id: str = Field(
        ...,
        description='The ID of the AWS Transit Gateway that you want Confluent CLoud to be attached to.',
        examples=['tgw-xxxxxxxxxxxxxxxxx'],
    )
    routes: List[Cidr] = Field(
        ...,
        description='List of destination routes.',
        examples=[['100.64.0.0/10', '10.0.0.0/8', '192.168.0.0/16', '172.16.0.0/12']],
    )


class Kind1Model13(Enum):
    aws_transit_gateway_attachment_status = 'AwsTransitGatewayAttachmentStatus'


class AwsTransitGatewayAttachmentStatus(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    kind: Literal['AwsTransitGatewayAttachmentStatus'] = Field(
        ..., description='AWS Transit Gateway Attachment Status kind type.'
    )
    transit_gateway_attachment_id: str = Field(
        ...,
        description='The ID of the AWS Transit Gateway VPC Attachment that attaches Confluent VPC to Transit Gateway.',
        examples=['tgw-attach-xxxxx'],
    )


class Kind1Model14(Enum):
    aws_private_link_access = 'AwsPrivateLinkAccess'


class AwsPrivateLinkAccess(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    kind: Literal['AwsPrivateLinkAccess'] = Field(
        ..., description='PrivateLink kind type.'
    )
    account: constr(pattern=r'^\d{12}$') = Field(
        ...,
        description='The AWS account ID for the account containing the VPCs you want to connect from using AWS PrivateLink.\nYou can find your AWS account ID [here](https://console.aws.amazon.com/billing/home?#/account)\nunder **My Account** in your AWS Management Console. Must be a **12 character string**.\n',
        examples=['000000000000'],
    )


class Kind1Model15(Enum):
    azure_private_link_access = 'AzurePrivateLinkAccess'


class AzurePrivateLinkAccess(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    kind: Literal['AzurePrivateLinkAccess'] = Field(
        ..., description='PrivateLink kind type.'
    )
    subscription: constr(min_length=1) = Field(
        ...,
        description='The Azure subscription ID for the account containing the VNets you want to connect from using\nAzure Private Link. You can find your Azure subscription ID in the subscription section of your\n[Microsoft Azure Portal](https://portal.azure.com/#blade/Microsoft_Azure_Billing/SubscriptionsBlade).\nMust be a valid **32 character UUID string**.\n',
    )


class Kind1Model16(Enum):
    gcp_private_service_connect_access = 'GcpPrivateServiceConnectAccess'


class GcpPrivateServiceConnectAccess(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    kind: Literal['GcpPrivateServiceConnectAccess'] = Field(
        ..., description='PrivateLink kind type.'
    )
    project: constr(min_length=1) = Field(
        ...,
        description='The GCP project ID for the account containing the VPCs that you want to connect from\nusing Private Service Connect. You can find your Google Cloud Project ID under **Project ID** section of\nyour [Google Cloud Console dashboard](https://console.cloud.google.com/home/dashboard).\n',
    )


class NetworkLinkServiceAcceptPolicy(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    environments: Optional[List[str]] = Field(
        None,
        description='List of environments from which connections can be accepted.\nAll networks win the list of environment will be allowed.\n',
    )
    networks: Optional[List[str]] = Field(
        None, description='List of networks from which connections can be accepted.\n'
    )


class ZoneInfo(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    zone_id: Optional[str] = Field(
        None, description='Cloud provider zone id', examples=['use1-az3']
    )
    cidr: Optional[str] = Field(
        None,
        description='The IPv4 [CIDR block](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing) to used for this network.\nMust be a `/27`. Required for VPC peering and AWS TransitGateway.\n',
        examples=['10.20.0.0/27'],
    )


class Kind1Model17(Enum):
    network_list = 'NetworkList'


class Metadata1Model6(ListMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    first: Optional[Any] = Field(
        None, examples=['https://api.confluent.cloud/networking/v1/networks']
    )
    last: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/networking/v1/networks?page_token=bcAOehAY8F16YD84Z1wT'
        ],
    )
    prev: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/networking/v1/networks?page_token=YIXRY97wWYmwzrax4dld'
        ],
    )
    next: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/networking/v1/networks?page_token=UvmDWOB1iwfAIBPj6EYb'
        ],
    )


class NetworkSpec(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    display_name: Optional[str] = Field(
        None, description='The name of the network', examples=['prod-aws-us-east1']
    )
    cloud: Optional[str] = Field(
        None,
        description='The cloud service provider in which the network exists.',
        examples=['AWS'],
    )
    region: Optional[str] = Field(
        None,
        description='The cloud service provider region in which the network exists.',
        examples=['us-east-1'],
    )
    connection_types: Optional[List[ConnectionType]] = Field(
        None,
        description='The connection types requested for use with the network.',
        min_length=1,
    )
    cidr: Optional[constr(pattern=r'^\d+\.\d+\.\d+\.\d+/\d+$')] = Field(
        None,
        description='The IPv4 [CIDR block](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing) to used for this network.\nMust be `/16`. Required for VPC peering and AWS TransitGateway.\n',
        examples=['10.200.0.0/16'],
    )
    zones: Optional[List[str]] = Field(
        None,
        description='The 3 availability zones for this network. They can optionally be specified for AWS networks\nused with PrivateLink, for GCP networks used with Private Service Connect, and for AWS and GCP\nnetworks used with Peering.\nOtherwise, they are automatically chosen by Confluent Cloud.\n\nOn AWS, zones are AWS [AZ IDs](https://docs.aws.amazon.com/ram/latest/userguide/working-with-az-ids.html)\n (e.g. use1-az3)\n\nOn GCP, zones are GCP [zones](https://cloud.google.com/compute/docs/regions-zones)\n (e.g. us-central1-c).\n\nOn Azure, zones are Confluent-chosen names (e.g. 1, 2, 3) since Azure does not\n have universal zone identifiers.\n',
        examples=[['use1-az1', 'use1-az2', 'use1-az3']],
        max_length=3,
        min_length=3,
    )
    zones_info: Optional[List[ZoneInfo]] = Field(
        None,
        description='Each item represents information related to a single zone.\n\nNote - The attribute is in a [Limited Availability lifecycle stage](https://docs.confluent.io/cloud/current/api.html#section/Versioning/API-Lifecycle-Policy)\n',
        max_length=3,
        min_length=3,
    )
    dns_config: Optional[DnsConfig] = Field(
        None,
        description='DNS config only applies to PrivateLink network connection type.\n\nWhen resolution is CHASED_PRIVATE, clusters in this network require both public and private DNS\n to resolve cluster endpoints.\n\nWhen resolution is PRIVATE, clusters in this network only require private DNS\n to resolve cluster endpoints.\n',
    )
    reserved_cidr: Optional[str] = Field(
        None,
        description='The reserved CIDR config is used only by AWS networks with connection_types = Vpc_Peering or Transit_Gateway\n\nAn IPv4 [CIDR](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)\n  reserved for Confluent Cloud Network. Must be \\24.\n  If not specified, Confluent Cloud Network uses 172.20.255.0/24\n\nNote - The attribute is in a [Limited Availability lifecycle stage](https://docs.confluent.io/cloud/current/api.html#section/Versioning/API-Lifecycle-Policy)\n',
        examples=['172.20.255.0/24'],
    )
    environment: Optional[ObjectReference] = Field(
        None, description='The environment to which this belongs.'
    )
    gateway: Optional[TypedEnvScopedObjectReference] = Field(
        None,
        description='The gateway associated with this object. The gateway can be one of networking.v1.Gateway. May be `null` or omitted if not associated with a gateway.',
    )


class Kind1Model18(Enum):
    peering_list = 'PeeringList'


class Metadata1Model7(ListMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    first: Optional[Any] = Field(
        None, examples=['https://api.confluent.cloud/networking/v1/peerings']
    )
    last: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/networking/v1/peerings?page_token=bcAOehAY8F16YD84Z1wT'
        ],
    )
    prev: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/networking/v1/peerings?page_token=YIXRY97wWYmwzrax4dld'
        ],
    )
    next: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/networking/v1/peerings?page_token=UvmDWOB1iwfAIBPj6EYb'
        ],
    )


class PeeringSpec(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    display_name: Optional[str] = Field(
        None, description='The name of the peering', examples=['prod-peering-use1']
    )
    cloud: Optional[Union[AwsPeering, GcpPeering, AzurePeering]] = Field(
        None, description='The cloud-specific peering details.', discriminator='kind'
    )
    environment: Optional[ObjectReference] = Field(
        None, description='The environment to which this belongs.'
    )
    network: Optional[ObjectReference] = Field(
        None, description='The network to which this belongs.'
    )


class Kind1Model19(Enum):
    transit_gateway_attachment_list = 'TransitGatewayAttachmentList'


class Metadata1Model8(ListMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    first: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/networking/v1/transit-gateway-attachments'
        ],
    )
    last: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/networking/v1/transit-gateway-attachments?page_token=bcAOehAY8F16YD84Z1wT'
        ],
    )
    prev: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/networking/v1/transit-gateway-attachments?page_token=YIXRY97wWYmwzrax4dld'
        ],
    )
    next: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/networking/v1/transit-gateway-attachments?page_token=UvmDWOB1iwfAIBPj6EYb'
        ],
    )


class TransitGatewayAttachmentSpec(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    display_name: Optional[str] = Field(
        None, description='The name of the TGW attachment', examples=['prod-tgw-use1']
    )
    cloud: Optional[AwsTransitGatewayAttachment] = Field(
        None,
        description='The cloud-specific Transit Gateway details.',
        discriminator='kind',
    )
    environment: Optional[ObjectReference] = Field(
        None, description='The environment to which this belongs.'
    )
    network: Optional[ObjectReference] = Field(
        None, description='The network to which this belongs.'
    )


class Kind1Model20(Enum):
    private_link_access_list = 'PrivateLinkAccessList'


class Metadata1Model9(ListMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    first: Optional[Any] = Field(
        None,
        examples=['https://api.confluent.cloud/networking/v1/private-link-accesses'],
    )
    last: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/networking/v1/private-link-accesses?page_token=bcAOehAY8F16YD84Z1wT'
        ],
    )
    prev: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/networking/v1/private-link-accesses?page_token=YIXRY97wWYmwzrax4dld'
        ],
    )
    next: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/networking/v1/private-link-accesses?page_token=UvmDWOB1iwfAIBPj6EYb'
        ],
    )


class PrivateLinkAccessSpec(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    display_name: Optional[str] = Field(
        None,
        description='The name of the PrivateLink access',
        examples=['prod-pl-use1'],
    )
    cloud: Optional[
        Union[
            AwsPrivateLinkAccess, AzurePrivateLinkAccess, GcpPrivateServiceConnectAccess
        ]
    ] = Field(
        None,
        description='The cloud-specific PrivateLink details.',
        discriminator='kind',
    )
    environment: Optional[ObjectReference] = Field(
        None, description='The environment to which this belongs.'
    )
    network: Optional[ObjectReference] = Field(
        None, description='The network to which this belongs.'
    )


class Kind1Model21(Enum):
    network_link_service_list = 'NetworkLinkServiceList'


class Metadata1Model10(ListMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    first: Optional[Any] = Field(
        None,
        examples=['https://api.confluent.cloud/networking/v1/network-link-services'],
    )
    last: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/networking/v1/network-link-services?page_token=bcAOehAY8F16YD84Z1wT'
        ],
    )
    prev: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/networking/v1/network-link-services?page_token=YIXRY97wWYmwzrax4dld'
        ],
    )
    next: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/networking/v1/network-link-services?page_token=UvmDWOB1iwfAIBPj6EYb'
        ],
    )


class NetworkLinkServiceSpec(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    display_name: Optional[str] = Field(
        None,
        description='The name of the network link service',
        examples=['prod-net-1-nls'],
    )
    description: Optional[str] = Field(
        None,
        description='The description of the network link service',
        examples=['Allow connections from analytics hub'],
    )
    accept: Optional[NetworkLinkServiceAcceptPolicy] = Field(
        None, description='Network Link Service Accept policy'
    )
    environment: Optional[GlobalObjectReference] = Field(
        None, description='The environment to which this belongs.'
    )
    network: Optional[EnvScopedObjectReference] = Field(
        None, description='The network to which this belongs.'
    )


class Kind1Model22(Enum):
    network_link_endpoint_list = 'NetworkLinkEndpointList'


class Metadata1Model11(ListMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    first: Optional[Any] = Field(
        None,
        examples=['https://api.confluent.cloud/networking/v1/network-link-endpoints'],
    )
    last: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/networking/v1/network-link-endpoints?page_token=bcAOehAY8F16YD84Z1wT'
        ],
    )
    prev: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/networking/v1/network-link-endpoints?page_token=YIXRY97wWYmwzrax4dld'
        ],
    )
    next: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/networking/v1/network-link-endpoints?page_token=UvmDWOB1iwfAIBPj6EYb'
        ],
    )


class NetworkLinkEndpointSpec(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    display_name: Optional[str] = Field(
        None,
        description='The name of the network link endpoint',
        examples=['prod-net-1-nle'],
    )
    description: Optional[str] = Field(
        None,
        description='The description of the network link endpoint',
        examples=['Connect to Network - analytics hub'],
    )
    environment: Optional[GlobalObjectReference] = Field(
        None, description='The environment to which this belongs.'
    )
    network: Optional[EnvScopedObjectReference] = Field(
        None, description='The network to which this belongs.'
    )
    network_link_service: Optional[EnvScopedObjectReference] = Field(
        None, description='The network_link_service to which this belongs.'
    )


class Kind1Model23(Enum):
    network_link_service_association_list = 'NetworkLinkServiceAssociationList'


class Metadata1Model12(ListMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    first: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/networking/v1/network-link-service-associations'
        ],
    )
    last: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/networking/v1/network-link-service-associations?page_token=bcAOehAY8F16YD84Z1wT'
        ],
    )
    prev: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/networking/v1/network-link-service-associations?page_token=YIXRY97wWYmwzrax4dld'
        ],
    )
    next: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/networking/v1/network-link-service-associations?page_token=UvmDWOB1iwfAIBPj6EYb'
        ],
    )


class NetworkLinkServiceAssociationSpec(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    display_name: Optional[str] = Field(
        None,
        description='The name of the network link endpoint',
        examples=['prod-net-1-nle'],
    )
    description: Optional[str] = Field(
        None,
        description='The description of the network link endpoint',
        examples=['Connect to Network - analytics hub'],
    )
    network_link_endpoint: Optional[str] = Field(
        None,
        description='ID of the Network link endpoint.',
        examples=['prod-net-1-nle'],
    )
    network_link_service: Optional[EnvScopedObjectReference] = Field(
        None, description='The network_link_service to which this belongs.'
    )
    environment: Optional[GlobalObjectReference] = Field(
        None, description='The environment to which this belongs.'
    )


class Kind1Model24(Enum):
    ip_address = 'IpAddress'


class IpAddress(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[Kind1Model24] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    ip_prefix: Optional[constr(pattern=r'^\d+\.\d+\.\d+\.\d+/\d+$')] = Field(
        None, description='The IP Address range.', examples=['10.200.0.0/28']
    )
    cloud: Optional[str] = Field(
        None,
        description='The cloud service provider in which the address exists.',
        examples=['AWS'],
    )
    region: Optional[str] = Field(
        None,
        description='The region/location where the IP Address is in use.',
        examples=['us-east-1'],
    )
    services: Optional[List[str]] = Field(
        None, description='The service types that will use the address.', min_length=1
    )
    address_type: Optional[str] = Field(
        None,
        description='Whether the address is used for egress or ingress.',
        examples=['EGRESS'],
    )


class Kind1Model25(Enum):
    ip_address_list = 'IpAddressList'


class Metadata1Model13(ListMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    first: Optional[Any] = Field(
        None, examples=['https://api.confluent.cloud/networking/v1/ip-addresses']
    )
    last: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/networking/v1/ip-addresses?page_token=bcAOehAY8F16YD84Z1wT'
        ],
    )
    prev: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/networking/v1/ip-addresses?page_token=YIXRY97wWYmwzrax4dld'
        ],
    )
    next: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/networking/v1/ip-addresses?page_token=UvmDWOB1iwfAIBPj6EYb'
        ],
    )


class IpAddressList(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: ApiVersion = Field(
        ...,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Kind1Model25 = Field(
        ..., description='Kind defines the object this REST resource represents.'
    )
    metadata: Metadata1Model13
    data: List[IpAddress] = Field(
        ...,
        description='A data property that contains an array of resource items. Each entry in the array is a separate resource.',
    )


class Kind1Model26(Enum):
    private_link_attachment = 'PrivateLinkAttachment'


class Metadata1Model14(ObjectMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/networking/v1/private-link-attachments/platt-12345'
        ],
    )
    resource_name: Optional[Any] = Field(
        None,
        examples=[
            'crn://confluent.cloud/organization=9bb441c4-edef-46ac-8a41-c49e44a3fd9a/private-link-attachment=platt-12345'
        ],
    )


class Kind1Model27(Enum):
    private_link_attachment_connection = 'PrivateLinkAttachmentConnection'


class Metadata1Model15(ObjectMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/networking/v1/private-link-attachment-connections/plattc-12345'
        ],
    )
    resource_name: Optional[Any] = Field(
        None,
        examples=[
            'crn://confluent.cloud/organization=9bb441c4-edef-46ac-8a41-c49e44a3fd9a/private-link-attachment-connection=plattc-12345'
        ],
    )


class Kind1Model28(Enum):
    aws_private_link_attachment_status = 'AwsPrivateLinkAttachmentStatus'


class AwsVpcEndpointService(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    vpc_endpoint_service_name: str = Field(
        ..., description='Id of the VPC Endpoint service.'
    )


class Kind1Model29(Enum):
    azure_private_link_attachment_status = 'AzurePrivateLinkAttachmentStatus'


class AzurePrivateLinkService(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    private_link_service_alias: constr(min_length=1) = Field(
        ...,
        description='Azure PrivateLink service alias.',
        examples=[
            'pls-plt-abcdef-az3.38748da8-3322-42f7-b97a-6448c21af653.centralus.azure.privatelinkservice'
        ],
    )
    private_link_service_resource_id: constr(min_length=1) = Field(
        ...,
        description='Azure PrivateLink service resource id.',
        examples=[
            '/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/s-abcde/providers/Microsoft.Network/privateLinkServices/pls-plt-abcdef'
        ],
    )


class Kind1Model30(Enum):
    gcp_private_link_attachment_status = 'GcpPrivateLinkAttachmentStatus'


class GcpPscServiceAttachment(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    zone: constr(min_length=1) = Field(
        ...,
        description='Zone associated with the PSC Service attachment.',
        examples=['us-central1-a'],
    )
    private_service_connect_service_attachment: constr(min_length=1) = Field(
        ...,
        description='Id of a Private Service Connect Service Attachment in Confluent Cloud.',
        examples=[
            'projects/example-project/regions/us-central1/serviceAttachments/plt-abcdef-service-attachment-us-central1-a'
        ],
    )


class Kind1Model31(Enum):
    aws_private_link_attachment_connection_status = (
        'AwsPrivateLinkAttachmentConnectionStatus'
    )


class AwsPrivateLinkAttachmentConnectionStatus(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    kind: Literal['AwsPrivateLinkAttachmentConnectionStatus'] = Field(
        ..., description='PrivateLinkAttachmentConnectionStatus kind.'
    )
    vpc_endpoint_service_name: constr(min_length=1) = Field(
        ...,
        description='Id of the VPC Endpoint service used for PrivateLink.',
        examples=['com.amazonaws.vpce.us-west-2.vpce-svc-00000000000000000'],
    )
    vpc_endpoint_id: constr(min_length=1) = Field(
        ...,
        description='Id of the VPC Endpoint (if any) that is connected to the VPC Endpoint service.',
        examples=['vpce-00000000000000000'],
    )


class Kind1Model32(Enum):
    azure_private_link_attachment_connection_status = (
        'AzurePrivateLinkAttachmentConnectionStatus'
    )


class AzurePrivateLinkAttachmentConnectionStatus(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    kind: Literal['AzurePrivateLinkAttachmentConnectionStatus'] = Field(
        ..., description='PrivateLinkAttachmentConnectionStatus kind.'
    )
    zone: constr(min_length=1) = Field(
        ...,
        description='Availability zone associated with the Azure PrivateLink service.',
        examples=['1'],
    )
    private_link_service_alias: constr(min_length=1) = Field(
        ...,
        description='Azure PrivateLink service alias for the availability zone.',
        examples=[
            'pls-plt-abcdef-az3.38748da8-3322-42f7-b97a-6448c21af653.centralus.azure.privatelinkservice'
        ],
    )
    private_link_service_resource_id: constr(min_length=1) = Field(
        ...,
        description='Azure PrivateLink service resource id for the availability zone.',
        examples=[
            '/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/s-abcde/providers/Microsoft.Network/privateLinkServices/pls-plt-abcdef-az3'
        ],
    )
    private_endpoint_resource_id: constr(min_length=1) = Field(
        ...,
        description='Resource Id of the PrivateEndpoint (if any) that is connected to\nthe PrivateLink service for this availability zone.\n',
        examples=[
            '/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/testvpc/providers/Microsoft.Network/privateEndpoints/pe-plt-abcdef-az3'
        ],
    )


class Kind1Model33(Enum):
    gcp_private_link_attachment_connection_status = (
        'GcpPrivateLinkAttachmentConnectionStatus'
    )


class GcpPrivateLinkAttachmentConnectionStatus(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    kind: Literal['GcpPrivateLinkAttachmentConnectionStatus'] = Field(
        ..., description='PrivateLinkAttachmentConnectionStatus kind.'
    )
    zone: constr(min_length=1) = Field(
        ...,
        description='Zone associated with the GCP PrivateLink attachment connection.',
        examples=['us-central1-a'],
    )
    private_service_connect_service_attachment: constr(min_length=1) = Field(
        ...,
        description='GCP Private Service Connect ServiceAttachment for the zone.',
        examples=[
            'projects/example-project/regions/us-central1/serviceAttachments/plt-abcdef-service-attachment-us-central1-a'
        ],
    )
    private_service_connect_connection_id: constr(min_length=1) = Field(
        ...,
        description='Id of the Private Service connection.',
        examples=['00000000000000000'],
    )


class Kind1Model34(Enum):
    aws_private_link_attachment_connection = 'AwsPrivateLinkAttachmentConnection'


class AwsPrivateLinkAttachmentConnection(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    kind: Literal['AwsPrivateLinkAttachmentConnection'] = Field(
        ..., description='PrivateLinkAttachmentConnection kind.'
    )
    vpc_endpoint_id: constr(min_length=1) = Field(
        ...,
        description='Id of a VPC Endpoint that is connected to the VPC Endpoint service.',
        examples=['vpce-00000000000000000'],
    )


class Kind1Model35(Enum):
    azure_private_link_attachment_connection = 'AzurePrivateLinkAttachmentConnection'


class AzurePrivateLinkAttachmentConnection(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    kind: Literal['AzurePrivateLinkAttachmentConnection'] = Field(
        ..., description='PrivateLinkAttachmentConnection kind.'
    )
    private_endpoint_resource_id: constr(min_length=1) = Field(
        ...,
        description='Resource Id of the PrivateEndpoint that is connected to the PrivateLink service.\n',
        examples=[
            '/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/testvpc/providers/Microsoft.Network/privateEndpoints/pe-plt-abcdef-az3'
        ],
    )


class Kind1Model36(Enum):
    gcp_private_link_attachment_connection = 'GcpPrivateLinkAttachmentConnection'


class GcpPrivateLinkAttachmentConnection(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    kind: Literal['GcpPrivateLinkAttachmentConnection'] = Field(
        ..., description='PrivateLinkAttachmentConnection kind.'
    )
    private_service_connect_connection_id: constr(min_length=1) = Field(
        ...,
        description='Id of the Private Service connection.',
        examples=['00000000000000000'],
    )


class Kind1Model37(Enum):
    private_link_attachment_list = 'PrivateLinkAttachmentList'


class Metadata1Model16(ListMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    first: Optional[Any] = Field(
        None,
        examples=['https://api.confluent.cloud/networking/v1/private-link-attachments'],
    )
    last: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/networking/v1/private-link-attachments?page_token=bcAOehAY8F16YD84Z1wT'
        ],
    )
    prev: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/networking/v1/private-link-attachments?page_token=YIXRY97wWYmwzrax4dld'
        ],
    )
    next: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/networking/v1/private-link-attachments?page_token=UvmDWOB1iwfAIBPj6EYb'
        ],
    )


class PrivateLinkAttachmentSpec(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    display_name: Optional[str] = Field(
        None,
        description='The name of the PrivateLink attachment.',
        examples=['prod-aws-us-east1'],
    )
    cloud: Optional[str] = Field(
        None,
        description='The cloud service provider that hosts the resources to access with the PrivateLink attachment.\n',
        examples=['AWS'],
    )
    region: Optional[str] = Field(
        None,
        description='The cloud service provider region where the resources to be accessed\nusing the PrivateLink attachment are located.\n',
        examples=['us-east-1'],
    )
    environment: Optional[ObjectReference] = Field(
        None, description='The environment to which this belongs.'
    )


class Kind1Model38(Enum):
    private_link_attachment_connection_list = 'PrivateLinkAttachmentConnectionList'


class Metadata1Model17(ListMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    first: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/networking/v1/private-link-attachment-connections'
        ],
    )
    last: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/networking/v1/private-link-attachment-connections?page_token=bcAOehAY8F16YD84Z1wT'
        ],
    )
    prev: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/networking/v1/private-link-attachment-connections?page_token=YIXRY97wWYmwzrax4dld'
        ],
    )
    next: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/networking/v1/private-link-attachment-connections?page_token=UvmDWOB1iwfAIBPj6EYb'
        ],
    )


class PrivateLinkAttachmentConnectionSpec(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    display_name: Optional[str] = Field(
        None,
        description='The name of the PrivateLink attachment connection.',
        examples=['prod-gcp-us-central1-a'],
    )
    cloud: Optional[
        Union[
            AwsPrivateLinkAttachmentConnection,
            AzurePrivateLinkAttachmentConnection,
            GcpPrivateLinkAttachmentConnection,
        ]
    ] = Field(
        None,
        description='The cloud-specific PrivateLink attachment connection details.',
        discriminator='kind',
    )
    environment: Optional[ObjectReference] = Field(
        None, description='The environment to which this belongs.'
    )
    private_link_attachment: Optional[ObjectReference] = Field(
        None, description='The private_link_attachment to which this belongs.'
    )


class Kind1Model39(Enum):
    dns_forwarder = 'DnsForwarder'


class Metadata1Model18(ObjectMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None,
        examples=['https://api.confluent.cloud/networking/v1/dns-forwarders/df-12345'],
    )
    resource_name: Optional[Any] = Field(
        None,
        examples=[
            'crn://confluent.cloud/organization=9bb441c4-edef-46ac-8a41-c49e44a3fd9a/environment=env-abc123/gateway=gw-456xyz/dns-forwarder=df-12345'
        ],
    )


class DnsForwarderStatus(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    phase: str = Field(
        ...,
        description="The lifecycle phase of the DNS forwarder:\n\n  PROVISIONING: DNS forwarder provisioning is in progress;\n\n  CREATED: DNS forwarder is created. It will automatically become ready once a Kafka cluster is provisioned;\n\n  READY: DNS forwarder is ready;\n\n  FAILED: DNS forwarder is in a failed state;\n\n  DEGRADED: DNS forwarder is in a degraded state, transitioning from 'READY' due to unreachable DNS resolvers;\n\n  DEPROVISIONING: DNS forwarder deprovisioning is in progress;\n",
        examples=['READY'],
    )
    error_code: Optional[str] = Field(
        None,
        description='Error code if dns forwarder is in a failed state. May be used for programmatic error checking.',
    )
    error_message: Optional[str] = Field(
        None,
        description='Displayable error message if dns forwarder is in a failed state',
    )


class Ip(RootModel[constr(pattern=r'^\d+\.\d+\.\d+\.\d+$')]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: constr(pattern=r'^\d+\.\d+\.\d+\.\d+$') = Field(
        ..., description='IPv4 Address', examples=['10.200.0.0']
    )


class Kind1Model40(Enum):
    forward_via_ip = 'ForwardViaIp'


class ForwardViaIp(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    kind: Literal['ForwardViaIp'] = Field(
        ..., description='DNS Forwarder Configured via DNS Server IPs kind type.'
    )
    dns_server_ips: List[Ip] = Field(
        ...,
        description='List of IP addresses of the DNS server',
        examples=[['10.200.0.0', '10.200.0.1']],
        max_length=3,
        min_length=1,
    )


class Kind1Model41(Enum):
    dns_forwarder_list = 'DnsForwarderList'


class Metadata1Model19(ListMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    first: Optional[Any] = Field(
        None, examples=['https://api.confluent.cloud/networking/v1/dns-forwarders']
    )
    last: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/networking/v1/dns-forwarders?page_token=bcAOehAY8F16YD84Z1wT'
        ],
    )
    prev: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/networking/v1/dns-forwarders?page_token=YIXRY97wWYmwzrax4dld'
        ],
    )
    next: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/networking/v1/dns-forwarders?page_token=UvmDWOB1iwfAIBPj6EYb'
        ],
    )


class DnsForwarderSpec(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    display_name: Optional[str] = Field(
        None, description='The name of the DNS forwarder', examples=['prod-dnsf-1']
    )
    domains: Optional[List[str]] = Field(
        None,
        description='List of domains for the DNS forwarder to use',
        examples=[['example.com', 'domainname.com']],
        max_length=10,
        min_length=0,
    )
    config: Optional[ForwardViaIp] = Field(
        None,
        description='The specific details of different kinds of configuration for DNS Forwarder.',
        discriminator='kind',
    )
    environment: Optional[ObjectReference] = Field(
        None, description='The environment to which this belongs.'
    )
    gateway: Optional[ObjectReference] = Field(
        None, description='The gateway to which this belongs.'
    )


class Kind1Model42(Enum):
    access_point = 'AccessPoint'


class Metadata1Model20(ObjectMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None,
        examples=['https://api.confluent.cloud/networking/v1/access-points/ap-12345'],
    )
    resource_name: Optional[Any] = Field(
        None,
        examples=[
            'crn://confluent.cloud/organization=9bb441c4-edef-46ac-8a41-c49e44a3fd9a/environment=env-abc123/gateway=gw-456xyz/access-point=ap-12345'
        ],
    )


class Kind1Model43(Enum):
    dns_record = 'DnsRecord'


class Metadata1Model21(ObjectMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None,
        examples=['https://api.confluent.cloud/networking/v1/dns-records/dnsrec-12345'],
    )
    resource_name: Optional[Any] = Field(
        None,
        examples=[
            'crn://confluent.cloud/organization=9bb441c4-edef-46ac-8a41-c49e44a3fd9a/environment=env-abc123/gateway=gw-456xyz/dns-record=dnsrec-12345'
        ],
    )


class DnsRecordStatus(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    phase: str = Field(
        ...,
        description='The lifecycle phase of the DNS record:\n\n  PROVISIONING: DNS record provisioning is in progress;\n\n  CREATED: DNS record is created. It will automatically become ready once a Kafka cluster is provisioned;\n\n  READY: DNS record is ready;\n\n  FAILED: DNS record is in a failed state;\n\n  DEPROVISIONING: DNS record deprovisioning is in progress;\n',
        examples=['READY'],
    )
    error_code: Optional[str] = Field(
        None,
        description='Error code if the DNS record is in a failed state. May be used for programmatic error checking.',
    )
    error_message: Optional[str] = Field(
        None,
        description='Displayable error message if the DNS record is in a failed state.',
    )


class Kind1Model44(Enum):
    aws_egress_private_link_endpoint = 'AwsEgressPrivateLinkEndpoint'


class AwsEgressPrivateLinkEndpoint(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    kind: Literal['AwsEgressPrivateLinkEndpoint'] = Field(
        ..., description='AwsEgressPrivateLinkEndpoint kind.'
    )
    vpc_endpoint_service_name: constr(min_length=1) = Field(
        ...,
        description='ID of the VPC Endpoint service used for PrivateLink.',
        examples=['com.amazonaws.vpce.us-west-2.vpce-svc-00000000000000000'],
    )
    enable_high_availability: Optional[bool] = Field(
        None,
        description='Whether a resource should be provisioned with high availability. Endpoints deployed with high availability have network interfaces deployed in multiple AZs.',
        examples=[False],
    )
    target_system: Optional[str] = Field(
        None,
        description='[Used by the Confluent Cloud Console] The target system or service that the PrivateLink Endpoint connects to (e.g. "MONGODB" or "SNOWFLAKE").',
        examples=['S3'],
    )


class Kind1Model45(Enum):
    azure_egress_private_link_endpoint = 'AzureEgressPrivateLinkEndpoint'


class AzureEgressPrivateLinkEndpoint(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    kind: Literal['AzureEgressPrivateLinkEndpoint'] = Field(
        ..., description='AzureEgressPrivateLinkEndpoint kind.'
    )
    private_link_service_resource_id: constr(min_length=1) = Field(
        ...,
        description='Resource ID of the Azure Private Link service.',
        examples=[
            '/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/s-abcde/providers/Microsoft.Network/privateLinkServices/pls-plt-abcdef-az3'
        ],
    )
    private_link_subresource_name: Optional[str] = Field(
        None,
        description='Name of the subresource for the Private Endpoint to connect to.',
        examples=['sqlServer'],
    )
    target_system: Optional[str] = Field(
        None,
        description='[Used by the Confluent Cloud Console] The target system or service that the PrivateLink Endpoint connects to (e.g. "MONGODB" or "SNOWFLAKE").',
        examples=['SNOWFLAKE'],
    )


class Kind1Model46(Enum):
    gcp_egress_private_service_connect_endpoint = (
        'GcpEgressPrivateServiceConnectEndpoint'
    )


class GcpEgressPrivateServiceConnectEndpoint(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    kind: Literal['GcpEgressPrivateServiceConnectEndpoint'] = Field(
        ..., description='GcpEgressPrivateServiceConnectEndpoint kind.'
    )
    private_service_connect_endpoint_target: constr(min_length=1) = Field(
        ...,
        description='URI of the service attachment for the published service that the Private Service Connect Endpoint connects to or "ALL_GOOGLE_APIS" for global Google APIs.',
        examples=[
            'projects/project-name/regions/us-central1/serviceAttachments/service-attachment-name'
        ],
    )
    target_system: Optional[str] = Field(
        None,
        description='[Used by the Confluent Cloud Console] The target system or service that the PrivateLink Endpoint connects to (e.g. "GCS" or "SNOWFLAKE").',
        examples=['GCS'],
    )


class Kind1Model47(Enum):
    aws_egress_private_link_endpoint_status = 'AwsEgressPrivateLinkEndpointStatus'


class AwsEgressPrivateLinkEndpointStatus(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    kind: Literal['AwsEgressPrivateLinkEndpointStatus'] = Field(
        ..., description='AwsEgressPrivateLinkEndpointStatus kind.'
    )
    vpc_endpoint_id: str = Field(
        ...,
        description='ID of a VPC Endpoint (if any) that is connected to the VPC Endpoint service.',
        examples=['vpce-00000000000000000'],
    )
    vpc_endpoint_dns_name: str = Field(
        ...,
        description='DNS name of a VPC Endpoint (if any) that is connected to the VPC Endpoint service.',
        examples=[
            'vpce-00000000000000000-00000000.vpce-svc-00000000000000000.us-west-2.vpce.amazonaws.com'
        ],
    )


class Kind1Model48(Enum):
    azure_egress_private_link_endpoint_status = 'AzureEgressPrivateLinkEndpointStatus'


class AzureEgressPrivateLinkEndpointStatus(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    kind: Literal['AzureEgressPrivateLinkEndpointStatus'] = Field(
        ..., description='AzureEgressPrivateLinkEndpointStatus kind.'
    )
    private_endpoint_resource_id: str = Field(
        ...,
        description='Resource ID of the Private Endpoint (if any) that is connected to the Private Link service.',
        examples=[
            '/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/testvpc/providers/Microsoft.Network/privateEndpoints/pe-plt-abcdef-az3'
        ],
    )
    private_endpoint_domain: Optional[str] = Field(
        None,
        description='Domain of the Private Endpoint (if any) that is connected to the Private Link service.',
        examples=['dbname.database.windows.net'],
    )
    private_endpoint_ip_address: str = Field(
        ...,
        description='IP address of the Private Endpoint (if any) that is connected to the Private Link service.',
        examples=['10.2.0.68'],
    )
    private_endpoint_custom_dns_config_domains: Optional[List[str]] = Field(
        None,
        description='Domains of the Private Endpoint (if any) based off FQDNs in Azure custom DNS configs, which are required in your private DNS setup.',
        examples=[
            ['dbname.database.windows.net', 'dbname-region.database.windows.net']
        ],
    )


class Kind1Model49(Enum):
    gcp_egress_private_service_connect_endpoint_status = (
        'GcpEgressPrivateServiceConnectEndpointStatus'
    )


class GcpEgressPrivateServiceConnectEndpointStatus(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    kind: Literal['GcpEgressPrivateServiceConnectEndpointStatus'] = Field(
        ..., description='GcpEgressPrivateServiceConnectEndpointStatus kind.'
    )
    private_service_connect_endpoint_connection_id: str = Field(
        ...,
        description='Connection ID of the Private Service Connect Endpoint (if any) that is connected to the endpoint target.',
        examples=[''],
    )
    private_service_connect_endpoint_name: str = Field(
        ...,
        description='Name of the Private Service Connect Endpoint (if any) that is connected to the endpoint target.',
        examples=['plap-123456'],
    )
    private_service_connect_endpoint_ip_address: str = Field(
        ...,
        description='IP address of the Private Service Connect Endpoint (if any) that is connected to the endpoint target.',
        examples=['10.2.0.68'],
    )


class Kind1Model50(Enum):
    private_link_access_point = 'PrivateLinkAccessPoint'


class PrivateLinkAccessPoint(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    kind: Literal['PrivateLinkAccessPoint'] = Field(
        ..., description='PrivateLinkAccessPoint kind.'
    )
    resource_id: constr(min_length=1) = Field(
        ..., description='ID of the target resource.', examples=['ap-12345']
    )


class Kind1Model51(Enum):
    aws_private_network_interface = 'AwsPrivateNetworkInterface'


class AwsPrivateNetworkInterface(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    kind: Literal['AwsPrivateNetworkInterface'] = Field(
        ..., description='AwsPrivateNetworkInterface kind.'
    )
    network_interfaces: Optional[List[str]] = Field(
        None,
        description='List of the IDs of the Elastic Network Interfaces.',
        examples=[
            [
                'eni-00000000000000000',
                'eni-00000000000000001',
                'eni-00000000000000002',
                'eni-00000000000000003',
                'eni-00000000000000004',
                'eni-00000000000000005',
                'eni-00000000000000006',
                'eni-00000000000000007',
                'eni-00000000000000008',
                'eni-00000000000000009',
                'eni-00000000000000010',
                'eni-00000000000000011',
                'eni-00000000000000012',
                'eni-00000000000000013',
                'eni-00000000000000014',
                'eni-00000000000000015',
                'eni-00000000000000016',
                'eni-00000000000000017',
                'eni-00000000000000018',
                'eni-00000000000000019',
                'eni-00000000000000020',
                'eni-00000000000000021',
                'eni-00000000000000022',
                'eni-00000000000000023',
                'eni-00000000000000024',
                'eni-00000000000000025',
                'eni-00000000000000026',
                'eni-00000000000000027',
                'eni-00000000000000028',
                'eni-00000000000000029',
                'eni-00000000000000030',
                'eni-00000000000000031',
                'eni-00000000000000032',
                'eni-00000000000000033',
                'eni-00000000000000034',
                'eni-00000000000000035',
                'eni-00000000000000036',
                'eni-00000000000000037',
                'eni-00000000000000038',
                'eni-00000000000000039',
                'eni-00000000000000040',
                'eni-00000000000000041',
                'eni-00000000000000042',
                'eni-00000000000000043',
                'eni-00000000000000044',
                'eni-00000000000000045',
                'eni-00000000000000046',
                'eni-00000000000000047',
                'eni-00000000000000048',
                'eni-00000000000000049',
                'eni-00000000000000050',
            ]
        ],
        min_length=51,
    )
    account: Optional[constr(pattern=r'^\d{12}$')] = Field(
        None,
        description='The AWS account ID associated with the ENIs you are using for the Confluent Private Network Interface.',
        examples=['000000000000'],
    )


class Kind1Model52(Enum):
    access_point_list = 'AccessPointList'


class Metadata1Model22(ListMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    first: Optional[Any] = Field(
        None, examples=['https://api.confluent.cloud/networking/v1/access-points']
    )
    last: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/networking/v1/access-points?page_token=bcAOehAY8F16YD84Z1wT'
        ],
    )
    prev: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/networking/v1/access-points?page_token=YIXRY97wWYmwzrax4dld'
        ],
    )
    next: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/networking/v1/access-points?page_token=UvmDWOB1iwfAIBPj6EYb'
        ],
    )


class AccessPointSpec(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    display_name: Optional[str] = Field(
        None,
        description='The name of the access point.',
        examples=['prod-ap-egress-usw2'],
    )
    config: Optional[
        Union[
            AwsEgressPrivateLinkEndpoint,
            AzureEgressPrivateLinkEndpoint,
            AwsPrivateNetworkInterface,
            GcpEgressPrivateServiceConnectEndpoint,
        ]
    ] = Field(
        None,
        description='The specific details of the different access point configurations.',
        discriminator='kind',
    )
    environment: Optional[ObjectReference] = Field(
        None, description='The environment to which this belongs.'
    )
    gateway: Optional[ObjectReference] = Field(
        None, description='The gateway to which this belongs.'
    )


class Kind1Model53(Enum):
    dns_record_list = 'DnsRecordList'


class Metadata1Model23(ListMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    first: Optional[Any] = Field(
        None, examples=['https://api.confluent.cloud/networking/v1/dns-records']
    )
    last: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/networking/v1/dns-records?page_token=bcAOehAY8F16YD84Z1wT'
        ],
    )
    prev: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/networking/v1/dns-records?page_token=YIXRY97wWYmwzrax4dld'
        ],
    )
    next: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/networking/v1/dns-records?page_token=UvmDWOB1iwfAIBPj6EYb'
        ],
    )


class DnsRecordSpec(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    display_name: Optional[str] = Field(
        None, description='The name of the DNS record.', examples=['prod-dnsrec-1']
    )
    domain: Optional[str] = Field(
        None,
        description='The fully qualified domain name of the DNS record.',
        examples=['example.com'],
    )
    config: Optional[PrivateLinkAccessPoint] = Field(
        None, description='The config of the DNS record.', discriminator='kind'
    )
    environment: Optional[ObjectReference] = Field(
        None, description='The environment to which this belongs.'
    )
    gateway: Optional[TypedEnvScopedObjectReference] = Field(
        None, description='The gateway to which this belongs.'
    )


class Kind1Model54(Enum):
    gateway = 'Gateway'


class Metadata1Model24(ObjectMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None, examples=['https://api.confluent.cloud/networking/v1/gateways/gw-12345']
    )
    resource_name: Optional[Any] = Field(
        None,
        examples=[
            'crn://confluent.cloud/organization=9bb441c4-edef-46ac-8a41-c49e44a3fd9a/environment=env-abc123/gateway=gw-12345'
        ],
    )


class Kind1Model55(Enum):
    aws_private_network_interface_gateway_spec = 'AwsPrivateNetworkInterfaceGatewaySpec'


class AwsPrivateNetworkInterfaceGatewaySpec(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    kind: Literal['AwsPrivateNetworkInterfaceGatewaySpec'] = Field(
        ..., description='AWS Private Network Interface Gateway Spec kind type.'
    )
    region: str = Field(
        ..., description='AWS region of the Private Network Interface Gateway.'
    )
    zones: List[str] = Field(
        ...,
        description='AWS availability zone ids of the Private Network Interface Gateway.',
    )


class Kind1Model56(Enum):
    aws_peering_gateway_spec = 'AwsPeeringGatewaySpec'


class AwsPeeringGatewaySpec(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    kind: Literal['AwsPeeringGatewaySpec'] = Field(
        ..., description='AWS Peering Gateway Spec kind type.'
    )
    region: str = Field(..., description='AWS region of the Peering Gateway.')


class Kind1Model57(Enum):
    azure_peering_gateway_spec = 'AzurePeeringGatewaySpec'


class AzurePeeringGatewaySpec(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    kind: Literal['AzurePeeringGatewaySpec'] = Field(
        ..., description='Azure Peering Gateway Spec kind type.'
    )
    region: str = Field(..., description='Azure region of the Peering Gateway.')


class Kind1Model58(Enum):
    aws_egress_private_link_gateway_spec = 'AwsEgressPrivateLinkGatewaySpec'


class AwsEgressPrivateLinkGatewaySpec(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    kind: Literal['AwsEgressPrivateLinkGatewaySpec'] = Field(
        ..., description='AWS Egress Private Link Gateway Spec kind type.'
    )
    region: str = Field(
        ..., description='AWS region of the Egress Private Link Gateway.'
    )


class Kind1Model59(Enum):
    azure_egress_private_link_gateway_spec = 'AzureEgressPrivateLinkGatewaySpec'


class AzureEgressPrivateLinkGatewaySpec(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    kind: Literal['AzureEgressPrivateLinkGatewaySpec'] = Field(
        ..., description='Azure Egress Private Link Gateway Spec kind type.'
    )
    region: str = Field(
        ..., description='Azure region of the Egress Private Link Gateway.'
    )


class Kind1Model60(Enum):
    gcp_peering_gateway_spec = 'GcpPeeringGatewaySpec'


class GcpPeeringGatewaySpec(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    kind: Literal['GcpPeeringGatewaySpec'] = Field(
        ..., description='GCP Peering Gateway Spec kind type.'
    )
    region: str = Field(..., description='GCP region of the Peering Gateway.')


class Kind1Model61(Enum):
    gcp_egress_private_service_connect_gateway_spec = (
        'GcpEgressPrivateServiceConnectGatewaySpec'
    )


class GcpEgressPrivateServiceConnectGatewaySpec(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    kind: Literal['GcpEgressPrivateServiceConnectGatewaySpec'] = Field(
        ..., description='GCP Private Service Connect Gateway Spec kind type.'
    )
    region: str = Field(
        ..., description='GCP region of the Egress Private Service Connect Gateway.'
    )


class Kind1Model62(Enum):
    aws_private_network_interface_gateway_status = (
        'AwsPrivateNetworkInterfaceGatewayStatus'
    )


class AwsPrivateNetworkInterfaceGatewayStatus(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    kind: Literal['AwsPrivateNetworkInterfaceGatewayStatus'] = Field(
        ..., description='AWS Private Network Interface Gateway Status kind type.'
    )
    account: Optional[str] = Field(
        None,
        description='The AWS account ID associated with the Private Network Interface Gateway.',
        examples=['000000000000'],
    )


class Kind1Model63(Enum):
    aws_egress_private_link_gateway_status = 'AwsEgressPrivateLinkGatewayStatus'


class AwsEgressPrivateLinkGatewayStatus(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    kind: Literal['AwsEgressPrivateLinkGatewayStatus'] = Field(
        ..., description='AWS Egress Private Link Gateway Status kind type.'
    )
    principal_arn: Optional[str] = Field(
        None,
        description='The principal ARN used by the AWS Egress Private Link Gateway.',
        examples=['arn:aws:iam::123456789012:cc-tenant-1-role'],
    )


class Kind1Model64(Enum):
    azure_egress_private_link_gateway_status = 'AzureEgressPrivateLinkGatewayStatus'


class AzureEgressPrivateLinkGatewayStatus(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    kind: Literal['AzureEgressPrivateLinkGatewayStatus'] = Field(
        ..., description='Azure Egress Private Link Gateway Status kind type.'
    )
    subscription: Optional[str] = Field(
        None,
        description='The Azure Subscription ID associated with the Confluent Cloud VPC.',
        examples=['00000000-0000-0000-0000-000000000000'],
    )


class Kind1Model65(Enum):
    gcp_peering_gateway_status = 'GcpPeeringGatewayStatus'


class GcpPeeringGatewayStatus(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    kind: Literal['GcpPeeringGatewayStatus'] = Field(
        ..., description='GCP Peering Gateway Status kind type.'
    )
    iam_principal: Optional[str] = Field(
        None,
        description='The IAM principal email used by the GCP Peering Gateway.',
        examples=['my-service-account@my-project.iam.gserviceaccount.com'],
    )


class Kind1Model66(Enum):
    gcp_egress_private_service_connect_gateway_status = (
        'GcpEgressPrivateServiceConnectGatewayStatus'
    )


class GcpEgressPrivateServiceConnectGatewayStatus(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    kind: Literal['GcpEgressPrivateServiceConnectGatewayStatus'] = Field(
        ..., description='GCP Private Service Connect Gateway Status kind type.'
    )
    project: Optional[str] = Field(
        None,
        description='The GCP project used by the GCP Private Service Connect Gateway.',
        examples=['proj-tenant-1'],
    )


class Kind1Model67(Enum):
    gateway_list = 'GatewayList'


class Metadata1Model25(ListMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    first: Optional[Any] = Field(
        None, examples=['https://api.confluent.cloud/networking/v1/gateways']
    )
    last: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/networking/v1/gateways?page_token=bcAOehAY8F16YD84Z1wT'
        ],
    )
    prev: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/networking/v1/gateways?page_token=YIXRY97wWYmwzrax4dld'
        ],
    )
    next: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/networking/v1/gateways?page_token=UvmDWOB1iwfAIBPj6EYb'
        ],
    )


class GatewaySpec(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    display_name: Optional[str] = Field(
        None, description='The name of the gateway.', examples=['prod-gateway']
    )
    config: Optional[
        Union[
            AwsEgressPrivateLinkGatewaySpec,
            AwsPrivateNetworkInterfaceGatewaySpec,
            AwsPeeringGatewaySpec,
            AzurePeeringGatewaySpec,
            AzureEgressPrivateLinkGatewaySpec,
            GcpPeeringGatewaySpec,
            GcpEgressPrivateServiceConnectGatewaySpec,
        ]
    ] = Field(
        None,
        description='Gateway type specific configuration. Please note that Peering configs are not supported in Create requests.',
        discriminator='kind',
    )
    environment: Optional[ObjectReference] = Field(
        None, description='The environment to which this belongs.'
    )


class NetworkSpecUpdate(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    display_name: Optional[str] = Field(
        None, description='The name of the network', examples=['prod-aws-us-east1']
    )
    environment: Optional[ObjectReference] = Field(
        None, description='The environment to which this belongs.'
    )
    gateway: Optional[TypedEnvScopedObjectReference] = Field(
        None,
        description='The gateway associated with this object. The gateway can be one of networking.v1.Gateway. May be `null` or omitted if not associated with a gateway.',
    )


class Kind1Model68(Enum):
    network = 'Network'


class Metadata1Model26(ObjectMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None, examples=['https://api.confluent.cloud/networking/v1/networks/n-12345']
    )
    resource_name: Optional[Any] = Field(
        None,
        examples=[
            'crn://confluent.cloud/organization=9bb441c4-edef-46ac-8a41-c49e44a3fd9a/environment=env-abc123/network=n-12345'
        ],
    )


class PeeringSpecUpdate(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    display_name: Optional[str] = Field(
        None, description='The name of the peering', examples=['prod-peering-use1']
    )
    environment: Optional[ObjectReference] = Field(
        None, description='The environment to which this belongs.'
    )


class Kind1Model69(Enum):
    peering = 'Peering'


class Metadata1Model27(ObjectMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None, examples=['https://api.confluent.cloud/networking/v1/peerings/p-12345']
    )
    resource_name: Optional[Any] = Field(
        None,
        examples=[
            'crn://confluent.cloud/organization=9bb441c4-edef-46ac-8a41-c49e44a3fd9a/environment=env-abc123/network=n-456xyz/peering=p-12345'
        ],
    )


class PeeringUpdate(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[Kind1Model69] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    id: Optional[constr(max_length=255)] = Field(
        None,
        description='ID is the "natural identifier" for an object within its scope/namespace; it is normally unique across time but not space. That is, you can assume that the ID will not be reclaimed and reused after an object is deleted ("time"); however, it may collide with IDs for other object `kinds` or objects of the same `kind` within a different scope/namespace ("space").',
        examples=['dlz-f3a90de'],
    )
    metadata: Optional[Metadata1Model27] = None
    spec: Optional[PeeringSpecUpdate] = None
    status: Optional[PeeringStatus] = None


class TransitGatewayAttachmentSpecUpdate(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    display_name: Optional[str] = Field(
        None, description='The name of the TGW attachment', examples=['prod-tgw-use1']
    )
    environment: Optional[ObjectReference] = Field(
        None, description='The environment to which this belongs.'
    )


class Kind1Model70(Enum):
    transit_gateway_attachment = 'TransitGatewayAttachment'


class Metadata1Model28(ObjectMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/networking/v1/transit-gateway-attachments/tga-12345'
        ],
    )
    resource_name: Optional[Any] = Field(
        None,
        examples=[
            'crn://confluent.cloud/organization=9bb441c4-edef-46ac-8a41-c49e44a3fd9a/environment=env-abc123/network=n-456xyz/transit-gateway-attachment=tga-12345'
        ],
    )


class PrivateLinkAccessSpecUpdate(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    display_name: Optional[str] = Field(
        None,
        description='The name of the PrivateLink access',
        examples=['prod-pl-use1'],
    )
    environment: Optional[ObjectReference] = Field(
        None, description='The environment to which this belongs.'
    )


class Kind1Model71(Enum):
    private_link_access = 'PrivateLinkAccess'


class Metadata1Model29(ObjectMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/networking/v1/private-link-accesses/pla-12345'
        ],
    )
    resource_name: Optional[Any] = Field(
        None,
        examples=[
            'crn://confluent.cloud/organization=9bb441c4-edef-46ac-8a41-c49e44a3fd9a/environment=env-abc123/network=n-456xyz/private-link-access=pla-12345'
        ],
    )


class PrivateLinkAccessUpdate(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[Kind1Model71] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    id: Optional[constr(max_length=255)] = Field(
        None,
        description='ID is the "natural identifier" for an object within its scope/namespace; it is normally unique across time but not space. That is, you can assume that the ID will not be reclaimed and reused after an object is deleted ("time"); however, it may collide with IDs for other object `kinds` or objects of the same `kind` within a different scope/namespace ("space").',
        examples=['dlz-f3a90de'],
    )
    metadata: Optional[Metadata1Model29] = None
    spec: Optional[PrivateLinkAccessSpecUpdate] = None
    status: Optional[PrivateLinkAccessStatus] = None


class NetworkLinkServiceSpecUpdate(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    display_name: Optional[str] = Field(
        None,
        description='The name of the network link service',
        examples=['prod-net-1-nls'],
    )
    description: Optional[str] = Field(
        None,
        description='The description of the network link service',
        examples=['Allow connections from analytics hub'],
    )
    accept: Optional[NetworkLinkServiceAcceptPolicy] = Field(
        None, description='Network Link Service Accept policy'
    )
    environment: Optional[GlobalObjectReference] = Field(
        None, description='The environment to which this belongs.'
    )


class Kind1Model72(Enum):
    network_link_service = 'NetworkLinkService'


class Metadata1Model30(ObjectMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/networking/v1/network-link-services/nls-12345'
        ],
    )
    resource_name: Optional[Any] = Field(
        None,
        examples=[
            'crn://confluent.cloud/organization=9bb441c4-edef-46ac-8a41-c49e44a3fd9a/environment=env-abc123/network=n-456xyz/network-link-service=nls-12345'
        ],
    )


class NetworkLinkServiceUpdate(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[Kind1Model72] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    id: Optional[constr(max_length=255)] = Field(
        None,
        description='ID is the "natural identifier" for an object within its scope/namespace; it is normally unique across time but not space. That is, you can assume that the ID will not be reclaimed and reused after an object is deleted ("time"); however, it may collide with IDs for other object `kinds` or objects of the same `kind` within a different scope/namespace ("space").',
        examples=['dlz-f3a90de'],
    )
    metadata: Optional[Metadata1Model30] = None
    spec: Optional[NetworkLinkServiceSpecUpdate] = None
    status: Optional[NetworkLinkServiceStatus] = None


class NetworkLinkEndpointSpecUpdate(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    display_name: Optional[str] = Field(
        None,
        description='The name of the network link endpoint',
        examples=['prod-net-1-nle'],
    )
    description: Optional[str] = Field(
        None,
        description='The description of the network link endpoint',
        examples=['Connect to Network - analytics hub'],
    )
    environment: Optional[GlobalObjectReference] = Field(
        None, description='The environment to which this belongs.'
    )


class Kind1Model73(Enum):
    network_link_endpoint = 'NetworkLinkEndpoint'


class Metadata1Model31(ObjectMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/networking/v1/network-link-endpoints/nle-12345'
        ],
    )
    resource_name: Optional[Any] = Field(
        None,
        examples=[
            'crn://confluent.cloud/organization=9bb441c4-edef-46ac-8a41-c49e44a3fd9a/environment=env-abc123/network=n-456xyz/network-link-endpoint=nle-12345'
        ],
    )


class NetworkLinkEndpointUpdate(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[Kind1Model73] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    id: Optional[constr(max_length=255)] = Field(
        None,
        description='ID is the "natural identifier" for an object within its scope/namespace; it is normally unique across time but not space. That is, you can assume that the ID will not be reclaimed and reused after an object is deleted ("time"); however, it may collide with IDs for other object `kinds` or objects of the same `kind` within a different scope/namespace ("space").',
        examples=['dlz-f3a90de'],
    )
    metadata: Optional[Metadata1Model31] = None
    spec: Optional[NetworkLinkEndpointSpecUpdate] = None
    status: Optional[NetworkLinkEndpointStatus] = None


class PrivateLinkAttachmentSpecUpdate(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    display_name: Optional[str] = Field(
        None,
        description='The name of the PrivateLink attachment.',
        examples=['prod-aws-us-east1'],
    )
    environment: Optional[ObjectReference] = Field(
        None, description='The environment to which this belongs.'
    )


class Kind1Model74(Enum):
    private_link_attachment = 'PrivateLinkAttachment'


class Metadata1Model32(ObjectMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/networking/v1/private-link-attachments/platt-12345'
        ],
    )
    resource_name: Optional[Any] = Field(
        None,
        examples=[
            'crn://confluent.cloud/organization=9bb441c4-edef-46ac-8a41-c49e44a3fd9a/private-link-attachment=platt-12345'
        ],
    )


class PrivateLinkAttachmentConnectionSpecUpdate(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    display_name: Optional[str] = Field(
        None,
        description='The name of the PrivateLink attachment connection.',
        examples=['prod-gcp-us-central1-a'],
    )
    environment: Optional[ObjectReference] = Field(
        None, description='The environment to which this belongs.'
    )


class Kind1Model75(Enum):
    private_link_attachment_connection = 'PrivateLinkAttachmentConnection'


class Metadata1Model33(ObjectMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/networking/v1/private-link-attachment-connections/plattc-12345'
        ],
    )
    resource_name: Optional[Any] = Field(
        None,
        examples=[
            'crn://confluent.cloud/organization=9bb441c4-edef-46ac-8a41-c49e44a3fd9a/private-link-attachment-connection=plattc-12345'
        ],
    )


class DnsForwarderSpecUpdate(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    display_name: Optional[str] = Field(
        None, description='The name of the DNS forwarder', examples=['prod-dnsf-1']
    )
    domains: Optional[List[str]] = Field(
        None,
        description='List of domains for the DNS forwarder to use',
        examples=[['example.com', 'domainname.com']],
        max_length=10,
        min_length=0,
    )
    config: Optional[ForwardViaIp] = Field(
        None,
        description='The specific details of different kinds of configuration for DNS Forwarder.',
        discriminator='kind',
    )
    environment: Optional[ObjectReference] = Field(
        None, description='The environment to which this belongs.'
    )


class Kind1Model76(Enum):
    dns_forwarder = 'DnsForwarder'


class Metadata1Model34(ObjectMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None,
        examples=['https://api.confluent.cloud/networking/v1/dns-forwarders/df-12345'],
    )
    resource_name: Optional[Any] = Field(
        None,
        examples=[
            'crn://confluent.cloud/organization=9bb441c4-edef-46ac-8a41-c49e44a3fd9a/environment=env-abc123/gateway=gw-456xyz/dns-forwarder=df-12345'
        ],
    )


class DnsForwarderUpdate(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[Kind1Model76] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    id: Optional[constr(max_length=255)] = Field(
        None,
        description='ID is the "natural identifier" for an object within its scope/namespace; it is normally unique across time but not space. That is, you can assume that the ID will not be reclaimed and reused after an object is deleted ("time"); however, it may collide with IDs for other object `kinds` or objects of the same `kind` within a different scope/namespace ("space").',
        examples=['dlz-f3a90de'],
    )
    metadata: Optional[Metadata1Model34] = None
    spec: Optional[DnsForwarderSpecUpdate] = None
    status: Optional[DnsForwarderStatus] = None


class AccessPointSpecUpdate(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    display_name: Optional[str] = Field(
        None,
        description='The name of the access point.',
        examples=['prod-ap-egress-usw2'],
    )
    config: Optional[
        Union[
            AwsEgressPrivateLinkEndpoint,
            AzureEgressPrivateLinkEndpoint,
            AwsPrivateNetworkInterface,
            GcpEgressPrivateServiceConnectEndpoint,
        ]
    ] = Field(
        None,
        description='The specific details of the different access point configurations.',
        discriminator='kind',
    )
    environment: Optional[ObjectReference] = Field(
        None, description='The environment to which this belongs.'
    )


class Kind1Model77(Enum):
    access_point = 'AccessPoint'


class Metadata1Model35(ObjectMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None,
        examples=['https://api.confluent.cloud/networking/v1/access-points/ap-12345'],
    )
    resource_name: Optional[Any] = Field(
        None,
        examples=[
            'crn://confluent.cloud/organization=9bb441c4-edef-46ac-8a41-c49e44a3fd9a/environment=env-abc123/gateway=gw-456xyz/access-point=ap-12345'
        ],
    )


class DnsRecordSpecUpdate(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    display_name: Optional[str] = Field(
        None, description='The name of the DNS record.', examples=['prod-dnsrec-1']
    )
    config: Optional[PrivateLinkAccessPoint] = Field(
        None, description='The config of the DNS record.', discriminator='kind'
    )
    environment: Optional[ObjectReference] = Field(
        None, description='The environment to which this belongs.'
    )


class Kind1Model78(Enum):
    dns_record = 'DnsRecord'


class Metadata1Model36(ObjectMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None,
        examples=['https://api.confluent.cloud/networking/v1/dns-records/dnsrec-12345'],
    )
    resource_name: Optional[Any] = Field(
        None,
        examples=[
            'crn://confluent.cloud/organization=9bb441c4-edef-46ac-8a41-c49e44a3fd9a/environment=env-abc123/gateway=gw-456xyz/dns-record=dnsrec-12345'
        ],
    )


class DnsRecordUpdate(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[Kind1Model78] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    id: Optional[constr(max_length=255)] = Field(
        None,
        description='ID is the "natural identifier" for an object within its scope/namespace; it is normally unique across time but not space. That is, you can assume that the ID will not be reclaimed and reused after an object is deleted ("time"); however, it may collide with IDs for other object `kinds` or objects of the same `kind` within a different scope/namespace ("space").',
        examples=['dlz-f3a90de'],
    )
    metadata: Optional[Metadata1Model36] = None
    spec: Optional[DnsRecordSpecUpdate] = None
    status: Optional[DnsRecordStatus] = None


class GatewaySpecUpdate(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    display_name: Optional[str] = Field(
        None, description='The name of the gateway.', examples=['prod-gateway']
    )
    environment: Optional[ObjectReference] = Field(
        None, description='The environment to which this belongs.'
    )


class Kind1Model79(Enum):
    gateway = 'Gateway'


class Metadata1Model37(ObjectMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None, examples=['https://api.confluent.cloud/networking/v1/gateways/gw-12345']
    )
    resource_name: Optional[Any] = Field(
        None,
        examples=[
            'crn://confluent.cloud/organization=9bb441c4-edef-46ac-8a41-c49e44a3fd9a/environment=env-abc123/gateway=gw-12345'
        ],
    )


class NetworkStatus(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    phase: str = Field(
        ...,
        description='The lifecyle phase of the network:\n\nPROVISIONING:  network provisioning is in progress;\n\nREADY:  network is ready;\n\nFAILED: provisioning failed;\n\nDEPROVISIONING: network deprovisioning is in progress;\n',
        examples=['READY'],
    )
    supported_connection_types: List[ConnectionType] = Field(
        ..., description='The connection types this network supports.', min_length=1
    )
    active_connection_types: List[ConnectionType] = Field(
        ...,
        description='The connection types requested for use with the network.',
        min_length=1,
    )
    error_code: Optional[str] = Field(
        None,
        description='Error code if network is in a failed state. May be used for programmatic error checking.',
        examples=['insufficient_capacity'],
    )
    error_message: Optional[str] = Field(
        None,
        description='Displayable error message if network is in a failed state',
        examples=['Could not provision cloud resources'],
    )
    dns_domain: Optional[str] = Field(
        None,
        description='The root DNS domain for the network if applicable. Present on networks that support PrivateLink.',
        examples=['00000.us-east-1.aws.glb.confluent.cloud'],
    )
    zonal_subdomains: Optional[Dict[str, str]] = Field(
        None,
        description='The DNS subdomain for each zone. Present on networks that support PrivateLink. Keys are zones and\nvalues are DNS domains.\n',
        examples=[
            {
                'use1-az1': 'use1-az1.00000.us-east-1.aws.confluent.cloud',
                'use1-az4': 'use1-az4.00000.us-east-1.aws.confluent.cloud',
                'use1-az5': 'use1-az5.00000.us-east-1.aws.confluent.cloud',
            }
        ],
    )
    cloud: Optional[Union[AwsNetwork, GcpNetwork, AzureNetwork]] = Field(
        None,
        description='The cloud-specific network details. These will be populated when the network reaches the READY state.',
        discriminator='kind',
    )
    idle_since: Optional[datetime] = Field(
        None,
        description='The date and time when the network becomes idle',
        examples=['2024-01-01T00:00:00Z'],
    )


class Peering(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[Kind1Model] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    id: Optional[constr(max_length=255)] = Field(
        None,
        description='ID is the "natural identifier" for an object within its scope/namespace; it is normally unique across time but not space. That is, you can assume that the ID will not be reclaimed and reused after an object is deleted ("time"); however, it may collide with IDs for other object `kinds` or objects of the same `kind` within a different scope/namespace ("space").',
        examples=['dlz-f3a90de'],
    )
    metadata: Optional[Metadata1Model] = None
    spec: Optional[PeeringSpec] = None
    status: Optional[PeeringStatus] = None


class TransitGatewayAttachmentStatus(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    phase: str = Field(
        ...,
        description='The lifecycle phase of the TGW attachment:\n\n  PROVISIONING: attachment provisioning is in progress;\n\n  PENDING_ACCEPT: attachment request is pending acceptance by the customer;\n\n  READY:  attachment is ready;\n\n  FAILED: attachment is in a failed state;\n\n  DEPROVISIONING: attachment deprovisioning is in progress;\n\n  DISCONNECTED: attachment was manually deleted directly in the cloud provider by the customer;\n\n  ERROR: invalid customer input during attachment creation.\n',
        examples=['READY'],
    )
    error_code: Optional[str] = Field(
        None,
        description='Error code if TGW attachment is in a failed state. May be used for programmatic error checking.',
    )
    error_message: Optional[str] = Field(
        None,
        description='Displayable error message if TGW attachment is in a failed state',
    )
    cloud: Optional[AwsTransitGatewayAttachmentStatus] = Field(
        None,
        description='The cloud-specific TGW attachment details.',
        discriminator='kind',
    )


class PrivateLinkAccess(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[Kind1Model2] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    id: Optional[constr(max_length=255)] = Field(
        None,
        description='ID is the "natural identifier" for an object within its scope/namespace; it is normally unique across time but not space. That is, you can assume that the ID will not be reclaimed and reused after an object is deleted ("time"); however, it may collide with IDs for other object `kinds` or objects of the same `kind` within a different scope/namespace ("space").',
        examples=['dlz-f3a90de'],
    )
    metadata: Optional[Metadata1Model2] = None
    spec: Optional[PrivateLinkAccessSpec] = None
    status: Optional[PrivateLinkAccessStatus] = None


class NetworkLinkService(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[Kind1Model3] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    id: Optional[constr(max_length=255)] = Field(
        None,
        description='ID is the "natural identifier" for an object within its scope/namespace; it is normally unique across time but not space. That is, you can assume that the ID will not be reclaimed and reused after an object is deleted ("time"); however, it may collide with IDs for other object `kinds` or objects of the same `kind` within a different scope/namespace ("space").',
        examples=['dlz-f3a90de'],
    )
    metadata: Optional[Metadata1Model3] = None
    spec: Optional[NetworkLinkServiceSpec] = None
    status: Optional[NetworkLinkServiceStatus] = None


class NetworkLinkEndpoint(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[Kind1Model4] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    id: Optional[constr(max_length=255)] = Field(
        None,
        description='ID is the "natural identifier" for an object within its scope/namespace; it is normally unique across time but not space. That is, you can assume that the ID will not be reclaimed and reused after an object is deleted ("time"); however, it may collide with IDs for other object `kinds` or objects of the same `kind` within a different scope/namespace ("space").',
        examples=['dlz-f3a90de'],
    )
    metadata: Optional[Metadata1Model4] = None
    spec: Optional[NetworkLinkEndpointSpec] = None
    status: Optional[NetworkLinkEndpointStatus] = None


class NetworkLinkServiceAssociation(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[Kind1Model5] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    id: Optional[constr(max_length=255)] = Field(
        None,
        description='ID is the "natural identifier" for an object within its scope/namespace; it is normally unique across time but not space. That is, you can assume that the ID will not be reclaimed and reused after an object is deleted ("time"); however, it may collide with IDs for other object `kinds` or objects of the same `kind` within a different scope/namespace ("space").',
        examples=['dlz-f3a90de'],
    )
    metadata: Optional[Metadata1Model5] = None
    spec: Optional[NetworkLinkServiceAssociationSpec] = None
    status: Optional[NetworkLinkServiceAssociationStatus] = None


class Datum(Peering):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    spec: Dict[str, Any]


class PeeringList(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: ApiVersion = Field(
        ...,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Kind1Model18 = Field(
        ..., description='Kind defines the object this REST resource represents.'
    )
    metadata: Metadata1Model7
    data: List[Datum] = Field(
        ...,
        description='A data property that contains an array of resource items. Each entry in the array is a separate resource.',
    )


class Datum1Model(PrivateLinkAccess):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    spec: Dict[str, Any]


class PrivateLinkAccessList(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: ApiVersion = Field(
        ...,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Kind1Model20 = Field(
        ..., description='Kind defines the object this REST resource represents.'
    )
    metadata: Metadata1Model9
    data: List[Datum1Model] = Field(
        ...,
        description='A data property that contains an array of resource items. Each entry in the array is a separate resource.',
    )


class Datum1Model1(NetworkLinkService):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    spec: Dict[str, Any]


class NetworkLinkServiceList(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: ApiVersion = Field(
        ...,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Kind1Model21 = Field(
        ..., description='Kind defines the object this REST resource represents.'
    )
    metadata: Metadata1Model10
    data: List[Datum1Model1] = Field(
        ...,
        description='A data property that contains an array of resource items. Each entry in the array is a separate resource.',
    )


class Datum1Model2(NetworkLinkEndpoint):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    spec: Dict[str, Any]


class NetworkLinkEndpointList(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: ApiVersion = Field(
        ...,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Kind1Model22 = Field(
        ..., description='Kind defines the object this REST resource represents.'
    )
    metadata: Metadata1Model11
    data: List[Datum1Model2] = Field(
        ...,
        description='A data property that contains an array of resource items. Each entry in the array is a separate resource.',
    )


class Datum1Model3(NetworkLinkServiceAssociation):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    spec: Dict[str, Any]


class NetworkLinkServiceAssociationList(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: ApiVersion = Field(
        ...,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Kind1Model23 = Field(
        ..., description='Kind defines the object this REST resource represents.'
    )
    metadata: Metadata1Model12
    data: List[Datum1Model3] = Field(
        ...,
        description='A data property that contains an array of resource items. Each entry in the array is a separate resource.',
    )


class PrivateLinkAttachmentConnectionStatus(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    phase: str = Field(
        ...,
        description='The lifecycle phase of the PrivateLink attachment:\n\n  PROVISIONING: PrivateLink attachment connection provisioning is in progress;\n\n  READY: PrivateLink attachment connection is ready;\n\n  FAILED: PrivateLink attachment connection is in a failed state;\n\n  DEPROVISIONING: PrivateLink attachment connection deprovisioning is in progress;\n\n  DISCONNECTED:|\n    PrivateLink attachment connection is in a disconnected state. This means the\n    private endpoint associated with this PrivateLink attachment connection has been deleted;\n',
        examples=['READY'],
    )
    error_code: Optional[str] = Field(
        None,
        description='Error code if PrivateLink attachment connection is in a failed state. May be used for programmatic error checking.',
    )
    error_message: Optional[str] = Field(
        None,
        description='Displayable error message if PrivateLink attachment connection is in a failed state.',
    )
    cloud: Optional[
        Union[
            AwsPrivateLinkAttachmentConnectionStatus,
            AzurePrivateLinkAttachmentConnectionStatus,
            GcpPrivateLinkAttachmentConnectionStatus,
        ]
    ] = Field(
        None,
        description='The cloud specific status of the PrivateLink attachment connection.',
        discriminator='kind',
    )


class AwsPrivateLinkAttachmentStatus(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    kind: Literal['AwsPrivateLinkAttachmentStatus'] = Field(
        ..., description='PrivateLinkAttachmentStatus kind.'
    )
    vpc_endpoint_service: AwsVpcEndpointService = Field(
        ...,
        description='AWS VPC Endpoint Service that can be used to establish connections for all zones.\n',
    )


class AzurePrivateLinkAttachmentStatus(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    kind: Literal['AzurePrivateLinkAttachmentStatus'] = Field(
        ..., description='PrivateLinkAttachmentStatus kind.'
    )
    private_link_service: AzurePrivateLinkService = Field(
        ...,
        description='Azure PrivateLink service that can be used to connect to a PrivateEndpoint.\n',
    )


class GcpPrivateLinkAttachmentStatus(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    kind: Literal['GcpPrivateLinkAttachmentStatus'] = Field(
        ..., description='PrivateLinkAttachmentStatus kind.'
    )
    service_attachments: List[GcpPscServiceAttachment] = Field(
        ...,
        description='Array of GCP PSC Service attachments that can be used to connect\nPSC Endpoints for each zone.\n',
    )


class DnsForwarder(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[Kind1Model39] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    id: Optional[constr(max_length=255)] = Field(
        None,
        description='ID is the "natural identifier" for an object within its scope/namespace; it is normally unique across time but not space. That is, you can assume that the ID will not be reclaimed and reused after an object is deleted ("time"); however, it may collide with IDs for other object `kinds` or objects of the same `kind` within a different scope/namespace ("space").',
        examples=['dlz-f3a90de'],
    )
    metadata: Optional[Metadata1Model18] = None
    spec: Optional[DnsForwarderSpec] = None
    status: Optional[DnsForwarderStatus] = None


class Datum1Model4(DnsForwarder):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    spec: Dict[str, Any]


class DnsForwarderList(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: ApiVersion = Field(
        ...,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Kind1Model41 = Field(
        ..., description='Kind defines the object this REST resource represents.'
    )
    metadata: Metadata1Model19
    data: List[Datum1Model4] = Field(
        ...,
        description='A data property that contains an array of resource items. Each entry in the array is a separate resource.',
    )


class AccessPointStatus(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    phase: str = Field(
        ...,
        description='The lifecycle phase of the access point:\n\n  PROVISIONING: Access point provisioning is in progress;\n\n  PENDING_ACCEPT: Access point connection request is pending acceptance by the customer;\n\n  READY:  Access point is ready;\n\n  FAILED: Access point is in a failed state;\n\n  DEPROVISIONING: Access point deprovisioning is in progress;\n\n  DISCONNECTED: Access Point has been disconnected in the cloud provider by the customer;\n\n  DEGRADED: Access Point is experiencing reduced performance or partial failure;\n\n  ERROR: Invalid customer input during Access Point creation;\n',
        examples=['READY'],
    )
    error_code: Optional[str] = Field(
        None,
        description='Error code if access point is in a failed state. May be used for programmatic error checking.',
    )
    error_message: Optional[str] = Field(
        None,
        description='Displayable error message if access point is in a failed state.',
    )
    config: Optional[
        Union[
            AwsEgressPrivateLinkEndpointStatus,
            AzureEgressPrivateLinkEndpointStatus,
            GcpEgressPrivateServiceConnectEndpointStatus,
        ]
    ] = Field(
        None,
        description='Cloud specific status of the access point.',
        discriminator='kind',
    )


class DnsRecord(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[Kind1Model43] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    id: Optional[constr(max_length=255)] = Field(
        None,
        description='ID is the "natural identifier" for an object within its scope/namespace; it is normally unique across time but not space. That is, you can assume that the ID will not be reclaimed and reused after an object is deleted ("time"); however, it may collide with IDs for other object `kinds` or objects of the same `kind` within a different scope/namespace ("space").',
        examples=['dlz-f3a90de'],
    )
    metadata: Optional[Metadata1Model21] = None
    spec: Optional[DnsRecordSpec] = None
    status: Optional[DnsRecordStatus] = None


class Datum1Model5(DnsRecord):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    spec: Dict[str, Any]


class DnsRecordList(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: ApiVersion = Field(
        ...,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Kind1Model53 = Field(
        ..., description='Kind defines the object this REST resource represents.'
    )
    metadata: Metadata1Model23
    data: List[Datum1Model5] = Field(
        ...,
        description='A data property that contains an array of resource items. Each entry in the array is a separate resource.',
    )


class GatewayStatus(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    phase: str = Field(
        ...,
        description='The lifecycle phase of the gateway:\n\n  CREATED: gateway exists without an Access Point.\n\n  PROVISIONING: gateway provisioning is in progress;\n\n  READY:  gateway is ready;\n\n  FAILED: gateway is in a failed state;\n\n  DEPROVISIONING: gateway deprovisioning is in progress;\n',
        examples=['READY'],
    )
    error_code: Optional[str] = Field(
        None,
        description='Error code if gateway is in a failed state. May be used for programmatic error checking.',
    )
    error_message: Optional[str] = Field(
        None, description='Displayable error message if gateway is in a failed state'
    )
    cloud_gateway: Optional[
        Union[
            AwsEgressPrivateLinkGatewayStatus,
            AwsPrivateNetworkInterfaceGatewayStatus,
            AzureEgressPrivateLinkGatewayStatus,
            GcpPeeringGatewayStatus,
            GcpEgressPrivateServiceConnectGatewayStatus,
        ]
    ] = Field(None, description='Gateway type specific status.', discriminator='kind')


class NetworkUpdate(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[Kind1Model68] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    id: Optional[constr(max_length=255)] = Field(
        None,
        description='ID is the "natural identifier" for an object within its scope/namespace; it is normally unique across time but not space. That is, you can assume that the ID will not be reclaimed and reused after an object is deleted ("time"); however, it may collide with IDs for other object `kinds` or objects of the same `kind` within a different scope/namespace ("space").',
        examples=['dlz-f3a90de'],
    )
    metadata: Optional[Metadata1Model26] = None
    spec: Optional[NetworkSpecUpdate] = None
    status: Optional[NetworkStatus] = None


class TransitGatewayAttachmentUpdate(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[Kind1Model70] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    id: Optional[constr(max_length=255)] = Field(
        None,
        description='ID is the "natural identifier" for an object within its scope/namespace; it is normally unique across time but not space. That is, you can assume that the ID will not be reclaimed and reused after an object is deleted ("time"); however, it may collide with IDs for other object `kinds` or objects of the same `kind` within a different scope/namespace ("space").',
        examples=['dlz-f3a90de'],
    )
    metadata: Optional[Metadata1Model28] = None
    spec: Optional[TransitGatewayAttachmentSpecUpdate] = None
    status: Optional[TransitGatewayAttachmentStatus] = None


class PrivateLinkAttachmentConnectionUpdate(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[Kind1Model75] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    id: Optional[constr(max_length=255)] = Field(
        None,
        description='ID is the "natural identifier" for an object within its scope/namespace; it is normally unique across time but not space. That is, you can assume that the ID will not be reclaimed and reused after an object is deleted ("time"); however, it may collide with IDs for other object `kinds` or objects of the same `kind` within a different scope/namespace ("space").',
        examples=['dlz-f3a90de'],
    )
    metadata: Optional[Metadata1Model33] = None
    spec: Optional[PrivateLinkAttachmentConnectionSpecUpdate] = None
    status: Optional[PrivateLinkAttachmentConnectionStatus] = None


class AccessPointUpdate(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[Kind1Model77] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    id: Optional[constr(max_length=255)] = Field(
        None,
        description='ID is the "natural identifier" for an object within its scope/namespace; it is normally unique across time but not space. That is, you can assume that the ID will not be reclaimed and reused after an object is deleted ("time"); however, it may collide with IDs for other object `kinds` or objects of the same `kind` within a different scope/namespace ("space").',
        examples=['dlz-f3a90de'],
    )
    metadata: Optional[Metadata1Model35] = None
    spec: Optional[AccessPointSpecUpdate] = None
    status: Optional[AccessPointStatus] = None


class GatewayUpdate(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[Kind1Model79] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    id: Optional[constr(max_length=255)] = Field(
        None,
        description='ID is the "natural identifier" for an object within its scope/namespace; it is normally unique across time but not space. That is, you can assume that the ID will not be reclaimed and reused after an object is deleted ("time"); however, it may collide with IDs for other object `kinds` or objects of the same `kind` within a different scope/namespace ("space").',
        examples=['dlz-f3a90de'],
    )
    metadata: Optional[Metadata1Model37] = None
    spec: Optional[GatewaySpecUpdate] = None
    status: Optional[GatewayStatus] = None


class Network(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[Kind] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    id: Optional[constr(max_length=255)] = Field(
        None,
        description='ID is the "natural identifier" for an object within its scope/namespace; it is normally unique across time but not space. That is, you can assume that the ID will not be reclaimed and reused after an object is deleted ("time"); however, it may collide with IDs for other object `kinds` or objects of the same `kind` within a different scope/namespace ("space").',
        examples=['dlz-f3a90de'],
    )
    metadata: Optional[Metadata] = None
    spec: Optional[NetworkSpec] = None
    status: Optional[NetworkStatus] = None


class TransitGatewayAttachment(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[Kind1Model1] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    id: Optional[constr(max_length=255)] = Field(
        None,
        description='ID is the "natural identifier" for an object within its scope/namespace; it is normally unique across time but not space. That is, you can assume that the ID will not be reclaimed and reused after an object is deleted ("time"); however, it may collide with IDs for other object `kinds` or objects of the same `kind` within a different scope/namespace ("space").',
        examples=['dlz-f3a90de'],
    )
    metadata: Optional[Metadata1Model1] = None
    spec: Optional[TransitGatewayAttachmentSpec] = None
    status: Optional[TransitGatewayAttachmentStatus] = None


class Datum1Model6(Network):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    spec: Dict[str, Any]


class NetworkList(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: ApiVersion = Field(
        ...,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Kind1Model17 = Field(
        ..., description='Kind defines the object this REST resource represents.'
    )
    metadata: Metadata1Model6
    data: List[Datum1Model6] = Field(
        ...,
        description='A data property that contains an array of resource items. Each entry in the array is a separate resource.',
    )


class Datum1Model7(TransitGatewayAttachment):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    spec: Dict[str, Any]


class TransitGatewayAttachmentList(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: ApiVersion = Field(
        ...,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Kind1Model19 = Field(
        ..., description='Kind defines the object this REST resource represents.'
    )
    metadata: Metadata1Model8
    data: List[Datum1Model7] = Field(
        ...,
        description='A data property that contains an array of resource items. Each entry in the array is a separate resource.',
    )


class PrivateLinkAttachmentStatus(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    phase: str = Field(
        ...,
        description='The lifecycle phase of the PrivateLink attachment:\n\n  PROVISIONING: PrivateLink attachment provisioning is in progress;\n\n  WAITING_FOR_CONNECTIONS: PrivateLink attachment is waiting for connections;\n\n  READY: PrivateLink attachment is ready;\n\n  FAILED: PrivateLink attachment is in a failed state;\n\n  EXPIRED: PrivateLink attachment has timed out waiting for connections, can only be deleted;\n\n  DEPROVISIONING: PrivateLink attachment deprovisioning is in progress;\n',
        examples=['READY'],
    )
    error_code: Optional[str] = Field(
        None,
        description='Error code if PrivateLink attachment is in a failed state. May be used for programmatic error checking.',
    )
    error_message: Optional[str] = Field(
        None,
        description='Displayable error message if PrivateLink attachment is in a failed state.',
    )
    dns_domain: Optional[str] = Field(
        None,
        description='The root DNS domain for the PrivateLink attachment.',
        examples=['us-east-1.aws.private.confluent.cloud'],
    )
    cloud: Optional[
        Union[
            AwsPrivateLinkAttachmentStatus,
            AzurePrivateLinkAttachmentStatus,
            GcpPrivateLinkAttachmentStatus,
        ]
    ] = Field(
        None,
        description='The cloud specific status of the PrivateLink attachment. These will be populated when the PrivateLink attachment reaches the WAITING_FOR_CONNECTIONS state.',
        discriminator='kind',
    )


class PrivateLinkAttachmentConnection(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[Kind1Model27] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    id: Optional[constr(max_length=255)] = Field(
        None,
        description='ID is the "natural identifier" for an object within its scope/namespace; it is normally unique across time but not space. That is, you can assume that the ID will not be reclaimed and reused after an object is deleted ("time"); however, it may collide with IDs for other object `kinds` or objects of the same `kind` within a different scope/namespace ("space").',
        examples=['dlz-f3a90de'],
    )
    metadata: Optional[Metadata1Model15] = None
    spec: Optional[PrivateLinkAttachmentConnectionSpec] = None
    status: Optional[PrivateLinkAttachmentConnectionStatus] = None


class Datum1Model8(PrivateLinkAttachmentConnection):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    spec: Dict[str, Any]


class PrivateLinkAttachmentConnectionList(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: ApiVersion = Field(
        ...,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Kind1Model38 = Field(
        ..., description='Kind defines the object this REST resource represents.'
    )
    metadata: Metadata1Model17
    data: List[Datum1Model8] = Field(
        ...,
        description='A data property that contains an array of resource items. Each entry in the array is a separate resource.',
    )


class AccessPoint(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[Kind1Model42] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    id: Optional[constr(max_length=255)] = Field(
        None,
        description='ID is the "natural identifier" for an object within its scope/namespace; it is normally unique across time but not space. That is, you can assume that the ID will not be reclaimed and reused after an object is deleted ("time"); however, it may collide with IDs for other object `kinds` or objects of the same `kind` within a different scope/namespace ("space").',
        examples=['dlz-f3a90de'],
    )
    metadata: Optional[Metadata1Model20] = None
    spec: Optional[AccessPointSpec] = None
    status: Optional[AccessPointStatus] = None


class Datum1Model9(AccessPoint):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    spec: Dict[str, Any]


class AccessPointList(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: ApiVersion = Field(
        ...,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Kind1Model52 = Field(
        ..., description='Kind defines the object this REST resource represents.'
    )
    metadata: Metadata1Model22
    data: List[Datum1Model9] = Field(
        ...,
        description='A data property that contains an array of resource items. Each entry in the array is a separate resource.',
    )


class Gateway(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[Kind1Model54] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    id: Optional[constr(max_length=255)] = Field(
        None,
        description='ID is the "natural identifier" for an object within its scope/namespace; it is normally unique across time but not space. That is, you can assume that the ID will not be reclaimed and reused after an object is deleted ("time"); however, it may collide with IDs for other object `kinds` or objects of the same `kind` within a different scope/namespace ("space").',
        examples=['dlz-f3a90de'],
    )
    metadata: Optional[Metadata1Model24] = None
    spec: Optional[GatewaySpec] = None
    status: Optional[GatewayStatus] = None


class Datum1Model10(Gateway):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    spec: Dict[str, Any]


class GatewayList(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: ApiVersion = Field(
        ...,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Kind1Model67 = Field(
        ..., description='Kind defines the object this REST resource represents.'
    )
    metadata: Metadata1Model25
    data: List[Datum1Model10] = Field(
        ...,
        description='A data property that contains an array of resource items. Each entry in the array is a separate resource.',
    )


class PrivateLinkAttachmentUpdate(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[Kind1Model74] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    id: Optional[constr(max_length=255)] = Field(
        None,
        description='ID is the "natural identifier" for an object within its scope/namespace; it is normally unique across time but not space. That is, you can assume that the ID will not be reclaimed and reused after an object is deleted ("time"); however, it may collide with IDs for other object `kinds` or objects of the same `kind` within a different scope/namespace ("space").',
        examples=['dlz-f3a90de'],
    )
    metadata: Optional[Metadata1Model32] = None
    spec: Optional[PrivateLinkAttachmentSpecUpdate] = None
    status: Optional[PrivateLinkAttachmentStatus] = None


class PrivateLinkAttachment(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[Kind1Model26] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    id: Optional[constr(max_length=255)] = Field(
        None,
        description='ID is the "natural identifier" for an object within its scope/namespace; it is normally unique across time but not space. That is, you can assume that the ID will not be reclaimed and reused after an object is deleted ("time"); however, it may collide with IDs for other object `kinds` or objects of the same `kind` within a different scope/namespace ("space").',
        examples=['dlz-f3a90de'],
    )
    metadata: Optional[Metadata1Model14] = None
    spec: Optional[PrivateLinkAttachmentSpec] = None
    status: Optional[PrivateLinkAttachmentStatus] = None


class Datum1Model11(PrivateLinkAttachment):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    spec: Dict[str, Any]


class PrivateLinkAttachmentList(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: ApiVersion = Field(
        ...,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Kind1Model37 = Field(
        ..., description='Kind defines the object this REST resource represents.'
    )
    metadata: Metadata1Model16
    data: List[Datum1Model11] = Field(
        ...,
        description='A data property that contains an array of resource items. Each entry in the array is a separate resource.',
    )
