import { IPrincipal, ServicePrincipalOpts } from './principals';
/**
 * Represents a statement in an IAM policy document.
 */
export declare class PolicyStatement {
    /**
     * Statement ID for this statement
     */
    sid?: string;
    effect: Effect;
    private action;
    private principal;
    private resource;
    private condition;
    constructor(props?: PolicyStatementProps);
    addActions(...actions: string[]): void;
    /**
     * Indicates if this permission has a "Principal" section.
     */
    readonly hasPrincipal: boolean;
    addPrincipals(...principals: IPrincipal[]): void;
    addAwsAccountPrincipal(accountId: string): void;
    addArnPrincipal(arn: string): void;
    /**
     * Adds a service principal to this policy statement.
     *
     * @param service the service name for which a service principal is requested (e.g: `s3.amazonaws.com`).
     * @param opts    options for adding the service principal (such as specifying a principal in a different region)
     */
    addServicePrincipal(service: string, opts?: ServicePrincipalOpts): void;
    addFederatedPrincipal(federated: any, conditions: {
        [key: string]: any;
    }): void;
    addAccountRootPrincipal(): void;
    addCanonicalUserPrincipal(canonicalUserId: string): void;
    addAnyPrincipal(): void;
    addResources(...arns: string[]): void;
    /**
     * Adds a ``"*"`` resource to this statement.
     */
    addAllResources(): void;
    /**
     * Indicates if this permission as at least one resource associated with it.
     */
    readonly hasResource: boolean;
    /**
     * Add a condition to the Policy
     */
    addCondition(key: string, value: any): void;
    /**
     * Add multiple conditions to the Policy
     */
    addConditions(conditions: {
        [key: string]: any;
    }): void;
    /**
     * Add a condition that limits to a given account
     */
    addAccountCondition(accountId: string): void;
    toStatementJson(): any;
    toString(): string;
    /**
     * JSON-ify the statement
     *
     * Used when JSON.stringify() is called
     */
    toJSON(): any;
}
export declare enum Effect {
    ALLOW = "Allow",
    DENY = "Deny"
}
/**
 * Interface for creating a policy statement
 */
export interface PolicyStatementProps {
    /**
     * List of actions to add to the statement
     *
     * @default - no actions
     */
    readonly actions?: string[];
    /**
     * List of principals to add to the statement
     *
     * @default - no principals
     */
    readonly principals?: IPrincipal[];
    /**
     * Resource ARNs to add to the statement
     *
     * @default - no principals
     */
    readonly resources?: string[];
    /**
     * Conditions to add to the statement
     *
     * @default - no condition
     */
    readonly conditions?: {
        [key: string]: any;
    };
    /**
     * Whether to allow or deny the actions in this statement
     *
     * @default - allow
     */
    readonly effect?: Effect;
}
