"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
const app = new core_1.App();
const stack = new core_1.Stack(app, 'integ-iam-role-1');
const g1 = new lib_1.Group(stack, 'MyGroup');
const g2 = new lib_1.Group(stack, 'YourGroup');
for (let i = 0; i < 5; ++i) {
    const user = new lib_1.User(stack, `User${i + 1}`);
    user.addToGroup(g1);
    g2.addUser(user);
}
const policy = new lib_1.Policy(stack, 'MyPolicy');
policy.attachToGroup(g1);
policy.addStatements(new lib_1.PolicyStatement({
    resources: [g2.groupArn],
    actions: ['iam:*']
}));
app.synth();
//# sourceMappingURL=data:application/json;base64,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