### What does `molywood` do?

Molywood is there to make cool molecular movies for you.

Specifically, `molywood` automatizes the most tedious steps in
generation of these movies, i.e. scripting in TCL, rendering, generating
overlays and combining frames, as well as merging frames into the final
movie:

![Molywood workflow](workflow.png)

We try to simplify the movie making syntax, as well as add extended
functionalities such as animating trajectory data with matplotlib,
adding insets or making multi-panel movies.

The basic idea behind the functionalities of `molywood` is best understood
through the examples shown in the Samples section. Ambitious users are
advised to familiarize themselves with the Documentation section, where
individual keywords are described in detail, and explore the
capabilities of the script through experimentation.

Recently, Molywood has been integrated into VMD through a graphical interface! 
You can find the repo of `molywood-gui` [here](https://gitlab.com/milafternoon/molywood-gui) 
and follow the instructions to learn how to make movies directly from VMD. 
There's also a [playlist](https://www.youtube.com/watch?v=7rHwlxm3d00&list=PLl6-JGevY8O1bExfakK8yr-sczsuBjooV) 
that features Youtube tutorials covering the basics.

Independent of the GUI, users can still use Molywood as a command-line tool, and 
the two modes are actually complementary - to accelerate movie design in the graphical 
interface, and then execute demanding rendering on an external workstation.

### Installation 

If you're an experienced user of scientific Python, VMD and ffmpeg, there is a good
chance a plain `pip` installation will be sufficient for you. In this case, type

```
pip install molywood    # downloads the script
molywood-gen-env        # performs the checkups 
molywood                # initializes a sample run
``` 

In every other case, we recommend that you follow the step-by-step installation instructions 
from [our OS-specific installation tutorials](http://mmb.irbbarcelona.org/molywood/tutorials).

For the latest (not always tested!) version of Molywood, as well as input files to reproduce 
the "Samples" examples, head to [the Gitlab repo](https://gitlab.com/KomBioMol/molywood) where 
Molywood is actively developed.

### Usage

Sample movie scripts are available in the `examples` directory on [GitLab](https://gitlab.com/KomBioMol/molywood): try
them first to see how the library works. Just running `molywood` in the command
line will allow you to (a) generate a sample input script, (b) display a sample
movie, (c) render a sample movie.

For regular use, `molywood` should be run from the console as:

 `molywood script.txt`

In general, to run `molywood` the following files are needed:

1. either (a) a visualization state generated by VMD, or (b) a structure
file; (a) is the preferred way - user may define the representations
as well as set the camera angle as desired, and then go to File > Save
Visualization State); in option (b), a default representation is used,
and a compatible trajectory file can be provided. Alternatively (c), one can
provide a four-character `pdb_code=...`, and the structure will be
automatically downloaded from the PDB database.
1. a 'movie script', i.e. a simple text file containing directives,
including a reference to the VMD visualization state (see examples and
the explanations below).

The good news is that the actual time-consuming rendering can be done externally,
e.g. on a remote workstation, once you set up the visualization state
locally. By using the draft mode along with `render=f`, you can also
quickly preview your movie.

### Featured movies

If you believe your `molywood`-generated movie should be featured in our gallery
to inspire other users, please email your example (input file, the rendered movie,
and possibly other files, such as your structure/trajectory and the .vmd
visualization state) to [this address](mailto:milafternoon@gmail.com). You may also
include a literature reference to highlight your work.

### Recent major releases

##### v1.0 (release date 07.2025)

- full integration with VMD GUI (partial previews, previewing highlight location)
- added `save_viewpoint`/`restore_viewpoint` for easy restoring of camera positions
- more flexible plotting options
- contour in `highlight`, editing representations defined in VMD

##### v0.24 (released 11.10.2022)

- support for `.cube` files loaded as a trajectory
- added `render_only` to limit rendering to selected frames 

##### v0.23 (released 25.07.2022)

- added loops and variables
- implemented `show_grid`
- CPK is now available as a `highlight` style
- `add_overlay` can now have `mode=n` just to edit overlay properties

##### v0.22 (released 26.12.2020)

- LaTeX syntax and newlines work properly in text `highlight`s
- highlights, translation or rotation can be performed on individual molecules
- `master_overlay`s can be used on top of multi-scene videos

##### v0.2 (released 27.11.2020)

- enabled custom user-defined TCL commands with `insert_tcl`, also in loops
- added `breakpoints` to automatically chop a video into parts
- DynamicBonds is now available as a `highlight` style
- `fitting` and `center_view` used with `molecules` now operate on selected molecules when multiple are involved
- `highlight` now has a `multiframe` option to show ensembles of structures
- `do_nothing` now renders frames much faster
- optional coloring of elements/types/names in `highlight`
- final write to .gif (with custom quality settings) now supported
- enabled logging of command line calls
- `dataframes_from_file` can be used in dynamic plotting
