import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermAppConfigurationKeyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/app_configuration_key#configuration_store_id DataAzurermAppConfigurationKey#configuration_store_id}
    */
    readonly configurationStoreId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/app_configuration_key#id DataAzurermAppConfigurationKey#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/app_configuration_key#key DataAzurermAppConfigurationKey#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/app_configuration_key#label DataAzurermAppConfigurationKey#label}
    */
    readonly label?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/app_configuration_key#timeouts DataAzurermAppConfigurationKey#timeouts}
    */
    readonly timeouts?: DataAzurermAppConfigurationKeyTimeouts;
}
export interface DataAzurermAppConfigurationKeyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/app_configuration_key#read DataAzurermAppConfigurationKey#read}
    */
    readonly read?: string;
}
export declare function dataAzurermAppConfigurationKeyTimeoutsToTerraform(struct?: DataAzurermAppConfigurationKeyTimeoutsOutputReference | DataAzurermAppConfigurationKeyTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermAppConfigurationKeyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermAppConfigurationKeyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermAppConfigurationKeyTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/app_configuration_key azurerm_app_configuration_key}
*/
export declare class DataAzurermAppConfigurationKey extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_app_configuration_key";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/app_configuration_key azurerm_app_configuration_key} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermAppConfigurationKeyConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermAppConfigurationKeyConfig);
    private _configurationStoreId?;
    get configurationStoreId(): string;
    set configurationStoreId(value: string);
    get configurationStoreIdInput(): string | undefined;
    get contentType(): string;
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _label?;
    get label(): string;
    set label(value: string);
    resetLabel(): void;
    get labelInput(): string | undefined;
    get locked(): cdktf.IResolvable;
    private _tags;
    get tags(): cdktf.StringMap;
    get type(): string;
    get value(): string;
    get vaultKeyReference(): string;
    private _timeouts;
    get timeouts(): DataAzurermAppConfigurationKeyTimeoutsOutputReference;
    putTimeouts(value: DataAzurermAppConfigurationKeyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermAppConfigurationKeyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
