import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface HdinsightInteractiveQueryClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#cluster_version HdinsightInteractiveQueryCluster#cluster_version}
    */
    readonly clusterVersion: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#encryption_in_transit_enabled HdinsightInteractiveQueryCluster#encryption_in_transit_enabled}
    */
    readonly encryptionInTransitEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#id HdinsightInteractiveQueryCluster#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#location HdinsightInteractiveQueryCluster#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#name HdinsightInteractiveQueryCluster#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#resource_group_name HdinsightInteractiveQueryCluster#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#tags HdinsightInteractiveQueryCluster#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#tier HdinsightInteractiveQueryCluster#tier}
    */
    readonly tier: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#tls_min_version HdinsightInteractiveQueryCluster#tls_min_version}
    */
    readonly tlsMinVersion?: string;
    /**
    * component_version block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#component_version HdinsightInteractiveQueryCluster#component_version}
    */
    readonly componentVersion: HdinsightInteractiveQueryClusterComponentVersion;
    /**
    * disk_encryption block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#disk_encryption HdinsightInteractiveQueryCluster#disk_encryption}
    */
    readonly diskEncryption?: HdinsightInteractiveQueryClusterDiskEncryption[] | cdktf.IResolvable;
    /**
    * extension block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#extension HdinsightInteractiveQueryCluster#extension}
    */
    readonly extension?: HdinsightInteractiveQueryClusterExtension;
    /**
    * gateway block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#gateway HdinsightInteractiveQueryCluster#gateway}
    */
    readonly gateway: HdinsightInteractiveQueryClusterGateway;
    /**
    * metastores block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#metastores HdinsightInteractiveQueryCluster#metastores}
    */
    readonly metastores?: HdinsightInteractiveQueryClusterMetastores;
    /**
    * monitor block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#monitor HdinsightInteractiveQueryCluster#monitor}
    */
    readonly monitor?: HdinsightInteractiveQueryClusterMonitor;
    /**
    * network block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#network HdinsightInteractiveQueryCluster#network}
    */
    readonly network?: HdinsightInteractiveQueryClusterNetwork;
    /**
    * roles block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#roles HdinsightInteractiveQueryCluster#roles}
    */
    readonly roles: HdinsightInteractiveQueryClusterRoles;
    /**
    * security_profile block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#security_profile HdinsightInteractiveQueryCluster#security_profile}
    */
    readonly securityProfile?: HdinsightInteractiveQueryClusterSecurityProfile;
    /**
    * storage_account block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#storage_account HdinsightInteractiveQueryCluster#storage_account}
    */
    readonly storageAccount?: HdinsightInteractiveQueryClusterStorageAccount[] | cdktf.IResolvable;
    /**
    * storage_account_gen2 block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#storage_account_gen2 HdinsightInteractiveQueryCluster#storage_account_gen2}
    */
    readonly storageAccountGen2?: HdinsightInteractiveQueryClusterStorageAccountGen2;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#timeouts HdinsightInteractiveQueryCluster#timeouts}
    */
    readonly timeouts?: HdinsightInteractiveQueryClusterTimeouts;
}
export interface HdinsightInteractiveQueryClusterComponentVersion {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#interactive_hive HdinsightInteractiveQueryCluster#interactive_hive}
    */
    readonly interactiveHive: string;
}
export declare function hdinsightInteractiveQueryClusterComponentVersionToTerraform(struct?: HdinsightInteractiveQueryClusterComponentVersionOutputReference | HdinsightInteractiveQueryClusterComponentVersion): any;
export declare class HdinsightInteractiveQueryClusterComponentVersionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightInteractiveQueryClusterComponentVersion | undefined;
    set internalValue(value: HdinsightInteractiveQueryClusterComponentVersion | undefined);
    private _interactiveHive?;
    get interactiveHive(): string;
    set interactiveHive(value: string);
    get interactiveHiveInput(): string | undefined;
}
export interface HdinsightInteractiveQueryClusterDiskEncryption {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#encryption_algorithm HdinsightInteractiveQueryCluster#encryption_algorithm}
    */
    readonly encryptionAlgorithm?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#encryption_at_host_enabled HdinsightInteractiveQueryCluster#encryption_at_host_enabled}
    */
    readonly encryptionAtHostEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#key_vault_key_id HdinsightInteractiveQueryCluster#key_vault_key_id}
    */
    readonly keyVaultKeyId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#key_vault_managed_identity_id HdinsightInteractiveQueryCluster#key_vault_managed_identity_id}
    */
    readonly keyVaultManagedIdentityId?: string;
}
export declare function hdinsightInteractiveQueryClusterDiskEncryptionToTerraform(struct?: HdinsightInteractiveQueryClusterDiskEncryption | cdktf.IResolvable): any;
export declare class HdinsightInteractiveQueryClusterDiskEncryptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HdinsightInteractiveQueryClusterDiskEncryption | cdktf.IResolvable | undefined;
    set internalValue(value: HdinsightInteractiveQueryClusterDiskEncryption | cdktf.IResolvable | undefined);
    private _encryptionAlgorithm?;
    get encryptionAlgorithm(): string;
    set encryptionAlgorithm(value: string);
    resetEncryptionAlgorithm(): void;
    get encryptionAlgorithmInput(): string | undefined;
    private _encryptionAtHostEnabled?;
    get encryptionAtHostEnabled(): boolean | cdktf.IResolvable;
    set encryptionAtHostEnabled(value: boolean | cdktf.IResolvable);
    resetEncryptionAtHostEnabled(): void;
    get encryptionAtHostEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _keyVaultKeyId?;
    get keyVaultKeyId(): string;
    set keyVaultKeyId(value: string);
    resetKeyVaultKeyId(): void;
    get keyVaultKeyIdInput(): string | undefined;
    private _keyVaultManagedIdentityId?;
    get keyVaultManagedIdentityId(): string;
    set keyVaultManagedIdentityId(value: string);
    resetKeyVaultManagedIdentityId(): void;
    get keyVaultManagedIdentityIdInput(): string | undefined;
}
export declare class HdinsightInteractiveQueryClusterDiskEncryptionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HdinsightInteractiveQueryClusterDiskEncryption[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HdinsightInteractiveQueryClusterDiskEncryptionOutputReference;
}
export interface HdinsightInteractiveQueryClusterExtension {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#log_analytics_workspace_id HdinsightInteractiveQueryCluster#log_analytics_workspace_id}
    */
    readonly logAnalyticsWorkspaceId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#primary_key HdinsightInteractiveQueryCluster#primary_key}
    */
    readonly primaryKey: string;
}
export declare function hdinsightInteractiveQueryClusterExtensionToTerraform(struct?: HdinsightInteractiveQueryClusterExtensionOutputReference | HdinsightInteractiveQueryClusterExtension): any;
export declare class HdinsightInteractiveQueryClusterExtensionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightInteractiveQueryClusterExtension | undefined;
    set internalValue(value: HdinsightInteractiveQueryClusterExtension | undefined);
    private _logAnalyticsWorkspaceId?;
    get logAnalyticsWorkspaceId(): string;
    set logAnalyticsWorkspaceId(value: string);
    get logAnalyticsWorkspaceIdInput(): string | undefined;
    private _primaryKey?;
    get primaryKey(): string;
    set primaryKey(value: string);
    get primaryKeyInput(): string | undefined;
}
export interface HdinsightInteractiveQueryClusterGateway {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#password HdinsightInteractiveQueryCluster#password}
    */
    readonly password: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#username HdinsightInteractiveQueryCluster#username}
    */
    readonly username: string;
}
export declare function hdinsightInteractiveQueryClusterGatewayToTerraform(struct?: HdinsightInteractiveQueryClusterGatewayOutputReference | HdinsightInteractiveQueryClusterGateway): any;
export declare class HdinsightInteractiveQueryClusterGatewayOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightInteractiveQueryClusterGateway | undefined;
    set internalValue(value: HdinsightInteractiveQueryClusterGateway | undefined);
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
}
export interface HdinsightInteractiveQueryClusterMetastoresAmbari {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#database_name HdinsightInteractiveQueryCluster#database_name}
    */
    readonly databaseName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#password HdinsightInteractiveQueryCluster#password}
    */
    readonly password: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#server HdinsightInteractiveQueryCluster#server}
    */
    readonly server: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#username HdinsightInteractiveQueryCluster#username}
    */
    readonly username: string;
}
export declare function hdinsightInteractiveQueryClusterMetastoresAmbariToTerraform(struct?: HdinsightInteractiveQueryClusterMetastoresAmbariOutputReference | HdinsightInteractiveQueryClusterMetastoresAmbari): any;
export declare class HdinsightInteractiveQueryClusterMetastoresAmbariOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightInteractiveQueryClusterMetastoresAmbari | undefined;
    set internalValue(value: HdinsightInteractiveQueryClusterMetastoresAmbari | undefined);
    private _databaseName?;
    get databaseName(): string;
    set databaseName(value: string);
    get databaseNameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _server?;
    get server(): string;
    set server(value: string);
    get serverInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
}
export interface HdinsightInteractiveQueryClusterMetastoresHive {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#database_name HdinsightInteractiveQueryCluster#database_name}
    */
    readonly databaseName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#password HdinsightInteractiveQueryCluster#password}
    */
    readonly password: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#server HdinsightInteractiveQueryCluster#server}
    */
    readonly server: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#username HdinsightInteractiveQueryCluster#username}
    */
    readonly username: string;
}
export declare function hdinsightInteractiveQueryClusterMetastoresHiveToTerraform(struct?: HdinsightInteractiveQueryClusterMetastoresHiveOutputReference | HdinsightInteractiveQueryClusterMetastoresHive): any;
export declare class HdinsightInteractiveQueryClusterMetastoresHiveOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightInteractiveQueryClusterMetastoresHive | undefined;
    set internalValue(value: HdinsightInteractiveQueryClusterMetastoresHive | undefined);
    private _databaseName?;
    get databaseName(): string;
    set databaseName(value: string);
    get databaseNameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _server?;
    get server(): string;
    set server(value: string);
    get serverInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
}
export interface HdinsightInteractiveQueryClusterMetastoresOozie {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#database_name HdinsightInteractiveQueryCluster#database_name}
    */
    readonly databaseName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#password HdinsightInteractiveQueryCluster#password}
    */
    readonly password: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#server HdinsightInteractiveQueryCluster#server}
    */
    readonly server: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#username HdinsightInteractiveQueryCluster#username}
    */
    readonly username: string;
}
export declare function hdinsightInteractiveQueryClusterMetastoresOozieToTerraform(struct?: HdinsightInteractiveQueryClusterMetastoresOozieOutputReference | HdinsightInteractiveQueryClusterMetastoresOozie): any;
export declare class HdinsightInteractiveQueryClusterMetastoresOozieOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightInteractiveQueryClusterMetastoresOozie | undefined;
    set internalValue(value: HdinsightInteractiveQueryClusterMetastoresOozie | undefined);
    private _databaseName?;
    get databaseName(): string;
    set databaseName(value: string);
    get databaseNameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _server?;
    get server(): string;
    set server(value: string);
    get serverInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
}
export interface HdinsightInteractiveQueryClusterMetastores {
    /**
    * ambari block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#ambari HdinsightInteractiveQueryCluster#ambari}
    */
    readonly ambari?: HdinsightInteractiveQueryClusterMetastoresAmbari;
    /**
    * hive block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#hive HdinsightInteractiveQueryCluster#hive}
    */
    readonly hive?: HdinsightInteractiveQueryClusterMetastoresHive;
    /**
    * oozie block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#oozie HdinsightInteractiveQueryCluster#oozie}
    */
    readonly oozie?: HdinsightInteractiveQueryClusterMetastoresOozie;
}
export declare function hdinsightInteractiveQueryClusterMetastoresToTerraform(struct?: HdinsightInteractiveQueryClusterMetastoresOutputReference | HdinsightInteractiveQueryClusterMetastores): any;
export declare class HdinsightInteractiveQueryClusterMetastoresOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightInteractiveQueryClusterMetastores | undefined;
    set internalValue(value: HdinsightInteractiveQueryClusterMetastores | undefined);
    private _ambari;
    get ambari(): HdinsightInteractiveQueryClusterMetastoresAmbariOutputReference;
    putAmbari(value: HdinsightInteractiveQueryClusterMetastoresAmbari): void;
    resetAmbari(): void;
    get ambariInput(): HdinsightInteractiveQueryClusterMetastoresAmbari | undefined;
    private _hive;
    get hive(): HdinsightInteractiveQueryClusterMetastoresHiveOutputReference;
    putHive(value: HdinsightInteractiveQueryClusterMetastoresHive): void;
    resetHive(): void;
    get hiveInput(): HdinsightInteractiveQueryClusterMetastoresHive | undefined;
    private _oozie;
    get oozie(): HdinsightInteractiveQueryClusterMetastoresOozieOutputReference;
    putOozie(value: HdinsightInteractiveQueryClusterMetastoresOozie): void;
    resetOozie(): void;
    get oozieInput(): HdinsightInteractiveQueryClusterMetastoresOozie | undefined;
}
export interface HdinsightInteractiveQueryClusterMonitor {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#log_analytics_workspace_id HdinsightInteractiveQueryCluster#log_analytics_workspace_id}
    */
    readonly logAnalyticsWorkspaceId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#primary_key HdinsightInteractiveQueryCluster#primary_key}
    */
    readonly primaryKey: string;
}
export declare function hdinsightInteractiveQueryClusterMonitorToTerraform(struct?: HdinsightInteractiveQueryClusterMonitorOutputReference | HdinsightInteractiveQueryClusterMonitor): any;
export declare class HdinsightInteractiveQueryClusterMonitorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightInteractiveQueryClusterMonitor | undefined;
    set internalValue(value: HdinsightInteractiveQueryClusterMonitor | undefined);
    private _logAnalyticsWorkspaceId?;
    get logAnalyticsWorkspaceId(): string;
    set logAnalyticsWorkspaceId(value: string);
    get logAnalyticsWorkspaceIdInput(): string | undefined;
    private _primaryKey?;
    get primaryKey(): string;
    set primaryKey(value: string);
    get primaryKeyInput(): string | undefined;
}
export interface HdinsightInteractiveQueryClusterNetwork {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#connection_direction HdinsightInteractiveQueryCluster#connection_direction}
    */
    readonly connectionDirection?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#private_link_enabled HdinsightInteractiveQueryCluster#private_link_enabled}
    */
    readonly privateLinkEnabled?: boolean | cdktf.IResolvable;
}
export declare function hdinsightInteractiveQueryClusterNetworkToTerraform(struct?: HdinsightInteractiveQueryClusterNetworkOutputReference | HdinsightInteractiveQueryClusterNetwork): any;
export declare class HdinsightInteractiveQueryClusterNetworkOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightInteractiveQueryClusterNetwork | undefined;
    set internalValue(value: HdinsightInteractiveQueryClusterNetwork | undefined);
    private _connectionDirection?;
    get connectionDirection(): string;
    set connectionDirection(value: string);
    resetConnectionDirection(): void;
    get connectionDirectionInput(): string | undefined;
    private _privateLinkEnabled?;
    get privateLinkEnabled(): boolean | cdktf.IResolvable;
    set privateLinkEnabled(value: boolean | cdktf.IResolvable);
    resetPrivateLinkEnabled(): void;
    get privateLinkEnabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface HdinsightInteractiveQueryClusterRolesHeadNode {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#password HdinsightInteractiveQueryCluster#password}
    */
    readonly password?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#ssh_keys HdinsightInteractiveQueryCluster#ssh_keys}
    */
    readonly sshKeys?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#subnet_id HdinsightInteractiveQueryCluster#subnet_id}
    */
    readonly subnetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#username HdinsightInteractiveQueryCluster#username}
    */
    readonly username: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#virtual_network_id HdinsightInteractiveQueryCluster#virtual_network_id}
    */
    readonly virtualNetworkId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#vm_size HdinsightInteractiveQueryCluster#vm_size}
    */
    readonly vmSize: string;
}
export declare function hdinsightInteractiveQueryClusterRolesHeadNodeToTerraform(struct?: HdinsightInteractiveQueryClusterRolesHeadNodeOutputReference | HdinsightInteractiveQueryClusterRolesHeadNode): any;
export declare class HdinsightInteractiveQueryClusterRolesHeadNodeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightInteractiveQueryClusterRolesHeadNode | undefined;
    set internalValue(value: HdinsightInteractiveQueryClusterRolesHeadNode | undefined);
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _sshKeys?;
    get sshKeys(): string[];
    set sshKeys(value: string[]);
    resetSshKeys(): void;
    get sshKeysInput(): string[] | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    resetSubnetId(): void;
    get subnetIdInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
    private _virtualNetworkId?;
    get virtualNetworkId(): string;
    set virtualNetworkId(value: string);
    resetVirtualNetworkId(): void;
    get virtualNetworkIdInput(): string | undefined;
    private _vmSize?;
    get vmSize(): string;
    set vmSize(value: string);
    get vmSizeInput(): string | undefined;
}
export interface HdinsightInteractiveQueryClusterRolesWorkerNodeAutoscaleCapacity {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#max_instance_count HdinsightInteractiveQueryCluster#max_instance_count}
    */
    readonly maxInstanceCount: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#min_instance_count HdinsightInteractiveQueryCluster#min_instance_count}
    */
    readonly minInstanceCount: number;
}
export declare function hdinsightInteractiveQueryClusterRolesWorkerNodeAutoscaleCapacityToTerraform(struct?: HdinsightInteractiveQueryClusterRolesWorkerNodeAutoscaleCapacityOutputReference | HdinsightInteractiveQueryClusterRolesWorkerNodeAutoscaleCapacity): any;
export declare class HdinsightInteractiveQueryClusterRolesWorkerNodeAutoscaleCapacityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightInteractiveQueryClusterRolesWorkerNodeAutoscaleCapacity | undefined;
    set internalValue(value: HdinsightInteractiveQueryClusterRolesWorkerNodeAutoscaleCapacity | undefined);
    private _maxInstanceCount?;
    get maxInstanceCount(): number;
    set maxInstanceCount(value: number);
    get maxInstanceCountInput(): number | undefined;
    private _minInstanceCount?;
    get minInstanceCount(): number;
    set minInstanceCount(value: number);
    get minInstanceCountInput(): number | undefined;
}
export interface HdinsightInteractiveQueryClusterRolesWorkerNodeAutoscaleRecurrenceSchedule {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#days HdinsightInteractiveQueryCluster#days}
    */
    readonly days: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#target_instance_count HdinsightInteractiveQueryCluster#target_instance_count}
    */
    readonly targetInstanceCount: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#time HdinsightInteractiveQueryCluster#time}
    */
    readonly time: string;
}
export declare function hdinsightInteractiveQueryClusterRolesWorkerNodeAutoscaleRecurrenceScheduleToTerraform(struct?: HdinsightInteractiveQueryClusterRolesWorkerNodeAutoscaleRecurrenceSchedule | cdktf.IResolvable): any;
export declare class HdinsightInteractiveQueryClusterRolesWorkerNodeAutoscaleRecurrenceScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HdinsightInteractiveQueryClusterRolesWorkerNodeAutoscaleRecurrenceSchedule | cdktf.IResolvable | undefined;
    set internalValue(value: HdinsightInteractiveQueryClusterRolesWorkerNodeAutoscaleRecurrenceSchedule | cdktf.IResolvable | undefined);
    private _days?;
    get days(): string[];
    set days(value: string[]);
    get daysInput(): string[] | undefined;
    private _targetInstanceCount?;
    get targetInstanceCount(): number;
    set targetInstanceCount(value: number);
    get targetInstanceCountInput(): number | undefined;
    private _time?;
    get time(): string;
    set time(value: string);
    get timeInput(): string | undefined;
}
export declare class HdinsightInteractiveQueryClusterRolesWorkerNodeAutoscaleRecurrenceScheduleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HdinsightInteractiveQueryClusterRolesWorkerNodeAutoscaleRecurrenceSchedule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HdinsightInteractiveQueryClusterRolesWorkerNodeAutoscaleRecurrenceScheduleOutputReference;
}
export interface HdinsightInteractiveQueryClusterRolesWorkerNodeAutoscaleRecurrence {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#timezone HdinsightInteractiveQueryCluster#timezone}
    */
    readonly timezone: string;
    /**
    * schedule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#schedule HdinsightInteractiveQueryCluster#schedule}
    */
    readonly schedule: HdinsightInteractiveQueryClusterRolesWorkerNodeAutoscaleRecurrenceSchedule[] | cdktf.IResolvable;
}
export declare function hdinsightInteractiveQueryClusterRolesWorkerNodeAutoscaleRecurrenceToTerraform(struct?: HdinsightInteractiveQueryClusterRolesWorkerNodeAutoscaleRecurrenceOutputReference | HdinsightInteractiveQueryClusterRolesWorkerNodeAutoscaleRecurrence): any;
export declare class HdinsightInteractiveQueryClusterRolesWorkerNodeAutoscaleRecurrenceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightInteractiveQueryClusterRolesWorkerNodeAutoscaleRecurrence | undefined;
    set internalValue(value: HdinsightInteractiveQueryClusterRolesWorkerNodeAutoscaleRecurrence | undefined);
    private _timezone?;
    get timezone(): string;
    set timezone(value: string);
    get timezoneInput(): string | undefined;
    private _schedule;
    get schedule(): HdinsightInteractiveQueryClusterRolesWorkerNodeAutoscaleRecurrenceScheduleList;
    putSchedule(value: HdinsightInteractiveQueryClusterRolesWorkerNodeAutoscaleRecurrenceSchedule[] | cdktf.IResolvable): void;
    get scheduleInput(): cdktf.IResolvable | HdinsightInteractiveQueryClusterRolesWorkerNodeAutoscaleRecurrenceSchedule[] | undefined;
}
export interface HdinsightInteractiveQueryClusterRolesWorkerNodeAutoscale {
    /**
    * capacity block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#capacity HdinsightInteractiveQueryCluster#capacity}
    */
    readonly capacity?: HdinsightInteractiveQueryClusterRolesWorkerNodeAutoscaleCapacity;
    /**
    * recurrence block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#recurrence HdinsightInteractiveQueryCluster#recurrence}
    */
    readonly recurrence?: HdinsightInteractiveQueryClusterRolesWorkerNodeAutoscaleRecurrence;
}
export declare function hdinsightInteractiveQueryClusterRolesWorkerNodeAutoscaleToTerraform(struct?: HdinsightInteractiveQueryClusterRolesWorkerNodeAutoscaleOutputReference | HdinsightInteractiveQueryClusterRolesWorkerNodeAutoscale): any;
export declare class HdinsightInteractiveQueryClusterRolesWorkerNodeAutoscaleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightInteractiveQueryClusterRolesWorkerNodeAutoscale | undefined;
    set internalValue(value: HdinsightInteractiveQueryClusterRolesWorkerNodeAutoscale | undefined);
    private _capacity;
    get capacity(): HdinsightInteractiveQueryClusterRolesWorkerNodeAutoscaleCapacityOutputReference;
    putCapacity(value: HdinsightInteractiveQueryClusterRolesWorkerNodeAutoscaleCapacity): void;
    resetCapacity(): void;
    get capacityInput(): HdinsightInteractiveQueryClusterRolesWorkerNodeAutoscaleCapacity | undefined;
    private _recurrence;
    get recurrence(): HdinsightInteractiveQueryClusterRolesWorkerNodeAutoscaleRecurrenceOutputReference;
    putRecurrence(value: HdinsightInteractiveQueryClusterRolesWorkerNodeAutoscaleRecurrence): void;
    resetRecurrence(): void;
    get recurrenceInput(): HdinsightInteractiveQueryClusterRolesWorkerNodeAutoscaleRecurrence | undefined;
}
export interface HdinsightInteractiveQueryClusterRolesWorkerNode {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#password HdinsightInteractiveQueryCluster#password}
    */
    readonly password?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#ssh_keys HdinsightInteractiveQueryCluster#ssh_keys}
    */
    readonly sshKeys?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#subnet_id HdinsightInteractiveQueryCluster#subnet_id}
    */
    readonly subnetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#target_instance_count HdinsightInteractiveQueryCluster#target_instance_count}
    */
    readonly targetInstanceCount: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#username HdinsightInteractiveQueryCluster#username}
    */
    readonly username: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#virtual_network_id HdinsightInteractiveQueryCluster#virtual_network_id}
    */
    readonly virtualNetworkId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#vm_size HdinsightInteractiveQueryCluster#vm_size}
    */
    readonly vmSize: string;
    /**
    * autoscale block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#autoscale HdinsightInteractiveQueryCluster#autoscale}
    */
    readonly autoscale?: HdinsightInteractiveQueryClusterRolesWorkerNodeAutoscale;
}
export declare function hdinsightInteractiveQueryClusterRolesWorkerNodeToTerraform(struct?: HdinsightInteractiveQueryClusterRolesWorkerNodeOutputReference | HdinsightInteractiveQueryClusterRolesWorkerNode): any;
export declare class HdinsightInteractiveQueryClusterRolesWorkerNodeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightInteractiveQueryClusterRolesWorkerNode | undefined;
    set internalValue(value: HdinsightInteractiveQueryClusterRolesWorkerNode | undefined);
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _sshKeys?;
    get sshKeys(): string[];
    set sshKeys(value: string[]);
    resetSshKeys(): void;
    get sshKeysInput(): string[] | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    resetSubnetId(): void;
    get subnetIdInput(): string | undefined;
    private _targetInstanceCount?;
    get targetInstanceCount(): number;
    set targetInstanceCount(value: number);
    get targetInstanceCountInput(): number | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
    private _virtualNetworkId?;
    get virtualNetworkId(): string;
    set virtualNetworkId(value: string);
    resetVirtualNetworkId(): void;
    get virtualNetworkIdInput(): string | undefined;
    private _vmSize?;
    get vmSize(): string;
    set vmSize(value: string);
    get vmSizeInput(): string | undefined;
    private _autoscale;
    get autoscale(): HdinsightInteractiveQueryClusterRolesWorkerNodeAutoscaleOutputReference;
    putAutoscale(value: HdinsightInteractiveQueryClusterRolesWorkerNodeAutoscale): void;
    resetAutoscale(): void;
    get autoscaleInput(): HdinsightInteractiveQueryClusterRolesWorkerNodeAutoscale | undefined;
}
export interface HdinsightInteractiveQueryClusterRolesZookeeperNode {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#password HdinsightInteractiveQueryCluster#password}
    */
    readonly password?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#ssh_keys HdinsightInteractiveQueryCluster#ssh_keys}
    */
    readonly sshKeys?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#subnet_id HdinsightInteractiveQueryCluster#subnet_id}
    */
    readonly subnetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#username HdinsightInteractiveQueryCluster#username}
    */
    readonly username: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#virtual_network_id HdinsightInteractiveQueryCluster#virtual_network_id}
    */
    readonly virtualNetworkId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#vm_size HdinsightInteractiveQueryCluster#vm_size}
    */
    readonly vmSize: string;
}
export declare function hdinsightInteractiveQueryClusterRolesZookeeperNodeToTerraform(struct?: HdinsightInteractiveQueryClusterRolesZookeeperNodeOutputReference | HdinsightInteractiveQueryClusterRolesZookeeperNode): any;
export declare class HdinsightInteractiveQueryClusterRolesZookeeperNodeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightInteractiveQueryClusterRolesZookeeperNode | undefined;
    set internalValue(value: HdinsightInteractiveQueryClusterRolesZookeeperNode | undefined);
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _sshKeys?;
    get sshKeys(): string[];
    set sshKeys(value: string[]);
    resetSshKeys(): void;
    get sshKeysInput(): string[] | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    resetSubnetId(): void;
    get subnetIdInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
    private _virtualNetworkId?;
    get virtualNetworkId(): string;
    set virtualNetworkId(value: string);
    resetVirtualNetworkId(): void;
    get virtualNetworkIdInput(): string | undefined;
    private _vmSize?;
    get vmSize(): string;
    set vmSize(value: string);
    get vmSizeInput(): string | undefined;
}
export interface HdinsightInteractiveQueryClusterRoles {
    /**
    * head_node block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#head_node HdinsightInteractiveQueryCluster#head_node}
    */
    readonly headNode: HdinsightInteractiveQueryClusterRolesHeadNode;
    /**
    * worker_node block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#worker_node HdinsightInteractiveQueryCluster#worker_node}
    */
    readonly workerNode: HdinsightInteractiveQueryClusterRolesWorkerNode;
    /**
    * zookeeper_node block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#zookeeper_node HdinsightInteractiveQueryCluster#zookeeper_node}
    */
    readonly zookeeperNode: HdinsightInteractiveQueryClusterRolesZookeeperNode;
}
export declare function hdinsightInteractiveQueryClusterRolesToTerraform(struct?: HdinsightInteractiveQueryClusterRolesOutputReference | HdinsightInteractiveQueryClusterRoles): any;
export declare class HdinsightInteractiveQueryClusterRolesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightInteractiveQueryClusterRoles | undefined;
    set internalValue(value: HdinsightInteractiveQueryClusterRoles | undefined);
    private _headNode;
    get headNode(): HdinsightInteractiveQueryClusterRolesHeadNodeOutputReference;
    putHeadNode(value: HdinsightInteractiveQueryClusterRolesHeadNode): void;
    get headNodeInput(): HdinsightInteractiveQueryClusterRolesHeadNode | undefined;
    private _workerNode;
    get workerNode(): HdinsightInteractiveQueryClusterRolesWorkerNodeOutputReference;
    putWorkerNode(value: HdinsightInteractiveQueryClusterRolesWorkerNode): void;
    get workerNodeInput(): HdinsightInteractiveQueryClusterRolesWorkerNode | undefined;
    private _zookeeperNode;
    get zookeeperNode(): HdinsightInteractiveQueryClusterRolesZookeeperNodeOutputReference;
    putZookeeperNode(value: HdinsightInteractiveQueryClusterRolesZookeeperNode): void;
    get zookeeperNodeInput(): HdinsightInteractiveQueryClusterRolesZookeeperNode | undefined;
}
export interface HdinsightInteractiveQueryClusterSecurityProfile {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#aadds_resource_id HdinsightInteractiveQueryCluster#aadds_resource_id}
    */
    readonly aaddsResourceId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#cluster_users_group_dns HdinsightInteractiveQueryCluster#cluster_users_group_dns}
    */
    readonly clusterUsersGroupDns?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#domain_name HdinsightInteractiveQueryCluster#domain_name}
    */
    readonly domainName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#domain_user_password HdinsightInteractiveQueryCluster#domain_user_password}
    */
    readonly domainUserPassword: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#domain_username HdinsightInteractiveQueryCluster#domain_username}
    */
    readonly domainUsername: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#ldaps_urls HdinsightInteractiveQueryCluster#ldaps_urls}
    */
    readonly ldapsUrls: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#msi_resource_id HdinsightInteractiveQueryCluster#msi_resource_id}
    */
    readonly msiResourceId: string;
}
export declare function hdinsightInteractiveQueryClusterSecurityProfileToTerraform(struct?: HdinsightInteractiveQueryClusterSecurityProfileOutputReference | HdinsightInteractiveQueryClusterSecurityProfile): any;
export declare class HdinsightInteractiveQueryClusterSecurityProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightInteractiveQueryClusterSecurityProfile | undefined;
    set internalValue(value: HdinsightInteractiveQueryClusterSecurityProfile | undefined);
    private _aaddsResourceId?;
    get aaddsResourceId(): string;
    set aaddsResourceId(value: string);
    get aaddsResourceIdInput(): string | undefined;
    private _clusterUsersGroupDns?;
    get clusterUsersGroupDns(): string[];
    set clusterUsersGroupDns(value: string[]);
    resetClusterUsersGroupDns(): void;
    get clusterUsersGroupDnsInput(): string[] | undefined;
    private _domainName?;
    get domainName(): string;
    set domainName(value: string);
    get domainNameInput(): string | undefined;
    private _domainUserPassword?;
    get domainUserPassword(): string;
    set domainUserPassword(value: string);
    get domainUserPasswordInput(): string | undefined;
    private _domainUsername?;
    get domainUsername(): string;
    set domainUsername(value: string);
    get domainUsernameInput(): string | undefined;
    private _ldapsUrls?;
    get ldapsUrls(): string[];
    set ldapsUrls(value: string[]);
    get ldapsUrlsInput(): string[] | undefined;
    private _msiResourceId?;
    get msiResourceId(): string;
    set msiResourceId(value: string);
    get msiResourceIdInput(): string | undefined;
}
export interface HdinsightInteractiveQueryClusterStorageAccount {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#is_default HdinsightInteractiveQueryCluster#is_default}
    */
    readonly isDefault: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#storage_account_key HdinsightInteractiveQueryCluster#storage_account_key}
    */
    readonly storageAccountKey: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#storage_container_id HdinsightInteractiveQueryCluster#storage_container_id}
    */
    readonly storageContainerId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#storage_resource_id HdinsightInteractiveQueryCluster#storage_resource_id}
    */
    readonly storageResourceId?: string;
}
export declare function hdinsightInteractiveQueryClusterStorageAccountToTerraform(struct?: HdinsightInteractiveQueryClusterStorageAccount | cdktf.IResolvable): any;
export declare class HdinsightInteractiveQueryClusterStorageAccountOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HdinsightInteractiveQueryClusterStorageAccount | cdktf.IResolvable | undefined;
    set internalValue(value: HdinsightInteractiveQueryClusterStorageAccount | cdktf.IResolvable | undefined);
    private _isDefault?;
    get isDefault(): boolean | cdktf.IResolvable;
    set isDefault(value: boolean | cdktf.IResolvable);
    get isDefaultInput(): boolean | cdktf.IResolvable | undefined;
    private _storageAccountKey?;
    get storageAccountKey(): string;
    set storageAccountKey(value: string);
    get storageAccountKeyInput(): string | undefined;
    private _storageContainerId?;
    get storageContainerId(): string;
    set storageContainerId(value: string);
    get storageContainerIdInput(): string | undefined;
    private _storageResourceId?;
    get storageResourceId(): string;
    set storageResourceId(value: string);
    resetStorageResourceId(): void;
    get storageResourceIdInput(): string | undefined;
}
export declare class HdinsightInteractiveQueryClusterStorageAccountList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HdinsightInteractiveQueryClusterStorageAccount[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HdinsightInteractiveQueryClusterStorageAccountOutputReference;
}
export interface HdinsightInteractiveQueryClusterStorageAccountGen2 {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#filesystem_id HdinsightInteractiveQueryCluster#filesystem_id}
    */
    readonly filesystemId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#is_default HdinsightInteractiveQueryCluster#is_default}
    */
    readonly isDefault: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#managed_identity_resource_id HdinsightInteractiveQueryCluster#managed_identity_resource_id}
    */
    readonly managedIdentityResourceId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#storage_resource_id HdinsightInteractiveQueryCluster#storage_resource_id}
    */
    readonly storageResourceId: string;
}
export declare function hdinsightInteractiveQueryClusterStorageAccountGen2ToTerraform(struct?: HdinsightInteractiveQueryClusterStorageAccountGen2OutputReference | HdinsightInteractiveQueryClusterStorageAccountGen2): any;
export declare class HdinsightInteractiveQueryClusterStorageAccountGen2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightInteractiveQueryClusterStorageAccountGen2 | undefined;
    set internalValue(value: HdinsightInteractiveQueryClusterStorageAccountGen2 | undefined);
    private _filesystemId?;
    get filesystemId(): string;
    set filesystemId(value: string);
    get filesystemIdInput(): string | undefined;
    private _isDefault?;
    get isDefault(): boolean | cdktf.IResolvable;
    set isDefault(value: boolean | cdktf.IResolvable);
    get isDefaultInput(): boolean | cdktf.IResolvable | undefined;
    private _managedIdentityResourceId?;
    get managedIdentityResourceId(): string;
    set managedIdentityResourceId(value: string);
    get managedIdentityResourceIdInput(): string | undefined;
    private _storageResourceId?;
    get storageResourceId(): string;
    set storageResourceId(value: string);
    get storageResourceIdInput(): string | undefined;
}
export interface HdinsightInteractiveQueryClusterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#create HdinsightInteractiveQueryCluster#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#delete HdinsightInteractiveQueryCluster#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#read HdinsightInteractiveQueryCluster#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#update HdinsightInteractiveQueryCluster#update}
    */
    readonly update?: string;
}
export declare function hdinsightInteractiveQueryClusterTimeoutsToTerraform(struct?: HdinsightInteractiveQueryClusterTimeoutsOutputReference | HdinsightInteractiveQueryClusterTimeouts | cdktf.IResolvable): any;
export declare class HdinsightInteractiveQueryClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightInteractiveQueryClusterTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: HdinsightInteractiveQueryClusterTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster azurerm_hdinsight_interactive_query_cluster}
*/
export declare class HdinsightInteractiveQueryCluster extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_hdinsight_interactive_query_cluster";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster azurerm_hdinsight_interactive_query_cluster} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options HdinsightInteractiveQueryClusterConfig
    */
    constructor(scope: Construct, id: string, config: HdinsightInteractiveQueryClusterConfig);
    private _clusterVersion?;
    get clusterVersion(): string;
    set clusterVersion(value: string);
    get clusterVersionInput(): string | undefined;
    private _encryptionInTransitEnabled?;
    get encryptionInTransitEnabled(): boolean | cdktf.IResolvable;
    set encryptionInTransitEnabled(value: boolean | cdktf.IResolvable);
    resetEncryptionInTransitEnabled(): void;
    get encryptionInTransitEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get httpsEndpoint(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get sshEndpoint(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _tier?;
    get tier(): string;
    set tier(value: string);
    get tierInput(): string | undefined;
    private _tlsMinVersion?;
    get tlsMinVersion(): string;
    set tlsMinVersion(value: string);
    resetTlsMinVersion(): void;
    get tlsMinVersionInput(): string | undefined;
    private _componentVersion;
    get componentVersion(): HdinsightInteractiveQueryClusterComponentVersionOutputReference;
    putComponentVersion(value: HdinsightInteractiveQueryClusterComponentVersion): void;
    get componentVersionInput(): HdinsightInteractiveQueryClusterComponentVersion | undefined;
    private _diskEncryption;
    get diskEncryption(): HdinsightInteractiveQueryClusterDiskEncryptionList;
    putDiskEncryption(value: HdinsightInteractiveQueryClusterDiskEncryption[] | cdktf.IResolvable): void;
    resetDiskEncryption(): void;
    get diskEncryptionInput(): cdktf.IResolvable | HdinsightInteractiveQueryClusterDiskEncryption[] | undefined;
    private _extension;
    get extension(): HdinsightInteractiveQueryClusterExtensionOutputReference;
    putExtension(value: HdinsightInteractiveQueryClusterExtension): void;
    resetExtension(): void;
    get extensionInput(): HdinsightInteractiveQueryClusterExtension | undefined;
    private _gateway;
    get gateway(): HdinsightInteractiveQueryClusterGatewayOutputReference;
    putGateway(value: HdinsightInteractiveQueryClusterGateway): void;
    get gatewayInput(): HdinsightInteractiveQueryClusterGateway | undefined;
    private _metastores;
    get metastores(): HdinsightInteractiveQueryClusterMetastoresOutputReference;
    putMetastores(value: HdinsightInteractiveQueryClusterMetastores): void;
    resetMetastores(): void;
    get metastoresInput(): HdinsightInteractiveQueryClusterMetastores | undefined;
    private _monitor;
    get monitor(): HdinsightInteractiveQueryClusterMonitorOutputReference;
    putMonitor(value: HdinsightInteractiveQueryClusterMonitor): void;
    resetMonitor(): void;
    get monitorInput(): HdinsightInteractiveQueryClusterMonitor | undefined;
    private _network;
    get network(): HdinsightInteractiveQueryClusterNetworkOutputReference;
    putNetwork(value: HdinsightInteractiveQueryClusterNetwork): void;
    resetNetwork(): void;
    get networkInput(): HdinsightInteractiveQueryClusterNetwork | undefined;
    private _roles;
    get roles(): HdinsightInteractiveQueryClusterRolesOutputReference;
    putRoles(value: HdinsightInteractiveQueryClusterRoles): void;
    get rolesInput(): HdinsightInteractiveQueryClusterRoles | undefined;
    private _securityProfile;
    get securityProfile(): HdinsightInteractiveQueryClusterSecurityProfileOutputReference;
    putSecurityProfile(value: HdinsightInteractiveQueryClusterSecurityProfile): void;
    resetSecurityProfile(): void;
    get securityProfileInput(): HdinsightInteractiveQueryClusterSecurityProfile | undefined;
    private _storageAccount;
    get storageAccount(): HdinsightInteractiveQueryClusterStorageAccountList;
    putStorageAccount(value: HdinsightInteractiveQueryClusterStorageAccount[] | cdktf.IResolvable): void;
    resetStorageAccount(): void;
    get storageAccountInput(): cdktf.IResolvable | HdinsightInteractiveQueryClusterStorageAccount[] | undefined;
    private _storageAccountGen2;
    get storageAccountGen2(): HdinsightInteractiveQueryClusterStorageAccountGen2OutputReference;
    putStorageAccountGen2(value: HdinsightInteractiveQueryClusterStorageAccountGen2): void;
    resetStorageAccountGen2(): void;
    get storageAccountGen2Input(): HdinsightInteractiveQueryClusterStorageAccountGen2 | undefined;
    private _timeouts;
    get timeouts(): HdinsightInteractiveQueryClusterTimeoutsOutputReference;
    putTimeouts(value: HdinsightInteractiveQueryClusterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | HdinsightInteractiveQueryClusterTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
