import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ManagementGroupSubscriptionAssociationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/management_group_subscription_association#id ManagementGroupSubscriptionAssociation#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/management_group_subscription_association#management_group_id ManagementGroupSubscriptionAssociation#management_group_id}
    */
    readonly managementGroupId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/management_group_subscription_association#subscription_id ManagementGroupSubscriptionAssociation#subscription_id}
    */
    readonly subscriptionId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/management_group_subscription_association#timeouts ManagementGroupSubscriptionAssociation#timeouts}
    */
    readonly timeouts?: ManagementGroupSubscriptionAssociationTimeouts;
}
export interface ManagementGroupSubscriptionAssociationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/management_group_subscription_association#create ManagementGroupSubscriptionAssociation#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/management_group_subscription_association#delete ManagementGroupSubscriptionAssociation#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/management_group_subscription_association#read ManagementGroupSubscriptionAssociation#read}
    */
    readonly read?: string;
}
export declare function managementGroupSubscriptionAssociationTimeoutsToTerraform(struct?: ManagementGroupSubscriptionAssociationTimeoutsOutputReference | ManagementGroupSubscriptionAssociationTimeouts | cdktf.IResolvable): any;
export declare class ManagementGroupSubscriptionAssociationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ManagementGroupSubscriptionAssociationTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ManagementGroupSubscriptionAssociationTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/management_group_subscription_association azurerm_management_group_subscription_association}
*/
export declare class ManagementGroupSubscriptionAssociation extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_management_group_subscription_association";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/management_group_subscription_association azurerm_management_group_subscription_association} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ManagementGroupSubscriptionAssociationConfig
    */
    constructor(scope: Construct, id: string, config: ManagementGroupSubscriptionAssociationConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _managementGroupId?;
    get managementGroupId(): string;
    set managementGroupId(value: string);
    get managementGroupIdInput(): string | undefined;
    private _subscriptionId?;
    get subscriptionId(): string;
    set subscriptionId(value: string);
    get subscriptionIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): ManagementGroupSubscriptionAssociationTimeoutsOutputReference;
    putTimeouts(value: ManagementGroupSubscriptionAssociationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ManagementGroupSubscriptionAssociationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
