import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MonitorActionGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#enabled MonitorActionGroup#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#id MonitorActionGroup#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#name MonitorActionGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#resource_group_name MonitorActionGroup#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#short_name MonitorActionGroup#short_name}
    */
    readonly shortName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#tags MonitorActionGroup#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * arm_role_receiver block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#arm_role_receiver MonitorActionGroup#arm_role_receiver}
    */
    readonly armRoleReceiver?: MonitorActionGroupArmRoleReceiver[] | cdktf.IResolvable;
    /**
    * automation_runbook_receiver block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#automation_runbook_receiver MonitorActionGroup#automation_runbook_receiver}
    */
    readonly automationRunbookReceiver?: MonitorActionGroupAutomationRunbookReceiver[] | cdktf.IResolvable;
    /**
    * azure_app_push_receiver block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#azure_app_push_receiver MonitorActionGroup#azure_app_push_receiver}
    */
    readonly azureAppPushReceiver?: MonitorActionGroupAzureAppPushReceiver[] | cdktf.IResolvable;
    /**
    * azure_function_receiver block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#azure_function_receiver MonitorActionGroup#azure_function_receiver}
    */
    readonly azureFunctionReceiver?: MonitorActionGroupAzureFunctionReceiver[] | cdktf.IResolvable;
    /**
    * email_receiver block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#email_receiver MonitorActionGroup#email_receiver}
    */
    readonly emailReceiver?: MonitorActionGroupEmailReceiver[] | cdktf.IResolvable;
    /**
    * event_hub_receiver block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#event_hub_receiver MonitorActionGroup#event_hub_receiver}
    */
    readonly eventHubReceiver?: MonitorActionGroupEventHubReceiver[] | cdktf.IResolvable;
    /**
    * itsm_receiver block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#itsm_receiver MonitorActionGroup#itsm_receiver}
    */
    readonly itsmReceiver?: MonitorActionGroupItsmReceiver[] | cdktf.IResolvable;
    /**
    * logic_app_receiver block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#logic_app_receiver MonitorActionGroup#logic_app_receiver}
    */
    readonly logicAppReceiver?: MonitorActionGroupLogicAppReceiver[] | cdktf.IResolvable;
    /**
    * sms_receiver block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#sms_receiver MonitorActionGroup#sms_receiver}
    */
    readonly smsReceiver?: MonitorActionGroupSmsReceiver[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#timeouts MonitorActionGroup#timeouts}
    */
    readonly timeouts?: MonitorActionGroupTimeouts;
    /**
    * voice_receiver block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#voice_receiver MonitorActionGroup#voice_receiver}
    */
    readonly voiceReceiver?: MonitorActionGroupVoiceReceiver[] | cdktf.IResolvable;
    /**
    * webhook_receiver block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#webhook_receiver MonitorActionGroup#webhook_receiver}
    */
    readonly webhookReceiver?: MonitorActionGroupWebhookReceiver[] | cdktf.IResolvable;
}
export interface MonitorActionGroupArmRoleReceiver {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#name MonitorActionGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#role_id MonitorActionGroup#role_id}
    */
    readonly roleId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#use_common_alert_schema MonitorActionGroup#use_common_alert_schema}
    */
    readonly useCommonAlertSchema?: boolean | cdktf.IResolvable;
}
export declare function monitorActionGroupArmRoleReceiverToTerraform(struct?: MonitorActionGroupArmRoleReceiver | cdktf.IResolvable): any;
export declare class MonitorActionGroupArmRoleReceiverOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MonitorActionGroupArmRoleReceiver | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorActionGroupArmRoleReceiver | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _roleId?;
    get roleId(): string;
    set roleId(value: string);
    get roleIdInput(): string | undefined;
    private _useCommonAlertSchema?;
    get useCommonAlertSchema(): boolean | cdktf.IResolvable;
    set useCommonAlertSchema(value: boolean | cdktf.IResolvable);
    resetUseCommonAlertSchema(): void;
    get useCommonAlertSchemaInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class MonitorActionGroupArmRoleReceiverList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MonitorActionGroupArmRoleReceiver[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MonitorActionGroupArmRoleReceiverOutputReference;
}
export interface MonitorActionGroupAutomationRunbookReceiver {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#automation_account_id MonitorActionGroup#automation_account_id}
    */
    readonly automationAccountId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#is_global_runbook MonitorActionGroup#is_global_runbook}
    */
    readonly isGlobalRunbook: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#name MonitorActionGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#runbook_name MonitorActionGroup#runbook_name}
    */
    readonly runbookName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#service_uri MonitorActionGroup#service_uri}
    */
    readonly serviceUri: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#use_common_alert_schema MonitorActionGroup#use_common_alert_schema}
    */
    readonly useCommonAlertSchema?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#webhook_resource_id MonitorActionGroup#webhook_resource_id}
    */
    readonly webhookResourceId: string;
}
export declare function monitorActionGroupAutomationRunbookReceiverToTerraform(struct?: MonitorActionGroupAutomationRunbookReceiver | cdktf.IResolvable): any;
export declare class MonitorActionGroupAutomationRunbookReceiverOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MonitorActionGroupAutomationRunbookReceiver | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorActionGroupAutomationRunbookReceiver | cdktf.IResolvable | undefined);
    private _automationAccountId?;
    get automationAccountId(): string;
    set automationAccountId(value: string);
    get automationAccountIdInput(): string | undefined;
    private _isGlobalRunbook?;
    get isGlobalRunbook(): boolean | cdktf.IResolvable;
    set isGlobalRunbook(value: boolean | cdktf.IResolvable);
    get isGlobalRunbookInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _runbookName?;
    get runbookName(): string;
    set runbookName(value: string);
    get runbookNameInput(): string | undefined;
    private _serviceUri?;
    get serviceUri(): string;
    set serviceUri(value: string);
    get serviceUriInput(): string | undefined;
    private _useCommonAlertSchema?;
    get useCommonAlertSchema(): boolean | cdktf.IResolvable;
    set useCommonAlertSchema(value: boolean | cdktf.IResolvable);
    resetUseCommonAlertSchema(): void;
    get useCommonAlertSchemaInput(): boolean | cdktf.IResolvable | undefined;
    private _webhookResourceId?;
    get webhookResourceId(): string;
    set webhookResourceId(value: string);
    get webhookResourceIdInput(): string | undefined;
}
export declare class MonitorActionGroupAutomationRunbookReceiverList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MonitorActionGroupAutomationRunbookReceiver[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MonitorActionGroupAutomationRunbookReceiverOutputReference;
}
export interface MonitorActionGroupAzureAppPushReceiver {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#email_address MonitorActionGroup#email_address}
    */
    readonly emailAddress: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#name MonitorActionGroup#name}
    */
    readonly name: string;
}
export declare function monitorActionGroupAzureAppPushReceiverToTerraform(struct?: MonitorActionGroupAzureAppPushReceiver | cdktf.IResolvable): any;
export declare class MonitorActionGroupAzureAppPushReceiverOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MonitorActionGroupAzureAppPushReceiver | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorActionGroupAzureAppPushReceiver | cdktf.IResolvable | undefined);
    private _emailAddress?;
    get emailAddress(): string;
    set emailAddress(value: string);
    get emailAddressInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export declare class MonitorActionGroupAzureAppPushReceiverList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MonitorActionGroupAzureAppPushReceiver[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MonitorActionGroupAzureAppPushReceiverOutputReference;
}
export interface MonitorActionGroupAzureFunctionReceiver {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#function_app_resource_id MonitorActionGroup#function_app_resource_id}
    */
    readonly functionAppResourceId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#function_name MonitorActionGroup#function_name}
    */
    readonly functionName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#http_trigger_url MonitorActionGroup#http_trigger_url}
    */
    readonly httpTriggerUrl: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#name MonitorActionGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#use_common_alert_schema MonitorActionGroup#use_common_alert_schema}
    */
    readonly useCommonAlertSchema?: boolean | cdktf.IResolvable;
}
export declare function monitorActionGroupAzureFunctionReceiverToTerraform(struct?: MonitorActionGroupAzureFunctionReceiver | cdktf.IResolvable): any;
export declare class MonitorActionGroupAzureFunctionReceiverOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MonitorActionGroupAzureFunctionReceiver | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorActionGroupAzureFunctionReceiver | cdktf.IResolvable | undefined);
    private _functionAppResourceId?;
    get functionAppResourceId(): string;
    set functionAppResourceId(value: string);
    get functionAppResourceIdInput(): string | undefined;
    private _functionName?;
    get functionName(): string;
    set functionName(value: string);
    get functionNameInput(): string | undefined;
    private _httpTriggerUrl?;
    get httpTriggerUrl(): string;
    set httpTriggerUrl(value: string);
    get httpTriggerUrlInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _useCommonAlertSchema?;
    get useCommonAlertSchema(): boolean | cdktf.IResolvable;
    set useCommonAlertSchema(value: boolean | cdktf.IResolvable);
    resetUseCommonAlertSchema(): void;
    get useCommonAlertSchemaInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class MonitorActionGroupAzureFunctionReceiverList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MonitorActionGroupAzureFunctionReceiver[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MonitorActionGroupAzureFunctionReceiverOutputReference;
}
export interface MonitorActionGroupEmailReceiver {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#email_address MonitorActionGroup#email_address}
    */
    readonly emailAddress: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#name MonitorActionGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#use_common_alert_schema MonitorActionGroup#use_common_alert_schema}
    */
    readonly useCommonAlertSchema?: boolean | cdktf.IResolvable;
}
export declare function monitorActionGroupEmailReceiverToTerraform(struct?: MonitorActionGroupEmailReceiver | cdktf.IResolvable): any;
export declare class MonitorActionGroupEmailReceiverOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MonitorActionGroupEmailReceiver | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorActionGroupEmailReceiver | cdktf.IResolvable | undefined);
    private _emailAddress?;
    get emailAddress(): string;
    set emailAddress(value: string);
    get emailAddressInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _useCommonAlertSchema?;
    get useCommonAlertSchema(): boolean | cdktf.IResolvable;
    set useCommonAlertSchema(value: boolean | cdktf.IResolvable);
    resetUseCommonAlertSchema(): void;
    get useCommonAlertSchemaInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class MonitorActionGroupEmailReceiverList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MonitorActionGroupEmailReceiver[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MonitorActionGroupEmailReceiverOutputReference;
}
export interface MonitorActionGroupEventHubReceiver {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#event_hub_id MonitorActionGroup#event_hub_id}
    */
    readonly eventHubId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#event_hub_name MonitorActionGroup#event_hub_name}
    */
    readonly eventHubName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#event_hub_namespace MonitorActionGroup#event_hub_namespace}
    */
    readonly eventHubNamespace?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#name MonitorActionGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#subscription_id MonitorActionGroup#subscription_id}
    */
    readonly subscriptionId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#tenant_id MonitorActionGroup#tenant_id}
    */
    readonly tenantId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#use_common_alert_schema MonitorActionGroup#use_common_alert_schema}
    */
    readonly useCommonAlertSchema?: boolean | cdktf.IResolvable;
}
export declare function monitorActionGroupEventHubReceiverToTerraform(struct?: MonitorActionGroupEventHubReceiver | cdktf.IResolvable): any;
export declare class MonitorActionGroupEventHubReceiverOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MonitorActionGroupEventHubReceiver | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorActionGroupEventHubReceiver | cdktf.IResolvable | undefined);
    private _eventHubId?;
    get eventHubId(): string;
    set eventHubId(value: string);
    resetEventHubId(): void;
    get eventHubIdInput(): string | undefined;
    private _eventHubName?;
    get eventHubName(): string;
    set eventHubName(value: string);
    resetEventHubName(): void;
    get eventHubNameInput(): string | undefined;
    private _eventHubNamespace?;
    get eventHubNamespace(): string;
    set eventHubNamespace(value: string);
    resetEventHubNamespace(): void;
    get eventHubNamespaceInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _subscriptionId?;
    get subscriptionId(): string;
    set subscriptionId(value: string);
    resetSubscriptionId(): void;
    get subscriptionIdInput(): string | undefined;
    private _tenantId?;
    get tenantId(): string;
    set tenantId(value: string);
    resetTenantId(): void;
    get tenantIdInput(): string | undefined;
    private _useCommonAlertSchema?;
    get useCommonAlertSchema(): boolean | cdktf.IResolvable;
    set useCommonAlertSchema(value: boolean | cdktf.IResolvable);
    resetUseCommonAlertSchema(): void;
    get useCommonAlertSchemaInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class MonitorActionGroupEventHubReceiverList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MonitorActionGroupEventHubReceiver[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MonitorActionGroupEventHubReceiverOutputReference;
}
export interface MonitorActionGroupItsmReceiver {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#connection_id MonitorActionGroup#connection_id}
    */
    readonly connectionId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#name MonitorActionGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#region MonitorActionGroup#region}
    */
    readonly region: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#ticket_configuration MonitorActionGroup#ticket_configuration}
    */
    readonly ticketConfiguration: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#workspace_id MonitorActionGroup#workspace_id}
    */
    readonly workspaceId: string;
}
export declare function monitorActionGroupItsmReceiverToTerraform(struct?: MonitorActionGroupItsmReceiver | cdktf.IResolvable): any;
export declare class MonitorActionGroupItsmReceiverOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MonitorActionGroupItsmReceiver | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorActionGroupItsmReceiver | cdktf.IResolvable | undefined);
    private _connectionId?;
    get connectionId(): string;
    set connectionId(value: string);
    get connectionIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    get regionInput(): string | undefined;
    private _ticketConfiguration?;
    get ticketConfiguration(): string;
    set ticketConfiguration(value: string);
    get ticketConfigurationInput(): string | undefined;
    private _workspaceId?;
    get workspaceId(): string;
    set workspaceId(value: string);
    get workspaceIdInput(): string | undefined;
}
export declare class MonitorActionGroupItsmReceiverList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MonitorActionGroupItsmReceiver[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MonitorActionGroupItsmReceiverOutputReference;
}
export interface MonitorActionGroupLogicAppReceiver {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#callback_url MonitorActionGroup#callback_url}
    */
    readonly callbackUrl: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#name MonitorActionGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#resource_id MonitorActionGroup#resource_id}
    */
    readonly resourceId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#use_common_alert_schema MonitorActionGroup#use_common_alert_schema}
    */
    readonly useCommonAlertSchema?: boolean | cdktf.IResolvable;
}
export declare function monitorActionGroupLogicAppReceiverToTerraform(struct?: MonitorActionGroupLogicAppReceiver | cdktf.IResolvable): any;
export declare class MonitorActionGroupLogicAppReceiverOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MonitorActionGroupLogicAppReceiver | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorActionGroupLogicAppReceiver | cdktf.IResolvable | undefined);
    private _callbackUrl?;
    get callbackUrl(): string;
    set callbackUrl(value: string);
    get callbackUrlInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceId?;
    get resourceId(): string;
    set resourceId(value: string);
    get resourceIdInput(): string | undefined;
    private _useCommonAlertSchema?;
    get useCommonAlertSchema(): boolean | cdktf.IResolvable;
    set useCommonAlertSchema(value: boolean | cdktf.IResolvable);
    resetUseCommonAlertSchema(): void;
    get useCommonAlertSchemaInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class MonitorActionGroupLogicAppReceiverList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MonitorActionGroupLogicAppReceiver[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MonitorActionGroupLogicAppReceiverOutputReference;
}
export interface MonitorActionGroupSmsReceiver {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#country_code MonitorActionGroup#country_code}
    */
    readonly countryCode: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#name MonitorActionGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#phone_number MonitorActionGroup#phone_number}
    */
    readonly phoneNumber: string;
}
export declare function monitorActionGroupSmsReceiverToTerraform(struct?: MonitorActionGroupSmsReceiver | cdktf.IResolvable): any;
export declare class MonitorActionGroupSmsReceiverOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MonitorActionGroupSmsReceiver | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorActionGroupSmsReceiver | cdktf.IResolvable | undefined);
    private _countryCode?;
    get countryCode(): string;
    set countryCode(value: string);
    get countryCodeInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _phoneNumber?;
    get phoneNumber(): string;
    set phoneNumber(value: string);
    get phoneNumberInput(): string | undefined;
}
export declare class MonitorActionGroupSmsReceiverList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MonitorActionGroupSmsReceiver[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MonitorActionGroupSmsReceiverOutputReference;
}
export interface MonitorActionGroupTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#create MonitorActionGroup#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#delete MonitorActionGroup#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#read MonitorActionGroup#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#update MonitorActionGroup#update}
    */
    readonly update?: string;
}
export declare function monitorActionGroupTimeoutsToTerraform(struct?: MonitorActionGroupTimeoutsOutputReference | MonitorActionGroupTimeouts | cdktf.IResolvable): any;
export declare class MonitorActionGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorActionGroupTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorActionGroupTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface MonitorActionGroupVoiceReceiver {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#country_code MonitorActionGroup#country_code}
    */
    readonly countryCode: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#name MonitorActionGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#phone_number MonitorActionGroup#phone_number}
    */
    readonly phoneNumber: string;
}
export declare function monitorActionGroupVoiceReceiverToTerraform(struct?: MonitorActionGroupVoiceReceiver | cdktf.IResolvable): any;
export declare class MonitorActionGroupVoiceReceiverOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MonitorActionGroupVoiceReceiver | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorActionGroupVoiceReceiver | cdktf.IResolvable | undefined);
    private _countryCode?;
    get countryCode(): string;
    set countryCode(value: string);
    get countryCodeInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _phoneNumber?;
    get phoneNumber(): string;
    set phoneNumber(value: string);
    get phoneNumberInput(): string | undefined;
}
export declare class MonitorActionGroupVoiceReceiverList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MonitorActionGroupVoiceReceiver[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MonitorActionGroupVoiceReceiverOutputReference;
}
export interface MonitorActionGroupWebhookReceiverAadAuth {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#identifier_uri MonitorActionGroup#identifier_uri}
    */
    readonly identifierUri?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#object_id MonitorActionGroup#object_id}
    */
    readonly objectId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#tenant_id MonitorActionGroup#tenant_id}
    */
    readonly tenantId?: string;
}
export declare function monitorActionGroupWebhookReceiverAadAuthToTerraform(struct?: MonitorActionGroupWebhookReceiverAadAuthOutputReference | MonitorActionGroupWebhookReceiverAadAuth): any;
export declare class MonitorActionGroupWebhookReceiverAadAuthOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorActionGroupWebhookReceiverAadAuth | undefined;
    set internalValue(value: MonitorActionGroupWebhookReceiverAadAuth | undefined);
    private _identifierUri?;
    get identifierUri(): string;
    set identifierUri(value: string);
    resetIdentifierUri(): void;
    get identifierUriInput(): string | undefined;
    private _objectId?;
    get objectId(): string;
    set objectId(value: string);
    get objectIdInput(): string | undefined;
    private _tenantId?;
    get tenantId(): string;
    set tenantId(value: string);
    resetTenantId(): void;
    get tenantIdInput(): string | undefined;
}
export interface MonitorActionGroupWebhookReceiver {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#name MonitorActionGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#service_uri MonitorActionGroup#service_uri}
    */
    readonly serviceUri: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#use_common_alert_schema MonitorActionGroup#use_common_alert_schema}
    */
    readonly useCommonAlertSchema?: boolean | cdktf.IResolvable;
    /**
    * aad_auth block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#aad_auth MonitorActionGroup#aad_auth}
    */
    readonly aadAuth?: MonitorActionGroupWebhookReceiverAadAuth;
}
export declare function monitorActionGroupWebhookReceiverToTerraform(struct?: MonitorActionGroupWebhookReceiver | cdktf.IResolvable): any;
export declare class MonitorActionGroupWebhookReceiverOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MonitorActionGroupWebhookReceiver | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorActionGroupWebhookReceiver | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _serviceUri?;
    get serviceUri(): string;
    set serviceUri(value: string);
    get serviceUriInput(): string | undefined;
    private _useCommonAlertSchema?;
    get useCommonAlertSchema(): boolean | cdktf.IResolvable;
    set useCommonAlertSchema(value: boolean | cdktf.IResolvable);
    resetUseCommonAlertSchema(): void;
    get useCommonAlertSchemaInput(): boolean | cdktf.IResolvable | undefined;
    private _aadAuth;
    get aadAuth(): MonitorActionGroupWebhookReceiverAadAuthOutputReference;
    putAadAuth(value: MonitorActionGroupWebhookReceiverAadAuth): void;
    resetAadAuth(): void;
    get aadAuthInput(): MonitorActionGroupWebhookReceiverAadAuth | undefined;
}
export declare class MonitorActionGroupWebhookReceiverList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MonitorActionGroupWebhookReceiver[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MonitorActionGroupWebhookReceiverOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group azurerm_monitor_action_group}
*/
export declare class MonitorActionGroup extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_monitor_action_group";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group azurerm_monitor_action_group} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MonitorActionGroupConfig
    */
    constructor(scope: Construct, id: string, config: MonitorActionGroupConfig);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _shortName?;
    get shortName(): string;
    set shortName(value: string);
    get shortNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _armRoleReceiver;
    get armRoleReceiver(): MonitorActionGroupArmRoleReceiverList;
    putArmRoleReceiver(value: MonitorActionGroupArmRoleReceiver[] | cdktf.IResolvable): void;
    resetArmRoleReceiver(): void;
    get armRoleReceiverInput(): cdktf.IResolvable | MonitorActionGroupArmRoleReceiver[] | undefined;
    private _automationRunbookReceiver;
    get automationRunbookReceiver(): MonitorActionGroupAutomationRunbookReceiverList;
    putAutomationRunbookReceiver(value: MonitorActionGroupAutomationRunbookReceiver[] | cdktf.IResolvable): void;
    resetAutomationRunbookReceiver(): void;
    get automationRunbookReceiverInput(): cdktf.IResolvable | MonitorActionGroupAutomationRunbookReceiver[] | undefined;
    private _azureAppPushReceiver;
    get azureAppPushReceiver(): MonitorActionGroupAzureAppPushReceiverList;
    putAzureAppPushReceiver(value: MonitorActionGroupAzureAppPushReceiver[] | cdktf.IResolvable): void;
    resetAzureAppPushReceiver(): void;
    get azureAppPushReceiverInput(): cdktf.IResolvable | MonitorActionGroupAzureAppPushReceiver[] | undefined;
    private _azureFunctionReceiver;
    get azureFunctionReceiver(): MonitorActionGroupAzureFunctionReceiverList;
    putAzureFunctionReceiver(value: MonitorActionGroupAzureFunctionReceiver[] | cdktf.IResolvable): void;
    resetAzureFunctionReceiver(): void;
    get azureFunctionReceiverInput(): cdktf.IResolvable | MonitorActionGroupAzureFunctionReceiver[] | undefined;
    private _emailReceiver;
    get emailReceiver(): MonitorActionGroupEmailReceiverList;
    putEmailReceiver(value: MonitorActionGroupEmailReceiver[] | cdktf.IResolvable): void;
    resetEmailReceiver(): void;
    get emailReceiverInput(): cdktf.IResolvable | MonitorActionGroupEmailReceiver[] | undefined;
    private _eventHubReceiver;
    get eventHubReceiver(): MonitorActionGroupEventHubReceiverList;
    putEventHubReceiver(value: MonitorActionGroupEventHubReceiver[] | cdktf.IResolvable): void;
    resetEventHubReceiver(): void;
    get eventHubReceiverInput(): cdktf.IResolvable | MonitorActionGroupEventHubReceiver[] | undefined;
    private _itsmReceiver;
    get itsmReceiver(): MonitorActionGroupItsmReceiverList;
    putItsmReceiver(value: MonitorActionGroupItsmReceiver[] | cdktf.IResolvable): void;
    resetItsmReceiver(): void;
    get itsmReceiverInput(): cdktf.IResolvable | MonitorActionGroupItsmReceiver[] | undefined;
    private _logicAppReceiver;
    get logicAppReceiver(): MonitorActionGroupLogicAppReceiverList;
    putLogicAppReceiver(value: MonitorActionGroupLogicAppReceiver[] | cdktf.IResolvable): void;
    resetLogicAppReceiver(): void;
    get logicAppReceiverInput(): cdktf.IResolvable | MonitorActionGroupLogicAppReceiver[] | undefined;
    private _smsReceiver;
    get smsReceiver(): MonitorActionGroupSmsReceiverList;
    putSmsReceiver(value: MonitorActionGroupSmsReceiver[] | cdktf.IResolvable): void;
    resetSmsReceiver(): void;
    get smsReceiverInput(): cdktf.IResolvable | MonitorActionGroupSmsReceiver[] | undefined;
    private _timeouts;
    get timeouts(): MonitorActionGroupTimeoutsOutputReference;
    putTimeouts(value: MonitorActionGroupTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | MonitorActionGroupTimeouts | undefined;
    private _voiceReceiver;
    get voiceReceiver(): MonitorActionGroupVoiceReceiverList;
    putVoiceReceiver(value: MonitorActionGroupVoiceReceiver[] | cdktf.IResolvable): void;
    resetVoiceReceiver(): void;
    get voiceReceiverInput(): cdktf.IResolvable | MonitorActionGroupVoiceReceiver[] | undefined;
    private _webhookReceiver;
    get webhookReceiver(): MonitorActionGroupWebhookReceiverList;
    putWebhookReceiver(value: MonitorActionGroupWebhookReceiver[] | cdktf.IResolvable): void;
    resetWebhookReceiver(): void;
    get webhookReceiverInput(): cdktf.IResolvable | MonitorActionGroupWebhookReceiver[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
