import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MonitorDataCollectionRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_data_collection_rule#description MonitorDataCollectionRule#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_data_collection_rule#id MonitorDataCollectionRule#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_data_collection_rule#kind MonitorDataCollectionRule#kind}
    */
    readonly kind?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_data_collection_rule#location MonitorDataCollectionRule#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_data_collection_rule#name MonitorDataCollectionRule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_data_collection_rule#resource_group_name MonitorDataCollectionRule#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_data_collection_rule#tags MonitorDataCollectionRule#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * data_flow block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_data_collection_rule#data_flow MonitorDataCollectionRule#data_flow}
    */
    readonly dataFlow: MonitorDataCollectionRuleDataFlow[] | cdktf.IResolvable;
    /**
    * data_sources block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_data_collection_rule#data_sources MonitorDataCollectionRule#data_sources}
    */
    readonly dataSources?: MonitorDataCollectionRuleDataSources;
    /**
    * destinations block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_data_collection_rule#destinations MonitorDataCollectionRule#destinations}
    */
    readonly destinations: MonitorDataCollectionRuleDestinations;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_data_collection_rule#timeouts MonitorDataCollectionRule#timeouts}
    */
    readonly timeouts?: MonitorDataCollectionRuleTimeouts;
}
export interface MonitorDataCollectionRuleDataFlow {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_data_collection_rule#destinations MonitorDataCollectionRule#destinations}
    */
    readonly destinations: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_data_collection_rule#streams MonitorDataCollectionRule#streams}
    */
    readonly streams: string[];
}
export declare function monitorDataCollectionRuleDataFlowToTerraform(struct?: MonitorDataCollectionRuleDataFlow | cdktf.IResolvable): any;
export declare class MonitorDataCollectionRuleDataFlowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MonitorDataCollectionRuleDataFlow | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorDataCollectionRuleDataFlow | cdktf.IResolvable | undefined);
    private _destinations?;
    get destinations(): string[];
    set destinations(value: string[]);
    get destinationsInput(): string[] | undefined;
    private _streams?;
    get streams(): string[];
    set streams(value: string[]);
    get streamsInput(): string[] | undefined;
}
export declare class MonitorDataCollectionRuleDataFlowList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MonitorDataCollectionRuleDataFlow[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MonitorDataCollectionRuleDataFlowOutputReference;
}
export interface MonitorDataCollectionRuleDataSourcesExtension {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_data_collection_rule#extension_json MonitorDataCollectionRule#extension_json}
    */
    readonly extensionJson?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_data_collection_rule#extension_name MonitorDataCollectionRule#extension_name}
    */
    readonly extensionName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_data_collection_rule#input_data_sources MonitorDataCollectionRule#input_data_sources}
    */
    readonly inputDataSources?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_data_collection_rule#name MonitorDataCollectionRule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_data_collection_rule#streams MonitorDataCollectionRule#streams}
    */
    readonly streams: string[];
}
export declare function monitorDataCollectionRuleDataSourcesExtensionToTerraform(struct?: MonitorDataCollectionRuleDataSourcesExtension | cdktf.IResolvable): any;
export declare class MonitorDataCollectionRuleDataSourcesExtensionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MonitorDataCollectionRuleDataSourcesExtension | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorDataCollectionRuleDataSourcesExtension | cdktf.IResolvable | undefined);
    private _extensionJson?;
    get extensionJson(): string;
    set extensionJson(value: string);
    resetExtensionJson(): void;
    get extensionJsonInput(): string | undefined;
    private _extensionName?;
    get extensionName(): string;
    set extensionName(value: string);
    get extensionNameInput(): string | undefined;
    private _inputDataSources?;
    get inputDataSources(): string[];
    set inputDataSources(value: string[]);
    resetInputDataSources(): void;
    get inputDataSourcesInput(): string[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _streams?;
    get streams(): string[];
    set streams(value: string[]);
    get streamsInput(): string[] | undefined;
}
export declare class MonitorDataCollectionRuleDataSourcesExtensionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MonitorDataCollectionRuleDataSourcesExtension[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MonitorDataCollectionRuleDataSourcesExtensionOutputReference;
}
export interface MonitorDataCollectionRuleDataSourcesPerformanceCounter {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_data_collection_rule#counter_specifiers MonitorDataCollectionRule#counter_specifiers}
    */
    readonly counterSpecifiers: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_data_collection_rule#name MonitorDataCollectionRule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_data_collection_rule#sampling_frequency_in_seconds MonitorDataCollectionRule#sampling_frequency_in_seconds}
    */
    readonly samplingFrequencyInSeconds: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_data_collection_rule#streams MonitorDataCollectionRule#streams}
    */
    readonly streams: string[];
}
export declare function monitorDataCollectionRuleDataSourcesPerformanceCounterToTerraform(struct?: MonitorDataCollectionRuleDataSourcesPerformanceCounter | cdktf.IResolvable): any;
export declare class MonitorDataCollectionRuleDataSourcesPerformanceCounterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MonitorDataCollectionRuleDataSourcesPerformanceCounter | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorDataCollectionRuleDataSourcesPerformanceCounter | cdktf.IResolvable | undefined);
    private _counterSpecifiers?;
    get counterSpecifiers(): string[];
    set counterSpecifiers(value: string[]);
    get counterSpecifiersInput(): string[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _samplingFrequencyInSeconds?;
    get samplingFrequencyInSeconds(): number;
    set samplingFrequencyInSeconds(value: number);
    get samplingFrequencyInSecondsInput(): number | undefined;
    private _streams?;
    get streams(): string[];
    set streams(value: string[]);
    get streamsInput(): string[] | undefined;
}
export declare class MonitorDataCollectionRuleDataSourcesPerformanceCounterList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MonitorDataCollectionRuleDataSourcesPerformanceCounter[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MonitorDataCollectionRuleDataSourcesPerformanceCounterOutputReference;
}
export interface MonitorDataCollectionRuleDataSourcesSyslog {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_data_collection_rule#facility_names MonitorDataCollectionRule#facility_names}
    */
    readonly facilityNames: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_data_collection_rule#log_levels MonitorDataCollectionRule#log_levels}
    */
    readonly logLevels: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_data_collection_rule#name MonitorDataCollectionRule#name}
    */
    readonly name: string;
}
export declare function monitorDataCollectionRuleDataSourcesSyslogToTerraform(struct?: MonitorDataCollectionRuleDataSourcesSyslog | cdktf.IResolvable): any;
export declare class MonitorDataCollectionRuleDataSourcesSyslogOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MonitorDataCollectionRuleDataSourcesSyslog | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorDataCollectionRuleDataSourcesSyslog | cdktf.IResolvable | undefined);
    private _facilityNames?;
    get facilityNames(): string[];
    set facilityNames(value: string[]);
    get facilityNamesInput(): string[] | undefined;
    private _logLevels?;
    get logLevels(): string[];
    set logLevels(value: string[]);
    get logLevelsInput(): string[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export declare class MonitorDataCollectionRuleDataSourcesSyslogList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MonitorDataCollectionRuleDataSourcesSyslog[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MonitorDataCollectionRuleDataSourcesSyslogOutputReference;
}
export interface MonitorDataCollectionRuleDataSourcesWindowsEventLog {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_data_collection_rule#name MonitorDataCollectionRule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_data_collection_rule#streams MonitorDataCollectionRule#streams}
    */
    readonly streams: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_data_collection_rule#x_path_queries MonitorDataCollectionRule#x_path_queries}
    */
    readonly xPathQueries: string[];
}
export declare function monitorDataCollectionRuleDataSourcesWindowsEventLogToTerraform(struct?: MonitorDataCollectionRuleDataSourcesWindowsEventLog | cdktf.IResolvable): any;
export declare class MonitorDataCollectionRuleDataSourcesWindowsEventLogOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MonitorDataCollectionRuleDataSourcesWindowsEventLog | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorDataCollectionRuleDataSourcesWindowsEventLog | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _streams?;
    get streams(): string[];
    set streams(value: string[]);
    get streamsInput(): string[] | undefined;
    private _xPathQueries?;
    get xPathQueries(): string[];
    set xPathQueries(value: string[]);
    get xPathQueriesInput(): string[] | undefined;
}
export declare class MonitorDataCollectionRuleDataSourcesWindowsEventLogList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MonitorDataCollectionRuleDataSourcesWindowsEventLog[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MonitorDataCollectionRuleDataSourcesWindowsEventLogOutputReference;
}
export interface MonitorDataCollectionRuleDataSources {
    /**
    * extension block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_data_collection_rule#extension MonitorDataCollectionRule#extension}
    */
    readonly extension?: MonitorDataCollectionRuleDataSourcesExtension[] | cdktf.IResolvable;
    /**
    * performance_counter block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_data_collection_rule#performance_counter MonitorDataCollectionRule#performance_counter}
    */
    readonly performanceCounter?: MonitorDataCollectionRuleDataSourcesPerformanceCounter[] | cdktf.IResolvable;
    /**
    * syslog block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_data_collection_rule#syslog MonitorDataCollectionRule#syslog}
    */
    readonly syslog?: MonitorDataCollectionRuleDataSourcesSyslog[] | cdktf.IResolvable;
    /**
    * windows_event_log block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_data_collection_rule#windows_event_log MonitorDataCollectionRule#windows_event_log}
    */
    readonly windowsEventLog?: MonitorDataCollectionRuleDataSourcesWindowsEventLog[] | cdktf.IResolvable;
}
export declare function monitorDataCollectionRuleDataSourcesToTerraform(struct?: MonitorDataCollectionRuleDataSourcesOutputReference | MonitorDataCollectionRuleDataSources): any;
export declare class MonitorDataCollectionRuleDataSourcesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorDataCollectionRuleDataSources | undefined;
    set internalValue(value: MonitorDataCollectionRuleDataSources | undefined);
    private _extension;
    get extension(): MonitorDataCollectionRuleDataSourcesExtensionList;
    putExtension(value: MonitorDataCollectionRuleDataSourcesExtension[] | cdktf.IResolvable): void;
    resetExtension(): void;
    get extensionInput(): cdktf.IResolvable | MonitorDataCollectionRuleDataSourcesExtension[] | undefined;
    private _performanceCounter;
    get performanceCounter(): MonitorDataCollectionRuleDataSourcesPerformanceCounterList;
    putPerformanceCounter(value: MonitorDataCollectionRuleDataSourcesPerformanceCounter[] | cdktf.IResolvable): void;
    resetPerformanceCounter(): void;
    get performanceCounterInput(): cdktf.IResolvable | MonitorDataCollectionRuleDataSourcesPerformanceCounter[] | undefined;
    private _syslog;
    get syslog(): MonitorDataCollectionRuleDataSourcesSyslogList;
    putSyslog(value: MonitorDataCollectionRuleDataSourcesSyslog[] | cdktf.IResolvable): void;
    resetSyslog(): void;
    get syslogInput(): cdktf.IResolvable | MonitorDataCollectionRuleDataSourcesSyslog[] | undefined;
    private _windowsEventLog;
    get windowsEventLog(): MonitorDataCollectionRuleDataSourcesWindowsEventLogList;
    putWindowsEventLog(value: MonitorDataCollectionRuleDataSourcesWindowsEventLog[] | cdktf.IResolvable): void;
    resetWindowsEventLog(): void;
    get windowsEventLogInput(): cdktf.IResolvable | MonitorDataCollectionRuleDataSourcesWindowsEventLog[] | undefined;
}
export interface MonitorDataCollectionRuleDestinationsAzureMonitorMetrics {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_data_collection_rule#name MonitorDataCollectionRule#name}
    */
    readonly name: string;
}
export declare function monitorDataCollectionRuleDestinationsAzureMonitorMetricsToTerraform(struct?: MonitorDataCollectionRuleDestinationsAzureMonitorMetricsOutputReference | MonitorDataCollectionRuleDestinationsAzureMonitorMetrics): any;
export declare class MonitorDataCollectionRuleDestinationsAzureMonitorMetricsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorDataCollectionRuleDestinationsAzureMonitorMetrics | undefined;
    set internalValue(value: MonitorDataCollectionRuleDestinationsAzureMonitorMetrics | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export interface MonitorDataCollectionRuleDestinationsLogAnalytics {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_data_collection_rule#name MonitorDataCollectionRule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_data_collection_rule#workspace_resource_id MonitorDataCollectionRule#workspace_resource_id}
    */
    readonly workspaceResourceId: string;
}
export declare function monitorDataCollectionRuleDestinationsLogAnalyticsToTerraform(struct?: MonitorDataCollectionRuleDestinationsLogAnalytics | cdktf.IResolvable): any;
export declare class MonitorDataCollectionRuleDestinationsLogAnalyticsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MonitorDataCollectionRuleDestinationsLogAnalytics | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorDataCollectionRuleDestinationsLogAnalytics | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _workspaceResourceId?;
    get workspaceResourceId(): string;
    set workspaceResourceId(value: string);
    get workspaceResourceIdInput(): string | undefined;
}
export declare class MonitorDataCollectionRuleDestinationsLogAnalyticsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MonitorDataCollectionRuleDestinationsLogAnalytics[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MonitorDataCollectionRuleDestinationsLogAnalyticsOutputReference;
}
export interface MonitorDataCollectionRuleDestinations {
    /**
    * azure_monitor_metrics block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_data_collection_rule#azure_monitor_metrics MonitorDataCollectionRule#azure_monitor_metrics}
    */
    readonly azureMonitorMetrics?: MonitorDataCollectionRuleDestinationsAzureMonitorMetrics;
    /**
    * log_analytics block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_data_collection_rule#log_analytics MonitorDataCollectionRule#log_analytics}
    */
    readonly logAnalytics?: MonitorDataCollectionRuleDestinationsLogAnalytics[] | cdktf.IResolvable;
}
export declare function monitorDataCollectionRuleDestinationsToTerraform(struct?: MonitorDataCollectionRuleDestinationsOutputReference | MonitorDataCollectionRuleDestinations): any;
export declare class MonitorDataCollectionRuleDestinationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorDataCollectionRuleDestinations | undefined;
    set internalValue(value: MonitorDataCollectionRuleDestinations | undefined);
    private _azureMonitorMetrics;
    get azureMonitorMetrics(): MonitorDataCollectionRuleDestinationsAzureMonitorMetricsOutputReference;
    putAzureMonitorMetrics(value: MonitorDataCollectionRuleDestinationsAzureMonitorMetrics): void;
    resetAzureMonitorMetrics(): void;
    get azureMonitorMetricsInput(): MonitorDataCollectionRuleDestinationsAzureMonitorMetrics | undefined;
    private _logAnalytics;
    get logAnalytics(): MonitorDataCollectionRuleDestinationsLogAnalyticsList;
    putLogAnalytics(value: MonitorDataCollectionRuleDestinationsLogAnalytics[] | cdktf.IResolvable): void;
    resetLogAnalytics(): void;
    get logAnalyticsInput(): cdktf.IResolvable | MonitorDataCollectionRuleDestinationsLogAnalytics[] | undefined;
}
export interface MonitorDataCollectionRuleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_data_collection_rule#create MonitorDataCollectionRule#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_data_collection_rule#delete MonitorDataCollectionRule#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_data_collection_rule#read MonitorDataCollectionRule#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_data_collection_rule#update MonitorDataCollectionRule#update}
    */
    readonly update?: string;
}
export declare function monitorDataCollectionRuleTimeoutsToTerraform(struct?: MonitorDataCollectionRuleTimeoutsOutputReference | MonitorDataCollectionRuleTimeouts | cdktf.IResolvable): any;
export declare class MonitorDataCollectionRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorDataCollectionRuleTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorDataCollectionRuleTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_data_collection_rule azurerm_monitor_data_collection_rule}
*/
export declare class MonitorDataCollectionRule extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_monitor_data_collection_rule";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_data_collection_rule azurerm_monitor_data_collection_rule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MonitorDataCollectionRuleConfig
    */
    constructor(scope: Construct, id: string, config: MonitorDataCollectionRuleConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _kind?;
    get kind(): string;
    set kind(value: string);
    resetKind(): void;
    get kindInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _dataFlow;
    get dataFlow(): MonitorDataCollectionRuleDataFlowList;
    putDataFlow(value: MonitorDataCollectionRuleDataFlow[] | cdktf.IResolvable): void;
    get dataFlowInput(): cdktf.IResolvable | MonitorDataCollectionRuleDataFlow[] | undefined;
    private _dataSources;
    get dataSources(): MonitorDataCollectionRuleDataSourcesOutputReference;
    putDataSources(value: MonitorDataCollectionRuleDataSources): void;
    resetDataSources(): void;
    get dataSourcesInput(): MonitorDataCollectionRuleDataSources | undefined;
    private _destinations;
    get destinations(): MonitorDataCollectionRuleDestinationsOutputReference;
    putDestinations(value: MonitorDataCollectionRuleDestinations): void;
    get destinationsInput(): MonitorDataCollectionRuleDestinations | undefined;
    private _timeouts;
    get timeouts(): MonitorDataCollectionRuleTimeoutsOutputReference;
    putTimeouts(value: MonitorDataCollectionRuleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | MonitorDataCollectionRuleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
