"""
Special Functions Module

This module provides special mathematical functions used in fractional calculus:
- Gamma and Beta functions
- Binomial coefficients
- Mittag-Leffler functions
- Fractional Green's functions
"""

from .gamma_beta import (
    gamma as gamma_function,
    gamma,
    beta as beta_function,
    beta,
    log_gamma
)

from .binomial_coeffs import (
    binomial as binomial_coefficient,
    binomial_fractional as generalized_binomial
)

from .mittag_leffler import (
    mittag_leffler as mittag_leffler_function,
    mittag_leffler_derivative
)

from .greens_function import (
    FractionalGreensFunction,
    FractionalDiffusionGreensFunction,
    FractionalWaveGreensFunction,
    FractionalAdvectionGreensFunction,
    create_fractional_greens_function,
    greens_function_properties,
    validate_greens_function,
    greens_function_convolution
)

__all__ = [
    # Gamma and Beta functions
    'gamma_function',
    'beta_function', 
    'incomplete_gamma',
    'incomplete_beta',
    'log_gamma',
    
    # Binomial coefficients
    'binomial_coefficient',
    'generalized_binomial',
    'multinomial_coefficient',
    'stirling_numbers',
    
    # Mittag-Leffler functions
    'mittag_leffler_function',
    'mittag_leffler_derivative',
    'generalized_mittag_leffler',
    'three_parameter_mittag_leffler',
    
    # Green's functions
    'FractionalGreensFunction',
    'FractionalDiffusionGreensFunction',
    'FractionalWaveGreensFunction',
    'FractionalAdvectionGreensFunction',
    'create_fractional_greens_function',
    'greens_function_properties',
    'validate_greens_function',
    'greens_function_convolution'
]
