"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("@aws-cdk/core");
function parseBucketArn(construct, props) {
    // if we have an explicit bucket ARN, use it.
    if (props.bucketArn) {
        return props.bucketArn;
    }
    if (props.bucketName) {
        return cdk.Stack.of(construct).formatArn({
            // S3 Bucket names are globally unique in a partition,
            // and so their ARNs have empty region and account components
            region: '',
            account: '',
            service: 's3',
            resource: props.bucketName,
        });
    }
    throw new Error('Cannot determine bucket ARN. At least `bucketArn` or `bucketName` is needed');
}
exports.parseBucketArn = parseBucketArn;
function parseBucketName(construct, props) {
    // if we have an explicit bucket name, use it.
    if (props.bucketName) {
        return props.bucketName;
    }
    // extract bucket name from bucket arn
    if (props.bucketArn) {
        return cdk.Stack.of(construct).parseArn(props.bucketArn).resource;
    }
    // no bucket name is okay since it's optional.
    return undefined;
}
exports.parseBucketName = parseBucketName;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXRpbC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInV0aWwudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQSxxQ0FBcUM7QUFHckMsU0FBZ0IsY0FBYyxDQUFDLFNBQXlCLEVBQUUsS0FBdUI7SUFFL0UsNkNBQTZDO0lBQzdDLElBQUksS0FBSyxDQUFDLFNBQVMsRUFBRTtRQUNuQixPQUFPLEtBQUssQ0FBQyxTQUFTLENBQUM7S0FDeEI7SUFFRCxJQUFJLEtBQUssQ0FBQyxVQUFVLEVBQUU7UUFDcEIsT0FBTyxHQUFHLENBQUMsS0FBSyxDQUFDLEVBQUUsQ0FBQyxTQUFTLENBQUMsQ0FBQyxTQUFTLENBQUM7WUFDdkMsc0RBQXNEO1lBQ3RELDZEQUE2RDtZQUM3RCxNQUFNLEVBQUUsRUFBRTtZQUNWLE9BQU8sRUFBRSxFQUFFO1lBQ1gsT0FBTyxFQUFFLElBQUk7WUFDYixRQUFRLEVBQUUsS0FBSyxDQUFDLFVBQVU7U0FDM0IsQ0FBQyxDQUFDO0tBQ0o7SUFFRCxNQUFNLElBQUksS0FBSyxDQUFDLDZFQUE2RSxDQUFDLENBQUM7QUFDakcsQ0FBQztBQW5CRCx3Q0FtQkM7QUFFRCxTQUFnQixlQUFlLENBQUMsU0FBeUIsRUFBRSxLQUF1QjtJQUVoRiw4Q0FBOEM7SUFDOUMsSUFBSSxLQUFLLENBQUMsVUFBVSxFQUFFO1FBQ3BCLE9BQU8sS0FBSyxDQUFDLFVBQVUsQ0FBQztLQUN6QjtJQUVELHNDQUFzQztJQUN0QyxJQUFJLEtBQUssQ0FBQyxTQUFTLEVBQUU7UUFDbkIsT0FBTyxHQUFHLENBQUMsS0FBSyxDQUFDLEVBQUUsQ0FBQyxTQUFTLENBQUMsQ0FBQyxRQUFRLENBQUMsS0FBSyxDQUFDLFNBQVMsQ0FBQyxDQUFDLFFBQVEsQ0FBQztLQUNuRTtJQUVELDhDQUE4QztJQUM5QyxPQUFPLFNBQVMsQ0FBQztBQUNuQixDQUFDO0FBZEQsMENBY0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBjZGsgZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5pbXBvcnQgeyBCdWNrZXRBdHRyaWJ1dGVzIH0gZnJvbSAnLi9idWNrZXQnO1xuXG5leHBvcnQgZnVuY3Rpb24gcGFyc2VCdWNrZXRBcm4oY29uc3RydWN0OiBjZGsuSUNvbnN0cnVjdCwgcHJvcHM6IEJ1Y2tldEF0dHJpYnV0ZXMpOiBzdHJpbmcge1xuXG4gIC8vIGlmIHdlIGhhdmUgYW4gZXhwbGljaXQgYnVja2V0IEFSTiwgdXNlIGl0LlxuICBpZiAocHJvcHMuYnVja2V0QXJuKSB7XG4gICAgcmV0dXJuIHByb3BzLmJ1Y2tldEFybjtcbiAgfVxuXG4gIGlmIChwcm9wcy5idWNrZXROYW1lKSB7XG4gICAgcmV0dXJuIGNkay5TdGFjay5vZihjb25zdHJ1Y3QpLmZvcm1hdEFybih7XG4gICAgICAvLyBTMyBCdWNrZXQgbmFtZXMgYXJlIGdsb2JhbGx5IHVuaXF1ZSBpbiBhIHBhcnRpdGlvbixcbiAgICAgIC8vIGFuZCBzbyB0aGVpciBBUk5zIGhhdmUgZW1wdHkgcmVnaW9uIGFuZCBhY2NvdW50IGNvbXBvbmVudHNcbiAgICAgIHJlZ2lvbjogJycsXG4gICAgICBhY2NvdW50OiAnJyxcbiAgICAgIHNlcnZpY2U6ICdzMycsXG4gICAgICByZXNvdXJjZTogcHJvcHMuYnVja2V0TmFtZSxcbiAgICB9KTtcbiAgfVxuXG4gIHRocm93IG5ldyBFcnJvcignQ2Fubm90IGRldGVybWluZSBidWNrZXQgQVJOLiBBdCBsZWFzdCBgYnVja2V0QXJuYCBvciBgYnVja2V0TmFtZWAgaXMgbmVlZGVkJyk7XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBwYXJzZUJ1Y2tldE5hbWUoY29uc3RydWN0OiBjZGsuSUNvbnN0cnVjdCwgcHJvcHM6IEJ1Y2tldEF0dHJpYnV0ZXMpOiBzdHJpbmcgfCB1bmRlZmluZWQge1xuXG4gIC8vIGlmIHdlIGhhdmUgYW4gZXhwbGljaXQgYnVja2V0IG5hbWUsIHVzZSBpdC5cbiAgaWYgKHByb3BzLmJ1Y2tldE5hbWUpIHtcbiAgICByZXR1cm4gcHJvcHMuYnVja2V0TmFtZTtcbiAgfVxuXG4gIC8vIGV4dHJhY3QgYnVja2V0IG5hbWUgZnJvbSBidWNrZXQgYXJuXG4gIGlmIChwcm9wcy5idWNrZXRBcm4pIHtcbiAgICByZXR1cm4gY2RrLlN0YWNrLm9mKGNvbnN0cnVjdCkucGFyc2VBcm4ocHJvcHMuYnVja2V0QXJuKS5yZXNvdXJjZTtcbiAgfVxuXG4gIC8vIG5vIGJ1Y2tldCBuYW1lIGlzIG9rYXkgc2luY2UgaXQncyBvcHRpb25hbC5cbiAgcmV0dXJuIHVuZGVmaW5lZDtcbn1cbiJdfQ==