# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ApplianceVlansArgs', 'ApplianceVlans']

@pulumi.input_type
class ApplianceVlansArgs:
    def __init__(__self__, *,
                 network_id: pulumi.Input[str],
                 vlan_id: pulumi.Input[str],
                 appliance_ip: Optional[pulumi.Input[str]] = None,
                 cidr: Optional[pulumi.Input[str]] = None,
                 dhcp_boot_filename: Optional[pulumi.Input[str]] = None,
                 dhcp_boot_next_server: Optional[pulumi.Input[str]] = None,
                 dhcp_boot_options_enabled: Optional[pulumi.Input[bool]] = None,
                 dhcp_handling: Optional[pulumi.Input[str]] = None,
                 dhcp_lease_time: Optional[pulumi.Input[str]] = None,
                 dhcp_options: Optional[pulumi.Input[Sequence[pulumi.Input['ApplianceVlansDhcpOptionArgs']]]] = None,
                 dhcp_relay_server_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 dns_nameservers: Optional[pulumi.Input[str]] = None,
                 group_policy_id: Optional[pulumi.Input[str]] = None,
                 ipv6: Optional[pulumi.Input['ApplianceVlansIpv6Args']] = None,
                 mandatory_dhcp: Optional[pulumi.Input['ApplianceVlansMandatoryDhcpArgs']] = None,
                 mask: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 reserved_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input['ApplianceVlansReservedIpRangeArgs']]]] = None,
                 subnet: Optional[pulumi.Input[str]] = None,
                 template_vlan_type: Optional[pulumi.Input[str]] = None,
                 vpn_nat_subnet: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ApplianceVlans resource.
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[str] vlan_id: The VLAN ID of the VLAN
        :param pulumi.Input[str] appliance_ip: The local IP of the appliance on the VLAN
        :param pulumi.Input[str] cidr: CIDR of the pool of subnets. Applicable only for template network. Each network bound to the template will automatically pick a subnet from this pool to build its own VLAN.
        :param pulumi.Input[str] dhcp_boot_filename: DHCP boot option for boot filename
        :param pulumi.Input[str] dhcp_boot_next_server: DHCP boot option to direct boot clients to the server to load the boot file from
        :param pulumi.Input[bool] dhcp_boot_options_enabled: Use DHCP boot options specified in other properties
        :param pulumi.Input[str] dhcp_handling: The appliance's handling of DHCP requests on this VLAN. One of: 'Run a DHCP server', 'Relay DHCP to another server' or 'Do not respond to DHCP requests'
        :param pulumi.Input[str] dhcp_lease_time: The term of DHCP leases if the appliance is running a DHCP server on this VLAN. One of: '30 minutes', '1 hour', '4 hours', '12 hours', '1 day' or '1 week'
        :param pulumi.Input[Sequence[pulumi.Input['ApplianceVlansDhcpOptionArgs']]] dhcp_options: The list of DHCP options that will be included in DHCP responses. Each object in the list should have "code", "type", and "value" properties.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dhcp_relay_server_ips: The IPs of the DHCP servers that DHCP requests should be relayed to
        :param pulumi.Input[str] dns_nameservers: The DNS nameservers used for DHCP responses, either "upstream*dns", "google*dns", "opendns", or a newline seperated string of IP addresses or domain names
        :param pulumi.Input[str] group_policy_id: The id of the desired group policy to apply to the VLAN
        :param pulumi.Input['ApplianceVlansIpv6Args'] ipv6: IPv6 configuration on the VLAN
        :param pulumi.Input['ApplianceVlansMandatoryDhcpArgs'] mandatory_dhcp: Mandatory DHCP will enforce that clients connecting to this VLAN must use the IP address assigned by the DHCP server. Clients who use a static IP address won't be able to associate. Only available on firmware versions 17.0 and above
        :param pulumi.Input[int] mask: Mask used for the subnet of all bound to the template networks. Applicable only for template network.
        :param pulumi.Input[str] name: The name of the VLAN
        :param pulumi.Input[Sequence[pulumi.Input['ApplianceVlansReservedIpRangeArgs']]] reserved_ip_ranges: The DHCP reserved IP ranges on the VLAN
        :param pulumi.Input[str] subnet: The subnet of the VLAN
        :param pulumi.Input[str] template_vlan_type: Type of subnetting of the VLAN. Applicable only for template network.
        :param pulumi.Input[str] vpn_nat_subnet: The translated VPN subnet if VPN and VPN subnet translation are enabled on the VLAN
        """
        pulumi.set(__self__, "network_id", network_id)
        pulumi.set(__self__, "vlan_id", vlan_id)
        if appliance_ip is not None:
            pulumi.set(__self__, "appliance_ip", appliance_ip)
        if cidr is not None:
            pulumi.set(__self__, "cidr", cidr)
        if dhcp_boot_filename is not None:
            pulumi.set(__self__, "dhcp_boot_filename", dhcp_boot_filename)
        if dhcp_boot_next_server is not None:
            pulumi.set(__self__, "dhcp_boot_next_server", dhcp_boot_next_server)
        if dhcp_boot_options_enabled is not None:
            pulumi.set(__self__, "dhcp_boot_options_enabled", dhcp_boot_options_enabled)
        if dhcp_handling is not None:
            pulumi.set(__self__, "dhcp_handling", dhcp_handling)
        if dhcp_lease_time is not None:
            pulumi.set(__self__, "dhcp_lease_time", dhcp_lease_time)
        if dhcp_options is not None:
            pulumi.set(__self__, "dhcp_options", dhcp_options)
        if dhcp_relay_server_ips is not None:
            pulumi.set(__self__, "dhcp_relay_server_ips", dhcp_relay_server_ips)
        if dns_nameservers is not None:
            pulumi.set(__self__, "dns_nameservers", dns_nameservers)
        if group_policy_id is not None:
            pulumi.set(__self__, "group_policy_id", group_policy_id)
        if ipv6 is not None:
            pulumi.set(__self__, "ipv6", ipv6)
        if mandatory_dhcp is not None:
            pulumi.set(__self__, "mandatory_dhcp", mandatory_dhcp)
        if mask is not None:
            pulumi.set(__self__, "mask", mask)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if reserved_ip_ranges is not None:
            pulumi.set(__self__, "reserved_ip_ranges", reserved_ip_ranges)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)
        if template_vlan_type is not None:
            pulumi.set(__self__, "template_vlan_type", template_vlan_type)
        if vpn_nat_subnet is not None:
            pulumi.set(__self__, "vpn_nat_subnet", vpn_nat_subnet)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> pulumi.Input[str]:
        """
        The VLAN ID of the VLAN
        """
        return pulumi.get(self, "vlan_id")

    @vlan_id.setter
    def vlan_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vlan_id", value)

    @property
    @pulumi.getter(name="applianceIp")
    def appliance_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The local IP of the appliance on the VLAN
        """
        return pulumi.get(self, "appliance_ip")

    @appliance_ip.setter
    def appliance_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "appliance_ip", value)

    @property
    @pulumi.getter
    def cidr(self) -> Optional[pulumi.Input[str]]:
        """
        CIDR of the pool of subnets. Applicable only for template network. Each network bound to the template will automatically pick a subnet from this pool to build its own VLAN.
        """
        return pulumi.get(self, "cidr")

    @cidr.setter
    def cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cidr", value)

    @property
    @pulumi.getter(name="dhcpBootFilename")
    def dhcp_boot_filename(self) -> Optional[pulumi.Input[str]]:
        """
        DHCP boot option for boot filename
        """
        return pulumi.get(self, "dhcp_boot_filename")

    @dhcp_boot_filename.setter
    def dhcp_boot_filename(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dhcp_boot_filename", value)

    @property
    @pulumi.getter(name="dhcpBootNextServer")
    def dhcp_boot_next_server(self) -> Optional[pulumi.Input[str]]:
        """
        DHCP boot option to direct boot clients to the server to load the boot file from
        """
        return pulumi.get(self, "dhcp_boot_next_server")

    @dhcp_boot_next_server.setter
    def dhcp_boot_next_server(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dhcp_boot_next_server", value)

    @property
    @pulumi.getter(name="dhcpBootOptionsEnabled")
    def dhcp_boot_options_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Use DHCP boot options specified in other properties
        """
        return pulumi.get(self, "dhcp_boot_options_enabled")

    @dhcp_boot_options_enabled.setter
    def dhcp_boot_options_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "dhcp_boot_options_enabled", value)

    @property
    @pulumi.getter(name="dhcpHandling")
    def dhcp_handling(self) -> Optional[pulumi.Input[str]]:
        """
        The appliance's handling of DHCP requests on this VLAN. One of: 'Run a DHCP server', 'Relay DHCP to another server' or 'Do not respond to DHCP requests'
        """
        return pulumi.get(self, "dhcp_handling")

    @dhcp_handling.setter
    def dhcp_handling(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dhcp_handling", value)

    @property
    @pulumi.getter(name="dhcpLeaseTime")
    def dhcp_lease_time(self) -> Optional[pulumi.Input[str]]:
        """
        The term of DHCP leases if the appliance is running a DHCP server on this VLAN. One of: '30 minutes', '1 hour', '4 hours', '12 hours', '1 day' or '1 week'
        """
        return pulumi.get(self, "dhcp_lease_time")

    @dhcp_lease_time.setter
    def dhcp_lease_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dhcp_lease_time", value)

    @property
    @pulumi.getter(name="dhcpOptions")
    def dhcp_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplianceVlansDhcpOptionArgs']]]]:
        """
        The list of DHCP options that will be included in DHCP responses. Each object in the list should have "code", "type", and "value" properties.
        """
        return pulumi.get(self, "dhcp_options")

    @dhcp_options.setter
    def dhcp_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplianceVlansDhcpOptionArgs']]]]):
        pulumi.set(self, "dhcp_options", value)

    @property
    @pulumi.getter(name="dhcpRelayServerIps")
    def dhcp_relay_server_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The IPs of the DHCP servers that DHCP requests should be relayed to
        """
        return pulumi.get(self, "dhcp_relay_server_ips")

    @dhcp_relay_server_ips.setter
    def dhcp_relay_server_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "dhcp_relay_server_ips", value)

    @property
    @pulumi.getter(name="dnsNameservers")
    def dns_nameservers(self) -> Optional[pulumi.Input[str]]:
        """
        The DNS nameservers used for DHCP responses, either "upstream*dns", "google*dns", "opendns", or a newline seperated string of IP addresses or domain names
        """
        return pulumi.get(self, "dns_nameservers")

    @dns_nameservers.setter
    def dns_nameservers(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_nameservers", value)

    @property
    @pulumi.getter(name="groupPolicyId")
    def group_policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the desired group policy to apply to the VLAN
        """
        return pulumi.get(self, "group_policy_id")

    @group_policy_id.setter
    def group_policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_policy_id", value)

    @property
    @pulumi.getter
    def ipv6(self) -> Optional[pulumi.Input['ApplianceVlansIpv6Args']]:
        """
        IPv6 configuration on the VLAN
        """
        return pulumi.get(self, "ipv6")

    @ipv6.setter
    def ipv6(self, value: Optional[pulumi.Input['ApplianceVlansIpv6Args']]):
        pulumi.set(self, "ipv6", value)

    @property
    @pulumi.getter(name="mandatoryDhcp")
    def mandatory_dhcp(self) -> Optional[pulumi.Input['ApplianceVlansMandatoryDhcpArgs']]:
        """
        Mandatory DHCP will enforce that clients connecting to this VLAN must use the IP address assigned by the DHCP server. Clients who use a static IP address won't be able to associate. Only available on firmware versions 17.0 and above
        """
        return pulumi.get(self, "mandatory_dhcp")

    @mandatory_dhcp.setter
    def mandatory_dhcp(self, value: Optional[pulumi.Input['ApplianceVlansMandatoryDhcpArgs']]):
        pulumi.set(self, "mandatory_dhcp", value)

    @property
    @pulumi.getter
    def mask(self) -> Optional[pulumi.Input[int]]:
        """
        Mask used for the subnet of all bound to the template networks. Applicable only for template network.
        """
        return pulumi.get(self, "mask")

    @mask.setter
    def mask(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "mask", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the VLAN
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="reservedIpRanges")
    def reserved_ip_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplianceVlansReservedIpRangeArgs']]]]:
        """
        The DHCP reserved IP ranges on the VLAN
        """
        return pulumi.get(self, "reserved_ip_ranges")

    @reserved_ip_ranges.setter
    def reserved_ip_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplianceVlansReservedIpRangeArgs']]]]):
        pulumi.set(self, "reserved_ip_ranges", value)

    @property
    @pulumi.getter
    def subnet(self) -> Optional[pulumi.Input[str]]:
        """
        The subnet of the VLAN
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet", value)

    @property
    @pulumi.getter(name="templateVlanType")
    def template_vlan_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of subnetting of the VLAN. Applicable only for template network.
        """
        return pulumi.get(self, "template_vlan_type")

    @template_vlan_type.setter
    def template_vlan_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "template_vlan_type", value)

    @property
    @pulumi.getter(name="vpnNatSubnet")
    def vpn_nat_subnet(self) -> Optional[pulumi.Input[str]]:
        """
        The translated VPN subnet if VPN and VPN subnet translation are enabled on the VLAN
        """
        return pulumi.get(self, "vpn_nat_subnet")

    @vpn_nat_subnet.setter
    def vpn_nat_subnet(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpn_nat_subnet", value)


@pulumi.input_type
class _ApplianceVlansState:
    def __init__(__self__, *,
                 appliance_ip: Optional[pulumi.Input[str]] = None,
                 cidr: Optional[pulumi.Input[str]] = None,
                 dhcp_boot_filename: Optional[pulumi.Input[str]] = None,
                 dhcp_boot_next_server: Optional[pulumi.Input[str]] = None,
                 dhcp_boot_options_enabled: Optional[pulumi.Input[bool]] = None,
                 dhcp_handling: Optional[pulumi.Input[str]] = None,
                 dhcp_lease_time: Optional[pulumi.Input[str]] = None,
                 dhcp_options: Optional[pulumi.Input[Sequence[pulumi.Input['ApplianceVlansDhcpOptionArgs']]]] = None,
                 dhcp_relay_server_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 dns_nameservers: Optional[pulumi.Input[str]] = None,
                 group_policy_id: Optional[pulumi.Input[str]] = None,
                 interface_id: Optional[pulumi.Input[str]] = None,
                 ipv6: Optional[pulumi.Input['ApplianceVlansIpv6Args']] = None,
                 mandatory_dhcp: Optional[pulumi.Input['ApplianceVlansMandatoryDhcpArgs']] = None,
                 mask: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 reserved_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input['ApplianceVlansReservedIpRangeArgs']]]] = None,
                 subnet: Optional[pulumi.Input[str]] = None,
                 template_vlan_type: Optional[pulumi.Input[str]] = None,
                 vlan_id: Optional[pulumi.Input[str]] = None,
                 vpn_nat_subnet: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ApplianceVlans resources.
        :param pulumi.Input[str] appliance_ip: The local IP of the appliance on the VLAN
        :param pulumi.Input[str] cidr: CIDR of the pool of subnets. Applicable only for template network. Each network bound to the template will automatically pick a subnet from this pool to build its own VLAN.
        :param pulumi.Input[str] dhcp_boot_filename: DHCP boot option for boot filename
        :param pulumi.Input[str] dhcp_boot_next_server: DHCP boot option to direct boot clients to the server to load the boot file from
        :param pulumi.Input[bool] dhcp_boot_options_enabled: Use DHCP boot options specified in other properties
        :param pulumi.Input[str] dhcp_handling: The appliance's handling of DHCP requests on this VLAN. One of: 'Run a DHCP server', 'Relay DHCP to another server' or 'Do not respond to DHCP requests'
        :param pulumi.Input[str] dhcp_lease_time: The term of DHCP leases if the appliance is running a DHCP server on this VLAN. One of: '30 minutes', '1 hour', '4 hours', '12 hours', '1 day' or '1 week'
        :param pulumi.Input[Sequence[pulumi.Input['ApplianceVlansDhcpOptionArgs']]] dhcp_options: The list of DHCP options that will be included in DHCP responses. Each object in the list should have "code", "type", and "value" properties.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dhcp_relay_server_ips: The IPs of the DHCP servers that DHCP requests should be relayed to
        :param pulumi.Input[str] dns_nameservers: The DNS nameservers used for DHCP responses, either "upstream*dns", "google*dns", "opendns", or a newline seperated string of IP addresses or domain names
        :param pulumi.Input[str] group_policy_id: The id of the desired group policy to apply to the VLAN
        :param pulumi.Input[str] interface_id: The interface ID of the VLAN
        :param pulumi.Input['ApplianceVlansIpv6Args'] ipv6: IPv6 configuration on the VLAN
        :param pulumi.Input['ApplianceVlansMandatoryDhcpArgs'] mandatory_dhcp: Mandatory DHCP will enforce that clients connecting to this VLAN must use the IP address assigned by the DHCP server. Clients who use a static IP address won't be able to associate. Only available on firmware versions 17.0 and above
        :param pulumi.Input[int] mask: Mask used for the subnet of all bound to the template networks. Applicable only for template network.
        :param pulumi.Input[str] name: The name of the VLAN
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[Sequence[pulumi.Input['ApplianceVlansReservedIpRangeArgs']]] reserved_ip_ranges: The DHCP reserved IP ranges on the VLAN
        :param pulumi.Input[str] subnet: The subnet of the VLAN
        :param pulumi.Input[str] template_vlan_type: Type of subnetting of the VLAN. Applicable only for template network.
        :param pulumi.Input[str] vlan_id: The VLAN ID of the VLAN
        :param pulumi.Input[str] vpn_nat_subnet: The translated VPN subnet if VPN and VPN subnet translation are enabled on the VLAN
        """
        if appliance_ip is not None:
            pulumi.set(__self__, "appliance_ip", appliance_ip)
        if cidr is not None:
            pulumi.set(__self__, "cidr", cidr)
        if dhcp_boot_filename is not None:
            pulumi.set(__self__, "dhcp_boot_filename", dhcp_boot_filename)
        if dhcp_boot_next_server is not None:
            pulumi.set(__self__, "dhcp_boot_next_server", dhcp_boot_next_server)
        if dhcp_boot_options_enabled is not None:
            pulumi.set(__self__, "dhcp_boot_options_enabled", dhcp_boot_options_enabled)
        if dhcp_handling is not None:
            pulumi.set(__self__, "dhcp_handling", dhcp_handling)
        if dhcp_lease_time is not None:
            pulumi.set(__self__, "dhcp_lease_time", dhcp_lease_time)
        if dhcp_options is not None:
            pulumi.set(__self__, "dhcp_options", dhcp_options)
        if dhcp_relay_server_ips is not None:
            pulumi.set(__self__, "dhcp_relay_server_ips", dhcp_relay_server_ips)
        if dns_nameservers is not None:
            pulumi.set(__self__, "dns_nameservers", dns_nameservers)
        if group_policy_id is not None:
            pulumi.set(__self__, "group_policy_id", group_policy_id)
        if interface_id is not None:
            pulumi.set(__self__, "interface_id", interface_id)
        if ipv6 is not None:
            pulumi.set(__self__, "ipv6", ipv6)
        if mandatory_dhcp is not None:
            pulumi.set(__self__, "mandatory_dhcp", mandatory_dhcp)
        if mask is not None:
            pulumi.set(__self__, "mask", mask)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if reserved_ip_ranges is not None:
            pulumi.set(__self__, "reserved_ip_ranges", reserved_ip_ranges)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)
        if template_vlan_type is not None:
            pulumi.set(__self__, "template_vlan_type", template_vlan_type)
        if vlan_id is not None:
            pulumi.set(__self__, "vlan_id", vlan_id)
        if vpn_nat_subnet is not None:
            pulumi.set(__self__, "vpn_nat_subnet", vpn_nat_subnet)

    @property
    @pulumi.getter(name="applianceIp")
    def appliance_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The local IP of the appliance on the VLAN
        """
        return pulumi.get(self, "appliance_ip")

    @appliance_ip.setter
    def appliance_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "appliance_ip", value)

    @property
    @pulumi.getter
    def cidr(self) -> Optional[pulumi.Input[str]]:
        """
        CIDR of the pool of subnets. Applicable only for template network. Each network bound to the template will automatically pick a subnet from this pool to build its own VLAN.
        """
        return pulumi.get(self, "cidr")

    @cidr.setter
    def cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cidr", value)

    @property
    @pulumi.getter(name="dhcpBootFilename")
    def dhcp_boot_filename(self) -> Optional[pulumi.Input[str]]:
        """
        DHCP boot option for boot filename
        """
        return pulumi.get(self, "dhcp_boot_filename")

    @dhcp_boot_filename.setter
    def dhcp_boot_filename(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dhcp_boot_filename", value)

    @property
    @pulumi.getter(name="dhcpBootNextServer")
    def dhcp_boot_next_server(self) -> Optional[pulumi.Input[str]]:
        """
        DHCP boot option to direct boot clients to the server to load the boot file from
        """
        return pulumi.get(self, "dhcp_boot_next_server")

    @dhcp_boot_next_server.setter
    def dhcp_boot_next_server(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dhcp_boot_next_server", value)

    @property
    @pulumi.getter(name="dhcpBootOptionsEnabled")
    def dhcp_boot_options_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Use DHCP boot options specified in other properties
        """
        return pulumi.get(self, "dhcp_boot_options_enabled")

    @dhcp_boot_options_enabled.setter
    def dhcp_boot_options_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "dhcp_boot_options_enabled", value)

    @property
    @pulumi.getter(name="dhcpHandling")
    def dhcp_handling(self) -> Optional[pulumi.Input[str]]:
        """
        The appliance's handling of DHCP requests on this VLAN. One of: 'Run a DHCP server', 'Relay DHCP to another server' or 'Do not respond to DHCP requests'
        """
        return pulumi.get(self, "dhcp_handling")

    @dhcp_handling.setter
    def dhcp_handling(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dhcp_handling", value)

    @property
    @pulumi.getter(name="dhcpLeaseTime")
    def dhcp_lease_time(self) -> Optional[pulumi.Input[str]]:
        """
        The term of DHCP leases if the appliance is running a DHCP server on this VLAN. One of: '30 minutes', '1 hour', '4 hours', '12 hours', '1 day' or '1 week'
        """
        return pulumi.get(self, "dhcp_lease_time")

    @dhcp_lease_time.setter
    def dhcp_lease_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dhcp_lease_time", value)

    @property
    @pulumi.getter(name="dhcpOptions")
    def dhcp_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplianceVlansDhcpOptionArgs']]]]:
        """
        The list of DHCP options that will be included in DHCP responses. Each object in the list should have "code", "type", and "value" properties.
        """
        return pulumi.get(self, "dhcp_options")

    @dhcp_options.setter
    def dhcp_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplianceVlansDhcpOptionArgs']]]]):
        pulumi.set(self, "dhcp_options", value)

    @property
    @pulumi.getter(name="dhcpRelayServerIps")
    def dhcp_relay_server_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The IPs of the DHCP servers that DHCP requests should be relayed to
        """
        return pulumi.get(self, "dhcp_relay_server_ips")

    @dhcp_relay_server_ips.setter
    def dhcp_relay_server_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "dhcp_relay_server_ips", value)

    @property
    @pulumi.getter(name="dnsNameservers")
    def dns_nameservers(self) -> Optional[pulumi.Input[str]]:
        """
        The DNS nameservers used for DHCP responses, either "upstream*dns", "google*dns", "opendns", or a newline seperated string of IP addresses or domain names
        """
        return pulumi.get(self, "dns_nameservers")

    @dns_nameservers.setter
    def dns_nameservers(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_nameservers", value)

    @property
    @pulumi.getter(name="groupPolicyId")
    def group_policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the desired group policy to apply to the VLAN
        """
        return pulumi.get(self, "group_policy_id")

    @group_policy_id.setter
    def group_policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_policy_id", value)

    @property
    @pulumi.getter(name="interfaceId")
    def interface_id(self) -> Optional[pulumi.Input[str]]:
        """
        The interface ID of the VLAN
        """
        return pulumi.get(self, "interface_id")

    @interface_id.setter
    def interface_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "interface_id", value)

    @property
    @pulumi.getter
    def ipv6(self) -> Optional[pulumi.Input['ApplianceVlansIpv6Args']]:
        """
        IPv6 configuration on the VLAN
        """
        return pulumi.get(self, "ipv6")

    @ipv6.setter
    def ipv6(self, value: Optional[pulumi.Input['ApplianceVlansIpv6Args']]):
        pulumi.set(self, "ipv6", value)

    @property
    @pulumi.getter(name="mandatoryDhcp")
    def mandatory_dhcp(self) -> Optional[pulumi.Input['ApplianceVlansMandatoryDhcpArgs']]:
        """
        Mandatory DHCP will enforce that clients connecting to this VLAN must use the IP address assigned by the DHCP server. Clients who use a static IP address won't be able to associate. Only available on firmware versions 17.0 and above
        """
        return pulumi.get(self, "mandatory_dhcp")

    @mandatory_dhcp.setter
    def mandatory_dhcp(self, value: Optional[pulumi.Input['ApplianceVlansMandatoryDhcpArgs']]):
        pulumi.set(self, "mandatory_dhcp", value)

    @property
    @pulumi.getter
    def mask(self) -> Optional[pulumi.Input[int]]:
        """
        Mask used for the subnet of all bound to the template networks. Applicable only for template network.
        """
        return pulumi.get(self, "mask")

    @mask.setter
    def mask(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "mask", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the VLAN
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[str]]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter(name="reservedIpRanges")
    def reserved_ip_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplianceVlansReservedIpRangeArgs']]]]:
        """
        The DHCP reserved IP ranges on the VLAN
        """
        return pulumi.get(self, "reserved_ip_ranges")

    @reserved_ip_ranges.setter
    def reserved_ip_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplianceVlansReservedIpRangeArgs']]]]):
        pulumi.set(self, "reserved_ip_ranges", value)

    @property
    @pulumi.getter
    def subnet(self) -> Optional[pulumi.Input[str]]:
        """
        The subnet of the VLAN
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet", value)

    @property
    @pulumi.getter(name="templateVlanType")
    def template_vlan_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of subnetting of the VLAN. Applicable only for template network.
        """
        return pulumi.get(self, "template_vlan_type")

    @template_vlan_type.setter
    def template_vlan_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "template_vlan_type", value)

    @property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> Optional[pulumi.Input[str]]:
        """
        The VLAN ID of the VLAN
        """
        return pulumi.get(self, "vlan_id")

    @vlan_id.setter
    def vlan_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vlan_id", value)

    @property
    @pulumi.getter(name="vpnNatSubnet")
    def vpn_nat_subnet(self) -> Optional[pulumi.Input[str]]:
        """
        The translated VPN subnet if VPN and VPN subnet translation are enabled on the VLAN
        """
        return pulumi.get(self, "vpn_nat_subnet")

    @vpn_nat_subnet.setter
    def vpn_nat_subnet(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpn_nat_subnet", value)


class ApplianceVlans(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 appliance_ip: Optional[pulumi.Input[str]] = None,
                 cidr: Optional[pulumi.Input[str]] = None,
                 dhcp_boot_filename: Optional[pulumi.Input[str]] = None,
                 dhcp_boot_next_server: Optional[pulumi.Input[str]] = None,
                 dhcp_boot_options_enabled: Optional[pulumi.Input[bool]] = None,
                 dhcp_handling: Optional[pulumi.Input[str]] = None,
                 dhcp_lease_time: Optional[pulumi.Input[str]] = None,
                 dhcp_options: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApplianceVlansDhcpOptionArgs']]]]] = None,
                 dhcp_relay_server_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 dns_nameservers: Optional[pulumi.Input[str]] = None,
                 group_policy_id: Optional[pulumi.Input[str]] = None,
                 ipv6: Optional[pulumi.Input[pulumi.InputType['ApplianceVlansIpv6Args']]] = None,
                 mandatory_dhcp: Optional[pulumi.Input[pulumi.InputType['ApplianceVlansMandatoryDhcpArgs']]] = None,
                 mask: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 reserved_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApplianceVlansReservedIpRangeArgs']]]]] = None,
                 subnet: Optional[pulumi.Input[str]] = None,
                 template_vlan_type: Optional[pulumi.Input[str]] = None,
                 vlan_id: Optional[pulumi.Input[str]] = None,
                 vpn_nat_subnet: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import meraki:networks/applianceVlans:ApplianceVlans example "network_id,vlan_id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] appliance_ip: The local IP of the appliance on the VLAN
        :param pulumi.Input[str] cidr: CIDR of the pool of subnets. Applicable only for template network. Each network bound to the template will automatically pick a subnet from this pool to build its own VLAN.
        :param pulumi.Input[str] dhcp_boot_filename: DHCP boot option for boot filename
        :param pulumi.Input[str] dhcp_boot_next_server: DHCP boot option to direct boot clients to the server to load the boot file from
        :param pulumi.Input[bool] dhcp_boot_options_enabled: Use DHCP boot options specified in other properties
        :param pulumi.Input[str] dhcp_handling: The appliance's handling of DHCP requests on this VLAN. One of: 'Run a DHCP server', 'Relay DHCP to another server' or 'Do not respond to DHCP requests'
        :param pulumi.Input[str] dhcp_lease_time: The term of DHCP leases if the appliance is running a DHCP server on this VLAN. One of: '30 minutes', '1 hour', '4 hours', '12 hours', '1 day' or '1 week'
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApplianceVlansDhcpOptionArgs']]]] dhcp_options: The list of DHCP options that will be included in DHCP responses. Each object in the list should have "code", "type", and "value" properties.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dhcp_relay_server_ips: The IPs of the DHCP servers that DHCP requests should be relayed to
        :param pulumi.Input[str] dns_nameservers: The DNS nameservers used for DHCP responses, either "upstream*dns", "google*dns", "opendns", or a newline seperated string of IP addresses or domain names
        :param pulumi.Input[str] group_policy_id: The id of the desired group policy to apply to the VLAN
        :param pulumi.Input[pulumi.InputType['ApplianceVlansIpv6Args']] ipv6: IPv6 configuration on the VLAN
        :param pulumi.Input[pulumi.InputType['ApplianceVlansMandatoryDhcpArgs']] mandatory_dhcp: Mandatory DHCP will enforce that clients connecting to this VLAN must use the IP address assigned by the DHCP server. Clients who use a static IP address won't be able to associate. Only available on firmware versions 17.0 and above
        :param pulumi.Input[int] mask: Mask used for the subnet of all bound to the template networks. Applicable only for template network.
        :param pulumi.Input[str] name: The name of the VLAN
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApplianceVlansReservedIpRangeArgs']]]] reserved_ip_ranges: The DHCP reserved IP ranges on the VLAN
        :param pulumi.Input[str] subnet: The subnet of the VLAN
        :param pulumi.Input[str] template_vlan_type: Type of subnetting of the VLAN. Applicable only for template network.
        :param pulumi.Input[str] vlan_id: The VLAN ID of the VLAN
        :param pulumi.Input[str] vpn_nat_subnet: The translated VPN subnet if VPN and VPN subnet translation are enabled on the VLAN
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApplianceVlansArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import meraki:networks/applianceVlans:ApplianceVlans example "network_id,vlan_id"
        ```

        :param str resource_name: The name of the resource.
        :param ApplianceVlansArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApplianceVlansArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 appliance_ip: Optional[pulumi.Input[str]] = None,
                 cidr: Optional[pulumi.Input[str]] = None,
                 dhcp_boot_filename: Optional[pulumi.Input[str]] = None,
                 dhcp_boot_next_server: Optional[pulumi.Input[str]] = None,
                 dhcp_boot_options_enabled: Optional[pulumi.Input[bool]] = None,
                 dhcp_handling: Optional[pulumi.Input[str]] = None,
                 dhcp_lease_time: Optional[pulumi.Input[str]] = None,
                 dhcp_options: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApplianceVlansDhcpOptionArgs']]]]] = None,
                 dhcp_relay_server_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 dns_nameservers: Optional[pulumi.Input[str]] = None,
                 group_policy_id: Optional[pulumi.Input[str]] = None,
                 ipv6: Optional[pulumi.Input[pulumi.InputType['ApplianceVlansIpv6Args']]] = None,
                 mandatory_dhcp: Optional[pulumi.Input[pulumi.InputType['ApplianceVlansMandatoryDhcpArgs']]] = None,
                 mask: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 reserved_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApplianceVlansReservedIpRangeArgs']]]]] = None,
                 subnet: Optional[pulumi.Input[str]] = None,
                 template_vlan_type: Optional[pulumi.Input[str]] = None,
                 vlan_id: Optional[pulumi.Input[str]] = None,
                 vpn_nat_subnet: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApplianceVlansArgs.__new__(ApplianceVlansArgs)

            __props__.__dict__["appliance_ip"] = appliance_ip
            __props__.__dict__["cidr"] = cidr
            __props__.__dict__["dhcp_boot_filename"] = dhcp_boot_filename
            __props__.__dict__["dhcp_boot_next_server"] = dhcp_boot_next_server
            __props__.__dict__["dhcp_boot_options_enabled"] = dhcp_boot_options_enabled
            __props__.__dict__["dhcp_handling"] = dhcp_handling
            __props__.__dict__["dhcp_lease_time"] = dhcp_lease_time
            __props__.__dict__["dhcp_options"] = dhcp_options
            __props__.__dict__["dhcp_relay_server_ips"] = dhcp_relay_server_ips
            __props__.__dict__["dns_nameservers"] = dns_nameservers
            __props__.__dict__["group_policy_id"] = group_policy_id
            __props__.__dict__["ipv6"] = ipv6
            __props__.__dict__["mandatory_dhcp"] = mandatory_dhcp
            __props__.__dict__["mask"] = mask
            __props__.__dict__["name"] = name
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            __props__.__dict__["reserved_ip_ranges"] = reserved_ip_ranges
            __props__.__dict__["subnet"] = subnet
            __props__.__dict__["template_vlan_type"] = template_vlan_type
            if vlan_id is None and not opts.urn:
                raise TypeError("Missing required property 'vlan_id'")
            __props__.__dict__["vlan_id"] = vlan_id
            __props__.__dict__["vpn_nat_subnet"] = vpn_nat_subnet
            __props__.__dict__["interface_id"] = None
        super(ApplianceVlans, __self__).__init__(
            'meraki:networks/applianceVlans:ApplianceVlans',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            appliance_ip: Optional[pulumi.Input[str]] = None,
            cidr: Optional[pulumi.Input[str]] = None,
            dhcp_boot_filename: Optional[pulumi.Input[str]] = None,
            dhcp_boot_next_server: Optional[pulumi.Input[str]] = None,
            dhcp_boot_options_enabled: Optional[pulumi.Input[bool]] = None,
            dhcp_handling: Optional[pulumi.Input[str]] = None,
            dhcp_lease_time: Optional[pulumi.Input[str]] = None,
            dhcp_options: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApplianceVlansDhcpOptionArgs']]]]] = None,
            dhcp_relay_server_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            dns_nameservers: Optional[pulumi.Input[str]] = None,
            group_policy_id: Optional[pulumi.Input[str]] = None,
            interface_id: Optional[pulumi.Input[str]] = None,
            ipv6: Optional[pulumi.Input[pulumi.InputType['ApplianceVlansIpv6Args']]] = None,
            mandatory_dhcp: Optional[pulumi.Input[pulumi.InputType['ApplianceVlansMandatoryDhcpArgs']]] = None,
            mask: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            network_id: Optional[pulumi.Input[str]] = None,
            reserved_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApplianceVlansReservedIpRangeArgs']]]]] = None,
            subnet: Optional[pulumi.Input[str]] = None,
            template_vlan_type: Optional[pulumi.Input[str]] = None,
            vlan_id: Optional[pulumi.Input[str]] = None,
            vpn_nat_subnet: Optional[pulumi.Input[str]] = None) -> 'ApplianceVlans':
        """
        Get an existing ApplianceVlans resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] appliance_ip: The local IP of the appliance on the VLAN
        :param pulumi.Input[str] cidr: CIDR of the pool of subnets. Applicable only for template network. Each network bound to the template will automatically pick a subnet from this pool to build its own VLAN.
        :param pulumi.Input[str] dhcp_boot_filename: DHCP boot option for boot filename
        :param pulumi.Input[str] dhcp_boot_next_server: DHCP boot option to direct boot clients to the server to load the boot file from
        :param pulumi.Input[bool] dhcp_boot_options_enabled: Use DHCP boot options specified in other properties
        :param pulumi.Input[str] dhcp_handling: The appliance's handling of DHCP requests on this VLAN. One of: 'Run a DHCP server', 'Relay DHCP to another server' or 'Do not respond to DHCP requests'
        :param pulumi.Input[str] dhcp_lease_time: The term of DHCP leases if the appliance is running a DHCP server on this VLAN. One of: '30 minutes', '1 hour', '4 hours', '12 hours', '1 day' or '1 week'
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApplianceVlansDhcpOptionArgs']]]] dhcp_options: The list of DHCP options that will be included in DHCP responses. Each object in the list should have "code", "type", and "value" properties.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dhcp_relay_server_ips: The IPs of the DHCP servers that DHCP requests should be relayed to
        :param pulumi.Input[str] dns_nameservers: The DNS nameservers used for DHCP responses, either "upstream*dns", "google*dns", "opendns", or a newline seperated string of IP addresses or domain names
        :param pulumi.Input[str] group_policy_id: The id of the desired group policy to apply to the VLAN
        :param pulumi.Input[str] interface_id: The interface ID of the VLAN
        :param pulumi.Input[pulumi.InputType['ApplianceVlansIpv6Args']] ipv6: IPv6 configuration on the VLAN
        :param pulumi.Input[pulumi.InputType['ApplianceVlansMandatoryDhcpArgs']] mandatory_dhcp: Mandatory DHCP will enforce that clients connecting to this VLAN must use the IP address assigned by the DHCP server. Clients who use a static IP address won't be able to associate. Only available on firmware versions 17.0 and above
        :param pulumi.Input[int] mask: Mask used for the subnet of all bound to the template networks. Applicable only for template network.
        :param pulumi.Input[str] name: The name of the VLAN
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApplianceVlansReservedIpRangeArgs']]]] reserved_ip_ranges: The DHCP reserved IP ranges on the VLAN
        :param pulumi.Input[str] subnet: The subnet of the VLAN
        :param pulumi.Input[str] template_vlan_type: Type of subnetting of the VLAN. Applicable only for template network.
        :param pulumi.Input[str] vlan_id: The VLAN ID of the VLAN
        :param pulumi.Input[str] vpn_nat_subnet: The translated VPN subnet if VPN and VPN subnet translation are enabled on the VLAN
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApplianceVlansState.__new__(_ApplianceVlansState)

        __props__.__dict__["appliance_ip"] = appliance_ip
        __props__.__dict__["cidr"] = cidr
        __props__.__dict__["dhcp_boot_filename"] = dhcp_boot_filename
        __props__.__dict__["dhcp_boot_next_server"] = dhcp_boot_next_server
        __props__.__dict__["dhcp_boot_options_enabled"] = dhcp_boot_options_enabled
        __props__.__dict__["dhcp_handling"] = dhcp_handling
        __props__.__dict__["dhcp_lease_time"] = dhcp_lease_time
        __props__.__dict__["dhcp_options"] = dhcp_options
        __props__.__dict__["dhcp_relay_server_ips"] = dhcp_relay_server_ips
        __props__.__dict__["dns_nameservers"] = dns_nameservers
        __props__.__dict__["group_policy_id"] = group_policy_id
        __props__.__dict__["interface_id"] = interface_id
        __props__.__dict__["ipv6"] = ipv6
        __props__.__dict__["mandatory_dhcp"] = mandatory_dhcp
        __props__.__dict__["mask"] = mask
        __props__.__dict__["name"] = name
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["reserved_ip_ranges"] = reserved_ip_ranges
        __props__.__dict__["subnet"] = subnet
        __props__.__dict__["template_vlan_type"] = template_vlan_type
        __props__.__dict__["vlan_id"] = vlan_id
        __props__.__dict__["vpn_nat_subnet"] = vpn_nat_subnet
        return ApplianceVlans(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applianceIp")
    def appliance_ip(self) -> pulumi.Output[str]:
        """
        The local IP of the appliance on the VLAN
        """
        return pulumi.get(self, "appliance_ip")

    @property
    @pulumi.getter
    def cidr(self) -> pulumi.Output[Optional[str]]:
        """
        CIDR of the pool of subnets. Applicable only for template network. Each network bound to the template will automatically pick a subnet from this pool to build its own VLAN.
        """
        return pulumi.get(self, "cidr")

    @property
    @pulumi.getter(name="dhcpBootFilename")
    def dhcp_boot_filename(self) -> pulumi.Output[str]:
        """
        DHCP boot option for boot filename
        """
        return pulumi.get(self, "dhcp_boot_filename")

    @property
    @pulumi.getter(name="dhcpBootNextServer")
    def dhcp_boot_next_server(self) -> pulumi.Output[str]:
        """
        DHCP boot option to direct boot clients to the server to load the boot file from
        """
        return pulumi.get(self, "dhcp_boot_next_server")

    @property
    @pulumi.getter(name="dhcpBootOptionsEnabled")
    def dhcp_boot_options_enabled(self) -> pulumi.Output[bool]:
        """
        Use DHCP boot options specified in other properties
        """
        return pulumi.get(self, "dhcp_boot_options_enabled")

    @property
    @pulumi.getter(name="dhcpHandling")
    def dhcp_handling(self) -> pulumi.Output[str]:
        """
        The appliance's handling of DHCP requests on this VLAN. One of: 'Run a DHCP server', 'Relay DHCP to another server' or 'Do not respond to DHCP requests'
        """
        return pulumi.get(self, "dhcp_handling")

    @property
    @pulumi.getter(name="dhcpLeaseTime")
    def dhcp_lease_time(self) -> pulumi.Output[str]:
        """
        The term of DHCP leases if the appliance is running a DHCP server on this VLAN. One of: '30 minutes', '1 hour', '4 hours', '12 hours', '1 day' or '1 week'
        """
        return pulumi.get(self, "dhcp_lease_time")

    @property
    @pulumi.getter(name="dhcpOptions")
    def dhcp_options(self) -> pulumi.Output[Sequence['outputs.ApplianceVlansDhcpOption']]:
        """
        The list of DHCP options that will be included in DHCP responses. Each object in the list should have "code", "type", and "value" properties.
        """
        return pulumi.get(self, "dhcp_options")

    @property
    @pulumi.getter(name="dhcpRelayServerIps")
    def dhcp_relay_server_ips(self) -> pulumi.Output[Sequence[str]]:
        """
        The IPs of the DHCP servers that DHCP requests should be relayed to
        """
        return pulumi.get(self, "dhcp_relay_server_ips")

    @property
    @pulumi.getter(name="dnsNameservers")
    def dns_nameservers(self) -> pulumi.Output[str]:
        """
        The DNS nameservers used for DHCP responses, either "upstream*dns", "google*dns", "opendns", or a newline seperated string of IP addresses or domain names
        """
        return pulumi.get(self, "dns_nameservers")

    @property
    @pulumi.getter(name="groupPolicyId")
    def group_policy_id(self) -> pulumi.Output[str]:
        """
        The id of the desired group policy to apply to the VLAN
        """
        return pulumi.get(self, "group_policy_id")

    @property
    @pulumi.getter(name="interfaceId")
    def interface_id(self) -> pulumi.Output[str]:
        """
        The interface ID of the VLAN
        """
        return pulumi.get(self, "interface_id")

    @property
    @pulumi.getter
    def ipv6(self) -> pulumi.Output['outputs.ApplianceVlansIpv6']:
        """
        IPv6 configuration on the VLAN
        """
        return pulumi.get(self, "ipv6")

    @property
    @pulumi.getter(name="mandatoryDhcp")
    def mandatory_dhcp(self) -> pulumi.Output['outputs.ApplianceVlansMandatoryDhcp']:
        """
        Mandatory DHCP will enforce that clients connecting to this VLAN must use the IP address assigned by the DHCP server. Clients who use a static IP address won't be able to associate. Only available on firmware versions 17.0 and above
        """
        return pulumi.get(self, "mandatory_dhcp")

    @property
    @pulumi.getter
    def mask(self) -> pulumi.Output[int]:
        """
        Mask used for the subnet of all bound to the template networks. Applicable only for template network.
        """
        return pulumi.get(self, "mask")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the VLAN
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter(name="reservedIpRanges")
    def reserved_ip_ranges(self) -> pulumi.Output[Sequence['outputs.ApplianceVlansReservedIpRange']]:
        """
        The DHCP reserved IP ranges on the VLAN
        """
        return pulumi.get(self, "reserved_ip_ranges")

    @property
    @pulumi.getter
    def subnet(self) -> pulumi.Output[str]:
        """
        The subnet of the VLAN
        """
        return pulumi.get(self, "subnet")

    @property
    @pulumi.getter(name="templateVlanType")
    def template_vlan_type(self) -> pulumi.Output[str]:
        """
        Type of subnetting of the VLAN. Applicable only for template network.
        """
        return pulumi.get(self, "template_vlan_type")

    @property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> pulumi.Output[str]:
        """
        The VLAN ID of the VLAN
        """
        return pulumi.get(self, "vlan_id")

    @property
    @pulumi.getter(name="vpnNatSubnet")
    def vpn_nat_subnet(self) -> pulumi.Output[str]:
        """
        The translated VPN subnet if VPN and VPN subnet translation are enabled on the VLAN
        """
        return pulumi.get(self, "vpn_nat_subnet")

