# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AlbLoadBalancerArgs', 'AlbLoadBalancer']

@pulumi.input_type
class AlbLoadBalancerArgs:
    def __init__(__self__, *,
                 allocation_policy: pulumi.Input['AlbLoadBalancerAllocationPolicyArgs'],
                 network_id: pulumi.Input[_builtins.str],
                 allow_zonal_shift: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_scale_policy: Optional[pulumi.Input['AlbLoadBalancerAutoScalePolicyArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 listeners: Optional[pulumi.Input[Sequence[pulumi.Input['AlbLoadBalancerListenerArgs']]]] = None,
                 log_options: Optional[pulumi.Input['AlbLoadBalancerLogOptionsArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a AlbLoadBalancer resource.
        :param pulumi.Input['AlbLoadBalancerAllocationPolicyArgs'] allocation_policy: Allocation zones for the Load Balancer instance.
        :param pulumi.Input[_builtins.str] network_id: The `VPC Network ID` of subnets which resource attached to.
        :param pulumi.Input[_builtins.bool] allow_zonal_shift: Specifies whether application load balancer is available to zonal shift
        :param pulumi.Input['AlbLoadBalancerAutoScalePolicyArgs'] auto_scale_policy: Scaling settings of the application load balancer.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[Sequence[pulumi.Input['AlbLoadBalancerListenerArgs']]] listeners: List of listeners for the Load Balancer.
        :param pulumi.Input['AlbLoadBalancerLogOptionsArgs'] log_options: Cloud Logging settings.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[_builtins.str] region_id: The region ID where Load Balancer is located at.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: The list of security groups applied to resource or their components.
        """
        pulumi.set(__self__, "allocation_policy", allocation_policy)
        pulumi.set(__self__, "network_id", network_id)
        if allow_zonal_shift is not None:
            pulumi.set(__self__, "allow_zonal_shift", allow_zonal_shift)
        if auto_scale_policy is not None:
            pulumi.set(__self__, "auto_scale_policy", auto_scale_policy)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if listeners is not None:
            pulumi.set(__self__, "listeners", listeners)
        if log_options is not None:
            pulumi.set(__self__, "log_options", log_options)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)

    @_builtins.property
    @pulumi.getter(name="allocationPolicy")
    def allocation_policy(self) -> pulumi.Input['AlbLoadBalancerAllocationPolicyArgs']:
        """
        Allocation zones for the Load Balancer instance.
        """
        return pulumi.get(self, "allocation_policy")

    @allocation_policy.setter
    def allocation_policy(self, value: pulumi.Input['AlbLoadBalancerAllocationPolicyArgs']):
        pulumi.set(self, "allocation_policy", value)

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[_builtins.str]:
        """
        The `VPC Network ID` of subnets which resource attached to.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "network_id", value)

    @_builtins.property
    @pulumi.getter(name="allowZonalShift")
    def allow_zonal_shift(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether application load balancer is available to zonal shift
        """
        return pulumi.get(self, "allow_zonal_shift")

    @allow_zonal_shift.setter
    def allow_zonal_shift(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_zonal_shift", value)

    @_builtins.property
    @pulumi.getter(name="autoScalePolicy")
    def auto_scale_policy(self) -> Optional[pulumi.Input['AlbLoadBalancerAutoScalePolicyArgs']]:
        """
        Scaling settings of the application load balancer.
        """
        return pulumi.get(self, "auto_scale_policy")

    @auto_scale_policy.setter
    def auto_scale_policy(self, value: Optional[pulumi.Input['AlbLoadBalancerAutoScalePolicyArgs']]):
        pulumi.set(self, "auto_scale_policy", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder_id", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def listeners(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlbLoadBalancerListenerArgs']]]]:
        """
        List of listeners for the Load Balancer.
        """
        return pulumi.get(self, "listeners")

    @listeners.setter
    def listeners(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlbLoadBalancerListenerArgs']]]]):
        pulumi.set(self, "listeners", value)

    @_builtins.property
    @pulumi.getter(name="logOptions")
    def log_options(self) -> Optional[pulumi.Input['AlbLoadBalancerLogOptionsArgs']]:
        """
        Cloud Logging settings.
        """
        return pulumi.get(self, "log_options")

    @log_options.setter
    def log_options(self, value: Optional[pulumi.Input['AlbLoadBalancerLogOptionsArgs']]):
        pulumi.set(self, "log_options", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region ID where Load Balancer is located at.
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_id", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of security groups applied to resource or their components.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_group_ids", value)


@pulumi.input_type
class _AlbLoadBalancerState:
    def __init__(__self__, *,
                 allocation_policy: Optional[pulumi.Input['AlbLoadBalancerAllocationPolicyArgs']] = None,
                 allow_zonal_shift: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_scale_policy: Optional[pulumi.Input['AlbLoadBalancerAutoScalePolicyArgs']] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 listeners: Optional[pulumi.Input[Sequence[pulumi.Input['AlbLoadBalancerListenerArgs']]]] = None,
                 log_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 log_options: Optional[pulumi.Input['AlbLoadBalancerLogOptionsArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AlbLoadBalancer resources.
        :param pulumi.Input['AlbLoadBalancerAllocationPolicyArgs'] allocation_policy: Allocation zones for the Load Balancer instance.
        :param pulumi.Input[_builtins.bool] allow_zonal_shift: Specifies whether application load balancer is available to zonal shift
        :param pulumi.Input['AlbLoadBalancerAutoScalePolicyArgs'] auto_scale_policy: Scaling settings of the application load balancer.
        :param pulumi.Input[_builtins.str] created_at: The creation timestamp of the resource.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[Sequence[pulumi.Input['AlbLoadBalancerListenerArgs']]] listeners: List of listeners for the Load Balancer.
        :param pulumi.Input[_builtins.str] log_group_id: Cloud Logging group ID to send logs to. Leave empty to use the balancer folder default log group.
        :param pulumi.Input['AlbLoadBalancerLogOptionsArgs'] log_options: Cloud Logging settings.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[_builtins.str] network_id: The `VPC Network ID` of subnets which resource attached to.
        :param pulumi.Input[_builtins.str] region_id: The region ID where Load Balancer is located at.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: The list of security groups applied to resource or their components.
        :param pulumi.Input[_builtins.str] status: Status of the Load Balancer.
        """
        if allocation_policy is not None:
            pulumi.set(__self__, "allocation_policy", allocation_policy)
        if allow_zonal_shift is not None:
            pulumi.set(__self__, "allow_zonal_shift", allow_zonal_shift)
        if auto_scale_policy is not None:
            pulumi.set(__self__, "auto_scale_policy", auto_scale_policy)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if listeners is not None:
            pulumi.set(__self__, "listeners", listeners)
        if log_group_id is not None:
            pulumi.set(__self__, "log_group_id", log_group_id)
        if log_options is not None:
            pulumi.set(__self__, "log_options", log_options)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="allocationPolicy")
    def allocation_policy(self) -> Optional[pulumi.Input['AlbLoadBalancerAllocationPolicyArgs']]:
        """
        Allocation zones for the Load Balancer instance.
        """
        return pulumi.get(self, "allocation_policy")

    @allocation_policy.setter
    def allocation_policy(self, value: Optional[pulumi.Input['AlbLoadBalancerAllocationPolicyArgs']]):
        pulumi.set(self, "allocation_policy", value)

    @_builtins.property
    @pulumi.getter(name="allowZonalShift")
    def allow_zonal_shift(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether application load balancer is available to zonal shift
        """
        return pulumi.get(self, "allow_zonal_shift")

    @allow_zonal_shift.setter
    def allow_zonal_shift(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_zonal_shift", value)

    @_builtins.property
    @pulumi.getter(name="autoScalePolicy")
    def auto_scale_policy(self) -> Optional[pulumi.Input['AlbLoadBalancerAutoScalePolicyArgs']]:
        """
        Scaling settings of the application load balancer.
        """
        return pulumi.get(self, "auto_scale_policy")

    @auto_scale_policy.setter
    def auto_scale_policy(self, value: Optional[pulumi.Input['AlbLoadBalancerAutoScalePolicyArgs']]):
        pulumi.set(self, "auto_scale_policy", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder_id", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def listeners(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlbLoadBalancerListenerArgs']]]]:
        """
        List of listeners for the Load Balancer.
        """
        return pulumi.get(self, "listeners")

    @listeners.setter
    def listeners(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlbLoadBalancerListenerArgs']]]]):
        pulumi.set(self, "listeners", value)

    @_builtins.property
    @pulumi.getter(name="logGroupId")
    def log_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cloud Logging group ID to send logs to. Leave empty to use the balancer folder default log group.
        """
        return pulumi.get(self, "log_group_id")

    @log_group_id.setter
    def log_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_group_id", value)

    @_builtins.property
    @pulumi.getter(name="logOptions")
    def log_options(self) -> Optional[pulumi.Input['AlbLoadBalancerLogOptionsArgs']]:
        """
        Cloud Logging settings.
        """
        return pulumi.get(self, "log_options")

    @log_options.setter
    def log_options(self, value: Optional[pulumi.Input['AlbLoadBalancerLogOptionsArgs']]):
        pulumi.set(self, "log_options", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The `VPC Network ID` of subnets which resource attached to.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_id", value)

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region ID where Load Balancer is located at.
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_id", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of security groups applied to resource or their components.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status of the Load Balancer.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("yandex:index/albLoadBalancer:AlbLoadBalancer")
class AlbLoadBalancer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allocation_policy: Optional[pulumi.Input[Union['AlbLoadBalancerAllocationPolicyArgs', 'AlbLoadBalancerAllocationPolicyArgsDict']]] = None,
                 allow_zonal_shift: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_scale_policy: Optional[pulumi.Input[Union['AlbLoadBalancerAutoScalePolicyArgs', 'AlbLoadBalancerAutoScalePolicyArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 listeners: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlbLoadBalancerListenerArgs', 'AlbLoadBalancerListenerArgsDict']]]]] = None,
                 log_options: Optional[pulumi.Input[Union['AlbLoadBalancerLogOptionsArgs', 'AlbLoadBalancerLogOptionsArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Creates an Application Load Balancer in the specified folder. For more information, see [the official documentation](https://yandex.cloud/docs/application-load-balancer/concepts/application-load-balancer).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new Application Load Balancer (ALB)
        #
        my_alb = yandex.AlbLoadBalancer("my_alb",
            name="my-load-balancer",
            network_id=test_network["id"],
            allocation_policy={
                "locations": [{
                    "zone_id": "ru-central1-a",
                    "subnet_id": test_subnet["id"],
                }],
            },
            listeners=[{
                "name": "my-listener",
                "endpoints": [{
                    "addresses": [{
                        "external_ipv4_address": {},
                    }],
                    "ports": [8080],
                }],
                "http": {
                    "handler": {
                        "http_router_id": test_router["id"],
                    },
                },
            }],
            log_options={
                "discard_rules": [{
                    "http_code_intervals": ["2XX"],
                    "discard_percent": 75,
                }],
            })
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        bash

        ```sh
        $ pulumi import yandex:index/albLoadBalancer:AlbLoadBalancer <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/albLoadBalancer:AlbLoadBalancer my_alb ds705**********q7qvl
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['AlbLoadBalancerAllocationPolicyArgs', 'AlbLoadBalancerAllocationPolicyArgsDict']] allocation_policy: Allocation zones for the Load Balancer instance.
        :param pulumi.Input[_builtins.bool] allow_zonal_shift: Specifies whether application load balancer is available to zonal shift
        :param pulumi.Input[Union['AlbLoadBalancerAutoScalePolicyArgs', 'AlbLoadBalancerAutoScalePolicyArgsDict']] auto_scale_policy: Scaling settings of the application load balancer.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlbLoadBalancerListenerArgs', 'AlbLoadBalancerListenerArgsDict']]]] listeners: List of listeners for the Load Balancer.
        :param pulumi.Input[Union['AlbLoadBalancerLogOptionsArgs', 'AlbLoadBalancerLogOptionsArgsDict']] log_options: Cloud Logging settings.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[_builtins.str] network_id: The `VPC Network ID` of subnets which resource attached to.
        :param pulumi.Input[_builtins.str] region_id: The region ID where Load Balancer is located at.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: The list of security groups applied to resource or their components.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AlbLoadBalancerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates an Application Load Balancer in the specified folder. For more information, see [the official documentation](https://yandex.cloud/docs/application-load-balancer/concepts/application-load-balancer).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new Application Load Balancer (ALB)
        #
        my_alb = yandex.AlbLoadBalancer("my_alb",
            name="my-load-balancer",
            network_id=test_network["id"],
            allocation_policy={
                "locations": [{
                    "zone_id": "ru-central1-a",
                    "subnet_id": test_subnet["id"],
                }],
            },
            listeners=[{
                "name": "my-listener",
                "endpoints": [{
                    "addresses": [{
                        "external_ipv4_address": {},
                    }],
                    "ports": [8080],
                }],
                "http": {
                    "handler": {
                        "http_router_id": test_router["id"],
                    },
                },
            }],
            log_options={
                "discard_rules": [{
                    "http_code_intervals": ["2XX"],
                    "discard_percent": 75,
                }],
            })
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        bash

        ```sh
        $ pulumi import yandex:index/albLoadBalancer:AlbLoadBalancer <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/albLoadBalancer:AlbLoadBalancer my_alb ds705**********q7qvl
        ```

        :param str resource_name: The name of the resource.
        :param AlbLoadBalancerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AlbLoadBalancerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allocation_policy: Optional[pulumi.Input[Union['AlbLoadBalancerAllocationPolicyArgs', 'AlbLoadBalancerAllocationPolicyArgsDict']]] = None,
                 allow_zonal_shift: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_scale_policy: Optional[pulumi.Input[Union['AlbLoadBalancerAutoScalePolicyArgs', 'AlbLoadBalancerAutoScalePolicyArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 listeners: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlbLoadBalancerListenerArgs', 'AlbLoadBalancerListenerArgsDict']]]]] = None,
                 log_options: Optional[pulumi.Input[Union['AlbLoadBalancerLogOptionsArgs', 'AlbLoadBalancerLogOptionsArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AlbLoadBalancerArgs.__new__(AlbLoadBalancerArgs)

            if allocation_policy is None and not opts.urn:
                raise TypeError("Missing required property 'allocation_policy'")
            __props__.__dict__["allocation_policy"] = allocation_policy
            __props__.__dict__["allow_zonal_shift"] = allow_zonal_shift
            __props__.__dict__["auto_scale_policy"] = auto_scale_policy
            __props__.__dict__["description"] = description
            __props__.__dict__["folder_id"] = folder_id
            __props__.__dict__["labels"] = labels
            __props__.__dict__["listeners"] = listeners
            __props__.__dict__["log_options"] = log_options
            __props__.__dict__["name"] = name
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            __props__.__dict__["region_id"] = region_id
            __props__.__dict__["security_group_ids"] = security_group_ids
            __props__.__dict__["created_at"] = None
            __props__.__dict__["log_group_id"] = None
            __props__.__dict__["status"] = None
        super(AlbLoadBalancer, __self__).__init__(
            'yandex:index/albLoadBalancer:AlbLoadBalancer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allocation_policy: Optional[pulumi.Input[Union['AlbLoadBalancerAllocationPolicyArgs', 'AlbLoadBalancerAllocationPolicyArgsDict']]] = None,
            allow_zonal_shift: Optional[pulumi.Input[_builtins.bool]] = None,
            auto_scale_policy: Optional[pulumi.Input[Union['AlbLoadBalancerAutoScalePolicyArgs', 'AlbLoadBalancerAutoScalePolicyArgsDict']]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            folder_id: Optional[pulumi.Input[_builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            listeners: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlbLoadBalancerListenerArgs', 'AlbLoadBalancerListenerArgsDict']]]]] = None,
            log_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            log_options: Optional[pulumi.Input[Union['AlbLoadBalancerLogOptionsArgs', 'AlbLoadBalancerLogOptionsArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_id: Optional[pulumi.Input[_builtins.str]] = None,
            region_id: Optional[pulumi.Input[_builtins.str]] = None,
            security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'AlbLoadBalancer':
        """
        Get an existing AlbLoadBalancer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['AlbLoadBalancerAllocationPolicyArgs', 'AlbLoadBalancerAllocationPolicyArgsDict']] allocation_policy: Allocation zones for the Load Balancer instance.
        :param pulumi.Input[_builtins.bool] allow_zonal_shift: Specifies whether application load balancer is available to zonal shift
        :param pulumi.Input[Union['AlbLoadBalancerAutoScalePolicyArgs', 'AlbLoadBalancerAutoScalePolicyArgsDict']] auto_scale_policy: Scaling settings of the application load balancer.
        :param pulumi.Input[_builtins.str] created_at: The creation timestamp of the resource.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlbLoadBalancerListenerArgs', 'AlbLoadBalancerListenerArgsDict']]]] listeners: List of listeners for the Load Balancer.
        :param pulumi.Input[_builtins.str] log_group_id: Cloud Logging group ID to send logs to. Leave empty to use the balancer folder default log group.
        :param pulumi.Input[Union['AlbLoadBalancerLogOptionsArgs', 'AlbLoadBalancerLogOptionsArgsDict']] log_options: Cloud Logging settings.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[_builtins.str] network_id: The `VPC Network ID` of subnets which resource attached to.
        :param pulumi.Input[_builtins.str] region_id: The region ID where Load Balancer is located at.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: The list of security groups applied to resource or their components.
        :param pulumi.Input[_builtins.str] status: Status of the Load Balancer.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AlbLoadBalancerState.__new__(_AlbLoadBalancerState)

        __props__.__dict__["allocation_policy"] = allocation_policy
        __props__.__dict__["allow_zonal_shift"] = allow_zonal_shift
        __props__.__dict__["auto_scale_policy"] = auto_scale_policy
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["folder_id"] = folder_id
        __props__.__dict__["labels"] = labels
        __props__.__dict__["listeners"] = listeners
        __props__.__dict__["log_group_id"] = log_group_id
        __props__.__dict__["log_options"] = log_options
        __props__.__dict__["name"] = name
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["region_id"] = region_id
        __props__.__dict__["security_group_ids"] = security_group_ids
        __props__.__dict__["status"] = status
        return AlbLoadBalancer(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="allocationPolicy")
    def allocation_policy(self) -> pulumi.Output['outputs.AlbLoadBalancerAllocationPolicy']:
        """
        Allocation zones for the Load Balancer instance.
        """
        return pulumi.get(self, "allocation_policy")

    @_builtins.property
    @pulumi.getter(name="allowZonalShift")
    def allow_zonal_shift(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether application load balancer is available to zonal shift
        """
        return pulumi.get(self, "allow_zonal_shift")

    @_builtins.property
    @pulumi.getter(name="autoScalePolicy")
    def auto_scale_policy(self) -> pulumi.Output[Optional['outputs.AlbLoadBalancerAutoScalePolicy']]:
        """
        Scaling settings of the application load balancer.
        """
        return pulumi.get(self, "auto_scale_policy")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> pulumi.Output[_builtins.str]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def listeners(self) -> pulumi.Output[Optional[Sequence['outputs.AlbLoadBalancerListener']]]:
        """
        List of listeners for the Load Balancer.
        """
        return pulumi.get(self, "listeners")

    @_builtins.property
    @pulumi.getter(name="logGroupId")
    def log_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        Cloud Logging group ID to send logs to. Leave empty to use the balancer folder default log group.
        """
        return pulumi.get(self, "log_group_id")

    @_builtins.property
    @pulumi.getter(name="logOptions")
    def log_options(self) -> pulumi.Output[Optional['outputs.AlbLoadBalancerLogOptions']]:
        """
        Cloud Logging settings.
        """
        return pulumi.get(self, "log_options")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[_builtins.str]:
        """
        The `VPC Network ID` of subnets which resource attached to.
        """
        return pulumi.get(self, "network_id")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The region ID where Load Balancer is located at.
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The list of security groups applied to resource or their components.
        """
        return pulumi.get(self, "security_group_ids")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Status of the Load Balancer.
        """
        return pulumi.get(self, "status")

