# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BackupPolicyArgs', 'BackupPolicy']

@pulumi.input_type
class BackupPolicyArgs:
    def __init__(__self__, *,
                 reattempts: pulumi.Input['BackupPolicyReattemptsArgs'],
                 retention: pulumi.Input['BackupPolicyRetentionArgs'],
                 scheduling: pulumi.Input['BackupPolicySchedulingArgs'],
                 vm_snapshot_reattempts: pulumi.Input['BackupPolicyVmSnapshotReattemptsArgs'],
                 archive_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cbt: Optional[pulumi.Input[_builtins.str]] = None,
                 compression: Optional[pulumi.Input[_builtins.str]] = None,
                 fast_backup_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 file_filters: Optional[pulumi.Input['BackupPolicyFileFiltersArgs']] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 format: Optional[pulumi.Input[_builtins.str]] = None,
                 lvm_snapshotting_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 multi_volume_snapshotting_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 performance_window_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 preserve_file_security_settings: Optional[pulumi.Input[_builtins.bool]] = None,
                 quiesce_snapshotting_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 sector_by_sector: Optional[pulumi.Input[_builtins.bool]] = None,
                 silent_mode_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 splitting_bytes: Optional[pulumi.Input[_builtins.str]] = None,
                 validation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 vss_provider: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a BackupPolicy resource.
        :param pulumi.Input['BackupPolicyReattemptsArgs'] reattempts: Amount of reattempts that should be performed while trying to make backup at the host.
        :param pulumi.Input['BackupPolicyRetentionArgs'] retention: Retention policy for backups. Allows to setup backups lifecycle.
        :param pulumi.Input['BackupPolicySchedulingArgs'] scheduling: Schedule settings for creating backups on the host.
        :param pulumi.Input['BackupPolicyVmSnapshotReattemptsArgs'] vm_snapshot_reattempts: Amount of reattempts that should be performed while trying to make snapshot.
        :param pulumi.Input[_builtins.str] archive_name: The name of generated archives. Default `[Machine Name]-[Plan ID]-[Unique ID]a`.
        :param pulumi.Input[_builtins.str] cbt: Configuration of Changed Block Tracking. Available values are: `USE_IF_ENABLED`, `ENABLED_AND_USE`, `DO_NOT_USE`. Default `DO_NOT_USE`.
        :param pulumi.Input[_builtins.str] compression: Archive compression level. Affects CPU. Available values: `NORMAL`, `HIGH`, `MAX`, `OFF`. Default: `NORMAL`.
        :param pulumi.Input[_builtins.bool] fast_backup_enabled: If true, determines whether a file has changed by the file size and timestamp. Otherwise, the entire file contents are compared to those stored in the backup.
        :param pulumi.Input['BackupPolicyFileFiltersArgs'] file_filters: File filters to specify masks of files to backup or to exclude of backuping.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[_builtins.str] format: Format of the backup. It's strongly recommend to leave this option empty or `AUTO`. Available values: `AUTO`, `VERSION_11`, `VERSION_12`.
        :param pulumi.Input[_builtins.bool] lvm_snapshotting_enabled: LVM will be used to create the volume snapshot. If LVM fails to create a snapshot (for example, because there is not enough free space), the software will create the snapshot itself.
        :param pulumi.Input[_builtins.bool] multi_volume_snapshotting_enabled: If true, snapshots of multiple volumes will be taken simultaneously. Default `true`.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[_builtins.bool] performance_window_enabled: Time windows for performance limitations of backup. Default `false`.
        :param pulumi.Input[_builtins.bool] preserve_file_security_settings: If true, a quiesced snapshot of the virtual machine will be taken. Default `true`.
        :param pulumi.Input[_builtins.bool] quiesce_snapshotting_enabled: If true, a quiesced snapshot of the virtual machine will be taken. Default `true`.
        :param pulumi.Input[_builtins.bool] sector_by_sector: A sector-by-sector backup of a disk or volume creates a backup copy of all sectors of the disk or volume, including those that do not contain data. Therefore, the size of such a backup copy will be equal to the size of the original disk or volume.
        :param pulumi.Input[_builtins.bool] silent_mode_enabled: If true, a user interaction will be avoided when possible. Default `true`.
        :param pulumi.Input[_builtins.str] splitting_bytes: Determines the size to split backups. It's better to leave this option unchanged. Default `9223372036854775807`.
        :param pulumi.Input[_builtins.bool] validation_enabled: Validation is a time-consuming process, even with incremental or differential backups of small amounts of data. This is because not only the data physically contained in the backup copy is verified, but all data restored when it is selected. This option requires access to previously created backup copies.
        :param pulumi.Input[_builtins.str] vss_provider: Settings for the volume shadow copy service. Available values are: `NATIVE`, `TARGET_SYSTEM_DEFINED`. Default `NATIVE`.
        """
        pulumi.set(__self__, "reattempts", reattempts)
        pulumi.set(__self__, "retention", retention)
        pulumi.set(__self__, "scheduling", scheduling)
        pulumi.set(__self__, "vm_snapshot_reattempts", vm_snapshot_reattempts)
        if archive_name is not None:
            pulumi.set(__self__, "archive_name", archive_name)
        if cbt is not None:
            pulumi.set(__self__, "cbt", cbt)
        if compression is not None:
            pulumi.set(__self__, "compression", compression)
        if fast_backup_enabled is not None:
            pulumi.set(__self__, "fast_backup_enabled", fast_backup_enabled)
        if file_filters is not None:
            pulumi.set(__self__, "file_filters", file_filters)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if lvm_snapshotting_enabled is not None:
            pulumi.set(__self__, "lvm_snapshotting_enabled", lvm_snapshotting_enabled)
        if multi_volume_snapshotting_enabled is not None:
            pulumi.set(__self__, "multi_volume_snapshotting_enabled", multi_volume_snapshotting_enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if performance_window_enabled is not None:
            pulumi.set(__self__, "performance_window_enabled", performance_window_enabled)
        if preserve_file_security_settings is not None:
            warnings.warn("""This setting is depricated and will be removed in future versions. You can safely delete it.""", DeprecationWarning)
            pulumi.log.warn("""preserve_file_security_settings is deprecated: This setting is depricated and will be removed in future versions. You can safely delete it.""")
        if preserve_file_security_settings is not None:
            pulumi.set(__self__, "preserve_file_security_settings", preserve_file_security_settings)
        if quiesce_snapshotting_enabled is not None:
            warnings.warn("""This setting is depricated and will be removed in future versions. You can safely delete it.""", DeprecationWarning)
            pulumi.log.warn("""quiesce_snapshotting_enabled is deprecated: This setting is depricated and will be removed in future versions. You can safely delete it.""")
        if quiesce_snapshotting_enabled is not None:
            pulumi.set(__self__, "quiesce_snapshotting_enabled", quiesce_snapshotting_enabled)
        if sector_by_sector is not None:
            pulumi.set(__self__, "sector_by_sector", sector_by_sector)
        if silent_mode_enabled is not None:
            pulumi.set(__self__, "silent_mode_enabled", silent_mode_enabled)
        if splitting_bytes is not None:
            pulumi.set(__self__, "splitting_bytes", splitting_bytes)
        if validation_enabled is not None:
            pulumi.set(__self__, "validation_enabled", validation_enabled)
        if vss_provider is not None:
            pulumi.set(__self__, "vss_provider", vss_provider)

    @_builtins.property
    @pulumi.getter
    def reattempts(self) -> pulumi.Input['BackupPolicyReattemptsArgs']:
        """
        Amount of reattempts that should be performed while trying to make backup at the host.
        """
        return pulumi.get(self, "reattempts")

    @reattempts.setter
    def reattempts(self, value: pulumi.Input['BackupPolicyReattemptsArgs']):
        pulumi.set(self, "reattempts", value)

    @_builtins.property
    @pulumi.getter
    def retention(self) -> pulumi.Input['BackupPolicyRetentionArgs']:
        """
        Retention policy for backups. Allows to setup backups lifecycle.
        """
        return pulumi.get(self, "retention")

    @retention.setter
    def retention(self, value: pulumi.Input['BackupPolicyRetentionArgs']):
        pulumi.set(self, "retention", value)

    @_builtins.property
    @pulumi.getter
    def scheduling(self) -> pulumi.Input['BackupPolicySchedulingArgs']:
        """
        Schedule settings for creating backups on the host.
        """
        return pulumi.get(self, "scheduling")

    @scheduling.setter
    def scheduling(self, value: pulumi.Input['BackupPolicySchedulingArgs']):
        pulumi.set(self, "scheduling", value)

    @_builtins.property
    @pulumi.getter(name="vmSnapshotReattempts")
    def vm_snapshot_reattempts(self) -> pulumi.Input['BackupPolicyVmSnapshotReattemptsArgs']:
        """
        Amount of reattempts that should be performed while trying to make snapshot.
        """
        return pulumi.get(self, "vm_snapshot_reattempts")

    @vm_snapshot_reattempts.setter
    def vm_snapshot_reattempts(self, value: pulumi.Input['BackupPolicyVmSnapshotReattemptsArgs']):
        pulumi.set(self, "vm_snapshot_reattempts", value)

    @_builtins.property
    @pulumi.getter(name="archiveName")
    def archive_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of generated archives. Default `[Machine Name]-[Plan ID]-[Unique ID]a`.
        """
        return pulumi.get(self, "archive_name")

    @archive_name.setter
    def archive_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "archive_name", value)

    @_builtins.property
    @pulumi.getter
    def cbt(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Configuration of Changed Block Tracking. Available values are: `USE_IF_ENABLED`, `ENABLED_AND_USE`, `DO_NOT_USE`. Default `DO_NOT_USE`.
        """
        return pulumi.get(self, "cbt")

    @cbt.setter
    def cbt(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cbt", value)

    @_builtins.property
    @pulumi.getter
    def compression(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Archive compression level. Affects CPU. Available values: `NORMAL`, `HIGH`, `MAX`, `OFF`. Default: `NORMAL`.
        """
        return pulumi.get(self, "compression")

    @compression.setter
    def compression(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compression", value)

    @_builtins.property
    @pulumi.getter(name="fastBackupEnabled")
    def fast_backup_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, determines whether a file has changed by the file size and timestamp. Otherwise, the entire file contents are compared to those stored in the backup.
        """
        return pulumi.get(self, "fast_backup_enabled")

    @fast_backup_enabled.setter
    def fast_backup_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "fast_backup_enabled", value)

    @_builtins.property
    @pulumi.getter(name="fileFilters")
    def file_filters(self) -> Optional[pulumi.Input['BackupPolicyFileFiltersArgs']]:
        """
        File filters to specify masks of files to backup or to exclude of backuping.
        """
        return pulumi.get(self, "file_filters")

    @file_filters.setter
    def file_filters(self, value: Optional[pulumi.Input['BackupPolicyFileFiltersArgs']]):
        pulumi.set(self, "file_filters", value)

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder_id", value)

    @_builtins.property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Format of the backup. It's strongly recommend to leave this option empty or `AUTO`. Available values: `AUTO`, `VERSION_11`, `VERSION_12`.
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "format", value)

    @_builtins.property
    @pulumi.getter(name="lvmSnapshottingEnabled")
    def lvm_snapshotting_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        LVM will be used to create the volume snapshot. If LVM fails to create a snapshot (for example, because there is not enough free space), the software will create the snapshot itself.
        """
        return pulumi.get(self, "lvm_snapshotting_enabled")

    @lvm_snapshotting_enabled.setter
    def lvm_snapshotting_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "lvm_snapshotting_enabled", value)

    @_builtins.property
    @pulumi.getter(name="multiVolumeSnapshottingEnabled")
    def multi_volume_snapshotting_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, snapshots of multiple volumes will be taken simultaneously. Default `true`.
        """
        return pulumi.get(self, "multi_volume_snapshotting_enabled")

    @multi_volume_snapshotting_enabled.setter
    def multi_volume_snapshotting_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "multi_volume_snapshotting_enabled", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="performanceWindowEnabled")
    def performance_window_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Time windows for performance limitations of backup. Default `false`.
        """
        return pulumi.get(self, "performance_window_enabled")

    @performance_window_enabled.setter
    def performance_window_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "performance_window_enabled", value)

    @_builtins.property
    @pulumi.getter(name="preserveFileSecuritySettings")
    @_utilities.deprecated("""This setting is depricated and will be removed in future versions. You can safely delete it.""")
    def preserve_file_security_settings(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, a quiesced snapshot of the virtual machine will be taken. Default `true`.
        """
        return pulumi.get(self, "preserve_file_security_settings")

    @preserve_file_security_settings.setter
    def preserve_file_security_settings(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "preserve_file_security_settings", value)

    @_builtins.property
    @pulumi.getter(name="quiesceSnapshottingEnabled")
    @_utilities.deprecated("""This setting is depricated and will be removed in future versions. You can safely delete it.""")
    def quiesce_snapshotting_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, a quiesced snapshot of the virtual machine will be taken. Default `true`.
        """
        return pulumi.get(self, "quiesce_snapshotting_enabled")

    @quiesce_snapshotting_enabled.setter
    def quiesce_snapshotting_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "quiesce_snapshotting_enabled", value)

    @_builtins.property
    @pulumi.getter(name="sectorBySector")
    def sector_by_sector(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        A sector-by-sector backup of a disk or volume creates a backup copy of all sectors of the disk or volume, including those that do not contain data. Therefore, the size of such a backup copy will be equal to the size of the original disk or volume.
        """
        return pulumi.get(self, "sector_by_sector")

    @sector_by_sector.setter
    def sector_by_sector(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "sector_by_sector", value)

    @_builtins.property
    @pulumi.getter(name="silentModeEnabled")
    def silent_mode_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, a user interaction will be avoided when possible. Default `true`.
        """
        return pulumi.get(self, "silent_mode_enabled")

    @silent_mode_enabled.setter
    def silent_mode_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "silent_mode_enabled", value)

    @_builtins.property
    @pulumi.getter(name="splittingBytes")
    def splitting_bytes(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Determines the size to split backups. It's better to leave this option unchanged. Default `9223372036854775807`.
        """
        return pulumi.get(self, "splitting_bytes")

    @splitting_bytes.setter
    def splitting_bytes(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "splitting_bytes", value)

    @_builtins.property
    @pulumi.getter(name="validationEnabled")
    def validation_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Validation is a time-consuming process, even with incremental or differential backups of small amounts of data. This is because not only the data physically contained in the backup copy is verified, but all data restored when it is selected. This option requires access to previously created backup copies.
        """
        return pulumi.get(self, "validation_enabled")

    @validation_enabled.setter
    def validation_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "validation_enabled", value)

    @_builtins.property
    @pulumi.getter(name="vssProvider")
    def vss_provider(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Settings for the volume shadow copy service. Available values are: `NATIVE`, `TARGET_SYSTEM_DEFINED`. Default `NATIVE`.
        """
        return pulumi.get(self, "vss_provider")

    @vss_provider.setter
    def vss_provider(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vss_provider", value)


@pulumi.input_type
class _BackupPolicyState:
    def __init__(__self__, *,
                 archive_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cbt: Optional[pulumi.Input[_builtins.str]] = None,
                 compression: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 fast_backup_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 file_filters: Optional[pulumi.Input['BackupPolicyFileFiltersArgs']] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 format: Optional[pulumi.Input[_builtins.str]] = None,
                 lvm_snapshotting_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 multi_volume_snapshotting_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 performance_window_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 preserve_file_security_settings: Optional[pulumi.Input[_builtins.bool]] = None,
                 quiesce_snapshotting_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 reattempts: Optional[pulumi.Input['BackupPolicyReattemptsArgs']] = None,
                 retention: Optional[pulumi.Input['BackupPolicyRetentionArgs']] = None,
                 scheduling: Optional[pulumi.Input['BackupPolicySchedulingArgs']] = None,
                 sector_by_sector: Optional[pulumi.Input[_builtins.bool]] = None,
                 silent_mode_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 splitting_bytes: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None,
                 validation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 vm_snapshot_reattempts: Optional[pulumi.Input['BackupPolicyVmSnapshotReattemptsArgs']] = None,
                 vss_provider: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering BackupPolicy resources.
        :param pulumi.Input[_builtins.str] archive_name: The name of generated archives. Default `[Machine Name]-[Plan ID]-[Unique ID]a`.
        :param pulumi.Input[_builtins.str] cbt: Configuration of Changed Block Tracking. Available values are: `USE_IF_ENABLED`, `ENABLED_AND_USE`, `DO_NOT_USE`. Default `DO_NOT_USE`.
        :param pulumi.Input[_builtins.str] compression: Archive compression level. Affects CPU. Available values: `NORMAL`, `HIGH`, `MAX`, `OFF`. Default: `NORMAL`.
        :param pulumi.Input[_builtins.str] created_at: The creation timestamp of the resource.
        :param pulumi.Input[_builtins.bool] enabled: If this field is true, it means that the policy is enabled.
        :param pulumi.Input[_builtins.bool] fast_backup_enabled: If true, determines whether a file has changed by the file size and timestamp. Otherwise, the entire file contents are compared to those stored in the backup.
        :param pulumi.Input['BackupPolicyFileFiltersArgs'] file_filters: File filters to specify masks of files to backup or to exclude of backuping.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[_builtins.str] format: Format of the backup. It's strongly recommend to leave this option empty or `AUTO`. Available values: `AUTO`, `VERSION_11`, `VERSION_12`.
        :param pulumi.Input[_builtins.bool] lvm_snapshotting_enabled: LVM will be used to create the volume snapshot. If LVM fails to create a snapshot (for example, because there is not enough free space), the software will create the snapshot itself.
        :param pulumi.Input[_builtins.bool] multi_volume_snapshotting_enabled: If true, snapshots of multiple volumes will be taken simultaneously. Default `true`.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[_builtins.bool] performance_window_enabled: Time windows for performance limitations of backup. Default `false`.
        :param pulumi.Input[_builtins.bool] preserve_file_security_settings: If true, a quiesced snapshot of the virtual machine will be taken. Default `true`.
        :param pulumi.Input[_builtins.bool] quiesce_snapshotting_enabled: If true, a quiesced snapshot of the virtual machine will be taken. Default `true`.
        :param pulumi.Input['BackupPolicyReattemptsArgs'] reattempts: Amount of reattempts that should be performed while trying to make backup at the host.
        :param pulumi.Input['BackupPolicyRetentionArgs'] retention: Retention policy for backups. Allows to setup backups lifecycle.
        :param pulumi.Input['BackupPolicySchedulingArgs'] scheduling: Schedule settings for creating backups on the host.
        :param pulumi.Input[_builtins.bool] sector_by_sector: A sector-by-sector backup of a disk or volume creates a backup copy of all sectors of the disk or volume, including those that do not contain data. Therefore, the size of such a backup copy will be equal to the size of the original disk or volume.
        :param pulumi.Input[_builtins.bool] silent_mode_enabled: If true, a user interaction will be avoided when possible. Default `true`.
        :param pulumi.Input[_builtins.str] splitting_bytes: Determines the size to split backups. It's better to leave this option unchanged. Default `9223372036854775807`.
        :param pulumi.Input[_builtins.str] updated_at: The update timestamp of the resource.
        :param pulumi.Input[_builtins.bool] validation_enabled: Validation is a time-consuming process, even with incremental or differential backups of small amounts of data. This is because not only the data physically contained in the backup copy is verified, but all data restored when it is selected. This option requires access to previously created backup copies.
        :param pulumi.Input['BackupPolicyVmSnapshotReattemptsArgs'] vm_snapshot_reattempts: Amount of reattempts that should be performed while trying to make snapshot.
        :param pulumi.Input[_builtins.str] vss_provider: Settings for the volume shadow copy service. Available values are: `NATIVE`, `TARGET_SYSTEM_DEFINED`. Default `NATIVE`.
        """
        if archive_name is not None:
            pulumi.set(__self__, "archive_name", archive_name)
        if cbt is not None:
            pulumi.set(__self__, "cbt", cbt)
        if compression is not None:
            pulumi.set(__self__, "compression", compression)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if fast_backup_enabled is not None:
            pulumi.set(__self__, "fast_backup_enabled", fast_backup_enabled)
        if file_filters is not None:
            pulumi.set(__self__, "file_filters", file_filters)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if lvm_snapshotting_enabled is not None:
            pulumi.set(__self__, "lvm_snapshotting_enabled", lvm_snapshotting_enabled)
        if multi_volume_snapshotting_enabled is not None:
            pulumi.set(__self__, "multi_volume_snapshotting_enabled", multi_volume_snapshotting_enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if performance_window_enabled is not None:
            pulumi.set(__self__, "performance_window_enabled", performance_window_enabled)
        if preserve_file_security_settings is not None:
            warnings.warn("""This setting is depricated and will be removed in future versions. You can safely delete it.""", DeprecationWarning)
            pulumi.log.warn("""preserve_file_security_settings is deprecated: This setting is depricated and will be removed in future versions. You can safely delete it.""")
        if preserve_file_security_settings is not None:
            pulumi.set(__self__, "preserve_file_security_settings", preserve_file_security_settings)
        if quiesce_snapshotting_enabled is not None:
            warnings.warn("""This setting is depricated and will be removed in future versions. You can safely delete it.""", DeprecationWarning)
            pulumi.log.warn("""quiesce_snapshotting_enabled is deprecated: This setting is depricated and will be removed in future versions. You can safely delete it.""")
        if quiesce_snapshotting_enabled is not None:
            pulumi.set(__self__, "quiesce_snapshotting_enabled", quiesce_snapshotting_enabled)
        if reattempts is not None:
            pulumi.set(__self__, "reattempts", reattempts)
        if retention is not None:
            pulumi.set(__self__, "retention", retention)
        if scheduling is not None:
            pulumi.set(__self__, "scheduling", scheduling)
        if sector_by_sector is not None:
            pulumi.set(__self__, "sector_by_sector", sector_by_sector)
        if silent_mode_enabled is not None:
            pulumi.set(__self__, "silent_mode_enabled", silent_mode_enabled)
        if splitting_bytes is not None:
            pulumi.set(__self__, "splitting_bytes", splitting_bytes)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if validation_enabled is not None:
            pulumi.set(__self__, "validation_enabled", validation_enabled)
        if vm_snapshot_reattempts is not None:
            pulumi.set(__self__, "vm_snapshot_reattempts", vm_snapshot_reattempts)
        if vss_provider is not None:
            pulumi.set(__self__, "vss_provider", vss_provider)

    @_builtins.property
    @pulumi.getter(name="archiveName")
    def archive_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of generated archives. Default `[Machine Name]-[Plan ID]-[Unique ID]a`.
        """
        return pulumi.get(self, "archive_name")

    @archive_name.setter
    def archive_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "archive_name", value)

    @_builtins.property
    @pulumi.getter
    def cbt(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Configuration of Changed Block Tracking. Available values are: `USE_IF_ENABLED`, `ENABLED_AND_USE`, `DO_NOT_USE`. Default `DO_NOT_USE`.
        """
        return pulumi.get(self, "cbt")

    @cbt.setter
    def cbt(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cbt", value)

    @_builtins.property
    @pulumi.getter
    def compression(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Archive compression level. Affects CPU. Available values: `NORMAL`, `HIGH`, `MAX`, `OFF`. Default: `NORMAL`.
        """
        return pulumi.get(self, "compression")

    @compression.setter
    def compression(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compression", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If this field is true, it means that the policy is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="fastBackupEnabled")
    def fast_backup_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, determines whether a file has changed by the file size and timestamp. Otherwise, the entire file contents are compared to those stored in the backup.
        """
        return pulumi.get(self, "fast_backup_enabled")

    @fast_backup_enabled.setter
    def fast_backup_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "fast_backup_enabled", value)

    @_builtins.property
    @pulumi.getter(name="fileFilters")
    def file_filters(self) -> Optional[pulumi.Input['BackupPolicyFileFiltersArgs']]:
        """
        File filters to specify masks of files to backup or to exclude of backuping.
        """
        return pulumi.get(self, "file_filters")

    @file_filters.setter
    def file_filters(self, value: Optional[pulumi.Input['BackupPolicyFileFiltersArgs']]):
        pulumi.set(self, "file_filters", value)

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder_id", value)

    @_builtins.property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Format of the backup. It's strongly recommend to leave this option empty or `AUTO`. Available values: `AUTO`, `VERSION_11`, `VERSION_12`.
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "format", value)

    @_builtins.property
    @pulumi.getter(name="lvmSnapshottingEnabled")
    def lvm_snapshotting_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        LVM will be used to create the volume snapshot. If LVM fails to create a snapshot (for example, because there is not enough free space), the software will create the snapshot itself.
        """
        return pulumi.get(self, "lvm_snapshotting_enabled")

    @lvm_snapshotting_enabled.setter
    def lvm_snapshotting_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "lvm_snapshotting_enabled", value)

    @_builtins.property
    @pulumi.getter(name="multiVolumeSnapshottingEnabled")
    def multi_volume_snapshotting_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, snapshots of multiple volumes will be taken simultaneously. Default `true`.
        """
        return pulumi.get(self, "multi_volume_snapshotting_enabled")

    @multi_volume_snapshotting_enabled.setter
    def multi_volume_snapshotting_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "multi_volume_snapshotting_enabled", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="performanceWindowEnabled")
    def performance_window_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Time windows for performance limitations of backup. Default `false`.
        """
        return pulumi.get(self, "performance_window_enabled")

    @performance_window_enabled.setter
    def performance_window_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "performance_window_enabled", value)

    @_builtins.property
    @pulumi.getter(name="preserveFileSecuritySettings")
    @_utilities.deprecated("""This setting is depricated and will be removed in future versions. You can safely delete it.""")
    def preserve_file_security_settings(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, a quiesced snapshot of the virtual machine will be taken. Default `true`.
        """
        return pulumi.get(self, "preserve_file_security_settings")

    @preserve_file_security_settings.setter
    def preserve_file_security_settings(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "preserve_file_security_settings", value)

    @_builtins.property
    @pulumi.getter(name="quiesceSnapshottingEnabled")
    @_utilities.deprecated("""This setting is depricated and will be removed in future versions. You can safely delete it.""")
    def quiesce_snapshotting_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, a quiesced snapshot of the virtual machine will be taken. Default `true`.
        """
        return pulumi.get(self, "quiesce_snapshotting_enabled")

    @quiesce_snapshotting_enabled.setter
    def quiesce_snapshotting_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "quiesce_snapshotting_enabled", value)

    @_builtins.property
    @pulumi.getter
    def reattempts(self) -> Optional[pulumi.Input['BackupPolicyReattemptsArgs']]:
        """
        Amount of reattempts that should be performed while trying to make backup at the host.
        """
        return pulumi.get(self, "reattempts")

    @reattempts.setter
    def reattempts(self, value: Optional[pulumi.Input['BackupPolicyReattemptsArgs']]):
        pulumi.set(self, "reattempts", value)

    @_builtins.property
    @pulumi.getter
    def retention(self) -> Optional[pulumi.Input['BackupPolicyRetentionArgs']]:
        """
        Retention policy for backups. Allows to setup backups lifecycle.
        """
        return pulumi.get(self, "retention")

    @retention.setter
    def retention(self, value: Optional[pulumi.Input['BackupPolicyRetentionArgs']]):
        pulumi.set(self, "retention", value)

    @_builtins.property
    @pulumi.getter
    def scheduling(self) -> Optional[pulumi.Input['BackupPolicySchedulingArgs']]:
        """
        Schedule settings for creating backups on the host.
        """
        return pulumi.get(self, "scheduling")

    @scheduling.setter
    def scheduling(self, value: Optional[pulumi.Input['BackupPolicySchedulingArgs']]):
        pulumi.set(self, "scheduling", value)

    @_builtins.property
    @pulumi.getter(name="sectorBySector")
    def sector_by_sector(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        A sector-by-sector backup of a disk or volume creates a backup copy of all sectors of the disk or volume, including those that do not contain data. Therefore, the size of such a backup copy will be equal to the size of the original disk or volume.
        """
        return pulumi.get(self, "sector_by_sector")

    @sector_by_sector.setter
    def sector_by_sector(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "sector_by_sector", value)

    @_builtins.property
    @pulumi.getter(name="silentModeEnabled")
    def silent_mode_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, a user interaction will be avoided when possible. Default `true`.
        """
        return pulumi.get(self, "silent_mode_enabled")

    @silent_mode_enabled.setter
    def silent_mode_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "silent_mode_enabled", value)

    @_builtins.property
    @pulumi.getter(name="splittingBytes")
    def splitting_bytes(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Determines the size to split backups. It's better to leave this option unchanged. Default `9223372036854775807`.
        """
        return pulumi.get(self, "splitting_bytes")

    @splitting_bytes.setter
    def splitting_bytes(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "splitting_bytes", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The update timestamp of the resource.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)

    @_builtins.property
    @pulumi.getter(name="validationEnabled")
    def validation_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Validation is a time-consuming process, even with incremental or differential backups of small amounts of data. This is because not only the data physically contained in the backup copy is verified, but all data restored when it is selected. This option requires access to previously created backup copies.
        """
        return pulumi.get(self, "validation_enabled")

    @validation_enabled.setter
    def validation_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "validation_enabled", value)

    @_builtins.property
    @pulumi.getter(name="vmSnapshotReattempts")
    def vm_snapshot_reattempts(self) -> Optional[pulumi.Input['BackupPolicyVmSnapshotReattemptsArgs']]:
        """
        Amount of reattempts that should be performed while trying to make snapshot.
        """
        return pulumi.get(self, "vm_snapshot_reattempts")

    @vm_snapshot_reattempts.setter
    def vm_snapshot_reattempts(self, value: Optional[pulumi.Input['BackupPolicyVmSnapshotReattemptsArgs']]):
        pulumi.set(self, "vm_snapshot_reattempts", value)

    @_builtins.property
    @pulumi.getter(name="vssProvider")
    def vss_provider(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Settings for the volume shadow copy service. Available values are: `NATIVE`, `TARGET_SYSTEM_DEFINED`. Default `NATIVE`.
        """
        return pulumi.get(self, "vss_provider")

    @vss_provider.setter
    def vss_provider(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vss_provider", value)


@pulumi.type_token("yandex:index/backupPolicy:BackupPolicy")
class BackupPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 archive_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cbt: Optional[pulumi.Input[_builtins.str]] = None,
                 compression: Optional[pulumi.Input[_builtins.str]] = None,
                 fast_backup_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 file_filters: Optional[pulumi.Input[Union['BackupPolicyFileFiltersArgs', 'BackupPolicyFileFiltersArgsDict']]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 format: Optional[pulumi.Input[_builtins.str]] = None,
                 lvm_snapshotting_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 multi_volume_snapshotting_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 performance_window_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 preserve_file_security_settings: Optional[pulumi.Input[_builtins.bool]] = None,
                 quiesce_snapshotting_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 reattempts: Optional[pulumi.Input[Union['BackupPolicyReattemptsArgs', 'BackupPolicyReattemptsArgsDict']]] = None,
                 retention: Optional[pulumi.Input[Union['BackupPolicyRetentionArgs', 'BackupPolicyRetentionArgsDict']]] = None,
                 scheduling: Optional[pulumi.Input[Union['BackupPolicySchedulingArgs', 'BackupPolicySchedulingArgsDict']]] = None,
                 sector_by_sector: Optional[pulumi.Input[_builtins.bool]] = None,
                 silent_mode_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 splitting_bytes: Optional[pulumi.Input[_builtins.str]] = None,
                 validation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 vm_snapshot_reattempts: Optional[pulumi.Input[Union['BackupPolicyVmSnapshotReattemptsArgs', 'BackupPolicyVmSnapshotReattemptsArgsDict']]] = None,
                 vss_provider: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Allows management of [Yandex Cloud Backup Policy](https://yandex.cloud/docs/backup/concepts/policy).

        > Cloud Backup Provider must be activated in order to manipulate with policies. Active it either by UI Console or by `yc` command.

        ## Defined types

        ### interval_type

         A string type, that accepts values in the format of: `number` + `time type`, where `time type` might be:
        * `s` — seconds
        * `m` — minutes
        * `h` — hours
        * `d` — days
        * `w` — weekdays
        * `M` — months

        Example of interval value: `5m`, `10d`, `2M`, `5w`

        ### day_type

        A string type, that accepts the following values: `ALWAYS_INCREMENTAL`, `ALWAYS_FULL`, `WEEKLY_FULL_DAILY_INCREMENTAL`, `WEEKLY_INCREMENTAL`.

        ### backup_set_type

        `TYPE_AUTO`, `TYPE_FULL`, `TYPE_INCREMENTAL`, `TYPE_DIFFERENTIAL`.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new basic Cloud Backup Policy
        #
        basic_policy = yandex.BackupPolicy("basic_policy",
            name="basic policy",
            scheduling={
                "enabled": False,
                "backup_sets": [{
                    "execute_by_interval": 86400,
                }],
            },
            retention={
                "after_backup": False,
            },
            reattempts={},
            vm_snapshot_reattempts={})
        ```

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new full Cloud Backup Policy
        #
        my_policy = yandex.BackupPolicy("my_policy",
            archive_name="[Machine Name]-[Plan ID]-[Unique ID]a",
            cbt="USE_IF_ENABLED",
            compression="NORMAL",
            fast_backup_enabled=True,
            format="AUTO",
            multi_volume_snapshotting_enabled=True,
            name="example_name",
            performance_window_enabled=True,
            preserve_file_security_settings=True,
            quiesce_snapshotting_enabled=True,
            silent_mode_enabled=True,
            splitting_bytes="9223372036854775807",
            vss_provider="NATIVE",
            reattempts={
                "enabled": True,
                "interval": "1m",
                "max_attempts": 10,
            },
            retention={
                "after_backup": False,
                "rules": [{
                    "max_age": "365d",
                    "repeat_periods": [],
                }],
            },
            scheduling={
                "enabled": False,
                "max_parallel_backups": 0,
                "random_max_delay": "30m",
                "scheme": "ALWAYS_INCREMENTAL",
                "weekly_backup_day": "MONDAY",
                "backup_sets": [{
                    "execute_by_times": [{
                        "include_last_day_of_month": True,
                        "monthdays": [],
                        "months": [
                            1,
                            2,
                            3,
                            4,
                            5,
                            6,
                            7,
                            8,
                            9,
                            10,
                            11,
                            12,
                        ],
                        "repeat_ats": ["04:10"],
                        "repeat_every": "30m",
                        "type": "MONTHLY",
                        "weekdays": [],
                    }],
                }],
            },
            vm_snapshot_reattempts={
                "enabled": True,
                "interval": "1m",
                "max_attempts": 10,
            })
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        bash

        ```sh
        $ pulumi import yandex:index/backupPolicy:BackupPolicy <resource Name> <Resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/backupPolicy:BackupPolicy my_backup_policy ...
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] archive_name: The name of generated archives. Default `[Machine Name]-[Plan ID]-[Unique ID]a`.
        :param pulumi.Input[_builtins.str] cbt: Configuration of Changed Block Tracking. Available values are: `USE_IF_ENABLED`, `ENABLED_AND_USE`, `DO_NOT_USE`. Default `DO_NOT_USE`.
        :param pulumi.Input[_builtins.str] compression: Archive compression level. Affects CPU. Available values: `NORMAL`, `HIGH`, `MAX`, `OFF`. Default: `NORMAL`.
        :param pulumi.Input[_builtins.bool] fast_backup_enabled: If true, determines whether a file has changed by the file size and timestamp. Otherwise, the entire file contents are compared to those stored in the backup.
        :param pulumi.Input[Union['BackupPolicyFileFiltersArgs', 'BackupPolicyFileFiltersArgsDict']] file_filters: File filters to specify masks of files to backup or to exclude of backuping.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[_builtins.str] format: Format of the backup. It's strongly recommend to leave this option empty or `AUTO`. Available values: `AUTO`, `VERSION_11`, `VERSION_12`.
        :param pulumi.Input[_builtins.bool] lvm_snapshotting_enabled: LVM will be used to create the volume snapshot. If LVM fails to create a snapshot (for example, because there is not enough free space), the software will create the snapshot itself.
        :param pulumi.Input[_builtins.bool] multi_volume_snapshotting_enabled: If true, snapshots of multiple volumes will be taken simultaneously. Default `true`.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[_builtins.bool] performance_window_enabled: Time windows for performance limitations of backup. Default `false`.
        :param pulumi.Input[_builtins.bool] preserve_file_security_settings: If true, a quiesced snapshot of the virtual machine will be taken. Default `true`.
        :param pulumi.Input[_builtins.bool] quiesce_snapshotting_enabled: If true, a quiesced snapshot of the virtual machine will be taken. Default `true`.
        :param pulumi.Input[Union['BackupPolicyReattemptsArgs', 'BackupPolicyReattemptsArgsDict']] reattempts: Amount of reattempts that should be performed while trying to make backup at the host.
        :param pulumi.Input[Union['BackupPolicyRetentionArgs', 'BackupPolicyRetentionArgsDict']] retention: Retention policy for backups. Allows to setup backups lifecycle.
        :param pulumi.Input[Union['BackupPolicySchedulingArgs', 'BackupPolicySchedulingArgsDict']] scheduling: Schedule settings for creating backups on the host.
        :param pulumi.Input[_builtins.bool] sector_by_sector: A sector-by-sector backup of a disk or volume creates a backup copy of all sectors of the disk or volume, including those that do not contain data. Therefore, the size of such a backup copy will be equal to the size of the original disk or volume.
        :param pulumi.Input[_builtins.bool] silent_mode_enabled: If true, a user interaction will be avoided when possible. Default `true`.
        :param pulumi.Input[_builtins.str] splitting_bytes: Determines the size to split backups. It's better to leave this option unchanged. Default `9223372036854775807`.
        :param pulumi.Input[_builtins.bool] validation_enabled: Validation is a time-consuming process, even with incremental or differential backups of small amounts of data. This is because not only the data physically contained in the backup copy is verified, but all data restored when it is selected. This option requires access to previously created backup copies.
        :param pulumi.Input[Union['BackupPolicyVmSnapshotReattemptsArgs', 'BackupPolicyVmSnapshotReattemptsArgsDict']] vm_snapshot_reattempts: Amount of reattempts that should be performed while trying to make snapshot.
        :param pulumi.Input[_builtins.str] vss_provider: Settings for the volume shadow copy service. Available values are: `NATIVE`, `TARGET_SYSTEM_DEFINED`. Default `NATIVE`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BackupPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Allows management of [Yandex Cloud Backup Policy](https://yandex.cloud/docs/backup/concepts/policy).

        > Cloud Backup Provider must be activated in order to manipulate with policies. Active it either by UI Console or by `yc` command.

        ## Defined types

        ### interval_type

         A string type, that accepts values in the format of: `number` + `time type`, where `time type` might be:
        * `s` — seconds
        * `m` — minutes
        * `h` — hours
        * `d` — days
        * `w` — weekdays
        * `M` — months

        Example of interval value: `5m`, `10d`, `2M`, `5w`

        ### day_type

        A string type, that accepts the following values: `ALWAYS_INCREMENTAL`, `ALWAYS_FULL`, `WEEKLY_FULL_DAILY_INCREMENTAL`, `WEEKLY_INCREMENTAL`.

        ### backup_set_type

        `TYPE_AUTO`, `TYPE_FULL`, `TYPE_INCREMENTAL`, `TYPE_DIFFERENTIAL`.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new basic Cloud Backup Policy
        #
        basic_policy = yandex.BackupPolicy("basic_policy",
            name="basic policy",
            scheduling={
                "enabled": False,
                "backup_sets": [{
                    "execute_by_interval": 86400,
                }],
            },
            retention={
                "after_backup": False,
            },
            reattempts={},
            vm_snapshot_reattempts={})
        ```

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new full Cloud Backup Policy
        #
        my_policy = yandex.BackupPolicy("my_policy",
            archive_name="[Machine Name]-[Plan ID]-[Unique ID]a",
            cbt="USE_IF_ENABLED",
            compression="NORMAL",
            fast_backup_enabled=True,
            format="AUTO",
            multi_volume_snapshotting_enabled=True,
            name="example_name",
            performance_window_enabled=True,
            preserve_file_security_settings=True,
            quiesce_snapshotting_enabled=True,
            silent_mode_enabled=True,
            splitting_bytes="9223372036854775807",
            vss_provider="NATIVE",
            reattempts={
                "enabled": True,
                "interval": "1m",
                "max_attempts": 10,
            },
            retention={
                "after_backup": False,
                "rules": [{
                    "max_age": "365d",
                    "repeat_periods": [],
                }],
            },
            scheduling={
                "enabled": False,
                "max_parallel_backups": 0,
                "random_max_delay": "30m",
                "scheme": "ALWAYS_INCREMENTAL",
                "weekly_backup_day": "MONDAY",
                "backup_sets": [{
                    "execute_by_times": [{
                        "include_last_day_of_month": True,
                        "monthdays": [],
                        "months": [
                            1,
                            2,
                            3,
                            4,
                            5,
                            6,
                            7,
                            8,
                            9,
                            10,
                            11,
                            12,
                        ],
                        "repeat_ats": ["04:10"],
                        "repeat_every": "30m",
                        "type": "MONTHLY",
                        "weekdays": [],
                    }],
                }],
            },
            vm_snapshot_reattempts={
                "enabled": True,
                "interval": "1m",
                "max_attempts": 10,
            })
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        bash

        ```sh
        $ pulumi import yandex:index/backupPolicy:BackupPolicy <resource Name> <Resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/backupPolicy:BackupPolicy my_backup_policy ...
        ```

        :param str resource_name: The name of the resource.
        :param BackupPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BackupPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 archive_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cbt: Optional[pulumi.Input[_builtins.str]] = None,
                 compression: Optional[pulumi.Input[_builtins.str]] = None,
                 fast_backup_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 file_filters: Optional[pulumi.Input[Union['BackupPolicyFileFiltersArgs', 'BackupPolicyFileFiltersArgsDict']]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 format: Optional[pulumi.Input[_builtins.str]] = None,
                 lvm_snapshotting_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 multi_volume_snapshotting_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 performance_window_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 preserve_file_security_settings: Optional[pulumi.Input[_builtins.bool]] = None,
                 quiesce_snapshotting_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 reattempts: Optional[pulumi.Input[Union['BackupPolicyReattemptsArgs', 'BackupPolicyReattemptsArgsDict']]] = None,
                 retention: Optional[pulumi.Input[Union['BackupPolicyRetentionArgs', 'BackupPolicyRetentionArgsDict']]] = None,
                 scheduling: Optional[pulumi.Input[Union['BackupPolicySchedulingArgs', 'BackupPolicySchedulingArgsDict']]] = None,
                 sector_by_sector: Optional[pulumi.Input[_builtins.bool]] = None,
                 silent_mode_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 splitting_bytes: Optional[pulumi.Input[_builtins.str]] = None,
                 validation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 vm_snapshot_reattempts: Optional[pulumi.Input[Union['BackupPolicyVmSnapshotReattemptsArgs', 'BackupPolicyVmSnapshotReattemptsArgsDict']]] = None,
                 vss_provider: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BackupPolicyArgs.__new__(BackupPolicyArgs)

            __props__.__dict__["archive_name"] = archive_name
            __props__.__dict__["cbt"] = cbt
            __props__.__dict__["compression"] = compression
            __props__.__dict__["fast_backup_enabled"] = fast_backup_enabled
            __props__.__dict__["file_filters"] = file_filters
            __props__.__dict__["folder_id"] = folder_id
            __props__.__dict__["format"] = format
            __props__.__dict__["lvm_snapshotting_enabled"] = lvm_snapshotting_enabled
            __props__.__dict__["multi_volume_snapshotting_enabled"] = multi_volume_snapshotting_enabled
            __props__.__dict__["name"] = name
            __props__.__dict__["performance_window_enabled"] = performance_window_enabled
            __props__.__dict__["preserve_file_security_settings"] = preserve_file_security_settings
            __props__.__dict__["quiesce_snapshotting_enabled"] = quiesce_snapshotting_enabled
            if reattempts is None and not opts.urn:
                raise TypeError("Missing required property 'reattempts'")
            __props__.__dict__["reattempts"] = reattempts
            if retention is None and not opts.urn:
                raise TypeError("Missing required property 'retention'")
            __props__.__dict__["retention"] = retention
            if scheduling is None and not opts.urn:
                raise TypeError("Missing required property 'scheduling'")
            __props__.__dict__["scheduling"] = scheduling
            __props__.__dict__["sector_by_sector"] = sector_by_sector
            __props__.__dict__["silent_mode_enabled"] = silent_mode_enabled
            __props__.__dict__["splitting_bytes"] = splitting_bytes
            __props__.__dict__["validation_enabled"] = validation_enabled
            if vm_snapshot_reattempts is None and not opts.urn:
                raise TypeError("Missing required property 'vm_snapshot_reattempts'")
            __props__.__dict__["vm_snapshot_reattempts"] = vm_snapshot_reattempts
            __props__.__dict__["vss_provider"] = vss_provider
            __props__.__dict__["created_at"] = None
            __props__.__dict__["enabled"] = None
            __props__.__dict__["updated_at"] = None
        super(BackupPolicy, __self__).__init__(
            'yandex:index/backupPolicy:BackupPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            archive_name: Optional[pulumi.Input[_builtins.str]] = None,
            cbt: Optional[pulumi.Input[_builtins.str]] = None,
            compression: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            fast_backup_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            file_filters: Optional[pulumi.Input[Union['BackupPolicyFileFiltersArgs', 'BackupPolicyFileFiltersArgsDict']]] = None,
            folder_id: Optional[pulumi.Input[_builtins.str]] = None,
            format: Optional[pulumi.Input[_builtins.str]] = None,
            lvm_snapshotting_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            multi_volume_snapshotting_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            performance_window_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            preserve_file_security_settings: Optional[pulumi.Input[_builtins.bool]] = None,
            quiesce_snapshotting_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            reattempts: Optional[pulumi.Input[Union['BackupPolicyReattemptsArgs', 'BackupPolicyReattemptsArgsDict']]] = None,
            retention: Optional[pulumi.Input[Union['BackupPolicyRetentionArgs', 'BackupPolicyRetentionArgsDict']]] = None,
            scheduling: Optional[pulumi.Input[Union['BackupPolicySchedulingArgs', 'BackupPolicySchedulingArgsDict']]] = None,
            sector_by_sector: Optional[pulumi.Input[_builtins.bool]] = None,
            silent_mode_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            splitting_bytes: Optional[pulumi.Input[_builtins.str]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None,
            validation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            vm_snapshot_reattempts: Optional[pulumi.Input[Union['BackupPolicyVmSnapshotReattemptsArgs', 'BackupPolicyVmSnapshotReattemptsArgsDict']]] = None,
            vss_provider: Optional[pulumi.Input[_builtins.str]] = None) -> 'BackupPolicy':
        """
        Get an existing BackupPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] archive_name: The name of generated archives. Default `[Machine Name]-[Plan ID]-[Unique ID]a`.
        :param pulumi.Input[_builtins.str] cbt: Configuration of Changed Block Tracking. Available values are: `USE_IF_ENABLED`, `ENABLED_AND_USE`, `DO_NOT_USE`. Default `DO_NOT_USE`.
        :param pulumi.Input[_builtins.str] compression: Archive compression level. Affects CPU. Available values: `NORMAL`, `HIGH`, `MAX`, `OFF`. Default: `NORMAL`.
        :param pulumi.Input[_builtins.str] created_at: The creation timestamp of the resource.
        :param pulumi.Input[_builtins.bool] enabled: If this field is true, it means that the policy is enabled.
        :param pulumi.Input[_builtins.bool] fast_backup_enabled: If true, determines whether a file has changed by the file size and timestamp. Otherwise, the entire file contents are compared to those stored in the backup.
        :param pulumi.Input[Union['BackupPolicyFileFiltersArgs', 'BackupPolicyFileFiltersArgsDict']] file_filters: File filters to specify masks of files to backup or to exclude of backuping.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[_builtins.str] format: Format of the backup. It's strongly recommend to leave this option empty or `AUTO`. Available values: `AUTO`, `VERSION_11`, `VERSION_12`.
        :param pulumi.Input[_builtins.bool] lvm_snapshotting_enabled: LVM will be used to create the volume snapshot. If LVM fails to create a snapshot (for example, because there is not enough free space), the software will create the snapshot itself.
        :param pulumi.Input[_builtins.bool] multi_volume_snapshotting_enabled: If true, snapshots of multiple volumes will be taken simultaneously. Default `true`.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[_builtins.bool] performance_window_enabled: Time windows for performance limitations of backup. Default `false`.
        :param pulumi.Input[_builtins.bool] preserve_file_security_settings: If true, a quiesced snapshot of the virtual machine will be taken. Default `true`.
        :param pulumi.Input[_builtins.bool] quiesce_snapshotting_enabled: If true, a quiesced snapshot of the virtual machine will be taken. Default `true`.
        :param pulumi.Input[Union['BackupPolicyReattemptsArgs', 'BackupPolicyReattemptsArgsDict']] reattempts: Amount of reattempts that should be performed while trying to make backup at the host.
        :param pulumi.Input[Union['BackupPolicyRetentionArgs', 'BackupPolicyRetentionArgsDict']] retention: Retention policy for backups. Allows to setup backups lifecycle.
        :param pulumi.Input[Union['BackupPolicySchedulingArgs', 'BackupPolicySchedulingArgsDict']] scheduling: Schedule settings for creating backups on the host.
        :param pulumi.Input[_builtins.bool] sector_by_sector: A sector-by-sector backup of a disk or volume creates a backup copy of all sectors of the disk or volume, including those that do not contain data. Therefore, the size of such a backup copy will be equal to the size of the original disk or volume.
        :param pulumi.Input[_builtins.bool] silent_mode_enabled: If true, a user interaction will be avoided when possible. Default `true`.
        :param pulumi.Input[_builtins.str] splitting_bytes: Determines the size to split backups. It's better to leave this option unchanged. Default `9223372036854775807`.
        :param pulumi.Input[_builtins.str] updated_at: The update timestamp of the resource.
        :param pulumi.Input[_builtins.bool] validation_enabled: Validation is a time-consuming process, even with incremental or differential backups of small amounts of data. This is because not only the data physically contained in the backup copy is verified, but all data restored when it is selected. This option requires access to previously created backup copies.
        :param pulumi.Input[Union['BackupPolicyVmSnapshotReattemptsArgs', 'BackupPolicyVmSnapshotReattemptsArgsDict']] vm_snapshot_reattempts: Amount of reattempts that should be performed while trying to make snapshot.
        :param pulumi.Input[_builtins.str] vss_provider: Settings for the volume shadow copy service. Available values are: `NATIVE`, `TARGET_SYSTEM_DEFINED`. Default `NATIVE`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BackupPolicyState.__new__(_BackupPolicyState)

        __props__.__dict__["archive_name"] = archive_name
        __props__.__dict__["cbt"] = cbt
        __props__.__dict__["compression"] = compression
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["fast_backup_enabled"] = fast_backup_enabled
        __props__.__dict__["file_filters"] = file_filters
        __props__.__dict__["folder_id"] = folder_id
        __props__.__dict__["format"] = format
        __props__.__dict__["lvm_snapshotting_enabled"] = lvm_snapshotting_enabled
        __props__.__dict__["multi_volume_snapshotting_enabled"] = multi_volume_snapshotting_enabled
        __props__.__dict__["name"] = name
        __props__.__dict__["performance_window_enabled"] = performance_window_enabled
        __props__.__dict__["preserve_file_security_settings"] = preserve_file_security_settings
        __props__.__dict__["quiesce_snapshotting_enabled"] = quiesce_snapshotting_enabled
        __props__.__dict__["reattempts"] = reattempts
        __props__.__dict__["retention"] = retention
        __props__.__dict__["scheduling"] = scheduling
        __props__.__dict__["sector_by_sector"] = sector_by_sector
        __props__.__dict__["silent_mode_enabled"] = silent_mode_enabled
        __props__.__dict__["splitting_bytes"] = splitting_bytes
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["validation_enabled"] = validation_enabled
        __props__.__dict__["vm_snapshot_reattempts"] = vm_snapshot_reattempts
        __props__.__dict__["vss_provider"] = vss_provider
        return BackupPolicy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="archiveName")
    def archive_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of generated archives. Default `[Machine Name]-[Plan ID]-[Unique ID]a`.
        """
        return pulumi.get(self, "archive_name")

    @_builtins.property
    @pulumi.getter
    def cbt(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Configuration of Changed Block Tracking. Available values are: `USE_IF_ENABLED`, `ENABLED_AND_USE`, `DO_NOT_USE`. Default `DO_NOT_USE`.
        """
        return pulumi.get(self, "cbt")

    @_builtins.property
    @pulumi.getter
    def compression(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Archive compression level. Affects CPU. Available values: `NORMAL`, `HIGH`, `MAX`, `OFF`. Default: `NORMAL`.
        """
        return pulumi.get(self, "compression")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        If this field is true, it means that the policy is enabled.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="fastBackupEnabled")
    def fast_backup_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If true, determines whether a file has changed by the file size and timestamp. Otherwise, the entire file contents are compared to those stored in the backup.
        """
        return pulumi.get(self, "fast_backup_enabled")

    @_builtins.property
    @pulumi.getter(name="fileFilters")
    def file_filters(self) -> pulumi.Output[Optional['outputs.BackupPolicyFileFilters']]:
        """
        File filters to specify masks of files to backup or to exclude of backuping.
        """
        return pulumi.get(self, "file_filters")

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> pulumi.Output[_builtins.str]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @_builtins.property
    @pulumi.getter
    def format(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Format of the backup. It's strongly recommend to leave this option empty or `AUTO`. Available values: `AUTO`, `VERSION_11`, `VERSION_12`.
        """
        return pulumi.get(self, "format")

    @_builtins.property
    @pulumi.getter(name="lvmSnapshottingEnabled")
    def lvm_snapshotting_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        LVM will be used to create the volume snapshot. If LVM fails to create a snapshot (for example, because there is not enough free space), the software will create the snapshot itself.
        """
        return pulumi.get(self, "lvm_snapshotting_enabled")

    @_builtins.property
    @pulumi.getter(name="multiVolumeSnapshottingEnabled")
    def multi_volume_snapshotting_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If true, snapshots of multiple volumes will be taken simultaneously. Default `true`.
        """
        return pulumi.get(self, "multi_volume_snapshotting_enabled")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="performanceWindowEnabled")
    def performance_window_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Time windows for performance limitations of backup. Default `false`.
        """
        return pulumi.get(self, "performance_window_enabled")

    @_builtins.property
    @pulumi.getter(name="preserveFileSecuritySettings")
    @_utilities.deprecated("""This setting is depricated and will be removed in future versions. You can safely delete it.""")
    def preserve_file_security_settings(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If true, a quiesced snapshot of the virtual machine will be taken. Default `true`.
        """
        return pulumi.get(self, "preserve_file_security_settings")

    @_builtins.property
    @pulumi.getter(name="quiesceSnapshottingEnabled")
    @_utilities.deprecated("""This setting is depricated and will be removed in future versions. You can safely delete it.""")
    def quiesce_snapshotting_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If true, a quiesced snapshot of the virtual machine will be taken. Default `true`.
        """
        return pulumi.get(self, "quiesce_snapshotting_enabled")

    @_builtins.property
    @pulumi.getter
    def reattempts(self) -> pulumi.Output['outputs.BackupPolicyReattempts']:
        """
        Amount of reattempts that should be performed while trying to make backup at the host.
        """
        return pulumi.get(self, "reattempts")

    @_builtins.property
    @pulumi.getter
    def retention(self) -> pulumi.Output['outputs.BackupPolicyRetention']:
        """
        Retention policy for backups. Allows to setup backups lifecycle.
        """
        return pulumi.get(self, "retention")

    @_builtins.property
    @pulumi.getter
    def scheduling(self) -> pulumi.Output['outputs.BackupPolicyScheduling']:
        """
        Schedule settings for creating backups on the host.
        """
        return pulumi.get(self, "scheduling")

    @_builtins.property
    @pulumi.getter(name="sectorBySector")
    def sector_by_sector(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        A sector-by-sector backup of a disk or volume creates a backup copy of all sectors of the disk or volume, including those that do not contain data. Therefore, the size of such a backup copy will be equal to the size of the original disk or volume.
        """
        return pulumi.get(self, "sector_by_sector")

    @_builtins.property
    @pulumi.getter(name="silentModeEnabled")
    def silent_mode_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If true, a user interaction will be avoided when possible. Default `true`.
        """
        return pulumi.get(self, "silent_mode_enabled")

    @_builtins.property
    @pulumi.getter(name="splittingBytes")
    def splitting_bytes(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Determines the size to split backups. It's better to leave this option unchanged. Default `9223372036854775807`.
        """
        return pulumi.get(self, "splitting_bytes")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        The update timestamp of the resource.
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter(name="validationEnabled")
    def validation_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Validation is a time-consuming process, even with incremental or differential backups of small amounts of data. This is because not only the data physically contained in the backup copy is verified, but all data restored when it is selected. This option requires access to previously created backup copies.
        """
        return pulumi.get(self, "validation_enabled")

    @_builtins.property
    @pulumi.getter(name="vmSnapshotReattempts")
    def vm_snapshot_reattempts(self) -> pulumi.Output['outputs.BackupPolicyVmSnapshotReattempts']:
        """
        Amount of reattempts that should be performed while trying to make snapshot.
        """
        return pulumi.get(self, "vm_snapshot_reattempts")

    @_builtins.property
    @pulumi.getter(name="vssProvider")
    def vss_provider(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Settings for the volume shadow copy service. Available values are: `NATIVE`, `TARGET_SYSTEM_DEFINED`. Default `NATIVE`.
        """
        return pulumi.get(self, "vss_provider")

