# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ComputeInstanceArgs', 'ComputeInstance']

@pulumi.input_type
class ComputeInstanceArgs:
    def __init__(__self__, *,
                 boot_disk: pulumi.Input['ComputeInstanceBootDiskArgs'],
                 network_interfaces: pulumi.Input[Sequence[pulumi.Input['ComputeInstanceNetworkInterfaceArgs']]],
                 resources: pulumi.Input['ComputeInstanceResourcesArgs'],
                 allow_recreate: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_stopping_for_update: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 filesystems: Optional[pulumi.Input[Sequence[pulumi.Input['ComputeInstanceFilesystemArgs']]]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 gpu_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 hostname: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 local_disks: Optional[pulumi.Input[Sequence[pulumi.Input['ComputeInstanceLocalDiskArgs']]]] = None,
                 maintenance_grace_period: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 metadata_options: Optional[pulumi.Input['ComputeInstanceMetadataOptionsArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_acceleration_type: Optional[pulumi.Input[_builtins.str]] = None,
                 placement_policy: Optional[pulumi.Input['ComputeInstancePlacementPolicyArgs']] = None,
                 platform_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduling_policy: Optional[pulumi.Input['ComputeInstanceSchedulingPolicyArgs']] = None,
                 secondary_disks: Optional[pulumi.Input[Sequence[pulumi.Input['ComputeInstanceSecondaryDiskArgs']]]] = None,
                 service_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ComputeInstance resource.
        :param pulumi.Input['ComputeInstanceBootDiskArgs'] boot_disk: The boot disk for the instance. Either `initialize_params` or `disk_id` must be specified.
        :param pulumi.Input[Sequence[pulumi.Input['ComputeInstanceNetworkInterfaceArgs']]] network_interfaces: Networks to attach to the instance. This can be specified multiple times.
        :param pulumi.Input['ComputeInstanceResourcesArgs'] resources: Compute resources that are allocated for the instance.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[Sequence[pulumi.Input['ComputeInstanceFilesystemArgs']]] filesystems: List of filesystems that are attached to the instance.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[_builtins.str] gpu_cluster_id: ID of the GPU cluster to attach this instance to.
        :param pulumi.Input[_builtins.str] hostname: Host name for the instance. This field is used to generate the instance `fqdn` value. The host name must be unique within the network and region. If not specified, the host name will be equal to `id` of the instance and `fqdn` will be `<id>.auto.internal`. Otherwise FQDN will be `<hostname>.<region_id>.internal`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[Sequence[pulumi.Input['ComputeInstanceLocalDiskArgs']]] local_disks: List of local disks that are attached to the instance.
        :param pulumi.Input[_builtins.str] maintenance_grace_period: Time between notification via metadata service and maintenance. E.g., `60s`.
        :param pulumi.Input[_builtins.str] maintenance_policy: Behavior on maintenance events. Can be: `unspecified`, `migrate`, `restart`. The default is `unspecified`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: Metadata key/value pairs to make available from within the instance.
        :param pulumi.Input['ComputeInstanceMetadataOptionsArgs'] metadata_options: Options allow user to configure access to instance's metadata.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[_builtins.str] network_acceleration_type: Type of network acceleration. Can be `standard` or `software_accelerated`. The default is `standard`.
        :param pulumi.Input['ComputeInstancePlacementPolicyArgs'] placement_policy: The placement policy configuration.
        :param pulumi.Input[_builtins.str] platform_id: The type of virtual machine to create.
        :param pulumi.Input['ComputeInstanceSchedulingPolicyArgs'] scheduling_policy: Scheduling policy configuration.
        :param pulumi.Input[Sequence[pulumi.Input['ComputeInstanceSecondaryDiskArgs']]] secondary_disks: A set of disks to attach to the instance. The structure is documented below.
               
               > The `allow_stopping_for_update` property must be set to `true` in order to update this structure.
        :param pulumi.Input[_builtins.str] service_account_id: [Service account](https://yandex.cloud/docs/iam/concepts/users/service-accounts) which linked to the resource.
        :param pulumi.Input[_builtins.str] zone: The [availability zone](https://yandex.cloud/docs/overview/concepts/geo-scope) where resource is located. If it is not provided, the default provider zone will be used.
        """
        pulumi.set(__self__, "boot_disk", boot_disk)
        pulumi.set(__self__, "network_interfaces", network_interfaces)
        pulumi.set(__self__, "resources", resources)
        if allow_recreate is not None:
            pulumi.set(__self__, "allow_recreate", allow_recreate)
        if allow_stopping_for_update is not None:
            pulumi.set(__self__, "allow_stopping_for_update", allow_stopping_for_update)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if filesystems is not None:
            pulumi.set(__self__, "filesystems", filesystems)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if gpu_cluster_id is not None:
            pulumi.set(__self__, "gpu_cluster_id", gpu_cluster_id)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if local_disks is not None:
            pulumi.set(__self__, "local_disks", local_disks)
        if maintenance_grace_period is not None:
            pulumi.set(__self__, "maintenance_grace_period", maintenance_grace_period)
        if maintenance_policy is not None:
            pulumi.set(__self__, "maintenance_policy", maintenance_policy)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if metadata_options is not None:
            pulumi.set(__self__, "metadata_options", metadata_options)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_acceleration_type is not None:
            pulumi.set(__self__, "network_acceleration_type", network_acceleration_type)
        if placement_policy is not None:
            pulumi.set(__self__, "placement_policy", placement_policy)
        if platform_id is not None:
            pulumi.set(__self__, "platform_id", platform_id)
        if scheduling_policy is not None:
            pulumi.set(__self__, "scheduling_policy", scheduling_policy)
        if secondary_disks is not None:
            pulumi.set(__self__, "secondary_disks", secondary_disks)
        if service_account_id is not None:
            pulumi.set(__self__, "service_account_id", service_account_id)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="bootDisk")
    def boot_disk(self) -> pulumi.Input['ComputeInstanceBootDiskArgs']:
        """
        The boot disk for the instance. Either `initialize_params` or `disk_id` must be specified.
        """
        return pulumi.get(self, "boot_disk")

    @boot_disk.setter
    def boot_disk(self, value: pulumi.Input['ComputeInstanceBootDiskArgs']):
        pulumi.set(self, "boot_disk", value)

    @_builtins.property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> pulumi.Input[Sequence[pulumi.Input['ComputeInstanceNetworkInterfaceArgs']]]:
        """
        Networks to attach to the instance. This can be specified multiple times.
        """
        return pulumi.get(self, "network_interfaces")

    @network_interfaces.setter
    def network_interfaces(self, value: pulumi.Input[Sequence[pulumi.Input['ComputeInstanceNetworkInterfaceArgs']]]):
        pulumi.set(self, "network_interfaces", value)

    @_builtins.property
    @pulumi.getter
    def resources(self) -> pulumi.Input['ComputeInstanceResourcesArgs']:
        """
        Compute resources that are allocated for the instance.
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: pulumi.Input['ComputeInstanceResourcesArgs']):
        pulumi.set(self, "resources", value)

    @_builtins.property
    @pulumi.getter(name="allowRecreate")
    def allow_recreate(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "allow_recreate")

    @allow_recreate.setter
    def allow_recreate(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_recreate", value)

    @_builtins.property
    @pulumi.getter(name="allowStoppingForUpdate")
    def allow_stopping_for_update(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "allow_stopping_for_update")

    @allow_stopping_for_update.setter
    def allow_stopping_for_update(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_stopping_for_update", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def filesystems(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ComputeInstanceFilesystemArgs']]]]:
        """
        List of filesystems that are attached to the instance.
        """
        return pulumi.get(self, "filesystems")

    @filesystems.setter
    def filesystems(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ComputeInstanceFilesystemArgs']]]]):
        pulumi.set(self, "filesystems", value)

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder_id", value)

    @_builtins.property
    @pulumi.getter(name="gpuClusterId")
    def gpu_cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the GPU cluster to attach this instance to.
        """
        return pulumi.get(self, "gpu_cluster_id")

    @gpu_cluster_id.setter
    def gpu_cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gpu_cluster_id", value)

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Host name for the instance. This field is used to generate the instance `fqdn` value. The host name must be unique within the network and region. If not specified, the host name will be equal to `id` of the instance and `fqdn` will be `<id>.auto.internal`. Otherwise FQDN will be `<hostname>.<region_id>.internal`.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hostname", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="localDisks")
    def local_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ComputeInstanceLocalDiskArgs']]]]:
        """
        List of local disks that are attached to the instance.
        """
        return pulumi.get(self, "local_disks")

    @local_disks.setter
    def local_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ComputeInstanceLocalDiskArgs']]]]):
        pulumi.set(self, "local_disks", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceGracePeriod")
    def maintenance_grace_period(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time between notification via metadata service and maintenance. E.g., `60s`.
        """
        return pulumi.get(self, "maintenance_grace_period")

    @maintenance_grace_period.setter
    def maintenance_grace_period(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintenance_grace_period", value)

    @_builtins.property
    @pulumi.getter(name="maintenancePolicy")
    def maintenance_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Behavior on maintenance events. Can be: `unspecified`, `migrate`, `restart`. The default is `unspecified`.
        """
        return pulumi.get(self, "maintenance_policy")

    @maintenance_policy.setter
    def maintenance_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintenance_policy", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Metadata key/value pairs to make available from within the instance.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter(name="metadataOptions")
    def metadata_options(self) -> Optional[pulumi.Input['ComputeInstanceMetadataOptionsArgs']]:
        """
        Options allow user to configure access to instance's metadata.
        """
        return pulumi.get(self, "metadata_options")

    @metadata_options.setter
    def metadata_options(self, value: Optional[pulumi.Input['ComputeInstanceMetadataOptionsArgs']]):
        pulumi.set(self, "metadata_options", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkAccelerationType")
    def network_acceleration_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of network acceleration. Can be `standard` or `software_accelerated`. The default is `standard`.
        """
        return pulumi.get(self, "network_acceleration_type")

    @network_acceleration_type.setter
    def network_acceleration_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_acceleration_type", value)

    @_builtins.property
    @pulumi.getter(name="placementPolicy")
    def placement_policy(self) -> Optional[pulumi.Input['ComputeInstancePlacementPolicyArgs']]:
        """
        The placement policy configuration.
        """
        return pulumi.get(self, "placement_policy")

    @placement_policy.setter
    def placement_policy(self, value: Optional[pulumi.Input['ComputeInstancePlacementPolicyArgs']]):
        pulumi.set(self, "placement_policy", value)

    @_builtins.property
    @pulumi.getter(name="platformId")
    def platform_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of virtual machine to create.
        """
        return pulumi.get(self, "platform_id")

    @platform_id.setter
    def platform_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "platform_id", value)

    @_builtins.property
    @pulumi.getter(name="schedulingPolicy")
    def scheduling_policy(self) -> Optional[pulumi.Input['ComputeInstanceSchedulingPolicyArgs']]:
        """
        Scheduling policy configuration.
        """
        return pulumi.get(self, "scheduling_policy")

    @scheduling_policy.setter
    def scheduling_policy(self, value: Optional[pulumi.Input['ComputeInstanceSchedulingPolicyArgs']]):
        pulumi.set(self, "scheduling_policy", value)

    @_builtins.property
    @pulumi.getter(name="secondaryDisks")
    def secondary_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ComputeInstanceSecondaryDiskArgs']]]]:
        """
        A set of disks to attach to the instance. The structure is documented below.

        > The `allow_stopping_for_update` property must be set to `true` in order to update this structure.
        """
        return pulumi.get(self, "secondary_disks")

    @secondary_disks.setter
    def secondary_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ComputeInstanceSecondaryDiskArgs']]]]):
        pulumi.set(self, "secondary_disks", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccountId")
    def service_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        [Service account](https://yandex.cloud/docs/iam/concepts/users/service-accounts) which linked to the resource.
        """
        return pulumi.get(self, "service_account_id")

    @service_account_id.setter
    def service_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_account_id", value)

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [availability zone](https://yandex.cloud/docs/overview/concepts/geo-scope) where resource is located. If it is not provided, the default provider zone will be used.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class _ComputeInstanceState:
    def __init__(__self__, *,
                 allow_recreate: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_stopping_for_update: Optional[pulumi.Input[_builtins.bool]] = None,
                 boot_disk: Optional[pulumi.Input['ComputeInstanceBootDiskArgs']] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 filesystems: Optional[pulumi.Input[Sequence[pulumi.Input['ComputeInstanceFilesystemArgs']]]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 fqdn: Optional[pulumi.Input[_builtins.str]] = None,
                 gpu_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 hardware_generations: Optional[pulumi.Input[Sequence[pulumi.Input['ComputeInstanceHardwareGenerationArgs']]]] = None,
                 hostname: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 local_disks: Optional[pulumi.Input[Sequence[pulumi.Input['ComputeInstanceLocalDiskArgs']]]] = None,
                 maintenance_grace_period: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 metadata_options: Optional[pulumi.Input['ComputeInstanceMetadataOptionsArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_acceleration_type: Optional[pulumi.Input[_builtins.str]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['ComputeInstanceNetworkInterfaceArgs']]]] = None,
                 placement_policy: Optional[pulumi.Input['ComputeInstancePlacementPolicyArgs']] = None,
                 platform_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resources: Optional[pulumi.Input['ComputeInstanceResourcesArgs']] = None,
                 scheduling_policy: Optional[pulumi.Input['ComputeInstanceSchedulingPolicyArgs']] = None,
                 secondary_disks: Optional[pulumi.Input[Sequence[pulumi.Input['ComputeInstanceSecondaryDiskArgs']]]] = None,
                 service_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ComputeInstance resources.
        :param pulumi.Input['ComputeInstanceBootDiskArgs'] boot_disk: The boot disk for the instance. Either `initialize_params` or `disk_id` must be specified.
        :param pulumi.Input[_builtins.str] created_at: The creation timestamp of the resource.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[Sequence[pulumi.Input['ComputeInstanceFilesystemArgs']]] filesystems: List of filesystems that are attached to the instance.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[_builtins.str] fqdn: The fully qualified DNS name of this instance.
        :param pulumi.Input[_builtins.str] gpu_cluster_id: ID of the GPU cluster to attach this instance to.
        :param pulumi.Input[_builtins.str] hostname: Host name for the instance. This field is used to generate the instance `fqdn` value. The host name must be unique within the network and region. If not specified, the host name will be equal to `id` of the instance and `fqdn` will be `<id>.auto.internal`. Otherwise FQDN will be `<hostname>.<region_id>.internal`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[Sequence[pulumi.Input['ComputeInstanceLocalDiskArgs']]] local_disks: List of local disks that are attached to the instance.
        :param pulumi.Input[_builtins.str] maintenance_grace_period: Time between notification via metadata service and maintenance. E.g., `60s`.
        :param pulumi.Input[_builtins.str] maintenance_policy: Behavior on maintenance events. Can be: `unspecified`, `migrate`, `restart`. The default is `unspecified`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: Metadata key/value pairs to make available from within the instance.
        :param pulumi.Input['ComputeInstanceMetadataOptionsArgs'] metadata_options: Options allow user to configure access to instance's metadata.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[_builtins.str] network_acceleration_type: Type of network acceleration. Can be `standard` or `software_accelerated`. The default is `standard`.
        :param pulumi.Input[Sequence[pulumi.Input['ComputeInstanceNetworkInterfaceArgs']]] network_interfaces: Networks to attach to the instance. This can be specified multiple times.
        :param pulumi.Input['ComputeInstancePlacementPolicyArgs'] placement_policy: The placement policy configuration.
        :param pulumi.Input[_builtins.str] platform_id: The type of virtual machine to create.
        :param pulumi.Input['ComputeInstanceResourcesArgs'] resources: Compute resources that are allocated for the instance.
        :param pulumi.Input['ComputeInstanceSchedulingPolicyArgs'] scheduling_policy: Scheduling policy configuration.
        :param pulumi.Input[Sequence[pulumi.Input['ComputeInstanceSecondaryDiskArgs']]] secondary_disks: A set of disks to attach to the instance. The structure is documented below.
               
               > The `allow_stopping_for_update` property must be set to `true` in order to update this structure.
        :param pulumi.Input[_builtins.str] service_account_id: [Service account](https://yandex.cloud/docs/iam/concepts/users/service-accounts) which linked to the resource.
        :param pulumi.Input[_builtins.str] status: The status of this instance.
        :param pulumi.Input[_builtins.str] zone: The [availability zone](https://yandex.cloud/docs/overview/concepts/geo-scope) where resource is located. If it is not provided, the default provider zone will be used.
        """
        if allow_recreate is not None:
            pulumi.set(__self__, "allow_recreate", allow_recreate)
        if allow_stopping_for_update is not None:
            pulumi.set(__self__, "allow_stopping_for_update", allow_stopping_for_update)
        if boot_disk is not None:
            pulumi.set(__self__, "boot_disk", boot_disk)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if filesystems is not None:
            pulumi.set(__self__, "filesystems", filesystems)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if gpu_cluster_id is not None:
            pulumi.set(__self__, "gpu_cluster_id", gpu_cluster_id)
        if hardware_generations is not None:
            pulumi.set(__self__, "hardware_generations", hardware_generations)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if local_disks is not None:
            pulumi.set(__self__, "local_disks", local_disks)
        if maintenance_grace_period is not None:
            pulumi.set(__self__, "maintenance_grace_period", maintenance_grace_period)
        if maintenance_policy is not None:
            pulumi.set(__self__, "maintenance_policy", maintenance_policy)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if metadata_options is not None:
            pulumi.set(__self__, "metadata_options", metadata_options)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_acceleration_type is not None:
            pulumi.set(__self__, "network_acceleration_type", network_acceleration_type)
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)
        if placement_policy is not None:
            pulumi.set(__self__, "placement_policy", placement_policy)
        if platform_id is not None:
            pulumi.set(__self__, "platform_id", platform_id)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if scheduling_policy is not None:
            pulumi.set(__self__, "scheduling_policy", scheduling_policy)
        if secondary_disks is not None:
            pulumi.set(__self__, "secondary_disks", secondary_disks)
        if service_account_id is not None:
            pulumi.set(__self__, "service_account_id", service_account_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="allowRecreate")
    def allow_recreate(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "allow_recreate")

    @allow_recreate.setter
    def allow_recreate(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_recreate", value)

    @_builtins.property
    @pulumi.getter(name="allowStoppingForUpdate")
    def allow_stopping_for_update(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "allow_stopping_for_update")

    @allow_stopping_for_update.setter
    def allow_stopping_for_update(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_stopping_for_update", value)

    @_builtins.property
    @pulumi.getter(name="bootDisk")
    def boot_disk(self) -> Optional[pulumi.Input['ComputeInstanceBootDiskArgs']]:
        """
        The boot disk for the instance. Either `initialize_params` or `disk_id` must be specified.
        """
        return pulumi.get(self, "boot_disk")

    @boot_disk.setter
    def boot_disk(self, value: Optional[pulumi.Input['ComputeInstanceBootDiskArgs']]):
        pulumi.set(self, "boot_disk", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def filesystems(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ComputeInstanceFilesystemArgs']]]]:
        """
        List of filesystems that are attached to the instance.
        """
        return pulumi.get(self, "filesystems")

    @filesystems.setter
    def filesystems(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ComputeInstanceFilesystemArgs']]]]):
        pulumi.set(self, "filesystems", value)

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder_id", value)

    @_builtins.property
    @pulumi.getter
    def fqdn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fully qualified DNS name of this instance.
        """
        return pulumi.get(self, "fqdn")

    @fqdn.setter
    def fqdn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fqdn", value)

    @_builtins.property
    @pulumi.getter(name="gpuClusterId")
    def gpu_cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the GPU cluster to attach this instance to.
        """
        return pulumi.get(self, "gpu_cluster_id")

    @gpu_cluster_id.setter
    def gpu_cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gpu_cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="hardwareGenerations")
    def hardware_generations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ComputeInstanceHardwareGenerationArgs']]]]:
        return pulumi.get(self, "hardware_generations")

    @hardware_generations.setter
    def hardware_generations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ComputeInstanceHardwareGenerationArgs']]]]):
        pulumi.set(self, "hardware_generations", value)

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Host name for the instance. This field is used to generate the instance `fqdn` value. The host name must be unique within the network and region. If not specified, the host name will be equal to `id` of the instance and `fqdn` will be `<id>.auto.internal`. Otherwise FQDN will be `<hostname>.<region_id>.internal`.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hostname", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="localDisks")
    def local_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ComputeInstanceLocalDiskArgs']]]]:
        """
        List of local disks that are attached to the instance.
        """
        return pulumi.get(self, "local_disks")

    @local_disks.setter
    def local_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ComputeInstanceLocalDiskArgs']]]]):
        pulumi.set(self, "local_disks", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceGracePeriod")
    def maintenance_grace_period(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time between notification via metadata service and maintenance. E.g., `60s`.
        """
        return pulumi.get(self, "maintenance_grace_period")

    @maintenance_grace_period.setter
    def maintenance_grace_period(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintenance_grace_period", value)

    @_builtins.property
    @pulumi.getter(name="maintenancePolicy")
    def maintenance_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Behavior on maintenance events. Can be: `unspecified`, `migrate`, `restart`. The default is `unspecified`.
        """
        return pulumi.get(self, "maintenance_policy")

    @maintenance_policy.setter
    def maintenance_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintenance_policy", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Metadata key/value pairs to make available from within the instance.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter(name="metadataOptions")
    def metadata_options(self) -> Optional[pulumi.Input['ComputeInstanceMetadataOptionsArgs']]:
        """
        Options allow user to configure access to instance's metadata.
        """
        return pulumi.get(self, "metadata_options")

    @metadata_options.setter
    def metadata_options(self, value: Optional[pulumi.Input['ComputeInstanceMetadataOptionsArgs']]):
        pulumi.set(self, "metadata_options", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkAccelerationType")
    def network_acceleration_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of network acceleration. Can be `standard` or `software_accelerated`. The default is `standard`.
        """
        return pulumi.get(self, "network_acceleration_type")

    @network_acceleration_type.setter
    def network_acceleration_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_acceleration_type", value)

    @_builtins.property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ComputeInstanceNetworkInterfaceArgs']]]]:
        """
        Networks to attach to the instance. This can be specified multiple times.
        """
        return pulumi.get(self, "network_interfaces")

    @network_interfaces.setter
    def network_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ComputeInstanceNetworkInterfaceArgs']]]]):
        pulumi.set(self, "network_interfaces", value)

    @_builtins.property
    @pulumi.getter(name="placementPolicy")
    def placement_policy(self) -> Optional[pulumi.Input['ComputeInstancePlacementPolicyArgs']]:
        """
        The placement policy configuration.
        """
        return pulumi.get(self, "placement_policy")

    @placement_policy.setter
    def placement_policy(self, value: Optional[pulumi.Input['ComputeInstancePlacementPolicyArgs']]):
        pulumi.set(self, "placement_policy", value)

    @_builtins.property
    @pulumi.getter(name="platformId")
    def platform_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of virtual machine to create.
        """
        return pulumi.get(self, "platform_id")

    @platform_id.setter
    def platform_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "platform_id", value)

    @_builtins.property
    @pulumi.getter
    def resources(self) -> Optional[pulumi.Input['ComputeInstanceResourcesArgs']]:
        """
        Compute resources that are allocated for the instance.
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: Optional[pulumi.Input['ComputeInstanceResourcesArgs']]):
        pulumi.set(self, "resources", value)

    @_builtins.property
    @pulumi.getter(name="schedulingPolicy")
    def scheduling_policy(self) -> Optional[pulumi.Input['ComputeInstanceSchedulingPolicyArgs']]:
        """
        Scheduling policy configuration.
        """
        return pulumi.get(self, "scheduling_policy")

    @scheduling_policy.setter
    def scheduling_policy(self, value: Optional[pulumi.Input['ComputeInstanceSchedulingPolicyArgs']]):
        pulumi.set(self, "scheduling_policy", value)

    @_builtins.property
    @pulumi.getter(name="secondaryDisks")
    def secondary_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ComputeInstanceSecondaryDiskArgs']]]]:
        """
        A set of disks to attach to the instance. The structure is documented below.

        > The `allow_stopping_for_update` property must be set to `true` in order to update this structure.
        """
        return pulumi.get(self, "secondary_disks")

    @secondary_disks.setter
    def secondary_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ComputeInstanceSecondaryDiskArgs']]]]):
        pulumi.set(self, "secondary_disks", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccountId")
    def service_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        [Service account](https://yandex.cloud/docs/iam/concepts/users/service-accounts) which linked to the resource.
        """
        return pulumi.get(self, "service_account_id")

    @service_account_id.setter
    def service_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_account_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of this instance.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [availability zone](https://yandex.cloud/docs/overview/concepts/geo-scope) where resource is located. If it is not provided, the default provider zone will be used.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.type_token("yandex:index/computeInstance:ComputeInstance")
class ComputeInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_recreate: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_stopping_for_update: Optional[pulumi.Input[_builtins.bool]] = None,
                 boot_disk: Optional[pulumi.Input[Union['ComputeInstanceBootDiskArgs', 'ComputeInstanceBootDiskArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 filesystems: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ComputeInstanceFilesystemArgs', 'ComputeInstanceFilesystemArgsDict']]]]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 gpu_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 hostname: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 local_disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ComputeInstanceLocalDiskArgs', 'ComputeInstanceLocalDiskArgsDict']]]]] = None,
                 maintenance_grace_period: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 metadata_options: Optional[pulumi.Input[Union['ComputeInstanceMetadataOptionsArgs', 'ComputeInstanceMetadataOptionsArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_acceleration_type: Optional[pulumi.Input[_builtins.str]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ComputeInstanceNetworkInterfaceArgs', 'ComputeInstanceNetworkInterfaceArgsDict']]]]] = None,
                 placement_policy: Optional[pulumi.Input[Union['ComputeInstancePlacementPolicyArgs', 'ComputeInstancePlacementPolicyArgsDict']]] = None,
                 platform_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resources: Optional[pulumi.Input[Union['ComputeInstanceResourcesArgs', 'ComputeInstanceResourcesArgsDict']]] = None,
                 scheduling_policy: Optional[pulumi.Input[Union['ComputeInstanceSchedulingPolicyArgs', 'ComputeInstanceSchedulingPolicyArgsDict']]] = None,
                 secondary_disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ComputeInstanceSecondaryDiskArgs', 'ComputeInstanceSecondaryDiskArgsDict']]]]] = None,
                 service_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        A VM instance resource. For more information, see [the official documentation](https://yandex.cloud/docs/compute/concepts/vm).

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        bash

        ```sh
        $ pulumi import yandex:index/computeInstance:ComputeInstance <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/computeInstance:ComputeInstance my_vm1 fhmur**********j51ah
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ComputeInstanceBootDiskArgs', 'ComputeInstanceBootDiskArgsDict']] boot_disk: The boot disk for the instance. Either `initialize_params` or `disk_id` must be specified.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ComputeInstanceFilesystemArgs', 'ComputeInstanceFilesystemArgsDict']]]] filesystems: List of filesystems that are attached to the instance.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[_builtins.str] gpu_cluster_id: ID of the GPU cluster to attach this instance to.
        :param pulumi.Input[_builtins.str] hostname: Host name for the instance. This field is used to generate the instance `fqdn` value. The host name must be unique within the network and region. If not specified, the host name will be equal to `id` of the instance and `fqdn` will be `<id>.auto.internal`. Otherwise FQDN will be `<hostname>.<region_id>.internal`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ComputeInstanceLocalDiskArgs', 'ComputeInstanceLocalDiskArgsDict']]]] local_disks: List of local disks that are attached to the instance.
        :param pulumi.Input[_builtins.str] maintenance_grace_period: Time between notification via metadata service and maintenance. E.g., `60s`.
        :param pulumi.Input[_builtins.str] maintenance_policy: Behavior on maintenance events. Can be: `unspecified`, `migrate`, `restart`. The default is `unspecified`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: Metadata key/value pairs to make available from within the instance.
        :param pulumi.Input[Union['ComputeInstanceMetadataOptionsArgs', 'ComputeInstanceMetadataOptionsArgsDict']] metadata_options: Options allow user to configure access to instance's metadata.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[_builtins.str] network_acceleration_type: Type of network acceleration. Can be `standard` or `software_accelerated`. The default is `standard`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ComputeInstanceNetworkInterfaceArgs', 'ComputeInstanceNetworkInterfaceArgsDict']]]] network_interfaces: Networks to attach to the instance. This can be specified multiple times.
        :param pulumi.Input[Union['ComputeInstancePlacementPolicyArgs', 'ComputeInstancePlacementPolicyArgsDict']] placement_policy: The placement policy configuration.
        :param pulumi.Input[_builtins.str] platform_id: The type of virtual machine to create.
        :param pulumi.Input[Union['ComputeInstanceResourcesArgs', 'ComputeInstanceResourcesArgsDict']] resources: Compute resources that are allocated for the instance.
        :param pulumi.Input[Union['ComputeInstanceSchedulingPolicyArgs', 'ComputeInstanceSchedulingPolicyArgsDict']] scheduling_policy: Scheduling policy configuration.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ComputeInstanceSecondaryDiskArgs', 'ComputeInstanceSecondaryDiskArgsDict']]]] secondary_disks: A set of disks to attach to the instance. The structure is documented below.
               
               > The `allow_stopping_for_update` property must be set to `true` in order to update this structure.
        :param pulumi.Input[_builtins.str] service_account_id: [Service account](https://yandex.cloud/docs/iam/concepts/users/service-accounts) which linked to the resource.
        :param pulumi.Input[_builtins.str] zone: The [availability zone](https://yandex.cloud/docs/overview/concepts/geo-scope) where resource is located. If it is not provided, the default provider zone will be used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ComputeInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A VM instance resource. For more information, see [the official documentation](https://yandex.cloud/docs/compute/concepts/vm).

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        bash

        ```sh
        $ pulumi import yandex:index/computeInstance:ComputeInstance <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/computeInstance:ComputeInstance my_vm1 fhmur**********j51ah
        ```

        :param str resource_name: The name of the resource.
        :param ComputeInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ComputeInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_recreate: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_stopping_for_update: Optional[pulumi.Input[_builtins.bool]] = None,
                 boot_disk: Optional[pulumi.Input[Union['ComputeInstanceBootDiskArgs', 'ComputeInstanceBootDiskArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 filesystems: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ComputeInstanceFilesystemArgs', 'ComputeInstanceFilesystemArgsDict']]]]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 gpu_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 hostname: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 local_disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ComputeInstanceLocalDiskArgs', 'ComputeInstanceLocalDiskArgsDict']]]]] = None,
                 maintenance_grace_period: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 metadata_options: Optional[pulumi.Input[Union['ComputeInstanceMetadataOptionsArgs', 'ComputeInstanceMetadataOptionsArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_acceleration_type: Optional[pulumi.Input[_builtins.str]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ComputeInstanceNetworkInterfaceArgs', 'ComputeInstanceNetworkInterfaceArgsDict']]]]] = None,
                 placement_policy: Optional[pulumi.Input[Union['ComputeInstancePlacementPolicyArgs', 'ComputeInstancePlacementPolicyArgsDict']]] = None,
                 platform_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resources: Optional[pulumi.Input[Union['ComputeInstanceResourcesArgs', 'ComputeInstanceResourcesArgsDict']]] = None,
                 scheduling_policy: Optional[pulumi.Input[Union['ComputeInstanceSchedulingPolicyArgs', 'ComputeInstanceSchedulingPolicyArgsDict']]] = None,
                 secondary_disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ComputeInstanceSecondaryDiskArgs', 'ComputeInstanceSecondaryDiskArgsDict']]]]] = None,
                 service_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ComputeInstanceArgs.__new__(ComputeInstanceArgs)

            __props__.__dict__["allow_recreate"] = allow_recreate
            __props__.__dict__["allow_stopping_for_update"] = allow_stopping_for_update
            if boot_disk is None and not opts.urn:
                raise TypeError("Missing required property 'boot_disk'")
            __props__.__dict__["boot_disk"] = boot_disk
            __props__.__dict__["description"] = description
            __props__.__dict__["filesystems"] = filesystems
            __props__.__dict__["folder_id"] = folder_id
            __props__.__dict__["gpu_cluster_id"] = gpu_cluster_id
            __props__.__dict__["hostname"] = hostname
            __props__.__dict__["labels"] = labels
            __props__.__dict__["local_disks"] = local_disks
            __props__.__dict__["maintenance_grace_period"] = maintenance_grace_period
            __props__.__dict__["maintenance_policy"] = maintenance_policy
            __props__.__dict__["metadata"] = metadata
            __props__.__dict__["metadata_options"] = metadata_options
            __props__.__dict__["name"] = name
            __props__.__dict__["network_acceleration_type"] = network_acceleration_type
            if network_interfaces is None and not opts.urn:
                raise TypeError("Missing required property 'network_interfaces'")
            __props__.__dict__["network_interfaces"] = network_interfaces
            __props__.__dict__["placement_policy"] = placement_policy
            __props__.__dict__["platform_id"] = platform_id
            if resources is None and not opts.urn:
                raise TypeError("Missing required property 'resources'")
            __props__.__dict__["resources"] = resources
            __props__.__dict__["scheduling_policy"] = scheduling_policy
            __props__.__dict__["secondary_disks"] = secondary_disks
            __props__.__dict__["service_account_id"] = service_account_id
            __props__.__dict__["zone"] = zone
            __props__.__dict__["created_at"] = None
            __props__.__dict__["fqdn"] = None
            __props__.__dict__["hardware_generations"] = None
            __props__.__dict__["status"] = None
        super(ComputeInstance, __self__).__init__(
            'yandex:index/computeInstance:ComputeInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allow_recreate: Optional[pulumi.Input[_builtins.bool]] = None,
            allow_stopping_for_update: Optional[pulumi.Input[_builtins.bool]] = None,
            boot_disk: Optional[pulumi.Input[Union['ComputeInstanceBootDiskArgs', 'ComputeInstanceBootDiskArgsDict']]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            filesystems: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ComputeInstanceFilesystemArgs', 'ComputeInstanceFilesystemArgsDict']]]]] = None,
            folder_id: Optional[pulumi.Input[_builtins.str]] = None,
            fqdn: Optional[pulumi.Input[_builtins.str]] = None,
            gpu_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            hardware_generations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ComputeInstanceHardwareGenerationArgs', 'ComputeInstanceHardwareGenerationArgsDict']]]]] = None,
            hostname: Optional[pulumi.Input[_builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            local_disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ComputeInstanceLocalDiskArgs', 'ComputeInstanceLocalDiskArgsDict']]]]] = None,
            maintenance_grace_period: Optional[pulumi.Input[_builtins.str]] = None,
            maintenance_policy: Optional[pulumi.Input[_builtins.str]] = None,
            metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            metadata_options: Optional[pulumi.Input[Union['ComputeInstanceMetadataOptionsArgs', 'ComputeInstanceMetadataOptionsArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_acceleration_type: Optional[pulumi.Input[_builtins.str]] = None,
            network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ComputeInstanceNetworkInterfaceArgs', 'ComputeInstanceNetworkInterfaceArgsDict']]]]] = None,
            placement_policy: Optional[pulumi.Input[Union['ComputeInstancePlacementPolicyArgs', 'ComputeInstancePlacementPolicyArgsDict']]] = None,
            platform_id: Optional[pulumi.Input[_builtins.str]] = None,
            resources: Optional[pulumi.Input[Union['ComputeInstanceResourcesArgs', 'ComputeInstanceResourcesArgsDict']]] = None,
            scheduling_policy: Optional[pulumi.Input[Union['ComputeInstanceSchedulingPolicyArgs', 'ComputeInstanceSchedulingPolicyArgsDict']]] = None,
            secondary_disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ComputeInstanceSecondaryDiskArgs', 'ComputeInstanceSecondaryDiskArgsDict']]]]] = None,
            service_account_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            zone: Optional[pulumi.Input[_builtins.str]] = None) -> 'ComputeInstance':
        """
        Get an existing ComputeInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ComputeInstanceBootDiskArgs', 'ComputeInstanceBootDiskArgsDict']] boot_disk: The boot disk for the instance. Either `initialize_params` or `disk_id` must be specified.
        :param pulumi.Input[_builtins.str] created_at: The creation timestamp of the resource.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ComputeInstanceFilesystemArgs', 'ComputeInstanceFilesystemArgsDict']]]] filesystems: List of filesystems that are attached to the instance.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[_builtins.str] fqdn: The fully qualified DNS name of this instance.
        :param pulumi.Input[_builtins.str] gpu_cluster_id: ID of the GPU cluster to attach this instance to.
        :param pulumi.Input[_builtins.str] hostname: Host name for the instance. This field is used to generate the instance `fqdn` value. The host name must be unique within the network and region. If not specified, the host name will be equal to `id` of the instance and `fqdn` will be `<id>.auto.internal`. Otherwise FQDN will be `<hostname>.<region_id>.internal`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ComputeInstanceLocalDiskArgs', 'ComputeInstanceLocalDiskArgsDict']]]] local_disks: List of local disks that are attached to the instance.
        :param pulumi.Input[_builtins.str] maintenance_grace_period: Time between notification via metadata service and maintenance. E.g., `60s`.
        :param pulumi.Input[_builtins.str] maintenance_policy: Behavior on maintenance events. Can be: `unspecified`, `migrate`, `restart`. The default is `unspecified`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: Metadata key/value pairs to make available from within the instance.
        :param pulumi.Input[Union['ComputeInstanceMetadataOptionsArgs', 'ComputeInstanceMetadataOptionsArgsDict']] metadata_options: Options allow user to configure access to instance's metadata.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[_builtins.str] network_acceleration_type: Type of network acceleration. Can be `standard` or `software_accelerated`. The default is `standard`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ComputeInstanceNetworkInterfaceArgs', 'ComputeInstanceNetworkInterfaceArgsDict']]]] network_interfaces: Networks to attach to the instance. This can be specified multiple times.
        :param pulumi.Input[Union['ComputeInstancePlacementPolicyArgs', 'ComputeInstancePlacementPolicyArgsDict']] placement_policy: The placement policy configuration.
        :param pulumi.Input[_builtins.str] platform_id: The type of virtual machine to create.
        :param pulumi.Input[Union['ComputeInstanceResourcesArgs', 'ComputeInstanceResourcesArgsDict']] resources: Compute resources that are allocated for the instance.
        :param pulumi.Input[Union['ComputeInstanceSchedulingPolicyArgs', 'ComputeInstanceSchedulingPolicyArgsDict']] scheduling_policy: Scheduling policy configuration.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ComputeInstanceSecondaryDiskArgs', 'ComputeInstanceSecondaryDiskArgsDict']]]] secondary_disks: A set of disks to attach to the instance. The structure is documented below.
               
               > The `allow_stopping_for_update` property must be set to `true` in order to update this structure.
        :param pulumi.Input[_builtins.str] service_account_id: [Service account](https://yandex.cloud/docs/iam/concepts/users/service-accounts) which linked to the resource.
        :param pulumi.Input[_builtins.str] status: The status of this instance.
        :param pulumi.Input[_builtins.str] zone: The [availability zone](https://yandex.cloud/docs/overview/concepts/geo-scope) where resource is located. If it is not provided, the default provider zone will be used.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ComputeInstanceState.__new__(_ComputeInstanceState)

        __props__.__dict__["allow_recreate"] = allow_recreate
        __props__.__dict__["allow_stopping_for_update"] = allow_stopping_for_update
        __props__.__dict__["boot_disk"] = boot_disk
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["filesystems"] = filesystems
        __props__.__dict__["folder_id"] = folder_id
        __props__.__dict__["fqdn"] = fqdn
        __props__.__dict__["gpu_cluster_id"] = gpu_cluster_id
        __props__.__dict__["hardware_generations"] = hardware_generations
        __props__.__dict__["hostname"] = hostname
        __props__.__dict__["labels"] = labels
        __props__.__dict__["local_disks"] = local_disks
        __props__.__dict__["maintenance_grace_period"] = maintenance_grace_period
        __props__.__dict__["maintenance_policy"] = maintenance_policy
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["metadata_options"] = metadata_options
        __props__.__dict__["name"] = name
        __props__.__dict__["network_acceleration_type"] = network_acceleration_type
        __props__.__dict__["network_interfaces"] = network_interfaces
        __props__.__dict__["placement_policy"] = placement_policy
        __props__.__dict__["platform_id"] = platform_id
        __props__.__dict__["resources"] = resources
        __props__.__dict__["scheduling_policy"] = scheduling_policy
        __props__.__dict__["secondary_disks"] = secondary_disks
        __props__.__dict__["service_account_id"] = service_account_id
        __props__.__dict__["status"] = status
        __props__.__dict__["zone"] = zone
        return ComputeInstance(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="allowRecreate")
    def allow_recreate(self) -> pulumi.Output[Optional[_builtins.bool]]:
        return pulumi.get(self, "allow_recreate")

    @_builtins.property
    @pulumi.getter(name="allowStoppingForUpdate")
    def allow_stopping_for_update(self) -> pulumi.Output[Optional[_builtins.bool]]:
        return pulumi.get(self, "allow_stopping_for_update")

    @_builtins.property
    @pulumi.getter(name="bootDisk")
    def boot_disk(self) -> pulumi.Output['outputs.ComputeInstanceBootDisk']:
        """
        The boot disk for the instance. Either `initialize_params` or `disk_id` must be specified.
        """
        return pulumi.get(self, "boot_disk")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def filesystems(self) -> pulumi.Output[Optional[Sequence['outputs.ComputeInstanceFilesystem']]]:
        """
        List of filesystems that are attached to the instance.
        """
        return pulumi.get(self, "filesystems")

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> pulumi.Output[_builtins.str]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @_builtins.property
    @pulumi.getter
    def fqdn(self) -> pulumi.Output[_builtins.str]:
        """
        The fully qualified DNS name of this instance.
        """
        return pulumi.get(self, "fqdn")

    @_builtins.property
    @pulumi.getter(name="gpuClusterId")
    def gpu_cluster_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the GPU cluster to attach this instance to.
        """
        return pulumi.get(self, "gpu_cluster_id")

    @_builtins.property
    @pulumi.getter(name="hardwareGenerations")
    def hardware_generations(self) -> pulumi.Output[Sequence['outputs.ComputeInstanceHardwareGeneration']]:
        return pulumi.get(self, "hardware_generations")

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> pulumi.Output[_builtins.str]:
        """
        Host name for the instance. This field is used to generate the instance `fqdn` value. The host name must be unique within the network and region. If not specified, the host name will be equal to `id` of the instance and `fqdn` will be `<id>.auto.internal`. Otherwise FQDN will be `<hostname>.<region_id>.internal`.
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="localDisks")
    def local_disks(self) -> pulumi.Output[Optional[Sequence['outputs.ComputeInstanceLocalDisk']]]:
        """
        List of local disks that are attached to the instance.
        """
        return pulumi.get(self, "local_disks")

    @_builtins.property
    @pulumi.getter(name="maintenanceGracePeriod")
    def maintenance_grace_period(self) -> pulumi.Output[_builtins.str]:
        """
        Time between notification via metadata service and maintenance. E.g., `60s`.
        """
        return pulumi.get(self, "maintenance_grace_period")

    @_builtins.property
    @pulumi.getter(name="maintenancePolicy")
    def maintenance_policy(self) -> pulumi.Output[_builtins.str]:
        """
        Behavior on maintenance events. Can be: `unspecified`, `migrate`, `restart`. The default is `unspecified`.
        """
        return pulumi.get(self, "maintenance_policy")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Metadata key/value pairs to make available from within the instance.
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter(name="metadataOptions")
    def metadata_options(self) -> pulumi.Output['outputs.ComputeInstanceMetadataOptions']:
        """
        Options allow user to configure access to instance's metadata.
        """
        return pulumi.get(self, "metadata_options")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkAccelerationType")
    def network_acceleration_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Type of network acceleration. Can be `standard` or `software_accelerated`. The default is `standard`.
        """
        return pulumi.get(self, "network_acceleration_type")

    @_builtins.property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> pulumi.Output[Sequence['outputs.ComputeInstanceNetworkInterface']]:
        """
        Networks to attach to the instance. This can be specified multiple times.
        """
        return pulumi.get(self, "network_interfaces")

    @_builtins.property
    @pulumi.getter(name="placementPolicy")
    def placement_policy(self) -> pulumi.Output['outputs.ComputeInstancePlacementPolicy']:
        """
        The placement policy configuration.
        """
        return pulumi.get(self, "placement_policy")

    @_builtins.property
    @pulumi.getter(name="platformId")
    def platform_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The type of virtual machine to create.
        """
        return pulumi.get(self, "platform_id")

    @_builtins.property
    @pulumi.getter
    def resources(self) -> pulumi.Output['outputs.ComputeInstanceResources']:
        """
        Compute resources that are allocated for the instance.
        """
        return pulumi.get(self, "resources")

    @_builtins.property
    @pulumi.getter(name="schedulingPolicy")
    def scheduling_policy(self) -> pulumi.Output['outputs.ComputeInstanceSchedulingPolicy']:
        """
        Scheduling policy configuration.
        """
        return pulumi.get(self, "scheduling_policy")

    @_builtins.property
    @pulumi.getter(name="secondaryDisks")
    def secondary_disks(self) -> pulumi.Output[Optional[Sequence['outputs.ComputeInstanceSecondaryDisk']]]:
        """
        A set of disks to attach to the instance. The structure is documented below.

        > The `allow_stopping_for_update` property must be set to `true` in order to update this structure.
        """
        return pulumi.get(self, "secondary_disks")

    @_builtins.property
    @pulumi.getter(name="serviceAccountId")
    def service_account_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        [Service account](https://yandex.cloud/docs/iam/concepts/users/service-accounts) which linked to the resource.
        """
        return pulumi.get(self, "service_account_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of this instance.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> pulumi.Output[_builtins.str]:
        """
        The [availability zone](https://yandex.cloud/docs/overview/concepts/geo-scope) where resource is located. If it is not provided, the default provider zone will be used.
        """
        return pulumi.get(self, "zone")

