# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ComputeInstanceGroupArgs', 'ComputeInstanceGroup']

@pulumi.input_type
class ComputeInstanceGroupArgs:
    def __init__(__self__, *,
                 allocation_policy: pulumi.Input['ComputeInstanceGroupAllocationPolicyArgs'],
                 deploy_policy: pulumi.Input['ComputeInstanceGroupDeployPolicyArgs'],
                 instance_template: pulumi.Input['ComputeInstanceGroupInstanceTemplateArgs'],
                 scale_policy: pulumi.Input['ComputeInstanceGroupScalePolicyArgs'],
                 service_account_id: pulumi.Input[_builtins.str],
                 application_load_balancer: Optional[pulumi.Input['ComputeInstanceGroupApplicationLoadBalancerArgs']] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 health_checks: Optional[pulumi.Input[Sequence[pulumi.Input['ComputeInstanceGroupHealthCheckArgs']]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 load_balancer: Optional[pulumi.Input['ComputeInstanceGroupLoadBalancerArgs']] = None,
                 max_checking_health_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a ComputeInstanceGroup resource.
        :param pulumi.Input['ComputeInstanceGroupAllocationPolicyArgs'] allocation_policy: The allocation policy of the instance group by zone and region.
        :param pulumi.Input['ComputeInstanceGroupDeployPolicyArgs'] deploy_policy: The deployment policy of the instance group.
        :param pulumi.Input['ComputeInstanceGroupInstanceTemplateArgs'] instance_template: The template for creating new instances.
        :param pulumi.Input['ComputeInstanceGroupScalePolicyArgs'] scale_policy: The scaling policy of the instance group.
               
               > Either `fixed_scale` or `auto_scale` must be specified.
        :param pulumi.Input[_builtins.str] service_account_id: [Service account](https://yandex.cloud/docs/iam/concepts/users/service-accounts) which linked to the resource.
        :param pulumi.Input['ComputeInstanceGroupApplicationLoadBalancerArgs'] application_load_balancer: Application Load balancing (L7) specifications.
        :param pulumi.Input[_builtins.bool] deletion_protection: The `true` value means that resource is protected from accidental deletion.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Sequence[pulumi.Input['ComputeInstanceGroupHealthCheckArgs']]] health_checks: Health check specifications.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input['ComputeInstanceGroupLoadBalancerArgs'] load_balancer: Load balancing specifications.
        :param pulumi.Input[_builtins.int] max_checking_health_duration: Timeout for waiting for the VM to become healthy. If the timeout is exceeded, the VM will be turned off based on the deployment policy. Specified in seconds.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] variables: A set of key/value variables pairs to assign to the instance group.
        """
        pulumi.set(__self__, "allocation_policy", allocation_policy)
        pulumi.set(__self__, "deploy_policy", deploy_policy)
        pulumi.set(__self__, "instance_template", instance_template)
        pulumi.set(__self__, "scale_policy", scale_policy)
        pulumi.set(__self__, "service_account_id", service_account_id)
        if application_load_balancer is not None:
            pulumi.set(__self__, "application_load_balancer", application_load_balancer)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if health_checks is not None:
            pulumi.set(__self__, "health_checks", health_checks)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if load_balancer is not None:
            pulumi.set(__self__, "load_balancer", load_balancer)
        if max_checking_health_duration is not None:
            pulumi.set(__self__, "max_checking_health_duration", max_checking_health_duration)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if variables is not None:
            pulumi.set(__self__, "variables", variables)

    @_builtins.property
    @pulumi.getter(name="allocationPolicy")
    def allocation_policy(self) -> pulumi.Input['ComputeInstanceGroupAllocationPolicyArgs']:
        """
        The allocation policy of the instance group by zone and region.
        """
        return pulumi.get(self, "allocation_policy")

    @allocation_policy.setter
    def allocation_policy(self, value: pulumi.Input['ComputeInstanceGroupAllocationPolicyArgs']):
        pulumi.set(self, "allocation_policy", value)

    @_builtins.property
    @pulumi.getter(name="deployPolicy")
    def deploy_policy(self) -> pulumi.Input['ComputeInstanceGroupDeployPolicyArgs']:
        """
        The deployment policy of the instance group.
        """
        return pulumi.get(self, "deploy_policy")

    @deploy_policy.setter
    def deploy_policy(self, value: pulumi.Input['ComputeInstanceGroupDeployPolicyArgs']):
        pulumi.set(self, "deploy_policy", value)

    @_builtins.property
    @pulumi.getter(name="instanceTemplate")
    def instance_template(self) -> pulumi.Input['ComputeInstanceGroupInstanceTemplateArgs']:
        """
        The template for creating new instances.
        """
        return pulumi.get(self, "instance_template")

    @instance_template.setter
    def instance_template(self, value: pulumi.Input['ComputeInstanceGroupInstanceTemplateArgs']):
        pulumi.set(self, "instance_template", value)

    @_builtins.property
    @pulumi.getter(name="scalePolicy")
    def scale_policy(self) -> pulumi.Input['ComputeInstanceGroupScalePolicyArgs']:
        """
        The scaling policy of the instance group.

        > Either `fixed_scale` or `auto_scale` must be specified.
        """
        return pulumi.get(self, "scale_policy")

    @scale_policy.setter
    def scale_policy(self, value: pulumi.Input['ComputeInstanceGroupScalePolicyArgs']):
        pulumi.set(self, "scale_policy", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccountId")
    def service_account_id(self) -> pulumi.Input[_builtins.str]:
        """
        [Service account](https://yandex.cloud/docs/iam/concepts/users/service-accounts) which linked to the resource.
        """
        return pulumi.get(self, "service_account_id")

    @service_account_id.setter
    def service_account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service_account_id", value)

    @_builtins.property
    @pulumi.getter(name="applicationLoadBalancer")
    def application_load_balancer(self) -> Optional[pulumi.Input['ComputeInstanceGroupApplicationLoadBalancerArgs']]:
        """
        Application Load balancing (L7) specifications.
        """
        return pulumi.get(self, "application_load_balancer")

    @application_load_balancer.setter
    def application_load_balancer(self, value: Optional[pulumi.Input['ComputeInstanceGroupApplicationLoadBalancerArgs']]):
        pulumi.set(self, "application_load_balancer", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The `true` value means that resource is protected from accidental deletion.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder_id", value)

    @_builtins.property
    @pulumi.getter(name="healthChecks")
    def health_checks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ComputeInstanceGroupHealthCheckArgs']]]]:
        """
        Health check specifications.
        """
        return pulumi.get(self, "health_checks")

    @health_checks.setter
    def health_checks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ComputeInstanceGroupHealthCheckArgs']]]]):
        pulumi.set(self, "health_checks", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="loadBalancer")
    def load_balancer(self) -> Optional[pulumi.Input['ComputeInstanceGroupLoadBalancerArgs']]:
        """
        Load balancing specifications.
        """
        return pulumi.get(self, "load_balancer")

    @load_balancer.setter
    def load_balancer(self, value: Optional[pulumi.Input['ComputeInstanceGroupLoadBalancerArgs']]):
        pulumi.set(self, "load_balancer", value)

    @_builtins.property
    @pulumi.getter(name="maxCheckingHealthDuration")
    def max_checking_health_duration(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Timeout for waiting for the VM to become healthy. If the timeout is exceeded, the VM will be turned off based on the deployment policy. Specified in seconds.
        """
        return pulumi.get(self, "max_checking_health_duration")

    @max_checking_health_duration.setter
    def max_checking_health_duration(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_checking_health_duration", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value variables pairs to assign to the instance group.
        """
        return pulumi.get(self, "variables")

    @variables.setter
    def variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "variables", value)


@pulumi.input_type
class _ComputeInstanceGroupState:
    def __init__(__self__, *,
                 allocation_policy: Optional[pulumi.Input['ComputeInstanceGroupAllocationPolicyArgs']] = None,
                 application_load_balancer: Optional[pulumi.Input['ComputeInstanceGroupApplicationLoadBalancerArgs']] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 deploy_policy: Optional[pulumi.Input['ComputeInstanceGroupDeployPolicyArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 health_checks: Optional[pulumi.Input[Sequence[pulumi.Input['ComputeInstanceGroupHealthCheckArgs']]]] = None,
                 instance_template: Optional[pulumi.Input['ComputeInstanceGroupInstanceTemplateArgs']] = None,
                 instances: Optional[pulumi.Input[Sequence[pulumi.Input['ComputeInstanceGroupInstanceArgs']]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 load_balancer: Optional[pulumi.Input['ComputeInstanceGroupLoadBalancerArgs']] = None,
                 max_checking_health_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 scale_policy: Optional[pulumi.Input['ComputeInstanceGroupScalePolicyArgs']] = None,
                 service_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering ComputeInstanceGroup resources.
        :param pulumi.Input['ComputeInstanceGroupAllocationPolicyArgs'] allocation_policy: The allocation policy of the instance group by zone and region.
        :param pulumi.Input['ComputeInstanceGroupApplicationLoadBalancerArgs'] application_load_balancer: Application Load balancing (L7) specifications.
        :param pulumi.Input[_builtins.str] created_at: The creation timestamp of the resource.
        :param pulumi.Input[_builtins.bool] deletion_protection: The `true` value means that resource is protected from accidental deletion.
        :param pulumi.Input['ComputeInstanceGroupDeployPolicyArgs'] deploy_policy: The deployment policy of the instance group.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Sequence[pulumi.Input['ComputeInstanceGroupHealthCheckArgs']]] health_checks: Health check specifications.
        :param pulumi.Input['ComputeInstanceGroupInstanceTemplateArgs'] instance_template: The template for creating new instances.
        :param pulumi.Input[Sequence[pulumi.Input['ComputeInstanceGroupInstanceArgs']]] instances: Instances block.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input['ComputeInstanceGroupLoadBalancerArgs'] load_balancer: Load balancing specifications.
        :param pulumi.Input[_builtins.int] max_checking_health_duration: Timeout for waiting for the VM to become healthy. If the timeout is exceeded, the VM will be turned off based on the deployment policy. Specified in seconds.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input['ComputeInstanceGroupScalePolicyArgs'] scale_policy: The scaling policy of the instance group.
               
               > Either `fixed_scale` or `auto_scale` must be specified.
        :param pulumi.Input[_builtins.str] service_account_id: [Service account](https://yandex.cloud/docs/iam/concepts/users/service-accounts) which linked to the resource.
        :param pulumi.Input[_builtins.str] status: The status of the instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] variables: A set of key/value variables pairs to assign to the instance group.
        """
        if allocation_policy is not None:
            pulumi.set(__self__, "allocation_policy", allocation_policy)
        if application_load_balancer is not None:
            pulumi.set(__self__, "application_load_balancer", application_load_balancer)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if deploy_policy is not None:
            pulumi.set(__self__, "deploy_policy", deploy_policy)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if health_checks is not None:
            pulumi.set(__self__, "health_checks", health_checks)
        if instance_template is not None:
            pulumi.set(__self__, "instance_template", instance_template)
        if instances is not None:
            pulumi.set(__self__, "instances", instances)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if load_balancer is not None:
            pulumi.set(__self__, "load_balancer", load_balancer)
        if max_checking_health_duration is not None:
            pulumi.set(__self__, "max_checking_health_duration", max_checking_health_duration)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if scale_policy is not None:
            pulumi.set(__self__, "scale_policy", scale_policy)
        if service_account_id is not None:
            pulumi.set(__self__, "service_account_id", service_account_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if variables is not None:
            pulumi.set(__self__, "variables", variables)

    @_builtins.property
    @pulumi.getter(name="allocationPolicy")
    def allocation_policy(self) -> Optional[pulumi.Input['ComputeInstanceGroupAllocationPolicyArgs']]:
        """
        The allocation policy of the instance group by zone and region.
        """
        return pulumi.get(self, "allocation_policy")

    @allocation_policy.setter
    def allocation_policy(self, value: Optional[pulumi.Input['ComputeInstanceGroupAllocationPolicyArgs']]):
        pulumi.set(self, "allocation_policy", value)

    @_builtins.property
    @pulumi.getter(name="applicationLoadBalancer")
    def application_load_balancer(self) -> Optional[pulumi.Input['ComputeInstanceGroupApplicationLoadBalancerArgs']]:
        """
        Application Load balancing (L7) specifications.
        """
        return pulumi.get(self, "application_load_balancer")

    @application_load_balancer.setter
    def application_load_balancer(self, value: Optional[pulumi.Input['ComputeInstanceGroupApplicationLoadBalancerArgs']]):
        pulumi.set(self, "application_load_balancer", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The `true` value means that resource is protected from accidental deletion.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter(name="deployPolicy")
    def deploy_policy(self) -> Optional[pulumi.Input['ComputeInstanceGroupDeployPolicyArgs']]:
        """
        The deployment policy of the instance group.
        """
        return pulumi.get(self, "deploy_policy")

    @deploy_policy.setter
    def deploy_policy(self, value: Optional[pulumi.Input['ComputeInstanceGroupDeployPolicyArgs']]):
        pulumi.set(self, "deploy_policy", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder_id", value)

    @_builtins.property
    @pulumi.getter(name="healthChecks")
    def health_checks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ComputeInstanceGroupHealthCheckArgs']]]]:
        """
        Health check specifications.
        """
        return pulumi.get(self, "health_checks")

    @health_checks.setter
    def health_checks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ComputeInstanceGroupHealthCheckArgs']]]]):
        pulumi.set(self, "health_checks", value)

    @_builtins.property
    @pulumi.getter(name="instanceTemplate")
    def instance_template(self) -> Optional[pulumi.Input['ComputeInstanceGroupInstanceTemplateArgs']]:
        """
        The template for creating new instances.
        """
        return pulumi.get(self, "instance_template")

    @instance_template.setter
    def instance_template(self, value: Optional[pulumi.Input['ComputeInstanceGroupInstanceTemplateArgs']]):
        pulumi.set(self, "instance_template", value)

    @_builtins.property
    @pulumi.getter
    def instances(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ComputeInstanceGroupInstanceArgs']]]]:
        """
        Instances block.
        """
        return pulumi.get(self, "instances")

    @instances.setter
    def instances(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ComputeInstanceGroupInstanceArgs']]]]):
        pulumi.set(self, "instances", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="loadBalancer")
    def load_balancer(self) -> Optional[pulumi.Input['ComputeInstanceGroupLoadBalancerArgs']]:
        """
        Load balancing specifications.
        """
        return pulumi.get(self, "load_balancer")

    @load_balancer.setter
    def load_balancer(self, value: Optional[pulumi.Input['ComputeInstanceGroupLoadBalancerArgs']]):
        pulumi.set(self, "load_balancer", value)

    @_builtins.property
    @pulumi.getter(name="maxCheckingHealthDuration")
    def max_checking_health_duration(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Timeout for waiting for the VM to become healthy. If the timeout is exceeded, the VM will be turned off based on the deployment policy. Specified in seconds.
        """
        return pulumi.get(self, "max_checking_health_duration")

    @max_checking_health_duration.setter
    def max_checking_health_duration(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_checking_health_duration", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="scalePolicy")
    def scale_policy(self) -> Optional[pulumi.Input['ComputeInstanceGroupScalePolicyArgs']]:
        """
        The scaling policy of the instance group.

        > Either `fixed_scale` or `auto_scale` must be specified.
        """
        return pulumi.get(self, "scale_policy")

    @scale_policy.setter
    def scale_policy(self, value: Optional[pulumi.Input['ComputeInstanceGroupScalePolicyArgs']]):
        pulumi.set(self, "scale_policy", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccountId")
    def service_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        [Service account](https://yandex.cloud/docs/iam/concepts/users/service-accounts) which linked to the resource.
        """
        return pulumi.get(self, "service_account_id")

    @service_account_id.setter
    def service_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_account_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the instance.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value variables pairs to assign to the instance group.
        """
        return pulumi.get(self, "variables")

    @variables.setter
    def variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "variables", value)


@pulumi.type_token("yandex:index/computeInstanceGroup:ComputeInstanceGroup")
class ComputeInstanceGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allocation_policy: Optional[pulumi.Input[Union['ComputeInstanceGroupAllocationPolicyArgs', 'ComputeInstanceGroupAllocationPolicyArgsDict']]] = None,
                 application_load_balancer: Optional[pulumi.Input[Union['ComputeInstanceGroupApplicationLoadBalancerArgs', 'ComputeInstanceGroupApplicationLoadBalancerArgsDict']]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 deploy_policy: Optional[pulumi.Input[Union['ComputeInstanceGroupDeployPolicyArgs', 'ComputeInstanceGroupDeployPolicyArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 health_checks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ComputeInstanceGroupHealthCheckArgs', 'ComputeInstanceGroupHealthCheckArgsDict']]]]] = None,
                 instance_template: Optional[pulumi.Input[Union['ComputeInstanceGroupInstanceTemplateArgs', 'ComputeInstanceGroupInstanceTemplateArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 load_balancer: Optional[pulumi.Input[Union['ComputeInstanceGroupLoadBalancerArgs', 'ComputeInstanceGroupLoadBalancerArgsDict']]] = None,
                 max_checking_health_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 scale_policy: Optional[pulumi.Input[Union['ComputeInstanceGroupScalePolicyArgs', 'ComputeInstanceGroupScalePolicyArgsDict']]] = None,
                 service_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        An Instance group resource. For more information, see [the official documentation](https://yandex.cloud/docs/compute/concepts/instance-groups/).

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        bash

        ```sh
        $ pulumi import yandex:index/computeInstanceGroup:ComputeInstanceGroup <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/computeInstanceGroup:ComputeInstanceGroup my_ig1 cl1jh**********u4275
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ComputeInstanceGroupAllocationPolicyArgs', 'ComputeInstanceGroupAllocationPolicyArgsDict']] allocation_policy: The allocation policy of the instance group by zone and region.
        :param pulumi.Input[Union['ComputeInstanceGroupApplicationLoadBalancerArgs', 'ComputeInstanceGroupApplicationLoadBalancerArgsDict']] application_load_balancer: Application Load balancing (L7) specifications.
        :param pulumi.Input[_builtins.bool] deletion_protection: The `true` value means that resource is protected from accidental deletion.
        :param pulumi.Input[Union['ComputeInstanceGroupDeployPolicyArgs', 'ComputeInstanceGroupDeployPolicyArgsDict']] deploy_policy: The deployment policy of the instance group.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ComputeInstanceGroupHealthCheckArgs', 'ComputeInstanceGroupHealthCheckArgsDict']]]] health_checks: Health check specifications.
        :param pulumi.Input[Union['ComputeInstanceGroupInstanceTemplateArgs', 'ComputeInstanceGroupInstanceTemplateArgsDict']] instance_template: The template for creating new instances.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[Union['ComputeInstanceGroupLoadBalancerArgs', 'ComputeInstanceGroupLoadBalancerArgsDict']] load_balancer: Load balancing specifications.
        :param pulumi.Input[_builtins.int] max_checking_health_duration: Timeout for waiting for the VM to become healthy. If the timeout is exceeded, the VM will be turned off based on the deployment policy. Specified in seconds.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[Union['ComputeInstanceGroupScalePolicyArgs', 'ComputeInstanceGroupScalePolicyArgsDict']] scale_policy: The scaling policy of the instance group.
               
               > Either `fixed_scale` or `auto_scale` must be specified.
        :param pulumi.Input[_builtins.str] service_account_id: [Service account](https://yandex.cloud/docs/iam/concepts/users/service-accounts) which linked to the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] variables: A set of key/value variables pairs to assign to the instance group.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ComputeInstanceGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        An Instance group resource. For more information, see [the official documentation](https://yandex.cloud/docs/compute/concepts/instance-groups/).

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        bash

        ```sh
        $ pulumi import yandex:index/computeInstanceGroup:ComputeInstanceGroup <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/computeInstanceGroup:ComputeInstanceGroup my_ig1 cl1jh**********u4275
        ```

        :param str resource_name: The name of the resource.
        :param ComputeInstanceGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ComputeInstanceGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allocation_policy: Optional[pulumi.Input[Union['ComputeInstanceGroupAllocationPolicyArgs', 'ComputeInstanceGroupAllocationPolicyArgsDict']]] = None,
                 application_load_balancer: Optional[pulumi.Input[Union['ComputeInstanceGroupApplicationLoadBalancerArgs', 'ComputeInstanceGroupApplicationLoadBalancerArgsDict']]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 deploy_policy: Optional[pulumi.Input[Union['ComputeInstanceGroupDeployPolicyArgs', 'ComputeInstanceGroupDeployPolicyArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 health_checks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ComputeInstanceGroupHealthCheckArgs', 'ComputeInstanceGroupHealthCheckArgsDict']]]]] = None,
                 instance_template: Optional[pulumi.Input[Union['ComputeInstanceGroupInstanceTemplateArgs', 'ComputeInstanceGroupInstanceTemplateArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 load_balancer: Optional[pulumi.Input[Union['ComputeInstanceGroupLoadBalancerArgs', 'ComputeInstanceGroupLoadBalancerArgsDict']]] = None,
                 max_checking_health_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 scale_policy: Optional[pulumi.Input[Union['ComputeInstanceGroupScalePolicyArgs', 'ComputeInstanceGroupScalePolicyArgsDict']]] = None,
                 service_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ComputeInstanceGroupArgs.__new__(ComputeInstanceGroupArgs)

            if allocation_policy is None and not opts.urn:
                raise TypeError("Missing required property 'allocation_policy'")
            __props__.__dict__["allocation_policy"] = allocation_policy
            __props__.__dict__["application_load_balancer"] = application_load_balancer
            __props__.__dict__["deletion_protection"] = deletion_protection
            if deploy_policy is None and not opts.urn:
                raise TypeError("Missing required property 'deploy_policy'")
            __props__.__dict__["deploy_policy"] = deploy_policy
            __props__.__dict__["description"] = description
            __props__.__dict__["folder_id"] = folder_id
            __props__.__dict__["health_checks"] = health_checks
            if instance_template is None and not opts.urn:
                raise TypeError("Missing required property 'instance_template'")
            __props__.__dict__["instance_template"] = instance_template
            __props__.__dict__["labels"] = labels
            __props__.__dict__["load_balancer"] = load_balancer
            __props__.__dict__["max_checking_health_duration"] = max_checking_health_duration
            __props__.__dict__["name"] = name
            if scale_policy is None and not opts.urn:
                raise TypeError("Missing required property 'scale_policy'")
            __props__.__dict__["scale_policy"] = scale_policy
            if service_account_id is None and not opts.urn:
                raise TypeError("Missing required property 'service_account_id'")
            __props__.__dict__["service_account_id"] = service_account_id
            __props__.__dict__["variables"] = variables
            __props__.__dict__["created_at"] = None
            __props__.__dict__["instances"] = None
            __props__.__dict__["status"] = None
        super(ComputeInstanceGroup, __self__).__init__(
            'yandex:index/computeInstanceGroup:ComputeInstanceGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allocation_policy: Optional[pulumi.Input[Union['ComputeInstanceGroupAllocationPolicyArgs', 'ComputeInstanceGroupAllocationPolicyArgsDict']]] = None,
            application_load_balancer: Optional[pulumi.Input[Union['ComputeInstanceGroupApplicationLoadBalancerArgs', 'ComputeInstanceGroupApplicationLoadBalancerArgsDict']]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
            deploy_policy: Optional[pulumi.Input[Union['ComputeInstanceGroupDeployPolicyArgs', 'ComputeInstanceGroupDeployPolicyArgsDict']]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            folder_id: Optional[pulumi.Input[_builtins.str]] = None,
            health_checks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ComputeInstanceGroupHealthCheckArgs', 'ComputeInstanceGroupHealthCheckArgsDict']]]]] = None,
            instance_template: Optional[pulumi.Input[Union['ComputeInstanceGroupInstanceTemplateArgs', 'ComputeInstanceGroupInstanceTemplateArgsDict']]] = None,
            instances: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ComputeInstanceGroupInstanceArgs', 'ComputeInstanceGroupInstanceArgsDict']]]]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            load_balancer: Optional[pulumi.Input[Union['ComputeInstanceGroupLoadBalancerArgs', 'ComputeInstanceGroupLoadBalancerArgsDict']]] = None,
            max_checking_health_duration: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            scale_policy: Optional[pulumi.Input[Union['ComputeInstanceGroupScalePolicyArgs', 'ComputeInstanceGroupScalePolicyArgsDict']]] = None,
            service_account_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'ComputeInstanceGroup':
        """
        Get an existing ComputeInstanceGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ComputeInstanceGroupAllocationPolicyArgs', 'ComputeInstanceGroupAllocationPolicyArgsDict']] allocation_policy: The allocation policy of the instance group by zone and region.
        :param pulumi.Input[Union['ComputeInstanceGroupApplicationLoadBalancerArgs', 'ComputeInstanceGroupApplicationLoadBalancerArgsDict']] application_load_balancer: Application Load balancing (L7) specifications.
        :param pulumi.Input[_builtins.str] created_at: The creation timestamp of the resource.
        :param pulumi.Input[_builtins.bool] deletion_protection: The `true` value means that resource is protected from accidental deletion.
        :param pulumi.Input[Union['ComputeInstanceGroupDeployPolicyArgs', 'ComputeInstanceGroupDeployPolicyArgsDict']] deploy_policy: The deployment policy of the instance group.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ComputeInstanceGroupHealthCheckArgs', 'ComputeInstanceGroupHealthCheckArgsDict']]]] health_checks: Health check specifications.
        :param pulumi.Input[Union['ComputeInstanceGroupInstanceTemplateArgs', 'ComputeInstanceGroupInstanceTemplateArgsDict']] instance_template: The template for creating new instances.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ComputeInstanceGroupInstanceArgs', 'ComputeInstanceGroupInstanceArgsDict']]]] instances: Instances block.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[Union['ComputeInstanceGroupLoadBalancerArgs', 'ComputeInstanceGroupLoadBalancerArgsDict']] load_balancer: Load balancing specifications.
        :param pulumi.Input[_builtins.int] max_checking_health_duration: Timeout for waiting for the VM to become healthy. If the timeout is exceeded, the VM will be turned off based on the deployment policy. Specified in seconds.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[Union['ComputeInstanceGroupScalePolicyArgs', 'ComputeInstanceGroupScalePolicyArgsDict']] scale_policy: The scaling policy of the instance group.
               
               > Either `fixed_scale` or `auto_scale` must be specified.
        :param pulumi.Input[_builtins.str] service_account_id: [Service account](https://yandex.cloud/docs/iam/concepts/users/service-accounts) which linked to the resource.
        :param pulumi.Input[_builtins.str] status: The status of the instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] variables: A set of key/value variables pairs to assign to the instance group.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ComputeInstanceGroupState.__new__(_ComputeInstanceGroupState)

        __props__.__dict__["allocation_policy"] = allocation_policy
        __props__.__dict__["application_load_balancer"] = application_load_balancer
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["deletion_protection"] = deletion_protection
        __props__.__dict__["deploy_policy"] = deploy_policy
        __props__.__dict__["description"] = description
        __props__.__dict__["folder_id"] = folder_id
        __props__.__dict__["health_checks"] = health_checks
        __props__.__dict__["instance_template"] = instance_template
        __props__.__dict__["instances"] = instances
        __props__.__dict__["labels"] = labels
        __props__.__dict__["load_balancer"] = load_balancer
        __props__.__dict__["max_checking_health_duration"] = max_checking_health_duration
        __props__.__dict__["name"] = name
        __props__.__dict__["scale_policy"] = scale_policy
        __props__.__dict__["service_account_id"] = service_account_id
        __props__.__dict__["status"] = status
        __props__.__dict__["variables"] = variables
        return ComputeInstanceGroup(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="allocationPolicy")
    def allocation_policy(self) -> pulumi.Output['outputs.ComputeInstanceGroupAllocationPolicy']:
        """
        The allocation policy of the instance group by zone and region.
        """
        return pulumi.get(self, "allocation_policy")

    @_builtins.property
    @pulumi.getter(name="applicationLoadBalancer")
    def application_load_balancer(self) -> pulumi.Output[Optional['outputs.ComputeInstanceGroupApplicationLoadBalancer']]:
        """
        Application Load balancing (L7) specifications.
        """
        return pulumi.get(self, "application_load_balancer")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        The `true` value means that resource is protected from accidental deletion.
        """
        return pulumi.get(self, "deletion_protection")

    @_builtins.property
    @pulumi.getter(name="deployPolicy")
    def deploy_policy(self) -> pulumi.Output['outputs.ComputeInstanceGroupDeployPolicy']:
        """
        The deployment policy of the instance group.
        """
        return pulumi.get(self, "deploy_policy")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> pulumi.Output[_builtins.str]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @_builtins.property
    @pulumi.getter(name="healthChecks")
    def health_checks(self) -> pulumi.Output[Optional[Sequence['outputs.ComputeInstanceGroupHealthCheck']]]:
        """
        Health check specifications.
        """
        return pulumi.get(self, "health_checks")

    @_builtins.property
    @pulumi.getter(name="instanceTemplate")
    def instance_template(self) -> pulumi.Output['outputs.ComputeInstanceGroupInstanceTemplate']:
        """
        The template for creating new instances.
        """
        return pulumi.get(self, "instance_template")

    @_builtins.property
    @pulumi.getter
    def instances(self) -> pulumi.Output[Sequence['outputs.ComputeInstanceGroupInstance']]:
        """
        Instances block.
        """
        return pulumi.get(self, "instances")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="loadBalancer")
    def load_balancer(self) -> pulumi.Output[Optional['outputs.ComputeInstanceGroupLoadBalancer']]:
        """
        Load balancing specifications.
        """
        return pulumi.get(self, "load_balancer")

    @_builtins.property
    @pulumi.getter(name="maxCheckingHealthDuration")
    def max_checking_health_duration(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Timeout for waiting for the VM to become healthy. If the timeout is exceeded, the VM will be turned off based on the deployment policy. Specified in seconds.
        """
        return pulumi.get(self, "max_checking_health_duration")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="scalePolicy")
    def scale_policy(self) -> pulumi.Output['outputs.ComputeInstanceGroupScalePolicy']:
        """
        The scaling policy of the instance group.

        > Either `fixed_scale` or `auto_scale` must be specified.
        """
        return pulumi.get(self, "scale_policy")

    @_builtins.property
    @pulumi.getter(name="serviceAccountId")
    def service_account_id(self) -> pulumi.Output[_builtins.str]:
        """
        [Service account](https://yandex.cloud/docs/iam/concepts/users/service-accounts) which linked to the resource.
        """
        return pulumi.get(self, "service_account_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the instance.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def variables(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A set of key/value variables pairs to assign to the instance group.
        """
        return pulumi.get(self, "variables")

