# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ComputeSnapshotArgs', 'ComputeSnapshot']

@pulumi.input_type
class ComputeSnapshotArgs:
    def __init__(__self__, *,
                 source_disk_id: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 hardware_generation: Optional[pulumi.Input['ComputeSnapshotHardwareGenerationArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ComputeSnapshot resource.
        :param pulumi.Input[_builtins.str] source_disk_id: ID of the disk to create a snapshot from.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input['ComputeSnapshotHardwareGenerationArgs'] hardware_generation: Hardware generation and its features, which will be applied to the instance when this snapshot is used as a boot disk source. Provide this property if you wish to override this value, which otherwise is inherited from the source.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[_builtins.str] name: The resource name.
        """
        pulumi.set(__self__, "source_disk_id", source_disk_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if hardware_generation is not None:
            pulumi.set(__self__, "hardware_generation", hardware_generation)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="sourceDiskId")
    def source_disk_id(self) -> pulumi.Input[_builtins.str]:
        """
        ID of the disk to create a snapshot from.
        """
        return pulumi.get(self, "source_disk_id")

    @source_disk_id.setter
    def source_disk_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "source_disk_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder_id", value)

    @_builtins.property
    @pulumi.getter(name="hardwareGeneration")
    def hardware_generation(self) -> Optional[pulumi.Input['ComputeSnapshotHardwareGenerationArgs']]:
        """
        Hardware generation and its features, which will be applied to the instance when this snapshot is used as a boot disk source. Provide this property if you wish to override this value, which otherwise is inherited from the source.
        """
        return pulumi.get(self, "hardware_generation")

    @hardware_generation.setter
    def hardware_generation(self, value: Optional[pulumi.Input['ComputeSnapshotHardwareGenerationArgs']]):
        pulumi.set(self, "hardware_generation", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _ComputeSnapshotState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_size: Optional[pulumi.Input[_builtins.int]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 hardware_generation: Optional[pulumi.Input['ComputeSnapshotHardwareGenerationArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 source_disk_id: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_size: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering ComputeSnapshot resources.
        :param pulumi.Input[_builtins.str] created_at: The creation timestamp of the resource.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.int] disk_size: Size of the disk when the snapshot was created, specified in GB.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input['ComputeSnapshotHardwareGenerationArgs'] hardware_generation: Hardware generation and its features, which will be applied to the instance when this snapshot is used as a boot disk source. Provide this property if you wish to override this value, which otherwise is inherited from the source.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[_builtins.str] source_disk_id: ID of the disk to create a snapshot from.
        :param pulumi.Input[_builtins.int] storage_size: Size of the snapshot, specified in GB.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disk_size is not None:
            pulumi.set(__self__, "disk_size", disk_size)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if hardware_generation is not None:
            pulumi.set(__self__, "hardware_generation", hardware_generation)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if source_disk_id is not None:
            pulumi.set(__self__, "source_disk_id", source_disk_id)
        if storage_size is not None:
            pulumi.set(__self__, "storage_size", storage_size)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="diskSize")
    def disk_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Size of the disk when the snapshot was created, specified in GB.
        """
        return pulumi.get(self, "disk_size")

    @disk_size.setter
    def disk_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "disk_size", value)

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder_id", value)

    @_builtins.property
    @pulumi.getter(name="hardwareGeneration")
    def hardware_generation(self) -> Optional[pulumi.Input['ComputeSnapshotHardwareGenerationArgs']]:
        """
        Hardware generation and its features, which will be applied to the instance when this snapshot is used as a boot disk source. Provide this property if you wish to override this value, which otherwise is inherited from the source.
        """
        return pulumi.get(self, "hardware_generation")

    @hardware_generation.setter
    def hardware_generation(self, value: Optional[pulumi.Input['ComputeSnapshotHardwareGenerationArgs']]):
        pulumi.set(self, "hardware_generation", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="sourceDiskId")
    def source_disk_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the disk to create a snapshot from.
        """
        return pulumi.get(self, "source_disk_id")

    @source_disk_id.setter
    def source_disk_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_disk_id", value)

    @_builtins.property
    @pulumi.getter(name="storageSize")
    def storage_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Size of the snapshot, specified in GB.
        """
        return pulumi.get(self, "storage_size")

    @storage_size.setter
    def storage_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "storage_size", value)


@pulumi.type_token("yandex:index/computeSnapshot:ComputeSnapshot")
class ComputeSnapshot(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 hardware_generation: Optional[pulumi.Input[Union['ComputeSnapshotHardwareGenerationArgs', 'ComputeSnapshotHardwareGenerationArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 source_disk_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Creates a new snapshot of a disk. For more information, see [the official documentation](https://yandex.cloud/docs/compute/concepts/snapshot).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new Compute Snapshot.
        #
        default = yandex.ComputeSnapshot("default",
            name="test-snapshot",
            source_disk_id="test_disk_id",
            labels={
                "my-label": "my-label-value",
            })
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        bash

        ```sh
        $ pulumi import yandex:index/computeSnapshot:ComputeSnapshot <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/computeSnapshot:ComputeSnapshot my_snapshot fd8hc**********o4qe2
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Union['ComputeSnapshotHardwareGenerationArgs', 'ComputeSnapshotHardwareGenerationArgsDict']] hardware_generation: Hardware generation and its features, which will be applied to the instance when this snapshot is used as a boot disk source. Provide this property if you wish to override this value, which otherwise is inherited from the source.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[_builtins.str] source_disk_id: ID of the disk to create a snapshot from.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ComputeSnapshotArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a new snapshot of a disk. For more information, see [the official documentation](https://yandex.cloud/docs/compute/concepts/snapshot).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new Compute Snapshot.
        #
        default = yandex.ComputeSnapshot("default",
            name="test-snapshot",
            source_disk_id="test_disk_id",
            labels={
                "my-label": "my-label-value",
            })
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        bash

        ```sh
        $ pulumi import yandex:index/computeSnapshot:ComputeSnapshot <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/computeSnapshot:ComputeSnapshot my_snapshot fd8hc**********o4qe2
        ```

        :param str resource_name: The name of the resource.
        :param ComputeSnapshotArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ComputeSnapshotArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 hardware_generation: Optional[pulumi.Input[Union['ComputeSnapshotHardwareGenerationArgs', 'ComputeSnapshotHardwareGenerationArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 source_disk_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ComputeSnapshotArgs.__new__(ComputeSnapshotArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["folder_id"] = folder_id
            __props__.__dict__["hardware_generation"] = hardware_generation
            __props__.__dict__["labels"] = labels
            __props__.__dict__["name"] = name
            if source_disk_id is None and not opts.urn:
                raise TypeError("Missing required property 'source_disk_id'")
            __props__.__dict__["source_disk_id"] = source_disk_id
            __props__.__dict__["created_at"] = None
            __props__.__dict__["disk_size"] = None
            __props__.__dict__["storage_size"] = None
        super(ComputeSnapshot, __self__).__init__(
            'yandex:index/computeSnapshot:ComputeSnapshot',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            disk_size: Optional[pulumi.Input[_builtins.int]] = None,
            folder_id: Optional[pulumi.Input[_builtins.str]] = None,
            hardware_generation: Optional[pulumi.Input[Union['ComputeSnapshotHardwareGenerationArgs', 'ComputeSnapshotHardwareGenerationArgsDict']]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            source_disk_id: Optional[pulumi.Input[_builtins.str]] = None,
            storage_size: Optional[pulumi.Input[_builtins.int]] = None) -> 'ComputeSnapshot':
        """
        Get an existing ComputeSnapshot resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] created_at: The creation timestamp of the resource.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.int] disk_size: Size of the disk when the snapshot was created, specified in GB.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Union['ComputeSnapshotHardwareGenerationArgs', 'ComputeSnapshotHardwareGenerationArgsDict']] hardware_generation: Hardware generation and its features, which will be applied to the instance when this snapshot is used as a boot disk source. Provide this property if you wish to override this value, which otherwise is inherited from the source.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[_builtins.str] source_disk_id: ID of the disk to create a snapshot from.
        :param pulumi.Input[_builtins.int] storage_size: Size of the snapshot, specified in GB.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ComputeSnapshotState.__new__(_ComputeSnapshotState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["disk_size"] = disk_size
        __props__.__dict__["folder_id"] = folder_id
        __props__.__dict__["hardware_generation"] = hardware_generation
        __props__.__dict__["labels"] = labels
        __props__.__dict__["name"] = name
        __props__.__dict__["source_disk_id"] = source_disk_id
        __props__.__dict__["storage_size"] = storage_size
        return ComputeSnapshot(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="diskSize")
    def disk_size(self) -> pulumi.Output[_builtins.int]:
        """
        Size of the disk when the snapshot was created, specified in GB.
        """
        return pulumi.get(self, "disk_size")

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> pulumi.Output[_builtins.str]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @_builtins.property
    @pulumi.getter(name="hardwareGeneration")
    def hardware_generation(self) -> pulumi.Output['outputs.ComputeSnapshotHardwareGeneration']:
        """
        Hardware generation and its features, which will be applied to the instance when this snapshot is used as a boot disk source. Provide this property if you wish to override this value, which otherwise is inherited from the source.
        """
        return pulumi.get(self, "hardware_generation")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="sourceDiskId")
    def source_disk_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the disk to create a snapshot from.
        """
        return pulumi.get(self, "source_disk_id")

    @_builtins.property
    @pulumi.getter(name="storageSize")
    def storage_size(self) -> pulumi.Output[_builtins.int]:
        """
        Size of the snapshot, specified in GB.
        """
        return pulumi.get(self, "storage_size")

