# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ContainerRepositoryArgs', 'ContainerRepository']

@pulumi.input_type
class ContainerRepositoryArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ContainerRepository resource.
        :param pulumi.Input[_builtins.str] name: A name of the repository. The name of the repository should start with id of a container registry and match the name of the images that will be pushed in the repository.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A name of the repository. The name of the repository should start with id of a container registry and match the name of the images that will be pushed in the repository.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _ContainerRepositoryState:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ContainerRepository resources.
        :param pulumi.Input[_builtins.str] name: A name of the repository. The name of the repository should start with id of a container registry and match the name of the images that will be pushed in the repository.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A name of the repository. The name of the repository should start with id of a container registry and match the name of the images that will be pushed in the repository.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.type_token("yandex:index/containerRepository:ContainerRepository")
class ContainerRepository(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Creates a new container repository. For more information, see [the official documentation](https://yandex.cloud/docs/container-registry/concepts/repository).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new Container Registry and new Repository with it.
        #
        my_registry = yandex.ContainerRegistry("my-registry", name="test-registry")
        my_repository = yandex.ContainerRepository("my-repository", name=my_registry.id.apply(lambda id: f"{id}/test-repository"))
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        bash

        ```sh
        $ pulumi import yandex:index/containerRepository:ContainerRepository <resource Name> <repository_id>
        ```

        ```sh
        $ pulumi import yandex:index/containerRepository:ContainerRepository my-repository crps9**********k9psn
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: A name of the repository. The name of the repository should start with id of a container registry and match the name of the images that will be pushed in the repository.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ContainerRepositoryArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a new container repository. For more information, see [the official documentation](https://yandex.cloud/docs/container-registry/concepts/repository).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new Container Registry and new Repository with it.
        #
        my_registry = yandex.ContainerRegistry("my-registry", name="test-registry")
        my_repository = yandex.ContainerRepository("my-repository", name=my_registry.id.apply(lambda id: f"{id}/test-repository"))
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        bash

        ```sh
        $ pulumi import yandex:index/containerRepository:ContainerRepository <resource Name> <repository_id>
        ```

        ```sh
        $ pulumi import yandex:index/containerRepository:ContainerRepository my-repository crps9**********k9psn
        ```

        :param str resource_name: The name of the resource.
        :param ContainerRepositoryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ContainerRepositoryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ContainerRepositoryArgs.__new__(ContainerRepositoryArgs)

            __props__.__dict__["name"] = name
        super(ContainerRepository, __self__).__init__(
            'yandex:index/containerRepository:ContainerRepository',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None) -> 'ContainerRepository':
        """
        Get an existing ContainerRepository resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: A name of the repository. The name of the repository should start with id of a container registry and match the name of the images that will be pushed in the repository.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ContainerRepositoryState.__new__(_ContainerRepositoryState)

        __props__.__dict__["name"] = name
        return ContainerRepository(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        A name of the repository. The name of the repository should start with id of a container registry and match the name of the images that will be pushed in the repository.
        """
        return pulumi.get(self, "name")

