# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ContainerRepositoryLifecyclePolicyArgs', 'ContainerRepositoryLifecyclePolicy']

@pulumi.input_type
class ContainerRepositoryLifecyclePolicyArgs:
    def __init__(__self__, *,
                 repository_id: pulumi.Input[_builtins.str],
                 status: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerRepositoryLifecyclePolicyRuleArgs']]]] = None):
        """
        The set of arguments for constructing a ContainerRepositoryLifecyclePolicy resource.
        :param pulumi.Input[_builtins.str] repository_id: The ID of the repository that the resource belongs to.
        :param pulumi.Input[_builtins.str] status: The status of lifecycle policy. Must be `active` or `disabled`.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerRepositoryLifecyclePolicyRuleArgs']]] rules: Repository rules.
        """
        pulumi.set(__self__, "repository_id", repository_id)
        pulumi.set(__self__, "status", status)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @_builtins.property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the repository that the resource belongs to.
        """
        return pulumi.get(self, "repository_id")

    @repository_id.setter
    def repository_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "repository_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Input[_builtins.str]:
        """
        The status of lifecycle policy. Must be `active` or `disabled`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerRepositoryLifecyclePolicyRuleArgs']]]]:
        """
        Repository rules.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerRepositoryLifecyclePolicyRuleArgs']]]]):
        pulumi.set(self, "rules", value)


@pulumi.input_type
class _ContainerRepositoryLifecyclePolicyState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 repository_id: Optional[pulumi.Input[_builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerRepositoryLifecyclePolicyRuleArgs']]]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ContainerRepositoryLifecyclePolicy resources.
        :param pulumi.Input[_builtins.str] created_at: The creation timestamp of the resource.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[_builtins.str] repository_id: The ID of the repository that the resource belongs to.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerRepositoryLifecyclePolicyRuleArgs']]] rules: Repository rules.
        :param pulumi.Input[_builtins.str] status: The status of lifecycle policy. Must be `active` or `disabled`.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if repository_id is not None:
            pulumi.set(__self__, "repository_id", repository_id)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the repository that the resource belongs to.
        """
        return pulumi.get(self, "repository_id")

    @repository_id.setter
    def repository_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repository_id", value)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerRepositoryLifecyclePolicyRuleArgs']]]]:
        """
        Repository rules.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerRepositoryLifecyclePolicyRuleArgs']]]]):
        pulumi.set(self, "rules", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of lifecycle policy. Must be `active` or `disabled`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("yandex:index/containerRepositoryLifecyclePolicy:ContainerRepositoryLifecyclePolicy")
class ContainerRepositoryLifecyclePolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 repository_id: Optional[pulumi.Input[_builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContainerRepositoryLifecyclePolicyRuleArgs', 'ContainerRepositoryLifecyclePolicyRuleArgsDict']]]]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Creates a new container repository lifecycle policy. For more information, see [the official documentation](https://yandex.cloud/docs/container-registry/concepts/lifecycle-policy).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create new Container Repository and Container Repository Lifecycle Policy for it.
        #
        my_registry = yandex.ContainerRegistry("my_registry", name="test-registry")
        my_repository = yandex.ContainerRepository("my_repository", name=my_registry.id.apply(lambda id: f"{id}/test-repository"))
        my_lifecycle_policy = yandex.ContainerRepositoryLifecyclePolicy("my_lifecycle_policy",
            name="test-lifecycle-policy-name",
            status="active",
            repository_id=my_repository.id,
            rules=[{
                "description": "my description",
                "untagged": True,
                "tag_regexp": ".*",
                "retained_top": 1,
            }])
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        bash

        ```sh
        $ pulumi import yandex:index/containerRepositoryLifecyclePolicy:ContainerRepositoryLifecyclePolicy <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/containerRepositoryLifecyclePolicy:ContainerRepositoryLifecyclePolicy my_lifecycle_policy ...
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[_builtins.str] repository_id: The ID of the repository that the resource belongs to.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ContainerRepositoryLifecyclePolicyRuleArgs', 'ContainerRepositoryLifecyclePolicyRuleArgsDict']]]] rules: Repository rules.
        :param pulumi.Input[_builtins.str] status: The status of lifecycle policy. Must be `active` or `disabled`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ContainerRepositoryLifecyclePolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a new container repository lifecycle policy. For more information, see [the official documentation](https://yandex.cloud/docs/container-registry/concepts/lifecycle-policy).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create new Container Repository and Container Repository Lifecycle Policy for it.
        #
        my_registry = yandex.ContainerRegistry("my_registry", name="test-registry")
        my_repository = yandex.ContainerRepository("my_repository", name=my_registry.id.apply(lambda id: f"{id}/test-repository"))
        my_lifecycle_policy = yandex.ContainerRepositoryLifecyclePolicy("my_lifecycle_policy",
            name="test-lifecycle-policy-name",
            status="active",
            repository_id=my_repository.id,
            rules=[{
                "description": "my description",
                "untagged": True,
                "tag_regexp": ".*",
                "retained_top": 1,
            }])
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        bash

        ```sh
        $ pulumi import yandex:index/containerRepositoryLifecyclePolicy:ContainerRepositoryLifecyclePolicy <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/containerRepositoryLifecyclePolicy:ContainerRepositoryLifecyclePolicy my_lifecycle_policy ...
        ```

        :param str resource_name: The name of the resource.
        :param ContainerRepositoryLifecyclePolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ContainerRepositoryLifecyclePolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 repository_id: Optional[pulumi.Input[_builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContainerRepositoryLifecyclePolicyRuleArgs', 'ContainerRepositoryLifecyclePolicyRuleArgsDict']]]]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ContainerRepositoryLifecyclePolicyArgs.__new__(ContainerRepositoryLifecyclePolicyArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            if repository_id is None and not opts.urn:
                raise TypeError("Missing required property 'repository_id'")
            __props__.__dict__["repository_id"] = repository_id
            __props__.__dict__["rules"] = rules
            if status is None and not opts.urn:
                raise TypeError("Missing required property 'status'")
            __props__.__dict__["status"] = status
            __props__.__dict__["created_at"] = None
        super(ContainerRepositoryLifecyclePolicy, __self__).__init__(
            'yandex:index/containerRepositoryLifecyclePolicy:ContainerRepositoryLifecyclePolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            repository_id: Optional[pulumi.Input[_builtins.str]] = None,
            rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContainerRepositoryLifecyclePolicyRuleArgs', 'ContainerRepositoryLifecyclePolicyRuleArgsDict']]]]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'ContainerRepositoryLifecyclePolicy':
        """
        Get an existing ContainerRepositoryLifecyclePolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] created_at: The creation timestamp of the resource.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[_builtins.str] repository_id: The ID of the repository that the resource belongs to.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ContainerRepositoryLifecyclePolicyRuleArgs', 'ContainerRepositoryLifecyclePolicyRuleArgsDict']]]] rules: Repository rules.
        :param pulumi.Input[_builtins.str] status: The status of lifecycle policy. Must be `active` or `disabled`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ContainerRepositoryLifecyclePolicyState.__new__(_ContainerRepositoryLifecyclePolicyState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["repository_id"] = repository_id
        __props__.__dict__["rules"] = rules
        __props__.__dict__["status"] = status
        return ContainerRepositoryLifecyclePolicy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the repository that the resource belongs to.
        """
        return pulumi.get(self, "repository_id")

    @_builtins.property
    @pulumi.getter
    def rules(self) -> pulumi.Output[Sequence['outputs.ContainerRepositoryLifecyclePolicyRule']]:
        """
        Repository rules.
        """
        return pulumi.get(self, "rules")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of lifecycle policy. Must be `active` or `disabled`.
        """
        return pulumi.get(self, "status")

