# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DataprocClusterArgs', 'DataprocCluster']

@pulumi.input_type
class DataprocClusterArgs:
    def __init__(__self__, *,
                 cluster_config: pulumi.Input['DataprocClusterClusterConfigArgs'],
                 service_account_id: pulumi.Input[_builtins.str],
                 autoscaling_service_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 environment: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 host_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 log_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ui_proxy: Optional[pulumi.Input[_builtins.bool]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a DataprocCluster resource.
        :param pulumi.Input['DataprocClusterClusterConfigArgs'] cluster_config: Configuration and resources for hosts that should be created with the cluster.
        :param pulumi.Input[_builtins.str] service_account_id: Service account to be used by the Yandex Data Processing agent to access resources of Yandex Cloud. Selected service account should have `mdb.dataproc.agent` role on the folder where the Yandex Data Processing cluster will be located.
        :param pulumi.Input[_builtins.str] autoscaling_service_account_id: Service account to be used for managing hosts in an autoscaled subcluster.
        :param pulumi.Input[_builtins.str] bucket: Name of the Object Storage bucket to use for Yandex Data Processing jobs. Yandex Data Processing Agent saves output of job driver's process to specified bucket. In order for this to work service account (specified by the `service_account_id` argument) should be given permission to create objects within this bucket.
        :param pulumi.Input[_builtins.bool] deletion_protection: The `true` value means that resource is protected from accidental deletion.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] environment: Deployment environment of the cluster. Can be either `PRESTABLE` or `PRODUCTION`. The default is `PRESTABLE`.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] host_group_ids: A list of host group IDs to place VMs of the cluster on.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[_builtins.str] log_group_id: ID of the cloud logging group for cluster logs.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: The list of security groups applied to resource or their components.
        :param pulumi.Input[_builtins.bool] ui_proxy: Whether to enable UI Proxy feature.
        :param pulumi.Input[_builtins.str] zone_id: The [availability zone](https://yandex.cloud/docs/overview/concepts/geo-scope) where resource is located. If it is not provided, the default provider zone will be used.
        """
        pulumi.set(__self__, "cluster_config", cluster_config)
        pulumi.set(__self__, "service_account_id", service_account_id)
        if autoscaling_service_account_id is not None:
            pulumi.set(__self__, "autoscaling_service_account_id", autoscaling_service_account_id)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if host_group_ids is not None:
            pulumi.set(__self__, "host_group_ids", host_group_ids)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if log_group_id is not None:
            pulumi.set(__self__, "log_group_id", log_group_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if ui_proxy is not None:
            pulumi.set(__self__, "ui_proxy", ui_proxy)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="clusterConfig")
    def cluster_config(self) -> pulumi.Input['DataprocClusterClusterConfigArgs']:
        """
        Configuration and resources for hosts that should be created with the cluster.
        """
        return pulumi.get(self, "cluster_config")

    @cluster_config.setter
    def cluster_config(self, value: pulumi.Input['DataprocClusterClusterConfigArgs']):
        pulumi.set(self, "cluster_config", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccountId")
    def service_account_id(self) -> pulumi.Input[_builtins.str]:
        """
        Service account to be used by the Yandex Data Processing agent to access resources of Yandex Cloud. Selected service account should have `mdb.dataproc.agent` role on the folder where the Yandex Data Processing cluster will be located.
        """
        return pulumi.get(self, "service_account_id")

    @service_account_id.setter
    def service_account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service_account_id", value)

    @_builtins.property
    @pulumi.getter(name="autoscalingServiceAccountId")
    def autoscaling_service_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Service account to be used for managing hosts in an autoscaled subcluster.
        """
        return pulumi.get(self, "autoscaling_service_account_id")

    @autoscaling_service_account_id.setter
    def autoscaling_service_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "autoscaling_service_account_id", value)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the Object Storage bucket to use for Yandex Data Processing jobs. Yandex Data Processing Agent saves output of job driver's process to specified bucket. In order for this to work service account (specified by the `service_account_id` argument) should be given permission to create objects within this bucket.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bucket", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The `true` value means that resource is protected from accidental deletion.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Deployment environment of the cluster. Can be either `PRESTABLE` or `PRODUCTION`. The default is `PRESTABLE`.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "environment", value)

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder_id", value)

    @_builtins.property
    @pulumi.getter(name="hostGroupIds")
    def host_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of host group IDs to place VMs of the cluster on.
        """
        return pulumi.get(self, "host_group_ids")

    @host_group_ids.setter
    def host_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "host_group_ids", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="logGroupId")
    def log_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the cloud logging group for cluster logs.
        """
        return pulumi.get(self, "log_group_id")

    @log_group_id.setter
    def log_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_group_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of security groups applied to resource or their components.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @_builtins.property
    @pulumi.getter(name="uiProxy")
    def ui_proxy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable UI Proxy feature.
        """
        return pulumi.get(self, "ui_proxy")

    @ui_proxy.setter
    def ui_proxy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ui_proxy", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [availability zone](https://yandex.cloud/docs/overview/concepts/geo-scope) where resource is located. If it is not provided, the default provider zone will be used.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.input_type
class _DataprocClusterState:
    def __init__(__self__, *,
                 autoscaling_service_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_config: Optional[pulumi.Input['DataprocClusterClusterConfigArgs']] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 environment: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 host_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 log_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 service_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ui_proxy: Optional[pulumi.Input[_builtins.bool]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DataprocCluster resources.
        :param pulumi.Input[_builtins.str] autoscaling_service_account_id: Service account to be used for managing hosts in an autoscaled subcluster.
        :param pulumi.Input[_builtins.str] bucket: Name of the Object Storage bucket to use for Yandex Data Processing jobs. Yandex Data Processing Agent saves output of job driver's process to specified bucket. In order for this to work service account (specified by the `service_account_id` argument) should be given permission to create objects within this bucket.
        :param pulumi.Input['DataprocClusterClusterConfigArgs'] cluster_config: Configuration and resources for hosts that should be created with the cluster.
        :param pulumi.Input[_builtins.str] created_at: The creation timestamp of the resource.
        :param pulumi.Input[_builtins.bool] deletion_protection: The `true` value means that resource is protected from accidental deletion.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] environment: Deployment environment of the cluster. Can be either `PRESTABLE` or `PRODUCTION`. The default is `PRESTABLE`.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] host_group_ids: A list of host group IDs to place VMs of the cluster on.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[_builtins.str] log_group_id: ID of the cloud logging group for cluster logs.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: The list of security groups applied to resource or their components.
        :param pulumi.Input[_builtins.str] service_account_id: Service account to be used by the Yandex Data Processing agent to access resources of Yandex Cloud. Selected service account should have `mdb.dataproc.agent` role on the folder where the Yandex Data Processing cluster will be located.
        :param pulumi.Input[_builtins.bool] ui_proxy: Whether to enable UI Proxy feature.
        :param pulumi.Input[_builtins.str] zone_id: The [availability zone](https://yandex.cloud/docs/overview/concepts/geo-scope) where resource is located. If it is not provided, the default provider zone will be used.
        """
        if autoscaling_service_account_id is not None:
            pulumi.set(__self__, "autoscaling_service_account_id", autoscaling_service_account_id)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if cluster_config is not None:
            pulumi.set(__self__, "cluster_config", cluster_config)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if host_group_ids is not None:
            pulumi.set(__self__, "host_group_ids", host_group_ids)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if log_group_id is not None:
            pulumi.set(__self__, "log_group_id", log_group_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if service_account_id is not None:
            pulumi.set(__self__, "service_account_id", service_account_id)
        if ui_proxy is not None:
            pulumi.set(__self__, "ui_proxy", ui_proxy)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="autoscalingServiceAccountId")
    def autoscaling_service_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Service account to be used for managing hosts in an autoscaled subcluster.
        """
        return pulumi.get(self, "autoscaling_service_account_id")

    @autoscaling_service_account_id.setter
    def autoscaling_service_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "autoscaling_service_account_id", value)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the Object Storage bucket to use for Yandex Data Processing jobs. Yandex Data Processing Agent saves output of job driver's process to specified bucket. In order for this to work service account (specified by the `service_account_id` argument) should be given permission to create objects within this bucket.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bucket", value)

    @_builtins.property
    @pulumi.getter(name="clusterConfig")
    def cluster_config(self) -> Optional[pulumi.Input['DataprocClusterClusterConfigArgs']]:
        """
        Configuration and resources for hosts that should be created with the cluster.
        """
        return pulumi.get(self, "cluster_config")

    @cluster_config.setter
    def cluster_config(self, value: Optional[pulumi.Input['DataprocClusterClusterConfigArgs']]):
        pulumi.set(self, "cluster_config", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The `true` value means that resource is protected from accidental deletion.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Deployment environment of the cluster. Can be either `PRESTABLE` or `PRODUCTION`. The default is `PRESTABLE`.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "environment", value)

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder_id", value)

    @_builtins.property
    @pulumi.getter(name="hostGroupIds")
    def host_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of host group IDs to place VMs of the cluster on.
        """
        return pulumi.get(self, "host_group_ids")

    @host_group_ids.setter
    def host_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "host_group_ids", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="logGroupId")
    def log_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the cloud logging group for cluster logs.
        """
        return pulumi.get(self, "log_group_id")

    @log_group_id.setter
    def log_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_group_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of security groups applied to resource or their components.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccountId")
    def service_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Service account to be used by the Yandex Data Processing agent to access resources of Yandex Cloud. Selected service account should have `mdb.dataproc.agent` role on the folder where the Yandex Data Processing cluster will be located.
        """
        return pulumi.get(self, "service_account_id")

    @service_account_id.setter
    def service_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_account_id", value)

    @_builtins.property
    @pulumi.getter(name="uiProxy")
    def ui_proxy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable UI Proxy feature.
        """
        return pulumi.get(self, "ui_proxy")

    @ui_proxy.setter
    def ui_proxy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ui_proxy", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [availability zone](https://yandex.cloud/docs/overview/concepts/geo-scope) where resource is located. If it is not provided, the default provider zone will be used.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.type_token("yandex:index/dataprocCluster:DataprocCluster")
class DataprocCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 autoscaling_service_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_config: Optional[pulumi.Input[Union['DataprocClusterClusterConfigArgs', 'DataprocClusterClusterConfigArgsDict']]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 environment: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 host_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 log_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 service_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ui_proxy: Optional[pulumi.Input[_builtins.bool]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Yandex Data Processing cluster. For more information, see [the official documentation](https://yandex.cloud/docs/data-proc/).

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        bash

        ```sh
        $ pulumi import yandex:index/dataprocCluster:DataprocCluster <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/dataprocCluster:DataprocCluster foo c9q85**********gpn21
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] autoscaling_service_account_id: Service account to be used for managing hosts in an autoscaled subcluster.
        :param pulumi.Input[_builtins.str] bucket: Name of the Object Storage bucket to use for Yandex Data Processing jobs. Yandex Data Processing Agent saves output of job driver's process to specified bucket. In order for this to work service account (specified by the `service_account_id` argument) should be given permission to create objects within this bucket.
        :param pulumi.Input[Union['DataprocClusterClusterConfigArgs', 'DataprocClusterClusterConfigArgsDict']] cluster_config: Configuration and resources for hosts that should be created with the cluster.
        :param pulumi.Input[_builtins.bool] deletion_protection: The `true` value means that resource is protected from accidental deletion.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] environment: Deployment environment of the cluster. Can be either `PRESTABLE` or `PRODUCTION`. The default is `PRESTABLE`.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] host_group_ids: A list of host group IDs to place VMs of the cluster on.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[_builtins.str] log_group_id: ID of the cloud logging group for cluster logs.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: The list of security groups applied to resource or their components.
        :param pulumi.Input[_builtins.str] service_account_id: Service account to be used by the Yandex Data Processing agent to access resources of Yandex Cloud. Selected service account should have `mdb.dataproc.agent` role on the folder where the Yandex Data Processing cluster will be located.
        :param pulumi.Input[_builtins.bool] ui_proxy: Whether to enable UI Proxy feature.
        :param pulumi.Input[_builtins.str] zone_id: The [availability zone](https://yandex.cloud/docs/overview/concepts/geo-scope) where resource is located. If it is not provided, the default provider zone will be used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DataprocClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Yandex Data Processing cluster. For more information, see [the official documentation](https://yandex.cloud/docs/data-proc/).

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        bash

        ```sh
        $ pulumi import yandex:index/dataprocCluster:DataprocCluster <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/dataprocCluster:DataprocCluster foo c9q85**********gpn21
        ```

        :param str resource_name: The name of the resource.
        :param DataprocClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DataprocClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 autoscaling_service_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_config: Optional[pulumi.Input[Union['DataprocClusterClusterConfigArgs', 'DataprocClusterClusterConfigArgsDict']]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 environment: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 host_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 log_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 service_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ui_proxy: Optional[pulumi.Input[_builtins.bool]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DataprocClusterArgs.__new__(DataprocClusterArgs)

            __props__.__dict__["autoscaling_service_account_id"] = autoscaling_service_account_id
            __props__.__dict__["bucket"] = bucket
            if cluster_config is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_config'")
            __props__.__dict__["cluster_config"] = cluster_config
            __props__.__dict__["deletion_protection"] = deletion_protection
            __props__.__dict__["description"] = description
            __props__.__dict__["environment"] = environment
            __props__.__dict__["folder_id"] = folder_id
            __props__.__dict__["host_group_ids"] = host_group_ids
            __props__.__dict__["labels"] = labels
            __props__.__dict__["log_group_id"] = log_group_id
            __props__.__dict__["name"] = name
            __props__.__dict__["security_group_ids"] = security_group_ids
            if service_account_id is None and not opts.urn:
                raise TypeError("Missing required property 'service_account_id'")
            __props__.__dict__["service_account_id"] = service_account_id
            __props__.__dict__["ui_proxy"] = ui_proxy
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["created_at"] = None
        super(DataprocCluster, __self__).__init__(
            'yandex:index/dataprocCluster:DataprocCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            autoscaling_service_account_id: Optional[pulumi.Input[_builtins.str]] = None,
            bucket: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_config: Optional[pulumi.Input[Union['DataprocClusterClusterConfigArgs', 'DataprocClusterClusterConfigArgsDict']]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            environment: Optional[pulumi.Input[_builtins.str]] = None,
            folder_id: Optional[pulumi.Input[_builtins.str]] = None,
            host_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            log_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            service_account_id: Optional[pulumi.Input[_builtins.str]] = None,
            ui_proxy: Optional[pulumi.Input[_builtins.bool]] = None,
            zone_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'DataprocCluster':
        """
        Get an existing DataprocCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] autoscaling_service_account_id: Service account to be used for managing hosts in an autoscaled subcluster.
        :param pulumi.Input[_builtins.str] bucket: Name of the Object Storage bucket to use for Yandex Data Processing jobs. Yandex Data Processing Agent saves output of job driver's process to specified bucket. In order for this to work service account (specified by the `service_account_id` argument) should be given permission to create objects within this bucket.
        :param pulumi.Input[Union['DataprocClusterClusterConfigArgs', 'DataprocClusterClusterConfigArgsDict']] cluster_config: Configuration and resources for hosts that should be created with the cluster.
        :param pulumi.Input[_builtins.str] created_at: The creation timestamp of the resource.
        :param pulumi.Input[_builtins.bool] deletion_protection: The `true` value means that resource is protected from accidental deletion.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] environment: Deployment environment of the cluster. Can be either `PRESTABLE` or `PRODUCTION`. The default is `PRESTABLE`.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] host_group_ids: A list of host group IDs to place VMs of the cluster on.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[_builtins.str] log_group_id: ID of the cloud logging group for cluster logs.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: The list of security groups applied to resource or their components.
        :param pulumi.Input[_builtins.str] service_account_id: Service account to be used by the Yandex Data Processing agent to access resources of Yandex Cloud. Selected service account should have `mdb.dataproc.agent` role on the folder where the Yandex Data Processing cluster will be located.
        :param pulumi.Input[_builtins.bool] ui_proxy: Whether to enable UI Proxy feature.
        :param pulumi.Input[_builtins.str] zone_id: The [availability zone](https://yandex.cloud/docs/overview/concepts/geo-scope) where resource is located. If it is not provided, the default provider zone will be used.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DataprocClusterState.__new__(_DataprocClusterState)

        __props__.__dict__["autoscaling_service_account_id"] = autoscaling_service_account_id
        __props__.__dict__["bucket"] = bucket
        __props__.__dict__["cluster_config"] = cluster_config
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["deletion_protection"] = deletion_protection
        __props__.__dict__["description"] = description
        __props__.__dict__["environment"] = environment
        __props__.__dict__["folder_id"] = folder_id
        __props__.__dict__["host_group_ids"] = host_group_ids
        __props__.__dict__["labels"] = labels
        __props__.__dict__["log_group_id"] = log_group_id
        __props__.__dict__["name"] = name
        __props__.__dict__["security_group_ids"] = security_group_ids
        __props__.__dict__["service_account_id"] = service_account_id
        __props__.__dict__["ui_proxy"] = ui_proxy
        __props__.__dict__["zone_id"] = zone_id
        return DataprocCluster(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autoscalingServiceAccountId")
    def autoscaling_service_account_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Service account to be used for managing hosts in an autoscaled subcluster.
        """
        return pulumi.get(self, "autoscaling_service_account_id")

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Name of the Object Storage bucket to use for Yandex Data Processing jobs. Yandex Data Processing Agent saves output of job driver's process to specified bucket. In order for this to work service account (specified by the `service_account_id` argument) should be given permission to create objects within this bucket.
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter(name="clusterConfig")
    def cluster_config(self) -> pulumi.Output['outputs.DataprocClusterClusterConfig']:
        """
        Configuration and resources for hosts that should be created with the cluster.
        """
        return pulumi.get(self, "cluster_config")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[_builtins.bool]:
        """
        The `true` value means that resource is protected from accidental deletion.
        """
        return pulumi.get(self, "deletion_protection")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def environment(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Deployment environment of the cluster. Can be either `PRESTABLE` or `PRODUCTION`. The default is `PRESTABLE`.
        """
        return pulumi.get(self, "environment")

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> pulumi.Output[_builtins.str]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @_builtins.property
    @pulumi.getter(name="hostGroupIds")
    def host_group_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of host group IDs to place VMs of the cluster on.
        """
        return pulumi.get(self, "host_group_ids")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="logGroupId")
    def log_group_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        ID of the cloud logging group for cluster logs.
        """
        return pulumi.get(self, "log_group_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The list of security groups applied to resource or their components.
        """
        return pulumi.get(self, "security_group_ids")

    @_builtins.property
    @pulumi.getter(name="serviceAccountId")
    def service_account_id(self) -> pulumi.Output[_builtins.str]:
        """
        Service account to be used by the Yandex Data Processing agent to access resources of Yandex Cloud. Selected service account should have `mdb.dataproc.agent` role on the folder where the Yandex Data Processing cluster will be located.
        """
        return pulumi.get(self, "service_account_id")

    @_builtins.property
    @pulumi.getter(name="uiProxy")
    def ui_proxy(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to enable UI Proxy feature.
        """
        return pulumi.get(self, "ui_proxy")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [availability zone](https://yandex.cloud/docs/overview/concepts/geo-scope) where resource is located. If it is not provided, the default provider zone will be used.
        """
        return pulumi.get(self, "zone_id")

