# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DatatransferTransferArgs', 'DatatransferTransfer']

@pulumi.input_type
class DatatransferTransferArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 on_create_activate_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 runtime: Optional[pulumi.Input['DatatransferTransferRuntimeArgs']] = None,
                 source_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_id: Optional[pulumi.Input[_builtins.str]] = None,
                 transformation: Optional[pulumi.Input['DatatransferTransferTransformationArgs']] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a DatatransferTransfer resource.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[_builtins.str] on_create_activate_mode: Activation action on create a new incremental transfer. It is not part of the transfer parameter and is used only on create. One of `sync_activate`, `async_activate`, `dont_activate`. The default is `sync_activate`.
        :param pulumi.Input['DatatransferTransferRuntimeArgs'] runtime: Runtime parameters for the transfer.
        :param pulumi.Input[_builtins.str] source_id: ID of the source endpoint for the transfer.
        :param pulumi.Input[_builtins.str] target_id: ID of the target endpoint for the transfer.
        :param pulumi.Input['DatatransferTransferTransformationArgs'] transformation: Transformation for the transfer.
        :param pulumi.Input[_builtins.str] type: Type of the transfer. One of `SNAPSHOT_ONLY`, `INCREMENT_ONLY`, `SNAPSHOT_AND_INCREMENT`
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if on_create_activate_mode is not None:
            pulumi.set(__self__, "on_create_activate_mode", on_create_activate_mode)
        if runtime is not None:
            pulumi.set(__self__, "runtime", runtime)
        if source_id is not None:
            pulumi.set(__self__, "source_id", source_id)
        if target_id is not None:
            pulumi.set(__self__, "target_id", target_id)
        if transformation is not None:
            pulumi.set(__self__, "transformation", transformation)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder_id", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="onCreateActivateMode")
    def on_create_activate_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Activation action on create a new incremental transfer. It is not part of the transfer parameter and is used only on create. One of `sync_activate`, `async_activate`, `dont_activate`. The default is `sync_activate`.
        """
        return pulumi.get(self, "on_create_activate_mode")

    @on_create_activate_mode.setter
    def on_create_activate_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "on_create_activate_mode", value)

    @_builtins.property
    @pulumi.getter
    def runtime(self) -> Optional[pulumi.Input['DatatransferTransferRuntimeArgs']]:
        """
        Runtime parameters for the transfer.
        """
        return pulumi.get(self, "runtime")

    @runtime.setter
    def runtime(self, value: Optional[pulumi.Input['DatatransferTransferRuntimeArgs']]):
        pulumi.set(self, "runtime", value)

    @_builtins.property
    @pulumi.getter(name="sourceId")
    def source_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the source endpoint for the transfer.
        """
        return pulumi.get(self, "source_id")

    @source_id.setter
    def source_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_id", value)

    @_builtins.property
    @pulumi.getter(name="targetId")
    def target_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the target endpoint for the transfer.
        """
        return pulumi.get(self, "target_id")

    @target_id.setter
    def target_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_id", value)

    @_builtins.property
    @pulumi.getter
    def transformation(self) -> Optional[pulumi.Input['DatatransferTransferTransformationArgs']]:
        """
        Transformation for the transfer.
        """
        return pulumi.get(self, "transformation")

    @transformation.setter
    def transformation(self, value: Optional[pulumi.Input['DatatransferTransferTransformationArgs']]):
        pulumi.set(self, "transformation", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of the transfer. One of `SNAPSHOT_ONLY`, `INCREMENT_ONLY`, `SNAPSHOT_AND_INCREMENT`
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _DatatransferTransferState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 on_create_activate_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 runtime: Optional[pulumi.Input['DatatransferTransferRuntimeArgs']] = None,
                 source_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_id: Optional[pulumi.Input[_builtins.str]] = None,
                 transformation: Optional[pulumi.Input['DatatransferTransferTransformationArgs']] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 warning: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DatatransferTransfer resources.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[_builtins.str] on_create_activate_mode: Activation action on create a new incremental transfer. It is not part of the transfer parameter and is used only on create. One of `sync_activate`, `async_activate`, `dont_activate`. The default is `sync_activate`.
        :param pulumi.Input['DatatransferTransferRuntimeArgs'] runtime: Runtime parameters for the transfer.
        :param pulumi.Input[_builtins.str] source_id: ID of the source endpoint for the transfer.
        :param pulumi.Input[_builtins.str] target_id: ID of the target endpoint for the transfer.
        :param pulumi.Input['DatatransferTransferTransformationArgs'] transformation: Transformation for the transfer.
        :param pulumi.Input[_builtins.str] type: Type of the transfer. One of `SNAPSHOT_ONLY`, `INCREMENT_ONLY`, `SNAPSHOT_AND_INCREMENT`
        :param pulumi.Input[_builtins.str] warning: Error description if transfer has any errors.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if on_create_activate_mode is not None:
            pulumi.set(__self__, "on_create_activate_mode", on_create_activate_mode)
        if runtime is not None:
            pulumi.set(__self__, "runtime", runtime)
        if source_id is not None:
            pulumi.set(__self__, "source_id", source_id)
        if target_id is not None:
            pulumi.set(__self__, "target_id", target_id)
        if transformation is not None:
            pulumi.set(__self__, "transformation", transformation)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if warning is not None:
            pulumi.set(__self__, "warning", warning)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder_id", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="onCreateActivateMode")
    def on_create_activate_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Activation action on create a new incremental transfer. It is not part of the transfer parameter and is used only on create. One of `sync_activate`, `async_activate`, `dont_activate`. The default is `sync_activate`.
        """
        return pulumi.get(self, "on_create_activate_mode")

    @on_create_activate_mode.setter
    def on_create_activate_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "on_create_activate_mode", value)

    @_builtins.property
    @pulumi.getter
    def runtime(self) -> Optional[pulumi.Input['DatatransferTransferRuntimeArgs']]:
        """
        Runtime parameters for the transfer.
        """
        return pulumi.get(self, "runtime")

    @runtime.setter
    def runtime(self, value: Optional[pulumi.Input['DatatransferTransferRuntimeArgs']]):
        pulumi.set(self, "runtime", value)

    @_builtins.property
    @pulumi.getter(name="sourceId")
    def source_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the source endpoint for the transfer.
        """
        return pulumi.get(self, "source_id")

    @source_id.setter
    def source_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_id", value)

    @_builtins.property
    @pulumi.getter(name="targetId")
    def target_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the target endpoint for the transfer.
        """
        return pulumi.get(self, "target_id")

    @target_id.setter
    def target_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_id", value)

    @_builtins.property
    @pulumi.getter
    def transformation(self) -> Optional[pulumi.Input['DatatransferTransferTransformationArgs']]:
        """
        Transformation for the transfer.
        """
        return pulumi.get(self, "transformation")

    @transformation.setter
    def transformation(self, value: Optional[pulumi.Input['DatatransferTransferTransformationArgs']]):
        pulumi.set(self, "transformation", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of the transfer. One of `SNAPSHOT_ONLY`, `INCREMENT_ONLY`, `SNAPSHOT_AND_INCREMENT`
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def warning(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Error description if transfer has any errors.
        """
        return pulumi.get(self, "warning")

    @warning.setter
    def warning(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "warning", value)


@pulumi.type_token("yandex:index/datatransferTransfer:DatatransferTransfer")
class DatatransferTransfer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 on_create_activate_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 runtime: Optional[pulumi.Input[Union['DatatransferTransferRuntimeArgs', 'DatatransferTransferRuntimeArgsDict']]] = None,
                 source_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_id: Optional[pulumi.Input[_builtins.str]] = None,
                 transformation: Optional[pulumi.Input[Union['DatatransferTransferTransformationArgs', 'DatatransferTransferTransformationArgsDict']]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Data Transfer transfer. For more information, see [the official documentation](https://yandex.cloud/docs/data-transfer/).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new pair of Data Transfer Endpoints Source & Target and Data Transfer.
        #
        # Create Data Transfer Endpoint "Source"
        pg_source = yandex.DatatransferEndpoint("pg_source",
            name="pg-test-source",
            settings={
                "postgres_source": {
                    "connection": {
                        "on_premise": {
                            "hosts": ["example.org"],
                            "port": 5432,
                        },
                    },
                    "slot_gigabyte_lag_limit": 100,
                    "database": "db1",
                    "user": "user1",
                    "password": {
                        "raw": "123",
                    },
                },
            })
        # Create Data Transfer Endpoint "Target"
        pg_target = yandex.DatatransferEndpoint("pg_target",
            folder_id="some_folder_id",
            name="pg-test-target2",
            settings={
                "postgres_target": {
                    "connection": {
                        "mdb_cluster_id": "some_cluster_id",
                    },
                    "database": "db2",
                    "user": "user2",
                    "password": {
                        "raw": "321",
                    },
                },
            })
        # Create Data Transfer from "Source" to "Target"
        pgpg_transfer = yandex.DatatransferTransfer("pgpg_transfer",
            folder_id="some_folder_id",
            name="pgpg",
            source_id=pg_source.id,
            target_id=pg_target.id,
            type="SNAPSHOT_AND_INCREMENT",
            runtime={
                "yc_runtime": {
                    "job_count": 1,
                    "upload_shard_params": {
                        "job_count": 4,
                        "process_count": 1,
                    },
                },
            },
            transformation={
                "transformers": [
                    {},
                    {},
                ],
            })
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        bash

        ```sh
        $ pulumi import yandex:index/datatransferTransfer:DatatransferTransfer <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/datatransferTransfer:DatatransferTransfer my_dt_transfer dttnc**********r3bkg
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[_builtins.str] on_create_activate_mode: Activation action on create a new incremental transfer. It is not part of the transfer parameter and is used only on create. One of `sync_activate`, `async_activate`, `dont_activate`. The default is `sync_activate`.
        :param pulumi.Input[Union['DatatransferTransferRuntimeArgs', 'DatatransferTransferRuntimeArgsDict']] runtime: Runtime parameters for the transfer.
        :param pulumi.Input[_builtins.str] source_id: ID of the source endpoint for the transfer.
        :param pulumi.Input[_builtins.str] target_id: ID of the target endpoint for the transfer.
        :param pulumi.Input[Union['DatatransferTransferTransformationArgs', 'DatatransferTransferTransformationArgsDict']] transformation: Transformation for the transfer.
        :param pulumi.Input[_builtins.str] type: Type of the transfer. One of `SNAPSHOT_ONLY`, `INCREMENT_ONLY`, `SNAPSHOT_AND_INCREMENT`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[DatatransferTransferArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Data Transfer transfer. For more information, see [the official documentation](https://yandex.cloud/docs/data-transfer/).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new pair of Data Transfer Endpoints Source & Target and Data Transfer.
        #
        # Create Data Transfer Endpoint "Source"
        pg_source = yandex.DatatransferEndpoint("pg_source",
            name="pg-test-source",
            settings={
                "postgres_source": {
                    "connection": {
                        "on_premise": {
                            "hosts": ["example.org"],
                            "port": 5432,
                        },
                    },
                    "slot_gigabyte_lag_limit": 100,
                    "database": "db1",
                    "user": "user1",
                    "password": {
                        "raw": "123",
                    },
                },
            })
        # Create Data Transfer Endpoint "Target"
        pg_target = yandex.DatatransferEndpoint("pg_target",
            folder_id="some_folder_id",
            name="pg-test-target2",
            settings={
                "postgres_target": {
                    "connection": {
                        "mdb_cluster_id": "some_cluster_id",
                    },
                    "database": "db2",
                    "user": "user2",
                    "password": {
                        "raw": "321",
                    },
                },
            })
        # Create Data Transfer from "Source" to "Target"
        pgpg_transfer = yandex.DatatransferTransfer("pgpg_transfer",
            folder_id="some_folder_id",
            name="pgpg",
            source_id=pg_source.id,
            target_id=pg_target.id,
            type="SNAPSHOT_AND_INCREMENT",
            runtime={
                "yc_runtime": {
                    "job_count": 1,
                    "upload_shard_params": {
                        "job_count": 4,
                        "process_count": 1,
                    },
                },
            },
            transformation={
                "transformers": [
                    {},
                    {},
                ],
            })
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        bash

        ```sh
        $ pulumi import yandex:index/datatransferTransfer:DatatransferTransfer <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/datatransferTransfer:DatatransferTransfer my_dt_transfer dttnc**********r3bkg
        ```

        :param str resource_name: The name of the resource.
        :param DatatransferTransferArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DatatransferTransferArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 on_create_activate_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 runtime: Optional[pulumi.Input[Union['DatatransferTransferRuntimeArgs', 'DatatransferTransferRuntimeArgsDict']]] = None,
                 source_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_id: Optional[pulumi.Input[_builtins.str]] = None,
                 transformation: Optional[pulumi.Input[Union['DatatransferTransferTransformationArgs', 'DatatransferTransferTransformationArgsDict']]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DatatransferTransferArgs.__new__(DatatransferTransferArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["folder_id"] = folder_id
            __props__.__dict__["labels"] = labels
            __props__.__dict__["name"] = name
            __props__.__dict__["on_create_activate_mode"] = on_create_activate_mode
            __props__.__dict__["runtime"] = runtime
            __props__.__dict__["source_id"] = source_id
            __props__.__dict__["target_id"] = target_id
            __props__.__dict__["transformation"] = transformation
            __props__.__dict__["type"] = type
            __props__.__dict__["warning"] = None
        super(DatatransferTransfer, __self__).__init__(
            'yandex:index/datatransferTransfer:DatatransferTransfer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            folder_id: Optional[pulumi.Input[_builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            on_create_activate_mode: Optional[pulumi.Input[_builtins.str]] = None,
            runtime: Optional[pulumi.Input[Union['DatatransferTransferRuntimeArgs', 'DatatransferTransferRuntimeArgsDict']]] = None,
            source_id: Optional[pulumi.Input[_builtins.str]] = None,
            target_id: Optional[pulumi.Input[_builtins.str]] = None,
            transformation: Optional[pulumi.Input[Union['DatatransferTransferTransformationArgs', 'DatatransferTransferTransformationArgsDict']]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            warning: Optional[pulumi.Input[_builtins.str]] = None) -> 'DatatransferTransfer':
        """
        Get an existing DatatransferTransfer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[_builtins.str] on_create_activate_mode: Activation action on create a new incremental transfer. It is not part of the transfer parameter and is used only on create. One of `sync_activate`, `async_activate`, `dont_activate`. The default is `sync_activate`.
        :param pulumi.Input[Union['DatatransferTransferRuntimeArgs', 'DatatransferTransferRuntimeArgsDict']] runtime: Runtime parameters for the transfer.
        :param pulumi.Input[_builtins.str] source_id: ID of the source endpoint for the transfer.
        :param pulumi.Input[_builtins.str] target_id: ID of the target endpoint for the transfer.
        :param pulumi.Input[Union['DatatransferTransferTransformationArgs', 'DatatransferTransferTransformationArgsDict']] transformation: Transformation for the transfer.
        :param pulumi.Input[_builtins.str] type: Type of the transfer. One of `SNAPSHOT_ONLY`, `INCREMENT_ONLY`, `SNAPSHOT_AND_INCREMENT`
        :param pulumi.Input[_builtins.str] warning: Error description if transfer has any errors.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DatatransferTransferState.__new__(_DatatransferTransferState)

        __props__.__dict__["description"] = description
        __props__.__dict__["folder_id"] = folder_id
        __props__.__dict__["labels"] = labels
        __props__.__dict__["name"] = name
        __props__.__dict__["on_create_activate_mode"] = on_create_activate_mode
        __props__.__dict__["runtime"] = runtime
        __props__.__dict__["source_id"] = source_id
        __props__.__dict__["target_id"] = target_id
        __props__.__dict__["transformation"] = transformation
        __props__.__dict__["type"] = type
        __props__.__dict__["warning"] = warning
        return DatatransferTransfer(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> pulumi.Output[_builtins.str]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="onCreateActivateMode")
    def on_create_activate_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Activation action on create a new incremental transfer. It is not part of the transfer parameter and is used only on create. One of `sync_activate`, `async_activate`, `dont_activate`. The default is `sync_activate`.
        """
        return pulumi.get(self, "on_create_activate_mode")

    @_builtins.property
    @pulumi.getter
    def runtime(self) -> pulumi.Output['outputs.DatatransferTransferRuntime']:
        """
        Runtime parameters for the transfer.
        """
        return pulumi.get(self, "runtime")

    @_builtins.property
    @pulumi.getter(name="sourceId")
    def source_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the source endpoint for the transfer.
        """
        return pulumi.get(self, "source_id")

    @_builtins.property
    @pulumi.getter(name="targetId")
    def target_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the target endpoint for the transfer.
        """
        return pulumi.get(self, "target_id")

    @_builtins.property
    @pulumi.getter
    def transformation(self) -> pulumi.Output[Optional['outputs.DatatransferTransferTransformation']]:
        """
        Transformation for the transfer.
        """
        return pulumi.get(self, "transformation")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        Type of the transfer. One of `SNAPSHOT_ONLY`, `INCREMENT_ONLY`, `SNAPSHOT_AND_INCREMENT`
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def warning(self) -> pulumi.Output[_builtins.str]:
        """
        Error description if transfer has any errors.
        """
        return pulumi.get(self, "warning")

