# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FunctionArgs', 'Function']

@pulumi.input_type
class FunctionArgs:
    def __init__(__self__, *,
                 entrypoint: pulumi.Input[_builtins.str],
                 memory: pulumi.Input[_builtins.int],
                 runtime: pulumi.Input[_builtins.str],
                 user_hash: pulumi.Input[_builtins.str],
                 async_invocation: Optional[pulumi.Input['FunctionAsyncInvocationArgs']] = None,
                 concurrency: Optional[pulumi.Input[_builtins.int]] = None,
                 connectivity: Optional[pulumi.Input['FunctionConnectivityArgs']] = None,
                 content: Optional[pulumi.Input['FunctionContentArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 environment: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 execution_timeout: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 log_options: Optional[pulumi.Input['FunctionLogOptionsArgs']] = None,
                 metadata_options: Optional[pulumi.Input['FunctionMetadataOptionsArgs']] = None,
                 mounts: Optional[pulumi.Input[Sequence[pulumi.Input['FunctionMountArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 package: Optional[pulumi.Input['FunctionPackageArgs']] = None,
                 secrets: Optional[pulumi.Input[Sequence[pulumi.Input['FunctionSecretArgs']]]] = None,
                 service_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_mounts: Optional[pulumi.Input[Sequence[pulumi.Input['FunctionStorageMountArgs']]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tmpfs_size: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a Function resource.
        :param pulumi.Input[_builtins.str] entrypoint: Entrypoint for Yandex Cloud Function.
        :param pulumi.Input[_builtins.int] memory: Memory in megabytes (**aligned to 128MB**) for Yandex Cloud Function.
        :param pulumi.Input[_builtins.str] runtime: Runtime for Yandex Cloud Function.
        :param pulumi.Input[_builtins.str] user_hash: User-defined string for current function version. User must change this string any times when function changed. Function will be updated when hash is changed.
        :param pulumi.Input['FunctionAsyncInvocationArgs'] async_invocation: Config for asynchronous invocations of Yandex Cloud Function.
        :param pulumi.Input[_builtins.int] concurrency: The maximum number of requests processed by a function instance at the same time.
        :param pulumi.Input['FunctionConnectivityArgs'] connectivity: Function version connectivity. If specified the version will be attached to specified network.
        :param pulumi.Input['FunctionContentArgs'] content: Version deployment content for Yandex Cloud Function code. Can be only one `package` or `content` section. Either `package` or `content` section must be specified.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] environment: A set of key/value environment variables for Yandex Cloud Function. Each key must begin with a letter (A-Z, a-z).
        :param pulumi.Input[_builtins.str] execution_timeout: Execution timeout in seconds for Yandex Cloud Function.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input['FunctionLogOptionsArgs'] log_options: Options for logging from Yandex Cloud Function.
        :param pulumi.Input['FunctionMetadataOptionsArgs'] metadata_options: Options set the access mode to function's metadata endpoints.
        :param pulumi.Input[Sequence[pulumi.Input['FunctionMountArgs']]] mounts: Mounts for Yandex Cloud Function.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input['FunctionPackageArgs'] package: Version deployment package for Yandex Cloud Function code. Can be only one `package` or `content` section. Either `package` or `content` section must be specified.
        :param pulumi.Input[Sequence[pulumi.Input['FunctionSecretArgs']]] secrets: Secrets for Yandex Cloud Function.
        :param pulumi.Input[_builtins.str] service_account_id: [Service account](https://yandex.cloud/docs/iam/concepts/users/service-accounts) which linked to the resource.
        :param pulumi.Input[Sequence[pulumi.Input['FunctionStorageMountArgs']]] storage_mounts: (**DEPRECATED**, use `mounts > object_storage` instead). Storage mounts for Yandex Cloud Function.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags for Yandex Cloud Function. Tag `$latest` isn't returned.
        :param pulumi.Input[_builtins.int] tmpfs_size: Tmpfs size for Yandex Cloud Function.
        """
        pulumi.set(__self__, "entrypoint", entrypoint)
        pulumi.set(__self__, "memory", memory)
        pulumi.set(__self__, "runtime", runtime)
        pulumi.set(__self__, "user_hash", user_hash)
        if async_invocation is not None:
            pulumi.set(__self__, "async_invocation", async_invocation)
        if concurrency is not None:
            pulumi.set(__self__, "concurrency", concurrency)
        if connectivity is not None:
            pulumi.set(__self__, "connectivity", connectivity)
        if content is not None:
            pulumi.set(__self__, "content", content)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if execution_timeout is not None:
            pulumi.set(__self__, "execution_timeout", execution_timeout)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if log_options is not None:
            pulumi.set(__self__, "log_options", log_options)
        if metadata_options is not None:
            pulumi.set(__self__, "metadata_options", metadata_options)
        if mounts is not None:
            pulumi.set(__self__, "mounts", mounts)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if package is not None:
            pulumi.set(__self__, "package", package)
        if secrets is not None:
            pulumi.set(__self__, "secrets", secrets)
        if service_account_id is not None:
            pulumi.set(__self__, "service_account_id", service_account_id)
        if storage_mounts is not None:
            warnings.warn("""The 'storage_mounts' field has been deprecated. Please use 'mounts' instead.""", DeprecationWarning)
            pulumi.log.warn("""storage_mounts is deprecated: The 'storage_mounts' field has been deprecated. Please use 'mounts' instead.""")
        if storage_mounts is not None:
            pulumi.set(__self__, "storage_mounts", storage_mounts)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tmpfs_size is not None:
            pulumi.set(__self__, "tmpfs_size", tmpfs_size)

    @_builtins.property
    @pulumi.getter
    def entrypoint(self) -> pulumi.Input[_builtins.str]:
        """
        Entrypoint for Yandex Cloud Function.
        """
        return pulumi.get(self, "entrypoint")

    @entrypoint.setter
    def entrypoint(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "entrypoint", value)

    @_builtins.property
    @pulumi.getter
    def memory(self) -> pulumi.Input[_builtins.int]:
        """
        Memory in megabytes (**aligned to 128MB**) for Yandex Cloud Function.
        """
        return pulumi.get(self, "memory")

    @memory.setter
    def memory(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "memory", value)

    @_builtins.property
    @pulumi.getter
    def runtime(self) -> pulumi.Input[_builtins.str]:
        """
        Runtime for Yandex Cloud Function.
        """
        return pulumi.get(self, "runtime")

    @runtime.setter
    def runtime(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "runtime", value)

    @_builtins.property
    @pulumi.getter(name="userHash")
    def user_hash(self) -> pulumi.Input[_builtins.str]:
        """
        User-defined string for current function version. User must change this string any times when function changed. Function will be updated when hash is changed.
        """
        return pulumi.get(self, "user_hash")

    @user_hash.setter
    def user_hash(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "user_hash", value)

    @_builtins.property
    @pulumi.getter(name="asyncInvocation")
    def async_invocation(self) -> Optional[pulumi.Input['FunctionAsyncInvocationArgs']]:
        """
        Config for asynchronous invocations of Yandex Cloud Function.
        """
        return pulumi.get(self, "async_invocation")

    @async_invocation.setter
    def async_invocation(self, value: Optional[pulumi.Input['FunctionAsyncInvocationArgs']]):
        pulumi.set(self, "async_invocation", value)

    @_builtins.property
    @pulumi.getter
    def concurrency(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of requests processed by a function instance at the same time.
        """
        return pulumi.get(self, "concurrency")

    @concurrency.setter
    def concurrency(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "concurrency", value)

    @_builtins.property
    @pulumi.getter
    def connectivity(self) -> Optional[pulumi.Input['FunctionConnectivityArgs']]:
        """
        Function version connectivity. If specified the version will be attached to specified network.
        """
        return pulumi.get(self, "connectivity")

    @connectivity.setter
    def connectivity(self, value: Optional[pulumi.Input['FunctionConnectivityArgs']]):
        pulumi.set(self, "connectivity", value)

    @_builtins.property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input['FunctionContentArgs']]:
        """
        Version deployment content for Yandex Cloud Function code. Can be only one `package` or `content` section. Either `package` or `content` section must be specified.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input['FunctionContentArgs']]):
        pulumi.set(self, "content", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value environment variables for Yandex Cloud Function. Each key must begin with a letter (A-Z, a-z).
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "environment", value)

    @_builtins.property
    @pulumi.getter(name="executionTimeout")
    def execution_timeout(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Execution timeout in seconds for Yandex Cloud Function.
        """
        return pulumi.get(self, "execution_timeout")

    @execution_timeout.setter
    def execution_timeout(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "execution_timeout", value)

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder_id", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="logOptions")
    def log_options(self) -> Optional[pulumi.Input['FunctionLogOptionsArgs']]:
        """
        Options for logging from Yandex Cloud Function.
        """
        return pulumi.get(self, "log_options")

    @log_options.setter
    def log_options(self, value: Optional[pulumi.Input['FunctionLogOptionsArgs']]):
        pulumi.set(self, "log_options", value)

    @_builtins.property
    @pulumi.getter(name="metadataOptions")
    def metadata_options(self) -> Optional[pulumi.Input['FunctionMetadataOptionsArgs']]:
        """
        Options set the access mode to function's metadata endpoints.
        """
        return pulumi.get(self, "metadata_options")

    @metadata_options.setter
    def metadata_options(self, value: Optional[pulumi.Input['FunctionMetadataOptionsArgs']]):
        pulumi.set(self, "metadata_options", value)

    @_builtins.property
    @pulumi.getter
    def mounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FunctionMountArgs']]]]:
        """
        Mounts for Yandex Cloud Function.
        """
        return pulumi.get(self, "mounts")

    @mounts.setter
    def mounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FunctionMountArgs']]]]):
        pulumi.set(self, "mounts", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def package(self) -> Optional[pulumi.Input['FunctionPackageArgs']]:
        """
        Version deployment package for Yandex Cloud Function code. Can be only one `package` or `content` section. Either `package` or `content` section must be specified.
        """
        return pulumi.get(self, "package")

    @package.setter
    def package(self, value: Optional[pulumi.Input['FunctionPackageArgs']]):
        pulumi.set(self, "package", value)

    @_builtins.property
    @pulumi.getter
    def secrets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FunctionSecretArgs']]]]:
        """
        Secrets for Yandex Cloud Function.
        """
        return pulumi.get(self, "secrets")

    @secrets.setter
    def secrets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FunctionSecretArgs']]]]):
        pulumi.set(self, "secrets", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccountId")
    def service_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        [Service account](https://yandex.cloud/docs/iam/concepts/users/service-accounts) which linked to the resource.
        """
        return pulumi.get(self, "service_account_id")

    @service_account_id.setter
    def service_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_account_id", value)

    @_builtins.property
    @pulumi.getter(name="storageMounts")
    @_utilities.deprecated("""The 'storage_mounts' field has been deprecated. Please use 'mounts' instead.""")
    def storage_mounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FunctionStorageMountArgs']]]]:
        """
        (**DEPRECATED**, use `mounts > object_storage` instead). Storage mounts for Yandex Cloud Function.
        """
        return pulumi.get(self, "storage_mounts")

    @storage_mounts.setter
    def storage_mounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FunctionStorageMountArgs']]]]):
        pulumi.set(self, "storage_mounts", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags for Yandex Cloud Function. Tag `$latest` isn't returned.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tmpfsSize")
    def tmpfs_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Tmpfs size for Yandex Cloud Function.
        """
        return pulumi.get(self, "tmpfs_size")

    @tmpfs_size.setter
    def tmpfs_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "tmpfs_size", value)


@pulumi.input_type
class _FunctionState:
    def __init__(__self__, *,
                 async_invocation: Optional[pulumi.Input['FunctionAsyncInvocationArgs']] = None,
                 concurrency: Optional[pulumi.Input[_builtins.int]] = None,
                 connectivity: Optional[pulumi.Input['FunctionConnectivityArgs']] = None,
                 content: Optional[pulumi.Input['FunctionContentArgs']] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 entrypoint: Optional[pulumi.Input[_builtins.str]] = None,
                 environment: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 execution_timeout: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 image_size: Optional[pulumi.Input[_builtins.int]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 log_options: Optional[pulumi.Input['FunctionLogOptionsArgs']] = None,
                 memory: Optional[pulumi.Input[_builtins.int]] = None,
                 metadata_options: Optional[pulumi.Input['FunctionMetadataOptionsArgs']] = None,
                 mounts: Optional[pulumi.Input[Sequence[pulumi.Input['FunctionMountArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 package: Optional[pulumi.Input['FunctionPackageArgs']] = None,
                 runtime: Optional[pulumi.Input[_builtins.str]] = None,
                 secrets: Optional[pulumi.Input[Sequence[pulumi.Input['FunctionSecretArgs']]]] = None,
                 service_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_mounts: Optional[pulumi.Input[Sequence[pulumi.Input['FunctionStorageMountArgs']]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tmpfs_size: Optional[pulumi.Input[_builtins.int]] = None,
                 user_hash: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Function resources.
        :param pulumi.Input['FunctionAsyncInvocationArgs'] async_invocation: Config for asynchronous invocations of Yandex Cloud Function.
        :param pulumi.Input[_builtins.int] concurrency: The maximum number of requests processed by a function instance at the same time.
        :param pulumi.Input['FunctionConnectivityArgs'] connectivity: Function version connectivity. If specified the version will be attached to specified network.
        :param pulumi.Input['FunctionContentArgs'] content: Version deployment content for Yandex Cloud Function code. Can be only one `package` or `content` section. Either `package` or `content` section must be specified.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] entrypoint: Entrypoint for Yandex Cloud Function.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] environment: A set of key/value environment variables for Yandex Cloud Function. Each key must begin with a letter (A-Z, a-z).
        :param pulumi.Input[_builtins.str] execution_timeout: Execution timeout in seconds for Yandex Cloud Function.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[_builtins.int] image_size: Image size for Yandex Cloud Function.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input['FunctionLogOptionsArgs'] log_options: Options for logging from Yandex Cloud Function.
        :param pulumi.Input[_builtins.int] memory: Memory in megabytes (**aligned to 128MB**) for Yandex Cloud Function.
        :param pulumi.Input['FunctionMetadataOptionsArgs'] metadata_options: Options set the access mode to function's metadata endpoints.
        :param pulumi.Input[Sequence[pulumi.Input['FunctionMountArgs']]] mounts: Mounts for Yandex Cloud Function.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input['FunctionPackageArgs'] package: Version deployment package for Yandex Cloud Function code. Can be only one `package` or `content` section. Either `package` or `content` section must be specified.
        :param pulumi.Input[_builtins.str] runtime: Runtime for Yandex Cloud Function.
        :param pulumi.Input[Sequence[pulumi.Input['FunctionSecretArgs']]] secrets: Secrets for Yandex Cloud Function.
        :param pulumi.Input[_builtins.str] service_account_id: [Service account](https://yandex.cloud/docs/iam/concepts/users/service-accounts) which linked to the resource.
        :param pulumi.Input[Sequence[pulumi.Input['FunctionStorageMountArgs']]] storage_mounts: (**DEPRECATED**, use `mounts > object_storage` instead). Storage mounts for Yandex Cloud Function.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags for Yandex Cloud Function. Tag `$latest` isn't returned.
        :param pulumi.Input[_builtins.int] tmpfs_size: Tmpfs size for Yandex Cloud Function.
        :param pulumi.Input[_builtins.str] user_hash: User-defined string for current function version. User must change this string any times when function changed. Function will be updated when hash is changed.
        :param pulumi.Input[_builtins.str] version: Version of Yandex Cloud Function.
        """
        if async_invocation is not None:
            pulumi.set(__self__, "async_invocation", async_invocation)
        if concurrency is not None:
            pulumi.set(__self__, "concurrency", concurrency)
        if connectivity is not None:
            pulumi.set(__self__, "connectivity", connectivity)
        if content is not None:
            pulumi.set(__self__, "content", content)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if entrypoint is not None:
            pulumi.set(__self__, "entrypoint", entrypoint)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if execution_timeout is not None:
            pulumi.set(__self__, "execution_timeout", execution_timeout)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if image_size is not None:
            pulumi.set(__self__, "image_size", image_size)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if log_options is not None:
            pulumi.set(__self__, "log_options", log_options)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)
        if metadata_options is not None:
            pulumi.set(__self__, "metadata_options", metadata_options)
        if mounts is not None:
            pulumi.set(__self__, "mounts", mounts)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if package is not None:
            pulumi.set(__self__, "package", package)
        if runtime is not None:
            pulumi.set(__self__, "runtime", runtime)
        if secrets is not None:
            pulumi.set(__self__, "secrets", secrets)
        if service_account_id is not None:
            pulumi.set(__self__, "service_account_id", service_account_id)
        if storage_mounts is not None:
            warnings.warn("""The 'storage_mounts' field has been deprecated. Please use 'mounts' instead.""", DeprecationWarning)
            pulumi.log.warn("""storage_mounts is deprecated: The 'storage_mounts' field has been deprecated. Please use 'mounts' instead.""")
        if storage_mounts is not None:
            pulumi.set(__self__, "storage_mounts", storage_mounts)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tmpfs_size is not None:
            pulumi.set(__self__, "tmpfs_size", tmpfs_size)
        if user_hash is not None:
            pulumi.set(__self__, "user_hash", user_hash)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="asyncInvocation")
    def async_invocation(self) -> Optional[pulumi.Input['FunctionAsyncInvocationArgs']]:
        """
        Config for asynchronous invocations of Yandex Cloud Function.
        """
        return pulumi.get(self, "async_invocation")

    @async_invocation.setter
    def async_invocation(self, value: Optional[pulumi.Input['FunctionAsyncInvocationArgs']]):
        pulumi.set(self, "async_invocation", value)

    @_builtins.property
    @pulumi.getter
    def concurrency(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of requests processed by a function instance at the same time.
        """
        return pulumi.get(self, "concurrency")

    @concurrency.setter
    def concurrency(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "concurrency", value)

    @_builtins.property
    @pulumi.getter
    def connectivity(self) -> Optional[pulumi.Input['FunctionConnectivityArgs']]:
        """
        Function version connectivity. If specified the version will be attached to specified network.
        """
        return pulumi.get(self, "connectivity")

    @connectivity.setter
    def connectivity(self, value: Optional[pulumi.Input['FunctionConnectivityArgs']]):
        pulumi.set(self, "connectivity", value)

    @_builtins.property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input['FunctionContentArgs']]:
        """
        Version deployment content for Yandex Cloud Function code. Can be only one `package` or `content` section. Either `package` or `content` section must be specified.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input['FunctionContentArgs']]):
        pulumi.set(self, "content", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def entrypoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Entrypoint for Yandex Cloud Function.
        """
        return pulumi.get(self, "entrypoint")

    @entrypoint.setter
    def entrypoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "entrypoint", value)

    @_builtins.property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value environment variables for Yandex Cloud Function. Each key must begin with a letter (A-Z, a-z).
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "environment", value)

    @_builtins.property
    @pulumi.getter(name="executionTimeout")
    def execution_timeout(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Execution timeout in seconds for Yandex Cloud Function.
        """
        return pulumi.get(self, "execution_timeout")

    @execution_timeout.setter
    def execution_timeout(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "execution_timeout", value)

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder_id", value)

    @_builtins.property
    @pulumi.getter(name="imageSize")
    def image_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Image size for Yandex Cloud Function.
        """
        return pulumi.get(self, "image_size")

    @image_size.setter
    def image_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "image_size", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="logOptions")
    def log_options(self) -> Optional[pulumi.Input['FunctionLogOptionsArgs']]:
        """
        Options for logging from Yandex Cloud Function.
        """
        return pulumi.get(self, "log_options")

    @log_options.setter
    def log_options(self, value: Optional[pulumi.Input['FunctionLogOptionsArgs']]):
        pulumi.set(self, "log_options", value)

    @_builtins.property
    @pulumi.getter
    def memory(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Memory in megabytes (**aligned to 128MB**) for Yandex Cloud Function.
        """
        return pulumi.get(self, "memory")

    @memory.setter
    def memory(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "memory", value)

    @_builtins.property
    @pulumi.getter(name="metadataOptions")
    def metadata_options(self) -> Optional[pulumi.Input['FunctionMetadataOptionsArgs']]:
        """
        Options set the access mode to function's metadata endpoints.
        """
        return pulumi.get(self, "metadata_options")

    @metadata_options.setter
    def metadata_options(self, value: Optional[pulumi.Input['FunctionMetadataOptionsArgs']]):
        pulumi.set(self, "metadata_options", value)

    @_builtins.property
    @pulumi.getter
    def mounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FunctionMountArgs']]]]:
        """
        Mounts for Yandex Cloud Function.
        """
        return pulumi.get(self, "mounts")

    @mounts.setter
    def mounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FunctionMountArgs']]]]):
        pulumi.set(self, "mounts", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def package(self) -> Optional[pulumi.Input['FunctionPackageArgs']]:
        """
        Version deployment package for Yandex Cloud Function code. Can be only one `package` or `content` section. Either `package` or `content` section must be specified.
        """
        return pulumi.get(self, "package")

    @package.setter
    def package(self, value: Optional[pulumi.Input['FunctionPackageArgs']]):
        pulumi.set(self, "package", value)

    @_builtins.property
    @pulumi.getter
    def runtime(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Runtime for Yandex Cloud Function.
        """
        return pulumi.get(self, "runtime")

    @runtime.setter
    def runtime(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "runtime", value)

    @_builtins.property
    @pulumi.getter
    def secrets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FunctionSecretArgs']]]]:
        """
        Secrets for Yandex Cloud Function.
        """
        return pulumi.get(self, "secrets")

    @secrets.setter
    def secrets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FunctionSecretArgs']]]]):
        pulumi.set(self, "secrets", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccountId")
    def service_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        [Service account](https://yandex.cloud/docs/iam/concepts/users/service-accounts) which linked to the resource.
        """
        return pulumi.get(self, "service_account_id")

    @service_account_id.setter
    def service_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_account_id", value)

    @_builtins.property
    @pulumi.getter(name="storageMounts")
    @_utilities.deprecated("""The 'storage_mounts' field has been deprecated. Please use 'mounts' instead.""")
    def storage_mounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FunctionStorageMountArgs']]]]:
        """
        (**DEPRECATED**, use `mounts > object_storage` instead). Storage mounts for Yandex Cloud Function.
        """
        return pulumi.get(self, "storage_mounts")

    @storage_mounts.setter
    def storage_mounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FunctionStorageMountArgs']]]]):
        pulumi.set(self, "storage_mounts", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags for Yandex Cloud Function. Tag `$latest` isn't returned.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tmpfsSize")
    def tmpfs_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Tmpfs size for Yandex Cloud Function.
        """
        return pulumi.get(self, "tmpfs_size")

    @tmpfs_size.setter
    def tmpfs_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "tmpfs_size", value)

    @_builtins.property
    @pulumi.getter(name="userHash")
    def user_hash(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User-defined string for current function version. User must change this string any times when function changed. Function will be updated when hash is changed.
        """
        return pulumi.get(self, "user_hash")

    @user_hash.setter
    def user_hash(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_hash", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Version of Yandex Cloud Function.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("yandex:index/function:Function")
class Function(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 async_invocation: Optional[pulumi.Input[Union['FunctionAsyncInvocationArgs', 'FunctionAsyncInvocationArgsDict']]] = None,
                 concurrency: Optional[pulumi.Input[_builtins.int]] = None,
                 connectivity: Optional[pulumi.Input[Union['FunctionConnectivityArgs', 'FunctionConnectivityArgsDict']]] = None,
                 content: Optional[pulumi.Input[Union['FunctionContentArgs', 'FunctionContentArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 entrypoint: Optional[pulumi.Input[_builtins.str]] = None,
                 environment: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 execution_timeout: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 log_options: Optional[pulumi.Input[Union['FunctionLogOptionsArgs', 'FunctionLogOptionsArgsDict']]] = None,
                 memory: Optional[pulumi.Input[_builtins.int]] = None,
                 metadata_options: Optional[pulumi.Input[Union['FunctionMetadataOptionsArgs', 'FunctionMetadataOptionsArgsDict']]] = None,
                 mounts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FunctionMountArgs', 'FunctionMountArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 package: Optional[pulumi.Input[Union['FunctionPackageArgs', 'FunctionPackageArgsDict']]] = None,
                 runtime: Optional[pulumi.Input[_builtins.str]] = None,
                 secrets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FunctionSecretArgs', 'FunctionSecretArgsDict']]]]] = None,
                 service_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_mounts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FunctionStorageMountArgs', 'FunctionStorageMountArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tmpfs_size: Optional[pulumi.Input[_builtins.int]] = None,
                 user_hash: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Allows management of [Yandex Cloud Function](https://yandex.cloud/docs/functions)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new Yandex Cloud Function
        #
        test_function = yandex.Function("test-function",
            name="some_name",
            description="any description",
            user_hash="any_user_defined_string",
            runtime="python37",
            entrypoint="main",
            memory=128,
            execution_timeout="10",
            service_account_id="ajeih**********838kk",
            tags=["my_tag"],
            secrets=[{
                "id": secret["id"],
                "version_id": secret_version["id"],
                "key": "secret-key",
                "environment_variable": "ENV_VARIABLE",
            }],
            content={
                "zip_filename": "function.zip",
            },
            mounts=[{
                "name": "mnt",
                "ephemeral_disk": {
                    "size_gb": 32,
                },
            }],
            async_invocation={
                "retries_count": 3,
                "service_account_id": "ajeih**********838kk",
                "ymq_failure_target": {
                    "service_account_id": "ajeqr**********qb76m",
                    "arn": "yrn:yc:ymq:ru-central1:b1glr**********9hsfp:fail",
                },
                "ymq_success_target": {
                    "service_account_id": "ajeqr**********qb76m",
                    "arn": "yrn:yc:ymq:ru-central1:b1glr**********9hsfp:success",
                },
            },
            log_options={
                "log_group_id": "e2392**********eq9fr",
                "min_level": "ERROR",
            })
        ```

        ```python
        import pulumi
        import pulumi_yandex as yandex
        import pulumi_yandex_marketmaker as yandex

        folder_id = "folder_id"
        sa = yandex.IamServiceAccount("sa",
            folder_id=folder_id,
            name="test-sa")
        sa_static_key = yandex.IamServiceAccountStaticAccessKey("sa-static-key",
            service_account_id=sa.id,
            description="static access key for object storage")
        my_bucket = yandex.StorageBucket("my-bucket",
            access_key=sa_static_key.access_key,
            secret_key=sa_static_key.secret_key,
            bucket="bucket")
        #
        # Create a new Yandex Cloud Function with mounted Object Storage Bucket.
        #
        test_function = yandex.Function("test-function",
            name="some_name",
            user_hash="v1",
            runtime="python37",
            entrypoint="index.handler",
            memory=128,
            execution_timeout="10",
            service_account_id=sa.id,
            content={
                "zip_filename": "function.zip",
            },
            mounts=[{
                "name": "mnt",
                "mode": "ro",
                "object_storage": {
                    "bucket": my_bucket.bucket,
                },
            }])
        sa_editor = yandex.index.ResourcemanagerFolderIamMember("sa-editor",
            folder_id=folder_id,
            role=storage.editor,
            member=fserviceAccount:{sa.id})
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        ```sh
        $ pulumi import yandex:index/function:Function <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/function:Function test-function d4e45**********pqvd3
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['FunctionAsyncInvocationArgs', 'FunctionAsyncInvocationArgsDict']] async_invocation: Config for asynchronous invocations of Yandex Cloud Function.
        :param pulumi.Input[_builtins.int] concurrency: The maximum number of requests processed by a function instance at the same time.
        :param pulumi.Input[Union['FunctionConnectivityArgs', 'FunctionConnectivityArgsDict']] connectivity: Function version connectivity. If specified the version will be attached to specified network.
        :param pulumi.Input[Union['FunctionContentArgs', 'FunctionContentArgsDict']] content: Version deployment content for Yandex Cloud Function code. Can be only one `package` or `content` section. Either `package` or `content` section must be specified.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] entrypoint: Entrypoint for Yandex Cloud Function.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] environment: A set of key/value environment variables for Yandex Cloud Function. Each key must begin with a letter (A-Z, a-z).
        :param pulumi.Input[_builtins.str] execution_timeout: Execution timeout in seconds for Yandex Cloud Function.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[Union['FunctionLogOptionsArgs', 'FunctionLogOptionsArgsDict']] log_options: Options for logging from Yandex Cloud Function.
        :param pulumi.Input[_builtins.int] memory: Memory in megabytes (**aligned to 128MB**) for Yandex Cloud Function.
        :param pulumi.Input[Union['FunctionMetadataOptionsArgs', 'FunctionMetadataOptionsArgsDict']] metadata_options: Options set the access mode to function's metadata endpoints.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FunctionMountArgs', 'FunctionMountArgsDict']]]] mounts: Mounts for Yandex Cloud Function.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[Union['FunctionPackageArgs', 'FunctionPackageArgsDict']] package: Version deployment package for Yandex Cloud Function code. Can be only one `package` or `content` section. Either `package` or `content` section must be specified.
        :param pulumi.Input[_builtins.str] runtime: Runtime for Yandex Cloud Function.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FunctionSecretArgs', 'FunctionSecretArgsDict']]]] secrets: Secrets for Yandex Cloud Function.
        :param pulumi.Input[_builtins.str] service_account_id: [Service account](https://yandex.cloud/docs/iam/concepts/users/service-accounts) which linked to the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FunctionStorageMountArgs', 'FunctionStorageMountArgsDict']]]] storage_mounts: (**DEPRECATED**, use `mounts > object_storage` instead). Storage mounts for Yandex Cloud Function.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags for Yandex Cloud Function. Tag `$latest` isn't returned.
        :param pulumi.Input[_builtins.int] tmpfs_size: Tmpfs size for Yandex Cloud Function.
        :param pulumi.Input[_builtins.str] user_hash: User-defined string for current function version. User must change this string any times when function changed. Function will be updated when hash is changed.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FunctionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Allows management of [Yandex Cloud Function](https://yandex.cloud/docs/functions)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new Yandex Cloud Function
        #
        test_function = yandex.Function("test-function",
            name="some_name",
            description="any description",
            user_hash="any_user_defined_string",
            runtime="python37",
            entrypoint="main",
            memory=128,
            execution_timeout="10",
            service_account_id="ajeih**********838kk",
            tags=["my_tag"],
            secrets=[{
                "id": secret["id"],
                "version_id": secret_version["id"],
                "key": "secret-key",
                "environment_variable": "ENV_VARIABLE",
            }],
            content={
                "zip_filename": "function.zip",
            },
            mounts=[{
                "name": "mnt",
                "ephemeral_disk": {
                    "size_gb": 32,
                },
            }],
            async_invocation={
                "retries_count": 3,
                "service_account_id": "ajeih**********838kk",
                "ymq_failure_target": {
                    "service_account_id": "ajeqr**********qb76m",
                    "arn": "yrn:yc:ymq:ru-central1:b1glr**********9hsfp:fail",
                },
                "ymq_success_target": {
                    "service_account_id": "ajeqr**********qb76m",
                    "arn": "yrn:yc:ymq:ru-central1:b1glr**********9hsfp:success",
                },
            },
            log_options={
                "log_group_id": "e2392**********eq9fr",
                "min_level": "ERROR",
            })
        ```

        ```python
        import pulumi
        import pulumi_yandex as yandex
        import pulumi_yandex_marketmaker as yandex

        folder_id = "folder_id"
        sa = yandex.IamServiceAccount("sa",
            folder_id=folder_id,
            name="test-sa")
        sa_static_key = yandex.IamServiceAccountStaticAccessKey("sa-static-key",
            service_account_id=sa.id,
            description="static access key for object storage")
        my_bucket = yandex.StorageBucket("my-bucket",
            access_key=sa_static_key.access_key,
            secret_key=sa_static_key.secret_key,
            bucket="bucket")
        #
        # Create a new Yandex Cloud Function with mounted Object Storage Bucket.
        #
        test_function = yandex.Function("test-function",
            name="some_name",
            user_hash="v1",
            runtime="python37",
            entrypoint="index.handler",
            memory=128,
            execution_timeout="10",
            service_account_id=sa.id,
            content={
                "zip_filename": "function.zip",
            },
            mounts=[{
                "name": "mnt",
                "mode": "ro",
                "object_storage": {
                    "bucket": my_bucket.bucket,
                },
            }])
        sa_editor = yandex.index.ResourcemanagerFolderIamMember("sa-editor",
            folder_id=folder_id,
            role=storage.editor,
            member=fserviceAccount:{sa.id})
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        ```sh
        $ pulumi import yandex:index/function:Function <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/function:Function test-function d4e45**********pqvd3
        ```

        :param str resource_name: The name of the resource.
        :param FunctionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FunctionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 async_invocation: Optional[pulumi.Input[Union['FunctionAsyncInvocationArgs', 'FunctionAsyncInvocationArgsDict']]] = None,
                 concurrency: Optional[pulumi.Input[_builtins.int]] = None,
                 connectivity: Optional[pulumi.Input[Union['FunctionConnectivityArgs', 'FunctionConnectivityArgsDict']]] = None,
                 content: Optional[pulumi.Input[Union['FunctionContentArgs', 'FunctionContentArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 entrypoint: Optional[pulumi.Input[_builtins.str]] = None,
                 environment: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 execution_timeout: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 log_options: Optional[pulumi.Input[Union['FunctionLogOptionsArgs', 'FunctionLogOptionsArgsDict']]] = None,
                 memory: Optional[pulumi.Input[_builtins.int]] = None,
                 metadata_options: Optional[pulumi.Input[Union['FunctionMetadataOptionsArgs', 'FunctionMetadataOptionsArgsDict']]] = None,
                 mounts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FunctionMountArgs', 'FunctionMountArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 package: Optional[pulumi.Input[Union['FunctionPackageArgs', 'FunctionPackageArgsDict']]] = None,
                 runtime: Optional[pulumi.Input[_builtins.str]] = None,
                 secrets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FunctionSecretArgs', 'FunctionSecretArgsDict']]]]] = None,
                 service_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_mounts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FunctionStorageMountArgs', 'FunctionStorageMountArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tmpfs_size: Optional[pulumi.Input[_builtins.int]] = None,
                 user_hash: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FunctionArgs.__new__(FunctionArgs)

            __props__.__dict__["async_invocation"] = async_invocation
            __props__.__dict__["concurrency"] = concurrency
            __props__.__dict__["connectivity"] = connectivity
            __props__.__dict__["content"] = content
            __props__.__dict__["description"] = description
            if entrypoint is None and not opts.urn:
                raise TypeError("Missing required property 'entrypoint'")
            __props__.__dict__["entrypoint"] = entrypoint
            __props__.__dict__["environment"] = environment
            __props__.__dict__["execution_timeout"] = execution_timeout
            __props__.__dict__["folder_id"] = folder_id
            __props__.__dict__["labels"] = labels
            __props__.__dict__["log_options"] = log_options
            if memory is None and not opts.urn:
                raise TypeError("Missing required property 'memory'")
            __props__.__dict__["memory"] = memory
            __props__.__dict__["metadata_options"] = metadata_options
            __props__.__dict__["mounts"] = mounts
            __props__.__dict__["name"] = name
            __props__.__dict__["package"] = package
            if runtime is None and not opts.urn:
                raise TypeError("Missing required property 'runtime'")
            __props__.__dict__["runtime"] = runtime
            __props__.__dict__["secrets"] = secrets
            __props__.__dict__["service_account_id"] = service_account_id
            __props__.__dict__["storage_mounts"] = storage_mounts
            __props__.__dict__["tags"] = tags
            __props__.__dict__["tmpfs_size"] = tmpfs_size
            if user_hash is None and not opts.urn:
                raise TypeError("Missing required property 'user_hash'")
            __props__.__dict__["user_hash"] = user_hash
            __props__.__dict__["created_at"] = None
            __props__.__dict__["image_size"] = None
            __props__.__dict__["version"] = None
        super(Function, __self__).__init__(
            'yandex:index/function:Function',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            async_invocation: Optional[pulumi.Input[Union['FunctionAsyncInvocationArgs', 'FunctionAsyncInvocationArgsDict']]] = None,
            concurrency: Optional[pulumi.Input[_builtins.int]] = None,
            connectivity: Optional[pulumi.Input[Union['FunctionConnectivityArgs', 'FunctionConnectivityArgsDict']]] = None,
            content: Optional[pulumi.Input[Union['FunctionContentArgs', 'FunctionContentArgsDict']]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            entrypoint: Optional[pulumi.Input[_builtins.str]] = None,
            environment: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            execution_timeout: Optional[pulumi.Input[_builtins.str]] = None,
            folder_id: Optional[pulumi.Input[_builtins.str]] = None,
            image_size: Optional[pulumi.Input[_builtins.int]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            log_options: Optional[pulumi.Input[Union['FunctionLogOptionsArgs', 'FunctionLogOptionsArgsDict']]] = None,
            memory: Optional[pulumi.Input[_builtins.int]] = None,
            metadata_options: Optional[pulumi.Input[Union['FunctionMetadataOptionsArgs', 'FunctionMetadataOptionsArgsDict']]] = None,
            mounts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FunctionMountArgs', 'FunctionMountArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            package: Optional[pulumi.Input[Union['FunctionPackageArgs', 'FunctionPackageArgsDict']]] = None,
            runtime: Optional[pulumi.Input[_builtins.str]] = None,
            secrets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FunctionSecretArgs', 'FunctionSecretArgsDict']]]]] = None,
            service_account_id: Optional[pulumi.Input[_builtins.str]] = None,
            storage_mounts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FunctionStorageMountArgs', 'FunctionStorageMountArgsDict']]]]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            tmpfs_size: Optional[pulumi.Input[_builtins.int]] = None,
            user_hash: Optional[pulumi.Input[_builtins.str]] = None,
            version: Optional[pulumi.Input[_builtins.str]] = None) -> 'Function':
        """
        Get an existing Function resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['FunctionAsyncInvocationArgs', 'FunctionAsyncInvocationArgsDict']] async_invocation: Config for asynchronous invocations of Yandex Cloud Function.
        :param pulumi.Input[_builtins.int] concurrency: The maximum number of requests processed by a function instance at the same time.
        :param pulumi.Input[Union['FunctionConnectivityArgs', 'FunctionConnectivityArgsDict']] connectivity: Function version connectivity. If specified the version will be attached to specified network.
        :param pulumi.Input[Union['FunctionContentArgs', 'FunctionContentArgsDict']] content: Version deployment content for Yandex Cloud Function code. Can be only one `package` or `content` section. Either `package` or `content` section must be specified.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] entrypoint: Entrypoint for Yandex Cloud Function.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] environment: A set of key/value environment variables for Yandex Cloud Function. Each key must begin with a letter (A-Z, a-z).
        :param pulumi.Input[_builtins.str] execution_timeout: Execution timeout in seconds for Yandex Cloud Function.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[_builtins.int] image_size: Image size for Yandex Cloud Function.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[Union['FunctionLogOptionsArgs', 'FunctionLogOptionsArgsDict']] log_options: Options for logging from Yandex Cloud Function.
        :param pulumi.Input[_builtins.int] memory: Memory in megabytes (**aligned to 128MB**) for Yandex Cloud Function.
        :param pulumi.Input[Union['FunctionMetadataOptionsArgs', 'FunctionMetadataOptionsArgsDict']] metadata_options: Options set the access mode to function's metadata endpoints.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FunctionMountArgs', 'FunctionMountArgsDict']]]] mounts: Mounts for Yandex Cloud Function.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[Union['FunctionPackageArgs', 'FunctionPackageArgsDict']] package: Version deployment package for Yandex Cloud Function code. Can be only one `package` or `content` section. Either `package` or `content` section must be specified.
        :param pulumi.Input[_builtins.str] runtime: Runtime for Yandex Cloud Function.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FunctionSecretArgs', 'FunctionSecretArgsDict']]]] secrets: Secrets for Yandex Cloud Function.
        :param pulumi.Input[_builtins.str] service_account_id: [Service account](https://yandex.cloud/docs/iam/concepts/users/service-accounts) which linked to the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FunctionStorageMountArgs', 'FunctionStorageMountArgsDict']]]] storage_mounts: (**DEPRECATED**, use `mounts > object_storage` instead). Storage mounts for Yandex Cloud Function.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags for Yandex Cloud Function. Tag `$latest` isn't returned.
        :param pulumi.Input[_builtins.int] tmpfs_size: Tmpfs size for Yandex Cloud Function.
        :param pulumi.Input[_builtins.str] user_hash: User-defined string for current function version. User must change this string any times when function changed. Function will be updated when hash is changed.
        :param pulumi.Input[_builtins.str] version: Version of Yandex Cloud Function.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FunctionState.__new__(_FunctionState)

        __props__.__dict__["async_invocation"] = async_invocation
        __props__.__dict__["concurrency"] = concurrency
        __props__.__dict__["connectivity"] = connectivity
        __props__.__dict__["content"] = content
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["entrypoint"] = entrypoint
        __props__.__dict__["environment"] = environment
        __props__.__dict__["execution_timeout"] = execution_timeout
        __props__.__dict__["folder_id"] = folder_id
        __props__.__dict__["image_size"] = image_size
        __props__.__dict__["labels"] = labels
        __props__.__dict__["log_options"] = log_options
        __props__.__dict__["memory"] = memory
        __props__.__dict__["metadata_options"] = metadata_options
        __props__.__dict__["mounts"] = mounts
        __props__.__dict__["name"] = name
        __props__.__dict__["package"] = package
        __props__.__dict__["runtime"] = runtime
        __props__.__dict__["secrets"] = secrets
        __props__.__dict__["service_account_id"] = service_account_id
        __props__.__dict__["storage_mounts"] = storage_mounts
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tmpfs_size"] = tmpfs_size
        __props__.__dict__["user_hash"] = user_hash
        __props__.__dict__["version"] = version
        return Function(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="asyncInvocation")
    def async_invocation(self) -> pulumi.Output[Optional['outputs.FunctionAsyncInvocation']]:
        """
        Config for asynchronous invocations of Yandex Cloud Function.
        """
        return pulumi.get(self, "async_invocation")

    @_builtins.property
    @pulumi.getter
    def concurrency(self) -> pulumi.Output[_builtins.int]:
        """
        The maximum number of requests processed by a function instance at the same time.
        """
        return pulumi.get(self, "concurrency")

    @_builtins.property
    @pulumi.getter
    def connectivity(self) -> pulumi.Output[Optional['outputs.FunctionConnectivity']]:
        """
        Function version connectivity. If specified the version will be attached to specified network.
        """
        return pulumi.get(self, "connectivity")

    @_builtins.property
    @pulumi.getter
    def content(self) -> pulumi.Output[Optional['outputs.FunctionContent']]:
        """
        Version deployment content for Yandex Cloud Function code. Can be only one `package` or `content` section. Either `package` or `content` section must be specified.
        """
        return pulumi.get(self, "content")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def entrypoint(self) -> pulumi.Output[_builtins.str]:
        """
        Entrypoint for Yandex Cloud Function.
        """
        return pulumi.get(self, "entrypoint")

    @_builtins.property
    @pulumi.getter
    def environment(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A set of key/value environment variables for Yandex Cloud Function. Each key must begin with a letter (A-Z, a-z).
        """
        return pulumi.get(self, "environment")

    @_builtins.property
    @pulumi.getter(name="executionTimeout")
    def execution_timeout(self) -> pulumi.Output[_builtins.str]:
        """
        Execution timeout in seconds for Yandex Cloud Function.
        """
        return pulumi.get(self, "execution_timeout")

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> pulumi.Output[_builtins.str]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @_builtins.property
    @pulumi.getter(name="imageSize")
    def image_size(self) -> pulumi.Output[_builtins.int]:
        """
        Image size for Yandex Cloud Function.
        """
        return pulumi.get(self, "image_size")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="logOptions")
    def log_options(self) -> pulumi.Output[Optional['outputs.FunctionLogOptions']]:
        """
        Options for logging from Yandex Cloud Function.
        """
        return pulumi.get(self, "log_options")

    @_builtins.property
    @pulumi.getter
    def memory(self) -> pulumi.Output[_builtins.int]:
        """
        Memory in megabytes (**aligned to 128MB**) for Yandex Cloud Function.
        """
        return pulumi.get(self, "memory")

    @_builtins.property
    @pulumi.getter(name="metadataOptions")
    def metadata_options(self) -> pulumi.Output['outputs.FunctionMetadataOptions']:
        """
        Options set the access mode to function's metadata endpoints.
        """
        return pulumi.get(self, "metadata_options")

    @_builtins.property
    @pulumi.getter
    def mounts(self) -> pulumi.Output[Sequence['outputs.FunctionMount']]:
        """
        Mounts for Yandex Cloud Function.
        """
        return pulumi.get(self, "mounts")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def package(self) -> pulumi.Output[Optional['outputs.FunctionPackage']]:
        """
        Version deployment package for Yandex Cloud Function code. Can be only one `package` or `content` section. Either `package` or `content` section must be specified.
        """
        return pulumi.get(self, "package")

    @_builtins.property
    @pulumi.getter
    def runtime(self) -> pulumi.Output[_builtins.str]:
        """
        Runtime for Yandex Cloud Function.
        """
        return pulumi.get(self, "runtime")

    @_builtins.property
    @pulumi.getter
    def secrets(self) -> pulumi.Output[Sequence['outputs.FunctionSecret']]:
        """
        Secrets for Yandex Cloud Function.
        """
        return pulumi.get(self, "secrets")

    @_builtins.property
    @pulumi.getter(name="serviceAccountId")
    def service_account_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        [Service account](https://yandex.cloud/docs/iam/concepts/users/service-accounts) which linked to the resource.
        """
        return pulumi.get(self, "service_account_id")

    @_builtins.property
    @pulumi.getter(name="storageMounts")
    @_utilities.deprecated("""The 'storage_mounts' field has been deprecated. Please use 'mounts' instead.""")
    def storage_mounts(self) -> pulumi.Output[Sequence['outputs.FunctionStorageMount']]:
        """
        (**DEPRECATED**, use `mounts > object_storage` instead). Storage mounts for Yandex Cloud Function.
        """
        return pulumi.get(self, "storage_mounts")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Tags for Yandex Cloud Function. Tag `$latest` isn't returned.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tmpfsSize")
    def tmpfs_size(self) -> pulumi.Output[_builtins.int]:
        """
        Tmpfs size for Yandex Cloud Function.
        """
        return pulumi.get(self, "tmpfs_size")

    @_builtins.property
    @pulumi.getter(name="userHash")
    def user_hash(self) -> pulumi.Output[_builtins.str]:
        """
        User-defined string for current function version. User must change this string any times when function changed. Function will be updated when hash is changed.
        """
        return pulumi.get(self, "user_hash")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.str]:
        """
        Version of Yandex Cloud Function.
        """
        return pulumi.get(self, "version")

